/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.i2p.router.web.ConsolePasswordManager;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigUIHelper
extends HelperBase {
    static final String PROP_THEME_PFX = "routerconsole.theme.";
    private static final String[] langs = new String[]{"ar", "cs", "da", "de", "et", "el", "en", "es", "fi", "fr", "hu", "it", "nb", "nl", "pl", "pt", "ru", "sv", "tr", "uk", "vi", "zh"};
    private static final String[] flags = new String[]{"lang_ar", "cz", "dk", "de", "ee", "gr", "us", "es", "fi", "fr", "hu", "it", "nl", "no", "pl", "pt", "ru", "se", "tr", "ua", "vn", "cn"};
    private static final String[] xlangs = new String[]{ConfigUIHelper._x("Arabic"), ConfigUIHelper._x("Czech"), ConfigUIHelper._x("Danish"), ConfigUIHelper._x("German"), ConfigUIHelper._x("Estonian"), ConfigUIHelper._x("Greek"), ConfigUIHelper._x("English"), ConfigUIHelper._x("Spanish"), ConfigUIHelper._x("Finnish"), ConfigUIHelper._x("French"), ConfigUIHelper._x("Hungarian"), ConfigUIHelper._x("Italian"), ConfigUIHelper._x("Dutch"), ConfigUIHelper._x("Norwegian Bokmaal"), ConfigUIHelper._x("Polish"), ConfigUIHelper._x("Portuguese"), ConfigUIHelper._x("Russian"), ConfigUIHelper._x("Swedish"), ConfigUIHelper._x("Turkish"), ConfigUIHelper._x("Ukrainian"), ConfigUIHelper._x("Vietnamese"), ConfigUIHelper._x("Chinese")};

    public String getSettings() {
        StringBuilder buf = new StringBuilder(512);
        String current = this._context.getProperty("routerconsole.theme", "light");
        Set<String> themes = this.themeSet();
        for (String theme : themes) {
            buf.append("<input type=\"radio\" class=\"optbox\" name=\"theme\" ");
            if (theme.equals(current)) {
                buf.append("checked=\"checked\" ");
            }
            buf.append("value=\"").append(theme).append("\">").append(this._(theme)).append("<br>\n");
        }
        boolean universalTheming = this._context.getBooleanProperty("routerconsole.universal.theme");
        buf.append("<input type=\"checkbox\" name=\"universalTheming\" ");
        if (universalTheming) {
            buf.append("checked=\"checked\" ");
        }
        buf.append("value=\"1\">").append(this._("Set theme universally across all apps")).append("<br>\n");
        return buf.toString();
    }

    public String getForceMobileConsole() {
        StringBuilder buf = new StringBuilder(256);
        boolean forceMobileConsole = this._context.getBooleanProperty("routerconsole.forceMobileConsole");
        buf.append("<input type=\"checkbox\" name=\"forceMobileConsole\" ");
        if (forceMobileConsole) {
            buf.append("checked=\"checked\" ");
        }
        buf.append("value=\"1\">").append(this._("Force the mobile console to be used")).append("<br>\n");
        return buf.toString();
    }

    private Set<String> themeSet() {
        TreeSet<String> rv = new TreeSet<String>();
        rv.add("light");
        File dir = new File(this._context.getBaseDir(), "docs/themes/console");
        File[] files = dir.listFiles();
        if (files == null) {
            return rv;
        }
        for (int i = 0; i < files.length; ++i) {
            String name = files[i].getName();
            if (!files[i].isDirectory() || name.equals("images")) continue;
            rv.add(name);
        }
        Set props = this._context.getPropertyNames();
        for (String prop : props) {
            if (!prop.startsWith(PROP_THEME_PFX) || prop.length() <= PROP_THEME_PFX.length()) continue;
            rv.add(prop.substring(PROP_THEME_PFX.length()));
        }
        return rv;
    }

    public String getLangSettings() {
        StringBuilder buf = new StringBuilder(512);
        String current = Messages.getLanguage(this._context);
        for (int i = 0; i < langs.length; ++i) {
            buf.append("<input type=\"radio\" class=\"optbox\" name=\"lang\" ");
            if (langs[i].equals(current)) {
                buf.append("checked=\"checked\" ");
            }
            buf.append("value=\"").append(langs[i]).append("\">").append("<img height=\"11\" width=\"16\" alt=\"\" src=\"/flags.jsp?c=").append(flags[i]).append("\"> ").append(Messages.getDisplayLanguage(langs[i], xlangs[i], this._context)).append("<br>\n");
        }
        return buf.toString();
    }

    public String getPasswordForm() {
        StringBuilder buf = new StringBuilder(512);
        ConsolePasswordManager mgr = new ConsolePasswordManager(this._context);
        Map<String, String> userpw = mgr.getMD5("routerconsole.auth.i2prouter");
        buf.append("<table>");
        if (userpw.isEmpty()) {
            buf.append("<tr><td colspan=\"3\">");
            buf.append(this._("Add a user and password to enable."));
            buf.append("</td></tr>");
        } else {
            buf.append("<tr><th>").append(this._("Remove")).append("</th><th>").append(this._("User Name")).append("</th><th>&nbsp;</th></tr>\n");
            for (String name : userpw.keySet()) {
                buf.append("<tr><td align=\"center\"><input type=\"checkbox\" class=\"optbox\" name=\"delete_").append(name).append("\"></td><td colspan=\"2\">").append(name).append("</td></tr>\n");
            }
        }
        buf.append("<tr><td align=\"center\"><b>").append(this._("Add")).append(":</b></td><td align=\"left\"><input type=\"text\" name=\"name\"></td><td align=\"left\"><b>");
        buf.append(this._("Password")).append(":</b> <input type=\"password\" size=\"40\" name=\"pw\"></td></tr></table>\n");
        return buf.toString();
    }
}

