/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.ArrayList;
import net.i2p.data.DataHelper;
import net.i2p.data.RouterAddress;
import net.i2p.router.transport.TransportManager;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.router.web.HelperBase;
import net.i2p.util.Addresses;

public class ConfigNetHelper
extends HelperBase {
    public static final String PROP_I2NP_NTCP_HOSTNAME = "i2np.ntcp.hostname";
    public static final String PROP_I2NP_NTCP_PORT = "i2np.ntcp.port";
    public static final String PROP_I2NP_NTCP_AUTO_PORT = "i2np.ntcp.autoport";
    public static final String PROP_I2NP_NTCP_AUTO_IP = "i2np.ntcp.autoip";
    private static final String CHECKED = " checked=\"checked\" ";
    public static final int DEFAULT_SHARE_KBPS = 12;

    public String getUdphostname() {
        return this._context.getProperty("i2np.udp.host", "");
    }

    public String getNtcphostname() {
        return this._context.getProperty(PROP_I2NP_NTCP_HOSTNAME, "");
    }

    public String getNtcpport() {
        return this._context.getProperty(PROP_I2NP_NTCP_PORT, "");
    }

    public String getUdpIP() {
        RouterAddress addr = this._context.router().getRouterInfo().getTargetAddress("SSU");
        if (addr == null) {
            return this._("unknown");
        }
        String rv = addr.getHost();
        if (rv == null) {
            return this._("unknown");
        }
        return rv;
    }

    public String getUdpPort() {
        return this.getConfiguredUdpPort();
    }

    public String getConfiguredUdpPort() {
        return this._context.getProperty("i2np.udp.internalPort", "unset");
    }

    public String getChecked(String prop) {
        if (this._context.getBooleanProperty(prop)) {
            return CHECKED;
        }
        return "";
    }

    public String getDynamicKeysChecked() {
        return this.getChecked("router.dynamicKeys");
    }

    public String getLaptopChecked() {
        return this.getChecked("i2np.laptopMode");
    }

    public String getTcpAutoPortChecked(int mode) {
        boolean specified;
        String port = this._context.getProperty(PROP_I2NP_NTCP_PORT);
        boolean bl = specified = port != null && port.length() > 0;
        if (mode == 1 && specified || mode == 2 && !specified) {
            return CHECKED;
        }
        return "";
    }

    public String getTcpAutoIPChecked(int mode) {
        boolean enabled = TransportManager.isNTCPEnabled(this._context);
        String hostname = this._context.getProperty(PROP_I2NP_NTCP_HOSTNAME);
        boolean specified = hostname != null && hostname.length() > 0;
        String auto = this._context.getProperty(PROP_I2NP_NTCP_AUTO_IP, "true");
        if (mode == 0 && !specified && auto.equals("false") && enabled || mode == 1 && specified && auto.equals("false") && enabled || mode == 2 && auto.equals("true") && enabled || mode == 3 && auto.equals("always") && enabled || mode == 4 && !enabled) {
            return CHECKED;
        }
        return "";
    }

    public String getUdpAutoIPChecked(int mode) {
        String hostname = this._context.getProperty("i2np.udp.host");
        boolean specified = hostname != null && hostname.length() > 0;
        boolean hidden = this._context.router().isHidden();
        String sources = this._context.getProperty("i2np.udp.addressSources", UDPTransport.DEFAULT_SOURCES);
        if (mode == 0 && sources.equals("ssu") && !hidden || mode == 1 && specified && !hidden || mode == 2 && hidden || mode == 3 && sources.equals("local,upnp,ssu") && !hidden || mode == 4 && sources.equals("local,ssu") && !hidden || mode == 5 && sources.equals("upnp,ssu") && !hidden) {
            return CHECKED;
        }
        return "";
    }

    public String getUpnpChecked() {
        if (this._context.getBooleanPropertyDefaultTrue("i2np.upnp.enable")) {
            return CHECKED;
        }
        return "";
    }

    public String getUdpDisabledChecked() {
        if (!this._context.getBooleanPropertyDefaultTrue("i2np.udp.enable")) {
            return CHECKED;
        }
        return "";
    }

    public String getRequireIntroductionsChecked() {
        short status = this._context.commSystem().getReachabilityStatus();
        switch (status) {
            case 0: 
            case 5: {
                return this.getChecked("i2np.udp.forceIntroducers");
            }
        }
        return CHECKED;
    }

    public String[] getAddresses() {
        ArrayList<String> al = new ArrayList<String>(Addresses.getAddresses());
        return al.toArray(new String[al.size()]);
    }

    public String getInboundRate() {
        return "" + this._context.bandwidthLimiter().getInboundKBytesPerSecond();
    }

    public String getOutboundRate() {
        return "" + this._context.bandwidthLimiter().getOutboundKBytesPerSecond();
    }

    public String getInboundRateBits() {
        return this.kbytesToBits(this._context.bandwidthLimiter().getInboundKBytesPerSecond());
    }

    public String getOutboundRateBits() {
        return this.kbytesToBits(this._context.bandwidthLimiter().getOutboundKBytesPerSecond());
    }

    public String getShareRateBits() {
        return this.kbytesToBits(this.getShareBandwidth());
    }

    private String kbytesToBits(int kbytes) {
        return DataHelper.formatSize(kbytes * 8 * 1024) + ' ' + this._("bits per second") + ' ' + this._("or {0} bytes per month maximum", DataHelper.formatSize((long)kbytes * 1024L * 60L * 60L * 24L * 31L));
    }

    public String getInboundBurstRate() {
        return "" + this._context.bandwidthLimiter().getInboundBurstKBytesPerSecond();
    }

    public String getOutboundBurstRate() {
        return "" + this._context.bandwidthLimiter().getOutboundBurstKBytesPerSecond();
    }

    public String getInboundBurstFactorBox() {
        int numSeconds = 1;
        int rateKBps = this._context.bandwidthLimiter().getInboundBurstKBytesPerSecond();
        int burstKB = this._context.bandwidthLimiter().getInboundBurstBytes() / 1024;
        if (rateKBps > 0 && burstKB > 0) {
            numSeconds = burstKB / rateKBps;
        }
        return ConfigNetHelper.getBurstFactor(numSeconds, "inboundburstfactor");
    }

    public String getOutboundBurstFactorBox() {
        int numSeconds = 1;
        int rateKBps = this._context.bandwidthLimiter().getOutboundBurstKBytesPerSecond();
        int burstKB = this._context.bandwidthLimiter().getOutboundBurstBytes() / 1024;
        if (rateKBps > 0 && burstKB > 0) {
            numSeconds = burstKB / rateKBps;
        }
        return ConfigNetHelper.getBurstFactor(numSeconds, "outboundburstfactor");
    }

    private static String getBurstFactor(int numSeconds, String name) {
        StringBuilder buf = new StringBuilder(256);
        buf.append("<select name=\"").append(name).append("\">\n");
        boolean found = false;
        for (int i = 10; i <= 70; i += 10) {
            int val = i;
            if (i == 70) {
                if (found) break;
                val = numSeconds;
            }
            buf.append("<option value=\"").append(val).append("\" ");
            if (val == numSeconds) {
                buf.append("selected ");
                found = true;
            }
            buf.append(">");
            buf.append(val).append(" seconds</option>\n");
        }
        buf.append("</select>\n");
        return buf.toString();
    }

    public String getEnableLoadTesting() {
        return "";
    }

    public String getSharePercentageBox() {
        int pct = (int)(100.0 * this._context.router().getSharePercentage());
        StringBuilder buf = new StringBuilder(256);
        buf.append("<select style=\"text-align: right !important;\" name=\"sharePercentage\">\n");
        boolean found = false;
        for (int i = 30; i <= 110; i += 10) {
            int val = i;
            if (i == 110) {
                if (found) break;
                val = pct;
            }
            buf.append("<option style=\"text-align: right;\" value=\"").append(val).append("\" ");
            if (pct == val) {
                buf.append("selected=\"selected\" ");
                found = true;
            }
            buf.append(">").append(val).append("%</option>\n");
        }
        buf.append("</select>\n");
        return buf.toString();
    }

    public int getShareBandwidth() {
        int irateKBps = this._context.bandwidthLimiter().getInboundKBytesPerSecond();
        int orateKBps = this._context.bandwidthLimiter().getOutboundKBytesPerSecond();
        double pct = this._context.router().getSharePercentage();
        if (irateKBps < 0 || orateKBps < 0) {
            return 12;
        }
        return (int)(pct * (double)Math.min(irateKBps, orateKBps));
    }
}

