/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import net.i2p.data.DataFormatException;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.router.web.FormHandler;
import net.i2p.util.ConvertToHash;

public class ConfigKeyringHandler
extends FormHandler {
    private String _peer;
    private String _key;

    protected void processForm() {
        if (this._action == null) {
            return;
        }
        boolean adding = this._action.equals(this._("Add key"));
        if (adding || this._action.equals(this._("Delete key"))) {
            if (this._peer == null) {
                this.addFormError(this._("You must enter a destination"));
            }
            if (this._key == null && adding) {
                this.addFormError(this._("You must enter a key"));
            }
            if (this._peer == null || this._key == null && adding) {
                return;
            }
            Hash h = ConvertToHash.getHash(this._peer);
            if (adding) {
                SessionKey sk = new SessionKey();
                try {
                    sk.fromBase64(this._key);
                }
                catch (DataFormatException dfe) {
                    // empty catch block
                }
                if (h != null && h.getData() != null && sk.getData() != null) {
                    this._context.keyRing().put(h, sk);
                    this.addFormNotice(this._("Key for") + " " + h.toBase64() + " " + this._("added to keyring"));
                } else {
                    this.addFormError(this._("Invalid destination or key"));
                }
            } else if (h != null && h.getData() != null) {
                if (this._context.keyRing().remove(h) != null) {
                    this.addFormNotice(this._("Key for") + " " + h.toBase64() + " " + this._("removed from keyring"));
                } else {
                    this.addFormNotice(this._("Key for") + " " + h.toBase64() + " " + this._("not found in keyring"));
                }
            } else {
                this.addFormError(this._("Invalid destination"));
            }
        } else {
            this.addFormError(this._("Unsupported"));
        }
    }

    public void setPeer(String peer) {
        this._peer = peer;
    }

    public void setKey(String peer) {
        this._key = peer;
    }
}

