/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.update;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import net.i2p.crypto.TrustedUpdate;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.update.UpdateRunner;
import net.i2p.router.util.RFC822Date;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.router.web.NewsHelper;
import net.i2p.update.UpdateMethod;
import net.i2p.update.UpdateType;
import net.i2p.util.EepGet;
import net.i2p.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NewsFetcher
extends UpdateRunner {
    private String _lastModified;
    private final File _newsFile;
    private final File _tempFile;
    private boolean _isNewer;
    private boolean _success;
    private static final String TEMP_NEWS_FILE = "news.xml.temp";
    private static final String VERSION_PREFIX = "<i2p.release ";
    private static final String VERSION_KEY = "version";
    private static final String MIN_VERSION_KEY = "minversion";
    private static final String SUD_KEY = "sudtorrent";
    private static final String SU2_KEY = "su2torrent";
    private static final String CLEARNET_SUD_KEY = "sudclearnet";
    private static final String CLEARNET_SU2_KEY = "su2clearnet";
    private static final String I2P_SUD_KEY = "sudi2p";
    private static final String I2P_SU2_KEY = "su2i2p";

    public NewsFetcher(RouterContext ctx, ConsoleUpdateManager mgr, List<URI> uris) {
        super(ctx, mgr, uris);
        this._newsFile = new File(ctx.getRouterDir(), "docs/news.xml");
        this._tempFile = new File(ctx.getTempDir(), "tmp-" + ctx.random().nextLong() + TEMP_NEWS_FILE);
        long lastMod = NewsHelper.lastChecked(ctx);
        if (lastMod > 0L) {
            this._lastModified = RFC822Date.to822Date(lastMod);
        }
    }

    @Override
    public UpdateType getType() {
        return UpdateType.NEWS;
    }

    private boolean dontInstall() {
        return NewsHelper.dontInstall(this._context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._isRunning = true;
        try {
            this.fetchNews();
        }
        finally {
            this._mgr.notifyCheckComplete(this, this._isNewer, this._success);
            this._isRunning = false;
        }
    }

    public void fetchNews() {
        boolean shouldProxy = Boolean.valueOf(this._context.getProperty("router.updateThroughProxy", ConfigUpdateHandler.DEFAULT_SHOULD_PROXY));
        String proxyHost = this._context.getProperty("router.updateProxyHost", "127.0.0.1");
        int proxyPort = ConfigUpdateHandler.proxyPort(this._context);
        Iterator i$ = this._urls.iterator();
        while (i$.hasNext()) {
            URI uri;
            this._currentURI = uri = (URI)i$.next();
            String newsURL = uri.toString();
            if (this._tempFile.exists()) {
                this._tempFile.delete();
            }
            try {
                EepGet get = shouldProxy ? new EepGet(this._context, true, proxyHost, proxyPort, 0, this._tempFile.getAbsolutePath(), newsURL, true, null, this._lastModified) : new EepGet(this._context, false, null, 0, 0, this._tempFile.getAbsolutePath(), newsURL, true, null, this._lastModified);
                get.addStatusListener(this);
                long start = this._context.clock().now();
                if (!get.fetch()) continue;
                this._context.router().saveConfig("routerconsole.newsLastChecked", Long.toString(start));
                return;
            }
            catch (Throwable t) {
                this._log.error("Error fetching the news", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkForUpdates() {
        if (this.dontInstall()) {
            return;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(this._newsFile);
            StringBuilder buf = new StringBuilder(128);
            while (DataHelper.readLine((InputStream)in, buf)) {
                int index = buf.indexOf(VERSION_PREFIX);
                if (index >= 0) {
                    Map<String, String> args = NewsFetcher.parseArgs(buf.substring(index + VERSION_PREFIX.length()));
                    String ver = args.get(VERSION_KEY);
                    if (ver != null) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Found version: [" + ver + "]");
                        }
                        if (TrustedUpdate.needsUpdate("0.9.6", ver)) {
                            List<URI> uris;
                            if (this._log.shouldLog(10)) {
                                this._log.debug("Our version is out of date, update!");
                            }
                            HashMap<UpdateMethod, List<URI>> sourceMap = new HashMap<UpdateMethod, List<URI>>(4);
                            sourceMap.put(UpdateMethod.HTTP, this._mgr.getUpdateURLs(UpdateType.ROUTER_SIGNED, "", UpdateMethod.HTTP));
                            String key = FileUtil.isPack200Supported() ? SU2_KEY : SUD_KEY;
                            String murl = args.get(key);
                            if (murl != null && !(uris = NewsFetcher.tokenize(murl)).isEmpty()) {
                                Collections.shuffle(uris, this._context.random());
                                sourceMap.put(UpdateMethod.TORRENT, uris);
                            }
                            this._mgr.notifyVersionAvailable(this, this._currentURI, UpdateType.ROUTER_SIGNED, "", sourceMap, ver, "");
                        } else if (this._log.shouldLog(10)) {
                            this._log.debug("Our version is current");
                        }
                        return;
                    }
                    if (this._log.shouldLog(30)) {
                        this._log.warn("No version in " + buf.toString());
                    }
                } else if (this._log.shouldLog(10)) {
                    this._log.debug("No match in " + buf.toString());
                }
                buf.setLength(0);
            }
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error checking the news for an update", ioe);
            }
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("No version found in news.xml file");
        }
    }

    private static Map<String, String> parseArgs(String args) {
        HashMap<String, String> rv = new HashMap<String, String>(8);
        char[] data = args.toCharArray();
        StringBuilder buf = new StringBuilder(32);
        boolean isQuoted = false;
        String key = null;
        block5: for (int i = 0; i < data.length; ++i) {
            switch (data[i]) {
                case '\"': 
                case '\'': {
                    if (isQuoted) {
                        if (key != null) {
                            rv.put(key, buf.toString().trim());
                            key = null;
                        }
                        buf.setLength(0);
                    }
                    isQuoted = !isQuoted;
                    continue block5;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': {
                    if (isQuoted) {
                        buf.append(data[i]);
                        continue block5;
                    }
                    if (key != null) {
                        rv.put(key, buf.toString().trim());
                        key = null;
                    }
                    buf.setLength(0);
                    continue block5;
                }
                case '=': {
                    if (isQuoted) {
                        buf.append(data[i]);
                        continue block5;
                    }
                    key = buf.toString().trim().toLowerCase(Locale.US);
                    buf.setLength(0);
                    continue block5;
                }
                default: {
                    buf.append(data[i]);
                }
            }
        }
        if (key != null) {
            rv.put(key, buf.toString().trim());
        }
        return rv;
    }

    private static List<URI> tokenize(String URLs) {
        StringTokenizer tok = new StringTokenizer(URLs, " ,\r\n");
        ArrayList<URI> rv = new ArrayList<URI>();
        while (tok.hasMoreTokens()) {
            try {
                rv.add(new URI(tok.nextToken().trim()));
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return rv;
    }

    @Override
    public void bytesTransferred(long alreadyTransferred, int currentWrite, long bytesTransferred, long bytesRemaining, String url) {
    }

    @Override
    public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
        if (this._log.shouldLog(20)) {
            this._log.info("News fetched from " + url + " with " + (alreadyTransferred + bytesTransferred));
        }
        long now = this._context.clock().now();
        if (this._tempFile.exists()) {
            boolean copied = FileUtil.copy(this._tempFile, this._newsFile, true, false);
            this._tempFile.delete();
            if (copied) {
                String newVer = Long.toString(now);
                this._context.router().saveConfig("routerconsole.newsLastUpdated", newVer);
                this._mgr.notifyVersionAvailable(this, this._currentURI, UpdateType.NEWS, "", UpdateMethod.HTTP, null, newVer, "");
                this._isNewer = true;
                this.checkForUpdates();
            } else if (this._log.shouldLog(40)) {
                this._log.error("Failed to copy the news file!");
            }
        } else if (this._log.shouldLog(30)) {
            this._log.warn("Transfer complete, but no file? - probably 304 Not Modified");
        }
        this._success = true;
    }

    @Override
    public void transferFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt) {
    }
}

