/*
 * Decompiled with CFR 0.152.
 */
package net.metanotion.io.block.index;

import java.io.IOException;
import net.metanotion.io.Serializer;
import net.metanotion.io.block.BlockFile;
import net.metanotion.io.block.index.BSkipList;
import net.metanotion.util.skiplist.SkipList;
import net.metanotion.util.skiplist.SkipSpan;

public class BSkipSpan
extends SkipSpan {
    protected static final int MAGIC = 1399873902;
    protected static final int HEADER_LEN = 20;
    public static final int CONT_HEADER_LEN = 8;
    protected final BlockFile bf;
    private final BSkipList bsl;
    protected int page;
    protected int overflowPage;
    protected int prevPage;
    protected int nextPage;
    protected Serializer keySer;
    protected Serializer valSer;
    protected int spanSize;
    protected boolean isKilled;

    public static void init(BlockFile bf, int page, int spanSize) throws IOException {
        BlockFile.pageSeek(bf.file, page);
        bf.file.writeInt(1399873902);
        bf.file.writeInt(0);
        bf.file.writeInt(0);
        bf.file.writeInt(0);
        bf.file.writeShort((short)spanSize);
        bf.file.writeShort(0);
    }

    public SkipSpan newInstance(SkipList sl) {
        try {
            int newPage = this.bf.allocPage();
            BSkipSpan.init(this.bf, newPage, this.bf.spanSize);
            return new BSkipSpan(this.bf, (BSkipList)sl, newPage, this.keySer, this.valSer);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error creating database page", ioe);
        }
    }

    public void killInstance() {
        if (this.isKilled) {
            this.bf.log.error("Already killed!! " + this, new Exception());
            return;
        }
        if (this.bf.log.shouldLog(10)) {
            this.bf.log.debug("Killing " + this);
        }
        this.isKilled = true;
        try {
            int curPage = this.overflowPage;
            this.bf.freePage(this.page);
            this.freeContinuationPages(curPage);
        }
        catch (IOException ioe) {
            this.bf.log.error("Error freeing " + this, ioe);
        }
        this.bsl.spanHash.remove(this.page);
    }

    private int freeContinuationPages(int curPage) throws IOException {
        int rv = 0;
        while (curPage > 0) {
            BlockFile.pageSeek(this.bf.file, curPage);
            int magic = this.bf.file.readInt();
            if (magic != 1129270868) {
                throw new IOException("Bad SkipSpan magic number 0x" + Integer.toHexString(magic) + " on page " + curPage);
            }
            int next = this.bf.file.readUnsignedInt();
            this.bf.freePage(curPage);
            curPage = next;
            ++rv;
        }
        return rv;
    }

    public void flush() {
        this.fflush();
    }

    private void fflush() {
        block14: {
            if (this.isKilled) {
                this.bf.log.error("Already killed!! " + this, new Exception());
                return;
            }
            try {
                BlockFile.pageSeek(this.bf.file, this.page);
                this.bf.file.writeInt(1399873902);
                this.bf.file.writeInt(this.overflowPage);
                this.prevPage = this.prev != null ? ((BSkipSpan)this.prev).page : 0;
                this.nextPage = this.next != null ? ((BSkipSpan)this.next).page : 0;
                this.bf.file.writeInt(this.prevPage);
                this.bf.file.writeInt(this.nextPage);
                if (this.keys == null) {
                    return;
                }
                this.bf.file.writeShort((short)this.keys.length);
                this.bf.file.writeShort((short)this.nKeys);
                if (this.nKeys <= 0 && this.prev != null) {
                    this.bf.log.error("Flushing with no entries?" + this, new Exception());
                }
                int curPage = this.page;
                int[] curNextPage = new int[]{this.overflowPage};
                int[] pageCounter = new int[]{20};
                for (int i = 0; i < this.nKeys; ++i) {
                    if (pageCounter[0] + 4 > 1024) {
                        if (curNextPage[0] == 0) {
                            curNextPage[0] = this.bf.allocPage();
                            BlockFile.pageSeek(this.bf.file, curNextPage[0]);
                            this.bf.file.writeInt(1129270868);
                            this.bf.file.writeInt(0);
                            BlockFile.pageSeek(this.bf.file, curPage);
                            this.bf.file.skipBytes(4);
                            this.bf.file.writeInt(curNextPage[0]);
                        }
                        BlockFile.pageSeek(this.bf.file, curNextPage[0]);
                        curPage = curNextPage[0];
                        this.bf.file.skipBytes(4);
                        curNextPage[0] = this.bf.file.readUnsignedInt();
                        pageCounter[0] = 8;
                    }
                    if (this.keys[i] == null || this.vals[i] == null) {
                        this.bf.log.error("Dropping null data in entry " + i + " page " + curPage + " key=" + this.keys[i] + " val=" + this.vals[i]);
                        --this.nKeys;
                        --i;
                        continue;
                    }
                    byte[] keyData = this.keySer.getBytes(this.keys[i]);
                    byte[] valData = this.valSer.getBytes(this.vals[i]);
                    if (keyData.length > 65535 || valData.length > 65535) {
                        this.bf.log.error("Dropping huge data in entry " + i + " page " + curPage + " keylen=" + keyData.length + " vallen=" + valData.length);
                        --this.nKeys;
                        --i;
                        continue;
                    }
                    pageCounter[0] = pageCounter[0] + 4;
                    this.bf.file.writeShort(keyData.length);
                    this.bf.file.writeShort(valData.length);
                    curPage = this.bf.writeMultiPageData(keyData, curPage, pageCounter, curNextPage);
                    curPage = this.bf.writeMultiPageData(valData, curPage, pageCounter, curNextPage);
                }
                BlockFile.pageSeek(this.bf.file, this.page);
                this.bf.file.skipBytes(4);
                this.overflowPage = this.bf.file.readUnsignedInt();
                if (curNextPage[0] == 0) break block14;
                BlockFile.pageSeek(this.bf.file, curPage);
                this.bf.file.skipBytes(4);
                this.bf.file.writeInt(0);
                if (curPage == this.page) {
                    this.overflowPage = 0;
                }
                try {
                    int freed = this.freeContinuationPages(curNextPage[0]);
                    if (this.bf.log.shouldLog(10)) {
                        this.bf.log.debug("Freed " + freed + " continuation pages");
                    }
                }
                catch (IOException ioe) {
                    this.bf.log.error("Error freeing " + this, ioe);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error writing to database", ioe);
            }
        }
    }

    private static void load(BSkipSpan bss, BlockFile bf, BSkipList bsl, int spanPage, Serializer key, Serializer val) throws IOException {
        BSkipSpan.loadInit(bss, bf, bsl, spanPage, key, val);
        bss.loadData();
    }

    protected static void loadInit(BSkipSpan bss, BlockFile bf, BSkipList bsl, int spanPage, Serializer key, Serializer val) throws IOException {
        if (bss.isKilled) {
            throw new IOException("Already killed!! " + bss);
        }
        bss.page = spanPage;
        bss.keySer = key;
        bss.valSer = val;
        bsl.spanHash.put(spanPage, bss);
        BlockFile.pageSeek(bf.file, spanPage);
        int magic = bf.file.readInt();
        if (magic != 1399873902) {
            throw new IOException("Bad SkipSpan magic number 0x" + Integer.toHexString(magic) + " on page " + spanPage);
        }
        bss.overflowPage = bf.file.readUnsignedInt();
        bss.prevPage = bf.file.readUnsignedInt();
        bss.nextPage = bf.file.readUnsignedInt();
        bss.spanSize = bf.file.readUnsignedShort();
        bss.nKeys = bf.file.readUnsignedShort();
        if (bss.spanSize < 1 || bss.spanSize > 256 || bss.nKeys > bss.spanSize) {
            bf.log.error("Invalid span size " + bss.nKeys + " / " + bss.spanSize);
            bss.nKeys = 0;
            bss.spanSize = bf.spanSize;
        }
    }

    protected void loadData() throws IOException {
        this.loadData(true);
    }

    protected void loadData(boolean flushOnError) throws IOException {
        if (this.isKilled) {
            throw new IOException("Already killed!! " + this);
        }
        this.keys = new Comparable[this.spanSize];
        this.vals = new Object[this.spanSize];
        int curPage = this.page;
        int[] curNextPage = new int[]{this.overflowPage};
        int[] pageCounter = new int[]{20};
        int fail = 0;
        for (int i = 0; i < this.nKeys; ++i) {
            if (pageCounter[0] + 4 > 1024) {
                BlockFile.pageSeek(this.bf.file, curNextPage[0]);
                int magic = this.bf.file.readInt();
                if (magic != 1129270868) {
                    this.bf.log.error("Lost " + (this.nKeys - i) + " entries - Bad SkipSpan magic number 0x" + Integer.toHexString(magic) + " on page " + curNextPage[0]);
                    this.lostEntries(i, curPage);
                    break;
                }
                curPage = curNextPage[0];
                curNextPage[0] = this.bf.file.readUnsignedInt();
                pageCounter[0] = 8;
            }
            int ksz = this.bf.file.readUnsignedShort();
            int vsz = this.bf.file.readUnsignedShort();
            pageCounter[0] = pageCounter[0] + 4;
            byte[] k = new byte[ksz];
            byte[] v = new byte[vsz];
            int lastGood = curPage;
            try {
                curPage = this.bf.readMultiPageData(k, curPage, pageCounter, curNextPage);
                curPage = this.bf.readMultiPageData(v, curPage, pageCounter, curNextPage);
            }
            catch (IOException ioe) {
                this.bf.log.error("Lost " + (this.nKeys - i) + " entries - Error loading " + this + " on page " + curPage, ioe);
                this.lostEntries(i, lastGood);
                break;
            }
            this.keys[i] = (Comparable)this.keySer.construct(k);
            this.vals[i] = this.valSer.construct(v);
            if (this.keys[i] != null && this.vals[i] != null) continue;
            this.bf.log.error("Null deserialized data in entry " + i + " page " + curPage + " key=" + this.keys[i] + " val=" + this.vals[i]);
            ++fail;
            --this.nKeys;
            --i;
        }
        if (fail > 0) {
            this.bf.log.error("Repairing corruption of " + fail + " entries");
            if (flushOnError) {
                this.fflush();
            }
        }
    }

    protected void lostEntries(int firstBadEntry, int lastGoodPage) {
        try {
            this.nKeys = firstBadEntry;
            BlockFile.pageSeek(this.bf.file, lastGoodPage);
            this.bf.file.skipBytes(4);
            this.bf.file.writeInt(0);
            if (lastGoodPage != this.page) {
                BlockFile.pageSeek(this.bf.file, this.page);
                this.bf.file.skipBytes(18);
            } else {
                this.bf.file.skipBytes(10);
            }
            this.bf.file.writeShort(this.nKeys);
        }
        catch (IOException ioe) {
            this.bf.log.error("Error while recovering from corruption of " + this, ioe);
        }
    }

    protected BSkipSpan(BlockFile bf, BSkipList bsl) {
        this.bf = bf;
        this.bsl = bsl;
    }

    public BSkipSpan(BlockFile bf, BSkipList bsl, int spanPage, Serializer key, Serializer val) throws IOException {
        BSkipSpan temp;
        this.bf = bf;
        this.bsl = bsl;
        BSkipSpan.load(this, bf, bsl, spanPage, key, val);
        this.next = null;
        this.prev = null;
        BSkipSpan bss = this;
        int np = this.nextPage;
        while (np != 0) {
            temp = bsl.spanHash.get(np);
            if (temp != null) {
                bss.next = temp;
                break;
            }
            bss.next = new BSkipSpan(bf, bsl);
            bss.next.next = null;
            bss.next.prev = bss;
            bss = (BSkipSpan)bss.next;
            BSkipSpan.load(bss, bf, bsl, np, key, val);
            np = bss.nextPage;
        }
        bss = this;
        np = this.prevPage;
        while (np != 0) {
            temp = bsl.spanHash.get(np);
            if (temp != null) {
                bss.prev = temp;
                break;
            }
            bss.prev = new BSkipSpan(bf, bsl);
            bss.prev.next = bss;
            bss.prev.prev = null;
            bss = (BSkipSpan)bss.prev;
            BSkipSpan.load(bss, bf, bsl, np, key, val);
            np = bss.prevPage;
        }
    }

    public String toString() {
        String rv = "BSS page: " + this.page + " key: \"" + this.firstKey() + '\"';
        if (this.isKilled) {
            rv = rv + " KILLED";
        }
        return rv;
    }
}

