/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.util.Addresses;
import net.i2p.util.OrderedProperties;

public class RouterAddress
extends DataStructureImpl {
    private int _cost = -1;
    private String _transportStyle;
    private final Properties _options = new OrderedProperties();
    private byte[] _ip;
    private int _port;
    public static final String PROP_HOST = "host";
    public static final String PROP_PORT = "port";

    public int getCost() {
        return this._cost;
    }

    public void setCost(int cost) {
        this._cost = cost;
    }

    public Date getExpiration() {
        return null;
    }

    public void setExpiration(Date expiration) {
    }

    public String getTransportStyle() {
        return this._transportStyle;
    }

    public void setTransportStyle(String transportStyle) {
        if (this._transportStyle != null) {
            throw new IllegalStateException();
        }
        this._transportStyle = transportStyle;
    }

    public Properties getOptions() {
        return this._options;
    }

    public Map getOptionsMap() {
        return Collections.unmodifiableMap(this._options);
    }

    public String getOption(String opt) {
        return this._options.getProperty(opt);
    }

    public void setOptions(Properties options) {
        if (!this._options.isEmpty()) {
            throw new IllegalStateException();
        }
        this._options.putAll((Map<?, ?>)options);
    }

    public byte[] getIP() {
        if (this._ip != null) {
            return this._ip;
        }
        byte[] rv = null;
        String host = this._options.getProperty(PROP_HOST);
        if (host != null && (rv = Addresses.getIP(host)) != null && (host.replaceAll("[0-9\\.]", "").length() == 0 || host.replaceAll("[0-9a-fA-F:]", "").length() == 0)) {
            this._ip = rv;
        }
        return rv;
    }

    public int getPort() {
        if (this._port != 0) {
            return this._port;
        }
        String port = this._options.getProperty(PROP_PORT);
        if (port != null) {
            try {
                int rv = Integer.parseInt(port);
                if (rv > 0 && rv <= 65535) {
                    this._port = rv;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this._port;
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        if (this._transportStyle != null) {
            throw new IllegalStateException();
        }
        this._cost = (int)DataHelper.readLong(in, 1);
        DataHelper.readDate(in);
        this._transportStyle = DataHelper.readString(in);
        if (this._transportStyle.equals("SSU")) {
            this._transportStyle = "SSU";
        } else if (this._transportStyle.equals("NTCP")) {
            this._transportStyle = "NTCP";
        }
        DataHelper.readProperties(in, this._options);
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._cost < 0 || this._transportStyle == null) {
            throw new DataFormatException("Not enough data to write a router address");
        }
        DataHelper.writeLong(out, 1, this._cost);
        DataHelper.writeDate(out, null);
        DataHelper.writeString(out, this._transportStyle);
        DataHelper.writeProperties(out, this._options);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof RouterAddress)) {
            return false;
        }
        RouterAddress addr = (RouterAddress)object;
        return this._cost == addr._cost && DataHelper.eq(this._transportStyle, addr._transportStyle);
    }

    public int hashCode() {
        return DataHelper.hashCode(this._transportStyle) ^ this._cost;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("[RouterAddress: ");
        buf.append("\n\tTransportStyle: ").append(this._transportStyle);
        buf.append("\n\tCost: ").append(this._cost);
        buf.append("\n\tOptions: #: ").append(this._options.size());
        for (Map.Entry<Object, Object> e : this._options.entrySet()) {
            String key = (String)e.getKey();
            String val = (String)e.getValue();
            buf.append("\n\t\t[").append(key).append("] = [").append(val).append("]");
        }
        buf.append("]");
        return buf.toString();
    }
}

