/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.jetty;

import net.i2p.I2PAppContext;
import net.i2p.util.Log;
import org.mortbay.jetty.Server;
import org.mortbay.log.Logger;

public class I2PLogger
implements Logger {
    private final Log _log;
    StringBuilder _buffer = new StringBuilder();

    public I2PLogger() {
        this(I2PAppContext.getGlobalContext());
    }

    public I2PLogger(I2PAppContext ctx) {
        this._log = ctx.logManager().getLog(Server.class);
        if (System.getProperty("DEBUG") != null) {
            this.setDebugEnabled(true);
        }
    }

    public boolean isDebugEnabled() {
        return this._log.shouldLog(10);
    }

    public void setDebugEnabled(boolean enabled) {
        if (enabled) {
            this._log.setMinimumPriority(10);
        } else {
            this._log.setMinimumPriority(40);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void info(String msg, Object arg0, Object arg1) {
        if (arg0 == null && arg1 == null) {
            this._log.info(msg);
        } else if (arg0 != null && arg1 == null && arg0 instanceof Throwable) {
            this._log.info(msg, (Throwable)arg0);
        } else if (this._log.shouldLog(20)) {
            StringBuilder stringBuilder = this._buffer;
            synchronized (stringBuilder) {
                this.format(msg, arg0, arg1);
                this._log.info(this._buffer.toString());
            }
        }
    }

    public void debug(String msg, Throwable th) {
        this._log.debug(msg, th);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(String msg, Object arg0, Object arg1) {
        if (arg0 == null && arg1 == null) {
            this._log.debug(msg);
        } else if (arg0 != null && arg1 == null && arg0 instanceof Throwable) {
            this._log.debug(msg, (Throwable)arg0);
        } else if (this._log.shouldLog(10)) {
            StringBuilder stringBuilder = this._buffer;
            synchronized (stringBuilder) {
                this.format(msg, arg0, arg1);
                this._log.debug(this._buffer.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String msg, Object arg0, Object arg1) {
        if (arg0 == null && arg1 == null) {
            this._log.warn(msg);
        } else if (arg0 != null && arg1 == null && arg0 instanceof Throwable) {
            this._log.error(msg, (Throwable)arg0);
        } else if (this._log.shouldLog(30)) {
            StringBuilder stringBuilder = this._buffer;
            synchronized (stringBuilder) {
                this.format(msg, arg0, arg1);
                this._log.warn(this._buffer.toString());
            }
        }
    }

    public void warn(String msg, Throwable th) {
        this._log.error(msg, th);
    }

    private void format(String msg, Object arg0, Object arg1) {
        int i1;
        this._buffer.setLength(0);
        int i0 = msg == null ? -1 : msg.indexOf("{}");
        int n = i1 = i0 < 0 ? -1 : msg.indexOf("{}", i0 + 2);
        if (i0 >= 0) {
            this.format(msg.substring(0, i0));
            this.format(String.valueOf(arg0 == null ? "null" : arg0));
            if (i1 >= 0) {
                this.format(msg.substring(i0 + 2, i1));
                this.format(String.valueOf(arg1 == null ? "null" : arg1));
                this.format(msg.substring(i1 + 2));
            } else {
                this.format(msg.substring(i0 + 2));
                if (arg1 != null) {
                    this._buffer.append(' ');
                    this.format(String.valueOf(arg1));
                }
            }
        } else {
            this.format(msg);
            if (arg0 != null) {
                this._buffer.append(' ');
                this.format(String.valueOf(arg0));
            }
            if (arg1 != null) {
                this._buffer.append(' ');
                this.format(String.valueOf(arg1));
            }
        }
    }

    private void format(String msg) {
        if (msg == null) {
            this._buffer.append("null");
        } else {
            this._buffer.append(msg);
        }
    }

    public Logger getLogger(String name) {
        return this;
    }

    public String toString() {
        return "I2PLogger";
    }

    static {
        System.out.println("INFO: Jetty " + Server.getVersion() + " logging to I2P logs using class " + Server.class.getName());
    }
}

