/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.ArrayList;
import java.util.List;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.util.CDQEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PendingGatewayMessage
implements CDQEntry {
    protected final Hash _toRouter;
    protected final TunnelId _toTunnel;
    protected final long _messageId;
    protected final long _expiration;
    protected final byte[] _remaining;
    protected int _offset;
    protected int _fragmentNumber;
    protected final long _created;
    private List<Long> _messageIds;
    private long _enqueueTime;

    public PendingGatewayMessage(I2NPMessage message, Hash toRouter, TunnelId toTunnel) {
        this._toRouter = toRouter;
        this._toTunnel = toTunnel;
        this._messageId = message.getUniqueId();
        this._expiration = message.getMessageExpiration();
        this._remaining = message.toByteArray();
        this._created = System.currentTimeMillis();
    }

    public Hash getToRouter() {
        return this._toRouter;
    }

    public TunnelId getToTunnel() {
        return this._toTunnel;
    }

    public long getMessageId() {
        return this._messageId;
    }

    public long getExpiration() {
        return this._expiration;
    }

    public byte[] getData() {
        return this._remaining;
    }

    public int getOffset() {
        return this._offset;
    }

    public void setOffset(int offset) {
        this._offset = offset;
    }

    public long getLifetime() {
        return System.currentTimeMillis() - this._created;
    }

    public int getFragmentNumber() {
        return this._fragmentNumber;
    }

    public void incrementFragmentNumber() {
        ++this._fragmentNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageId(long id) {
        PendingGatewayMessage pendingGatewayMessage = this;
        synchronized (pendingGatewayMessage) {
            if (this._messageIds == null) {
                this._messageIds = new ArrayList<Long>();
            }
            this._messageIds.add(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getMessageIds() {
        PendingGatewayMessage pendingGatewayMessage = this;
        synchronized (pendingGatewayMessage) {
            if (this._messageIds != null) {
                return new ArrayList<Long>(this._messageIds);
            }
            return new ArrayList<Long>();
        }
    }

    @Override
    public void setEnqueueTime(long now) {
        this._enqueueTime = now;
    }

    @Override
    public long getEnqueueTime() {
        return this._enqueueTime;
    }

    @Override
    public void drop() {
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("Message ").append(this._messageId);
        if (this._toRouter != null) {
            buf.append(" targetting ");
            buf.append(this._toRouter.toBase64()).append(" ");
            if (this._toTunnel != null) {
                buf.append(this._toTunnel.getTunnelId());
            }
        }
        buf.append(" actual lifetime ");
        buf.append(this.getLifetime()).append("ms");
        buf.append(" potential lifetime ");
        buf.append(this._expiration - this._created).append("ms");
        buf.append(" size ").append(this._remaining.length);
        buf.append(" offset ").append(this._offset);
        buf.append(" frag ").append(this._fragmentNumber);
        return buf.toString();
    }
}

