/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManager;
import net.i2p.app.ClientAppState;
import net.i2p.router.RouterContext;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

public class RouterAppManager
implements ClientAppManager {
    private final RouterContext _context;
    private final Log _log;
    private final Set<ClientApp> _clients;
    private final ConcurrentHashMap<String, ClientApp> _registered;

    public RouterAppManager(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(RouterAppManager.class);
        this._clients = new ConcurrentHashSet(16);
        this._registered = new ConcurrentHashMap(8);
    }

    public void addAndStart(ClientApp app) {
        this._clients.add(app);
        try {
            app.startup();
        }
        catch (Throwable t) {
            this._clients.remove(app);
            this._log.error("Client " + app + " failed to start", t);
        }
    }

    public void notify(ClientApp app, ClientAppState state, String message, Exception e) {
        switch (state) {
            case UNINITIALIZED: 
            case INITIALIZED: {
                if (!this._log.shouldLog(30)) break;
                this._log.warn("Client " + app.getDisplayName() + " called notify for " + state);
                break;
            }
            case STARTING: 
            case RUNNING: {
                if (!this._log.shouldLog(20)) break;
                this._log.info("Client " + app.getDisplayName() + " called notify for " + state);
                break;
            }
            case FORKED: 
            case STOPPING: 
            case STOPPED: {
                this._clients.remove(app);
                this._registered.remove(app.getName(), app);
                if (message == null) {
                    message = "";
                }
                if (!this._log.shouldLog(20)) break;
                this._log.info("Client " + app.getDisplayName() + " called notify for " + state + ' ' + message, (Throwable)e);
                break;
            }
            case CRASHED: 
            case START_FAILED: {
                this._clients.remove(app);
                this._registered.remove(app.getName(), app);
                if (message == null) {
                    message = "";
                }
                this._log.log(50, "Client " + app.getDisplayName() + ' ' + state + ' ' + message, (Throwable)e);
            }
        }
    }

    public boolean register(ClientApp app) {
        if (!this._clients.contains(app)) {
            return false;
        }
        return this._registered.putIfAbsent(app.getName(), app) == null;
    }

    public void unregister(ClientApp app) {
        this._registered.remove(app.getName(), app);
    }

    public ClientApp getRegisteredApp(String name) {
        return this._registered.get(name);
    }
}

