/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.math.BigInteger;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.router.networkdb.kademlia.KBucket;
import net.i2p.router.networkdb.kademlia.KBucketImpl;
import net.i2p.router.networkdb.kademlia.LocalHash;
import net.i2p.router.networkdb.kademlia.SelectionCollector;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KBucketSet {
    private final Log _log;
    private final I2PAppContext _context;
    private final LocalHash _us;
    private final KBucket[] _buckets;
    private volatile int _size;
    public static final int BASE = 8;
    public static final int KEYSIZE_BITS = 256;
    public static final int NUM_BUCKETS = 32;
    private static final BigInteger BASE_I = new BigInteger("256");
    public static final int BUCKET_SIZE = 500;

    public KBucketSet(I2PAppContext context, Hash us) {
        this._us = new LocalHash(us);
        this._context = context;
        this._log = context.logManager().getLog(KBucketSet.class);
        this._buckets = this.createBuckets();
        context.statManager().createRateStat("netDb.KBSGetAllTime", "Time to add all Hashes to the Collector", "NetworkDatabase", new long[]{3600000L});
    }

    public boolean add(Hash peer) {
        int bucket = this.pickBucket(peer);
        if (bucket >= 0) {
            int oldSize = this._buckets[bucket].getKeyCount();
            int numInBucket = this._buckets[bucket].add(peer);
            if (numInBucket != oldSize) {
                ++this._size;
            }
            if (numInBucket > 500) {
                // empty if block
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Peer " + peer + " added to bucket " + bucket);
            }
            return oldSize != numInBucket;
        }
        throw new IllegalArgumentException("Unable to pick a bucket.  wtf!");
    }

    public int size() {
        return this._size;
    }

    public boolean remove(Hash entry) {
        int bucket = this.pickBucket(entry);
        KBucket kbucket = this.getBucket(bucket);
        boolean removed = kbucket.remove(entry);
        if (removed) {
            --this._size;
        }
        return removed;
    }

    public void clear() {
        for (int i = 0; i < this._buckets.length; ++i) {
            this._buckets[i].setEntries(Collections.EMPTY_SET);
        }
        this._size = 0;
        this._us.clearXorCache();
    }

    public Set<Hash> getAll() {
        return this.getAll(Collections.EMPTY_SET);
    }

    public Set<Hash> getAll(Set<Hash> toIgnore) {
        HashSet<Hash> all = new HashSet<Hash>(1024);
        for (int i = 0; i < this._buckets.length; ++i) {
            all.addAll(this._buckets[i].getEntries());
        }
        all.removeAll(toIgnore);
        return all;
    }

    public void getAll(SelectionCollector collector) {
        long start = this._context.clock().now();
        for (int i = 0; i < this._buckets.length; ++i) {
            this._buckets[i].getEntries(collector);
        }
        this._context.statManager().addRateData("netDb.KBSGetAllTime", this._context.clock().now() - start, 0L);
    }

    public int pickBucket(Hash key) {
        for (int i = 0; i < 32; ++i) {
            if (!this._buckets[i].shouldContain(key)) continue;
            return i;
        }
        this._log.error("Key does not fit in any bucket?! WTF!\nKey  : [" + DataHelper.toHexString((byte[])key.getData()) + "]" + "\nUs   : [" + KBucketSet.toString(this._us.getData()) + "]" + "\nDelta: [" + DataHelper.toHexString((byte[])DataHelper.xor((byte[])this._us.getData(), (byte[])key.getData())) + "]", (Throwable)new Exception("WTF"));
        this.displayBuckets();
        return -1;
    }

    public KBucket getBucket(int bucket) {
        return this._buckets[bucket];
    }

    protected KBucket[] createBuckets() {
        KBucket[] buckets = new KBucket[32];
        for (int i = 0; i < 31; ++i) {
            buckets[i] = this.createBucket(i * 8, (i + 1) * 8);
        }
        buckets[31] = this.createBucket(248, 257);
        return buckets;
    }

    protected KBucket createBucket(int start, int end) {
        KBucketImpl bucket = new KBucketImpl(this._context, this._us);
        bucket.setRange(start, end);
        this._log.debug("Creating a bucket from " + start + " to " + end);
        return bucket;
    }

    public void displayBuckets() {
        this._log.info(this.toString());
    }

    public String toString() {
        BigInteger us = new BigInteger(1, this._us.getData());
        StringBuilder buf = new StringBuilder(1024);
        buf.append("Bucket set rooted on: ").append(us.toString()).append(" (aka ").append(us.toString(2)).append("): \n");
        for (int i = 0; i < 32; ++i) {
            buf.append("* Bucket ").append(i).append("/").append(31).append(": )\n");
            buf.append("Start:  ").append("2^").append(this._buckets[i].getRangeBegin()).append(")\n");
            buf.append("End:    ").append("2^").append(this._buckets[i].getRangeEnd()).append(")\n");
            buf.append("Contents:").append(this._buckets[i].toString()).append("\n");
        }
        return buf.toString();
    }

    static final String toString(byte[] b) {
        byte[] val = new byte[32];
        if (b.length < 32) {
            System.arraycopy(b, 0, val, 32 - b.length - 1, b.length);
        } else {
            System.arraycopy(b, 32 - b.length, val, 0, val.length);
        }
        StringBuilder buf = new StringBuilder(256);
        for (int i = 0; i < val.length; ++i) {
            for (int j = 7; j >= 0; --j) {
                boolean bb;
                boolean bl = bb = 0 != (val[i] & 1 << j);
                if (bb) {
                    buf.append("1");
                    continue;
                }
                buf.append("0");
            }
            buf.append(" ");
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        I2PAppContext context = I2PAppContext.getGlobalContext();
        Log log = context.logManager().getLog(KBucketSet.class);
        KBucketSet set = new KBucketSet(context, Hash.FAKE_HASH);
        KBucketSet.testSelf(set, log);
        KBucketSet.testRandom(set, 1000, context, log);
    }

    private static void testSelf(KBucketSet set, Log log) {
        boolean added = set.add(Hash.FAKE_HASH);
        if (!added) {
            log.error("Unable to add self...");
        } else {
            log.debug("Added self");
        }
    }

    private static void testRandom(KBucketSet set, int count, I2PAppContext context, Log log) {
        for (int i = 0; i < count; ++i) {
            byte[] val = new byte[32];
            context.random().nextBytes(val);
            boolean added = set.add(new Hash(val));
            if (!added) {
                log.error("Unable to add random key [" + DataHelper.toHexString((byte[])val) + "]");
                continue;
            }
            log.debug("Added random key");
        }
    }
}

