/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark.dht;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import net.i2p.I2PAppContext;
import net.i2p.data.DataFormatException;
import net.i2p.util.Log;
import net.i2p.util.SecureFileOutputStream;
import org.klomp.snark.dht.DHTNodes;
import org.klomp.snark.dht.KRPC;
import org.klomp.snark.dht.NodeInfo;

abstract class PersistDHT {
    private static final long MAX_AGE = 3600000L;

    PersistDHT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void loadDHT(KRPC krpc, File file) {
        Log log = I2PAppContext.getGlobalContext().logManager().getLog(PersistDHT.class);
        int count = 0;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "ISO-8859-1"));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                try {
                    krpc.heardAbout(new NodeInfo(line));
                    ++count;
                }
                catch (IllegalArgumentException iae) {
                    if (!log.shouldLog(30)) continue;
                    log.warn("Error reading DHT entry", iae);
                }
                catch (DataFormatException dfe) {
                    if (!log.shouldLog(30)) continue;
                    log.warn("Error reading DHT entry", dfe);
                }
            }
        }
        catch (IOException ioe) {
            if (log.shouldLog(30) && file.exists()) {
                log.warn("Error reading the DHT File", ioe);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
        if (log.shouldLog(20)) {
            log.info("Loaded " + count + " nodes from " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void saveDHT(DHTNodes nodes, boolean saveAll, File file) {
        if (nodes.size() <= 0) {
            return;
        }
        Log log = I2PAppContext.getGlobalContext().logManager().getLog(PersistDHT.class);
        int count = 0;
        long maxAge = saveAll ? 0L : I2PAppContext.getGlobalContext().clock().now() - 3600000L;
        PrintWriter out = null;
        try {
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new SecureFileOutputStream(file), "ISO-8859-1")));
            out.println("# DHT nodes, format is NID:Hash:Destination:port");
            for (NodeInfo ni : nodes.values()) {
                if (ni.lastSeen() < maxAge) continue;
                out.println(ni.toPersistentString());
                ++count;
            }
        }
        catch (IOException ioe) {
            if (log.shouldLog(30)) {
                log.warn("Error writing the DHT File", ioe);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        if (log.shouldLog(20)) {
            log.info("Stored " + count + " nodes to " + file);
        }
    }
}

