/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import net.i2p.I2PAppContext;
import net.i2p.client.streaming.impl.BandwidthEstimator;
import net.i2p.client.streaming.impl.ConnectionOptions;
import net.i2p.data.DataHelper;
import net.i2p.util.Log;

class SimpleBandwidthEstimator
implements BandwidthEstimator {
    private final I2PAppContext _context;
    private final Log _log;
    private final ConnectionOptions _opts;
    private long _tAck;
    private float _bKFiltered;
    private float _bK_ns_est;
    private int _acked;
    private static final int DECAY_FACTOR = 8;
    private static final int WESTWOOD_RTT_MIN = 500;

    SimpleBandwidthEstimator(I2PAppContext ctx, ConnectionOptions opts) {
        this._log = ctx.logManager().getLog(SimpleBandwidthEstimator.class);
        this._context = ctx;
        this._opts = opts;
        this._tAck = ctx.clock().now();
        this._acked = -1;
    }

    @Override
    public synchronized void addSample(int acked) {
        long now = this._context.clock().now();
        if (this._acked < 0) {
            float bkdt;
            long deltaT = Math.max(now - this._tAck, 500L);
            this._bKFiltered = bkdt = (float)acked / (float)deltaT;
            this._bK_ns_est = bkdt;
            this._acked = 0;
            this._tAck = now;
            if (this._log.shouldDebug()) {
                this._log.debug("first sample packets: " + acked + " deltaT: " + deltaT + ' ' + this);
            }
        } else {
            this._acked += acked;
            if (now - this._tAck >= (long)Math.max(this._opts.getRTT(), 500)) {
                this.computeBWE(now);
            }
        }
    }

    @Override
    public synchronized float getBandwidthEstimate() {
        long now = this._context.clock().now();
        if (now - this._tAck >= (long)Math.max(this._opts.getRTT(), 500)) {
            return this.computeBWE(now);
        }
        return this._bKFiltered;
    }

    private synchronized float computeBWE(long now) {
        if (this._acked < 0) {
            return 0.0f;
        }
        this.updateBK(now, this._acked);
        this._acked = 0;
        return this._bKFiltered;
    }

    private void decay() {
        this._bK_ns_est *= 0.875f;
        this._bKFiltered = SimpleBandwidthEstimator.westwood_do_filter(this._bKFiltered, this._bK_ns_est);
    }

    private void updateBK(long time, int packets) {
        float bkdt;
        long deltaT = time - this._tAck;
        int rtt = Math.max(this._opts.getRTT(), 500);
        if (deltaT > (long)(2 * rtt)) {
            int numrtts = Math.min((int)(deltaT / (long)rtt - 1L), 16);
            for (int i = 0; i < numrtts; ++i) {
                this.decay();
            }
            deltaT -= (long)(numrtts * rtt);
            if (this._log.shouldDebug()) {
                this._log.debug("decayed " + numrtts + " times, new _bK_ns_est: " + this._bK_ns_est + ' ' + this);
            }
        }
        if (packets > 0) {
            bkdt = (float)packets / (float)deltaT;
            this._bK_ns_est = SimpleBandwidthEstimator.westwood_do_filter(this._bK_ns_est, bkdt);
            this._bKFiltered = SimpleBandwidthEstimator.westwood_do_filter(this._bKFiltered, this._bK_ns_est);
        } else {
            bkdt = 0.0f;
            this.decay();
        }
        this._tAck = time;
        if (this._log.shouldDebug()) {
            this._log.debug("computeBWE packets: " + packets + " deltaT: " + deltaT + " bk/deltaT: " + bkdt + " _bK_ns_est: " + this._bK_ns_est + ' ' + this);
        }
    }

    private static float westwood_do_filter(float a, float b) {
        return (7.0f * a + b) / 8.0f;
    }

    public synchronized String toString() {
        return "SBE[ _bKFiltered " + this._bKFiltered + " _tAck " + this._tAck + "; " + DataHelper.formatSize2Decimal((long)((long)(this._bKFiltered * 1000.0f * (float)this._opts.getMaxMessageSize())), (boolean)false) + "Bps]";
    }
}

