/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import com.southernstorm.noise.protocol.CipherState;
import com.southernstorm.noise.protocol.CipherStatePair;
import com.southernstorm.noise.protocol.HandshakeState;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.i2p.crypto.SigType;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.Signature;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.transport.crypto.DHSessionKeyBuilder;
import net.i2p.router.transport.ntcp.EstablishBase;
import net.i2p.router.transport.ntcp.NTCP2Options;
import net.i2p.router.transport.ntcp.NTCP2Payload;
import net.i2p.router.transport.ntcp.NTCPConnection;
import net.i2p.router.transport.ntcp.NTCPTransport;
import net.i2p.router.transport.ntcp.OutboundNTCP2State;
import net.i2p.util.ByteArrayStream;
import net.i2p.util.ByteCache;
import net.i2p.util.HexDump;
import net.i2p.util.SimpleByteCache;

class InboundEstablishState
extends EstablishBase
implements NTCP2Payload.PayloadCallback {
    private byte[] _curEncrypted;
    private int _aliceIdentSize;
    private RouterIdentity _aliceIdent;
    private final ByteArrayOutputStream _sz_aliceIdent_tsA_padding_aliceSig;
    private int _sz_aliceIdent_tsA_padding_aliceSigSize;
    private boolean _released;
    private HandshakeState _handshakeState;
    private int _padlen1;
    private int _msg3p2len;
    private int _msg3p2FailReason = -1;
    private ByteArray _msg3tmp;
    private NTCP2Options _hisPadding;
    private static final int BUFFER_SIZE = 4096;
    private static final int MAX_DATA_READ_BUFS = 32;
    private static final ByteCache _dataReadBufs = ByteCache.getInstance(32, 4096);
    private static final int NTCP1_MSG1_SIZE = 288;
    private static final int PADDING1_MAX = 223;
    private static final int PADDING1_FAIL_MAX = 128;
    private static final int PADDING2_MAX = 64;
    private static final int RI_MIN = 439;
    private static final int MSG3P2_MIN = 459;
    private static final int MSG3P2_MAX = 6000;
    private static final Set<EstablishBase.State> STATES_NTCP2 = EnumSet.of(EstablishBase.State.IB_NTCP2_INIT, new EstablishBase.State[]{EstablishBase.State.IB_NTCP2_GOT_X, EstablishBase.State.IB_NTCP2_GOT_PADDING, EstablishBase.State.IB_NTCP2_SENT_Y, EstablishBase.State.IB_NTCP2_GOT_RI, EstablishBase.State.IB_NTCP2_READ_RANDOM});
    private static final Set<EstablishBase.State> STATES_MSG3 = EnumSet.of(EstablishBase.State.IB_SENT_Y, EstablishBase.State.IB_GOT_RI_SIZE, EstablishBase.State.IB_GOT_RI);

    public InboundEstablishState(RouterContext ctx, NTCPTransport transport, NTCPConnection con) {
        super(ctx, transport, con);
        this._state = EstablishBase.State.IB_INIT;
        this._sz_aliceIdent_tsA_padding_aliceSig = new ByteArrayOutputStream(512);
        this._prevEncrypted = SimpleByteCache.acquire(16);
        this._curEncrypted = SimpleByteCache.acquire(16);
    }

    @Override
    public synchronized void receive(ByteBuffer src) {
        super.receive(src);
        if (!src.hasRemaining()) {
            return;
        }
        this.receiveInbound(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getVersion() {
        if (!this._transport.isNTCP2Enabled()) {
            return 1;
        }
        if (!this._transport.isNTCP1Enabled()) {
            return 2;
        }
        Object object = this._stateLock;
        synchronized (object) {
            if (this._state == EstablishBase.State.IB_INIT) {
                return 0;
            }
            if (STATES_NTCP2.contains((Object)this._state)) {
                return 2;
            }
            return 1;
        }
    }

    private void receiveInbound(ByteBuffer src) {
        int toGet;
        if (STATES_NTCP2.contains((Object)this._state)) {
            this.receiveInboundNTCP2(src);
            return;
        }
        if (this._state == EstablishBase.State.IB_INIT && src.hasRemaining()) {
            int remaining = src.remaining();
            if (this._transport.isNTCP2Enabled()) {
                if (remaining + this._received < 64) {
                    src.get(this._X, this._received, remaining);
                    this._received += remaining;
                    if (this._log.shouldWarn()) {
                        this._log.warn("Short buffer got " + remaining + " total now " + this._received + " on " + this);
                    }
                    return;
                }
                if (remaining + this._received < 288 || !this._transport.isNTCP1Enabled()) {
                    this._con.setVersion(2);
                    this.changeState(EstablishBase.State.IB_NTCP2_INIT);
                    this.receiveInboundNTCP2(src);
                    return;
                }
            }
            int toGet2 = Math.min(remaining, 256 - this._received);
            src.get(this._X, this._received, toGet2);
            this._received += toGet2;
            if (this._received < 256) {
                return;
            }
            this.changeState(EstablishBase.State.IB_GOT_X);
            this._received = 0;
        }
        if (this._state == EstablishBase.State.IB_GOT_X && src.hasRemaining()) {
            toGet = Math.min(src.remaining(), 32 - this._received);
            src.get(this._hX_xor_bobIdentHash, this._received, toGet);
            this._received += toGet;
            if (this._received < 32) {
                return;
            }
            this.changeState(EstablishBase.State.IB_GOT_HX);
            this._received = 0;
        }
        if (this._state == EstablishBase.State.IB_GOT_HX) {
            if (this._log.shouldLog(10)) {
                this._log.debug(this.prefix() + "Enough data for a DH received");
            }
            byte[] realXor = SimpleByteCache.acquire(32);
            this._context.sha().calculateHash(this._X, 0, 256, realXor, 0);
            InboundEstablishState.xor32(this._context.routerHash().getData(), realXor);
            if (!DataHelper.eq(realXor, this._hX_xor_bobIdentHash)) {
                SimpleByteCache.release(realXor);
                this._context.statManager().addRateData("ntcp.invalidHXxorBIH", 1L);
                this.fail("Invalid hX_xor");
                return;
            }
            SimpleByteCache.release(realXor);
            if (!this._transport.isHXHIValid(this._hX_xor_bobIdentHash)) {
                this._context.statManager().addRateData("ntcp.replayHXxorBIH", 1L);
                this.fail("Replay hX_xor");
                return;
            }
            try {
                this._dh.setPeerPublicValue(this._X);
                this._dh.getSessionKey();
                System.arraycopy(this._hX_xor_bobIdentHash, 16, this._prevEncrypted, 0, 16);
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "DH session key calculated (" + this._dh.getSessionKey().toBase64() + ")");
                }
                byte[] xy = new byte[512];
                System.arraycopy(this._X, 0, xy, 0, 256);
                System.arraycopy(this._Y, 0, xy, 256, 256);
                byte[] hxy = SimpleByteCache.acquire(32);
                this._context.sha().calculateHash(xy, 0, 512, hxy, 0);
                this._tsB = (this._context.clock().now() + 500L) / 1000L;
                byte[] toEncrypt = new byte[48];
                System.arraycopy(hxy, 0, toEncrypt, 0, 32);
                byte[] tsB = DataHelper.toLong(4, this._tsB);
                System.arraycopy(tsB, 0, toEncrypt, 32, tsB.length);
                this._context.random().nextBytes(toEncrypt, 36, 12);
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "h(x+y)=" + Base64.encode(hxy));
                    this._log.debug(this.prefix() + "tsb = " + this._tsB);
                    this._log.debug(this.prefix() + "unencrypted H(X+Y)+tsB+padding: " + Base64.encode(toEncrypt));
                    this._log.debug(this.prefix() + "encryption iv= " + Base64.encode(this._Y, 240, 16));
                    this._log.debug(this.prefix() + "encryption key= " + this._dh.getSessionKey().toBase64());
                }
                SimpleByteCache.release(hxy);
                this._context.aes().encrypt(toEncrypt, 0, this._e_hXY_tsB, 0, this._dh.getSessionKey(), this._Y, 240, 48);
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "encrypted H(X+Y)+tsB+padding: " + Base64.encode(this._e_hXY_tsB));
                }
                byte[] write = new byte[304];
                System.arraycopy(this._Y, 0, write, 0, 256);
                System.arraycopy(this._e_hXY_tsB, 0, write, 256, 48);
                this.changeState(EstablishBase.State.IB_SENT_Y);
                this._transport.getPumper().wantsWrite(this._con, write);
                if (!src.hasRemaining()) {
                    return;
                }
            }
            catch (DHSessionKeyBuilder.InvalidPublicParameterException e) {
                this._context.statManager().addRateData("ntcp.invalidDH", 1L);
                this.fail("Invalid X", e);
                return;
            }
            catch (IllegalStateException ise) {
                this.fail("reused keys?", ise);
                return;
            }
        }
        while (STATES_MSG3.contains((Object)this._state) && src.hasRemaining()) {
            block39: {
                if (this._received < 16 && src.hasRemaining()) {
                    toGet = Math.min(src.remaining(), 16 - this._received);
                    src.get(this._curEncrypted, this._received, toGet);
                    this._received += toGet;
                    if (this._received < 16) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug(this.prefix() + "end of available data with only a partial block read (" + this._received + ")");
                        }
                        return;
                    }
                }
                if (this._received < 16) continue;
                this._context.aes().decrypt(this._curEncrypted, 0, this._curDecrypted, 0, this._dh.getSessionKey(), this._prevEncrypted, 0, 16);
                byte[] swap = this._prevEncrypted;
                this._prevEncrypted = this._curEncrypted;
                this._curEncrypted = swap;
                this._received = 0;
                if (this._state == EstablishBase.State.IB_SENT_Y) {
                    int sz = (int)DataHelper.fromLong(this._curDecrypted, 0, 2);
                    if (sz < 387 || sz > 3072) {
                        this._context.statManager().addRateData("ntcp.invalidInboundSize", sz);
                        this.fail("size is invalid", new Exception("size is " + sz));
                        return;
                    }
                    if (this._log.shouldLog(10)) {
                        this._log.debug(this.prefix() + "got the RI size: " + sz);
                    }
                    this._aliceIdentSize = sz;
                    this.changeState(EstablishBase.State.IB_GOT_RI_SIZE);
                }
                try {
                    this._sz_aliceIdent_tsA_padding_aliceSig.write(this._curDecrypted);
                }
                catch (IOException ioe) {
                    if (!this._log.shouldLog(40)) break block39;
                    this._log.error(this.prefix() + "Error writing to the baos?", ioe);
                }
            }
            if (this._state == EstablishBase.State.IB_GOT_RI_SIZE && this._sz_aliceIdent_tsA_padding_aliceSig.size() >= 2 + this._aliceIdentSize) {
                this.readAliceRouterIdentity();
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "got the RI");
                }
                if (this._aliceIdent == null) {
                    return;
                }
                SigType type = this._aliceIdent.getSigningPublicKey().getType();
                if (type == null) {
                    this.fail("Unsupported sig type");
                    return;
                }
                this.changeState(EstablishBase.State.IB_GOT_RI);
                this._sz_aliceIdent_tsA_padding_aliceSigSize = 2 + this._aliceIdentSize + 4 + type.getSigLen();
                int rem = this._sz_aliceIdent_tsA_padding_aliceSigSize % 16;
                int padding = 0;
                if (rem > 0) {
                    padding = 16 - rem;
                }
                this._sz_aliceIdent_tsA_padding_aliceSigSize += padding;
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "alice ident size decrypted as " + this._aliceIdentSize + ", making the padding at " + padding + " and total size at " + this._sz_aliceIdent_tsA_padding_aliceSigSize);
                }
            }
            if (this._state != EstablishBase.State.IB_GOT_RI || this._sz_aliceIdent_tsA_padding_aliceSig.size() < this._sz_aliceIdent_tsA_padding_aliceSigSize) continue;
            if (this._log.shouldLog(10)) {
                this._log.debug(this.prefix() + "got the sig");
            }
            this.verifyInbound(src);
            if (this._log.shouldLog(10)) {
                this._log.debug(this.prefix() + "verifying size (sz=" + this._sz_aliceIdent_tsA_padding_aliceSig.size() + " expected=" + this._sz_aliceIdent_tsA_padding_aliceSigSize + ' ' + (Object)((Object)this._state) + ')');
            }
            return;
        }
        if (STATES_DONE.contains((Object)this._state) && src.hasRemaining() && this._log.shouldWarn()) {
            this._log.warn("Received unexpected " + src.remaining() + " on " + this, new Exception());
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.prefix() + "done with the data, not yet complete or corrupt");
        }
    }

    private void readAliceRouterIdentity() {
        byte[] b = this._sz_aliceIdent_tsA_padding_aliceSig.toByteArray();
        try {
            int sz = this._aliceIdentSize;
            if (sz < 387 || sz > 3072 || sz > b.length - 2) {
                this._context.statManager().addRateData("ntcp.invalidInboundSize", sz);
                this.fail("size is invalid", new Exception("size is " + sz));
                return;
            }
            RouterIdentity alice = new RouterIdentity();
            ByteArrayInputStream bais = new ByteArrayInputStream(b, 2, sz);
            alice.readBytes(bais);
            this._aliceIdent = alice;
        }
        catch (IOException ioe) {
            this._context.statManager().addRateData("ntcp.invalidInboundIOE", 1L);
            this.fail("Error verifying peer", ioe);
        }
        catch (DataFormatException dfe) {
            this._context.statManager().addRateData("ntcp.invalidInboundDFE", 1L);
            this.fail("Error verifying peer", dfe);
        }
    }

    private void verifyInbound(ByteBuffer buf) {
        byte[] b = this._sz_aliceIdent_tsA_padding_aliceSig.toByteArray();
        try {
            int sz = this._aliceIdentSize;
            long tsA = DataHelper.fromLong(b, 2 + sz, 4);
            long now = this._context.clock().now();
            long rtt = now - this._con.getCreated();
            this._peerSkew = (now - tsA * 1000L - rtt / 2L + 500L) / 1000L;
            ByteArrayStream baos = new ByteArrayStream(552);
            baos.write(this._X);
            baos.write(this._Y);
            baos.write(this._context.routerHash().getData());
            baos.write(DataHelper.toLong(4, tsA));
            baos.write(DataHelper.toLong(4, this._tsB));
            byte[] toVerify = baos.toByteArray();
            SigType type = this._aliceIdent.getSigningPublicKey().getType();
            if (type == null) {
                this.fail("unsupported sig type");
                return;
            }
            byte[] s = new byte[type.getSigLen()];
            System.arraycopy(b, b.length - s.length, s, 0, s.length);
            Signature sig = new Signature(type, s);
            boolean ok = this._context.dsa().verifySignature(sig, toVerify, this._aliceIdent.getSigningPublicKey());
            Hash aliceHash = this._aliceIdent.calculateHash();
            if (ok) {
                ok = this.verifyInbound(aliceHash);
            }
            if (ok) {
                this._con.setRemotePeer(this._aliceIdent);
                this.sendInboundConfirm(aliceHash, tsA);
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "e_bobSig is " + this._e_bobSig.length + " bytes long");
                }
                byte[] iv = this._curEncrypted;
                System.arraycopy(this._e_bobSig, this._e_bobSig.length - 16, iv, 0, 16);
                this._con.finishInboundEstablishment(this._dh.getSessionKey(), this._peerSkew, iv, this._prevEncrypted);
                this.changeState(EstablishBase.State.VERIFIED);
                if (buf.hasRemaining()) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("extra data " + buf.remaining() + " on " + this);
                    }
                    this._con.recvEncryptedI2NP(buf);
                }
                this.releaseBufs(true);
                if (this._log.shouldLog(20)) {
                    this._log.info(this.prefix() + "Verified remote peer as " + aliceHash);
                }
            } else {
                this._context.statManager().addRateData("ntcp.invalidInboundSignature", 1L);
            }
        }
        catch (IOException ioe) {
            this._context.statManager().addRateData("ntcp.invalidInboundIOE", 1L);
            this.fail("Error verifying peer", ioe);
        }
    }

    private boolean verifyInbound(Hash aliceHash) {
        byte[] ip;
        InetAddress addr = this._con.getChannel().socket().getInetAddress();
        byte[] byArray = ip = addr == null ? null : addr.getAddress();
        if (this._context.banlist().isBanlistedForever(aliceHash)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Dropping inbound connection from permanently banlisted peer: " + aliceHash);
            }
            if (ip != null) {
                this._context.blocklist().add(ip);
            }
            if (this.getVersion() < 2) {
                this.fail("Peer is banlisted forever: " + aliceHash);
            } else if (this._log.shouldWarn()) {
                this._log.warn("Peer is banlisted forever: " + aliceHash);
            }
            this._msg3p2FailReason = 17;
            return false;
        }
        if (ip != null) {
            this._transport.setIP(aliceHash, ip);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.prefix() + "verification successful for " + this._con);
        }
        long diff = 1000L * Math.abs(this._peerSkew);
        if (!this._context.clock().getUpdatedSuccessfully()) {
            this._context.clock().setOffset(1000L * (0L - this._peerSkew), true);
            this._peerSkew = 0L;
            if (diff != 0L) {
                this._log.logAlways(30, "NTP failure, NTCP adjusting clock by " + DataHelper.formatDuration(diff));
            }
        } else {
            if (diff >= 60000L) {
                this._context.statManager().addRateData("ntcp.invalidInboundSkew", diff);
                this._transport.markReachable(aliceHash, true);
                this._context.banlist().banlistRouter(DataHelper.formatDuration(diff), aliceHash, InboundEstablishState._x("Excessive clock skew: {0}"));
                this._transport.setLastBadSkew(this._peerSkew);
                if (this.getVersion() < 2) {
                    this.fail("Clocks too skewed (" + diff + " ms)", null, true);
                } else if (this._log.shouldWarn()) {
                    this._log.warn("Clocks too skewed (" + diff + " ms)");
                }
                this._msg3p2FailReason = 7;
                return false;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug(this.prefix() + "Clock skew: " + diff + " ms");
            }
        }
        return true;
    }

    private boolean verifyInboundNetworkID(RouterInfo alice) {
        boolean rv;
        int aliceID = alice.getNetworkId();
        boolean bl = rv = aliceID == this._context.router().getNetworkID();
        if (!rv) {
            InetAddress addr;
            Hash aliceHash = alice.getHash();
            if (this._log.shouldLog(30)) {
                this._log.warn("Not in our network: " + alice, new Exception());
            }
            if ((addr = this._con.getChannel().socket().getInetAddress()) != null) {
                byte[] ip = addr.getAddress();
                this._context.blocklist().add(ip);
            }
            this._context.banlist().banlistRouterForever(aliceHash, "Not in our network: " + aliceID);
            this._transport.markUnreachable(aliceHash);
            this._msg3p2FailReason = 17;
        }
        return rv;
    }

    private void sendInboundConfirm(Hash h, long tsA) {
        byte[] toSign = new byte[552];
        int off = 0;
        System.arraycopy(this._X, 0, toSign, off, 256);
        System.arraycopy(this._Y, 0, toSign, off += 256, 256);
        System.arraycopy(h.getData(), 0, toSign, off += 256, 32);
        DataHelper.toLong(toSign, off += 32, 4, tsA);
        DataHelper.toLong(toSign, off += 4, 4, this._tsB);
        off += 4;
        Signature sig = this._context.dsa().sign(toSign, this._context.keyManager().getSigningPrivateKey());
        int siglen = sig.length();
        int rem = siglen % 16;
        int padding = rem > 0 ? 16 - rem : 0;
        byte[] preSig = new byte[siglen + padding];
        System.arraycopy(sig.getData(), 0, preSig, 0, siglen);
        if (padding > 0) {
            this._context.random().nextBytes(preSig, siglen, padding);
        }
        this._e_bobSig = new byte[preSig.length];
        this._context.aes().encrypt(preSig, 0, this._e_bobSig, 0, this._dh.getSessionKey(), this._e_hXY_tsB, 32, this._e_bobSig.length);
        if (this._log.shouldLog(10)) {
            this._log.debug(this.prefix() + "Sending encrypted inbound confirmation");
        }
        this._transport.getPumper().wantsWrite(this._con, this._e_bobSig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void receiveInboundNTCP2(ByteBuffer src) {
        int toGet;
        if (this._state == EstablishBase.State.IB_NTCP2_INIT && src.hasRemaining()) {
            int v;
            toGet = Math.min(src.remaining(), 64 - this._received);
            src.get(this._X, this._received, toGet);
            this._received += toGet;
            if (this._received < 64) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Short buffer got " + toGet + " total now " + this._received);
                }
                return;
            }
            this.changeState(EstablishBase.State.IB_NTCP2_GOT_X);
            this._received = 0;
            if (!this._transport.isHXHIValid(this._X)) {
                this._context.statManager().addRateData("ntcp.replayHXxorBIH", 1L);
                this.fail("Replay msg 1, eX = " + Base64.encode(this._X, 0, 32));
                return;
            }
            Hash h = this._context.routerHash();
            SessionKey bobHash = new SessionKey(h.getData());
            System.arraycopy(this._X, 16, this._prevEncrypted, 0, 16);
            this._context.aes().decrypt(this._X, 0, this._X, 0, bobHash, this._transport.getNTCP2StaticIV(), 32);
            if (DataHelper.eqCT(this._X, 0, OutboundNTCP2State.ZEROKEY, 0, 32)) {
                this.fail("Bad msg 1, X = 0");
                return;
            }
            if ((this._X[31] & 0x80) != 0) {
                this.fail("Bad PK msg 1");
                return;
            }
            try {
                this._handshakeState = new HandshakeState("XK", 2, this._transport.getXDHFactory());
            }
            catch (GeneralSecurityException gse) {
                throw new IllegalStateException("bad proto", gse);
            }
            this._handshakeState.getLocalKeyPair().setKeys(this._transport.getNTCP2StaticPrivkey(), 0, this._transport.getNTCP2StaticPubkey(), 0);
            byte[] options = new byte[16];
            try {
                this._handshakeState.start();
                if (this._log.shouldDebug()) {
                    this._log.debug("After start: " + this._handshakeState.toString());
                }
                this._handshakeState.readMessage(this._X, 0, 64, options, 0);
            }
            catch (GeneralSecurityException gse) {
                this._padlen1 = this._context.random().nextInt(128) - src.remaining();
                if (this._padlen1 > 0) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Bad msg 1, X = " + Base64.encode(this._X, 0, 32) + " with " + src.remaining() + " more bytes, waiting for " + this._padlen1 + " more bytes", gse);
                    }
                    this.changeState(EstablishBase.State.IB_NTCP2_READ_RANDOM);
                } else {
                    this.fail("Bad msg 1, X = " + Base64.encode(this._X, 0, 32) + " remaining = " + src.remaining(), gse);
                }
                return;
            }
            catch (RuntimeException re) {
                this.fail("Bad msg 1, X = " + Base64.encode(this._X, 0, 32), re);
                return;
            }
            if (this._log.shouldDebug()) {
                this._log.debug("After msg 1: " + this._handshakeState.toString());
            }
            if ((v = options[1] & 0xFF) != 2) {
                this.fail("Bad version: " + v);
                return;
            }
            v = options[0] & 0xFF;
            if (v != 0 && v != this._context.router().getNetworkID()) {
                InetAddress addr = this._con.getChannel().socket().getInetAddress();
                if (addr != null) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Dropping inbound connection from wrong network: " + addr);
                    }
                    byte[] ip = addr.getAddress();
                    this._context.blocklist().add(ip);
                }
                this.fail("Bad network id: " + v);
                return;
            }
            this._padlen1 = (int)DataHelper.fromLong(options, 2, 2);
            this._msg3p2len = (int)DataHelper.fromLong(options, 4, 2);
            long tsA = DataHelper.fromLong(options, 8, 4);
            long now = this._context.clock().now();
            long rtt = 250L;
            this._peerSkew = (now - tsA * 1000L - rtt / 2L + 500L) / 1000L;
            if (!(this._peerSkew <= 60L && this._peerSkew >= -60L || this._context.clock().getUpdatedSuccessfully())) {
                this.fail("Clock Skew: " + this._peerSkew, null, true);
                return;
            }
            if (this._padlen1 > 223 && this._transport.isNTCP1Enabled()) {
                this.fail("bad msg 1 padlen: " + this._padlen1);
                return;
            }
            if (this._msg3p2len < 459 || this._msg3p2len > 6000) {
                this.fail("bad msg3p2 len: " + this._msg3p2len);
                return;
            }
            if (this._padlen1 <= 0) {
                this.changeState(EstablishBase.State.IB_NTCP2_GOT_PADDING);
                if (src.hasRemaining()) {
                    this.fail("Extra data after msg 1: " + src.remaining());
                } else {
                    this.prepareOutbound2();
                }
                return;
            }
        }
        if (this._state == EstablishBase.State.IB_NTCP2_READ_RANDOM && src.hasRemaining()) {
            this._received += src.remaining();
            if (this._received < this._padlen1) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Bad msg 1, got " + src.remaining() + " more bytes, waiting for " + (this._padlen1 - this._received) + " more bytes");
                }
            } else {
                this.fail("Bad msg 1, failing after getting " + src.remaining() + " more bytes");
            }
            return;
        }
        if (this._state == EstablishBase.State.IB_NTCP2_GOT_X && src.hasRemaining()) {
            toGet = Math.min(src.remaining(), this._padlen1 - this._received);
            src.get(this._X, this._received, toGet);
            this._received += toGet;
            if (this._received < this._padlen1) {
                return;
            }
            this.changeState(EstablishBase.State.IB_NTCP2_GOT_PADDING);
            this._handshakeState.mixHash(this._X, 0, this._padlen1);
            if (this._log.shouldDebug()) {
                this._log.debug("After mixhash padding " + this._padlen1 + " msg 1: " + this._handshakeState.toString());
            }
            this._received = 0;
            if (src.hasRemaining()) {
                this.fail("Extra data after msg 1: " + src.remaining());
            } else {
                this.prepareOutbound2();
            }
            return;
        }
        if (this._state == EstablishBase.State.IB_NTCP2_SENT_Y && src.hasRemaining()) {
            int msg3tot = 48 + this._msg3p2len;
            if (this._msg3tmp == null) {
                this._msg3tmp = (ByteArray)_dataReadBufs.acquire();
            }
            byte[] tmp = this._msg3tmp.getData();
            int toGet2 = Math.min(src.remaining(), msg3tot - this._received);
            src.get(tmp, this._received, toGet2);
            this._received += toGet2;
            if (this._received < msg3tot) {
                return;
            }
            this.changeState(EstablishBase.State.IB_NTCP2_GOT_RI);
            this._received = 0;
            ByteArray ptmp = (ByteArray)_dataReadBufs.acquire();
            byte[] payload = ptmp.getData();
            try {
                this._handshakeState.readMessage(tmp, 0, msg3tot, payload, 0);
            }
            catch (GeneralSecurityException gse) {
                _dataReadBufs.release(ptmp, false);
                this.fail("Bad msg 3, part 1 is:\n" + HexDump.dump(tmp, 0, 48), gse);
                return;
            }
            catch (RuntimeException re) {
                _dataReadBufs.release(ptmp, false);
                this.fail("Bad msg 3", re);
                return;
            }
            if (this._log.shouldDebug()) {
                this._log.debug("After msg 3: " + this._handshakeState.toString());
            }
            try {
                NTCP2Payload.processPayload(this._context, this, payload, 0, this._msg3p2len - 16, true);
            }
            catch (IOException ioe) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Bad msg 3 payload", ioe);
                }
                if (this._msg3p2FailReason < 0) {
                    this._msg3p2FailReason = 9;
                }
            }
            catch (DataFormatException dfe) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Bad msg 3 payload", dfe);
                }
                if (this._msg3p2FailReason < 0) {
                    this._msg3p2FailReason = 15;
                }
                this._context.statManager().addRateData("ntcp.invalidInboundSignature", 1L);
            }
            catch (I2NPMessageException ime) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Bad msg 3 payload", ime);
                }
                if (this._msg3p2FailReason < 0) {
                    this._msg3p2FailReason = 0;
                }
            }
            finally {
                _dataReadBufs.release(ptmp, false);
            }
            this.setDataPhase(src);
        }
    }

    private synchronized void prepareOutbound2() {
        byte[] options2 = new byte[16];
        int padlen2 = this._context.random().nextInt(64);
        DataHelper.toLong(options2, 2, 2, padlen2);
        long now = this._context.clock().now() / 1000L;
        DataHelper.toLong(options2, 8, 4, now);
        byte[] tmp = new byte[64 + padlen2];
        try {
            this._handshakeState.writeMessage(tmp, 0, options2, 0, 16);
        }
        catch (GeneralSecurityException gse) {
            if (!this._log.shouldWarn()) {
                this._log.error("Bad msg 2 out", gse);
            }
            this.fail("Bad msg 2 out", gse);
            return;
        }
        catch (RuntimeException re) {
            if (!this._log.shouldWarn()) {
                this._log.error("Bad msg 2 out", re);
            }
            this.fail("Bad msg 2 out", re);
            return;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("After msg 2: " + this._handshakeState.toString());
        }
        Hash h = this._context.routerHash();
        SessionKey bobHash = new SessionKey(h.getData());
        this._context.aes().encrypt(tmp, 0, tmp, 0, bobHash, this._prevEncrypted, 32);
        if (padlen2 > 0) {
            this._context.random().nextBytes(tmp, 64, padlen2);
            this._handshakeState.mixHash(tmp, 64, padlen2);
            if (this._log.shouldDebug()) {
                this._log.debug("After mixhash padding " + padlen2 + " msg 2: " + this._handshakeState.toString());
            }
        }
        this.changeState(EstablishBase.State.IB_NTCP2_SENT_Y);
        this._transport.getPumper().wantsWrite(this._con, tmp);
    }

    private synchronized void setDataPhase(ByteBuffer buf) {
        CipherStatePair ckp = this._handshakeState.split();
        CipherState rcvr = ckp.getReceiver();
        CipherState sender = ckp.getSender();
        byte[][] sipkeys = OutboundNTCP2State.generateSipHashKeys(this._context, this._handshakeState);
        byte[] sip_ab = sipkeys[0];
        byte[] sip_ba = sipkeys[1];
        if (this._msg3p2FailReason >= 0) {
            if (this._log.shouldWarn()) {
                this._log.warn("Failed msg3p2, code " + this._msg3p2FailReason + " for " + this);
            }
            this._con.failInboundEstablishment(sender, sip_ba, this._msg3p2FailReason);
            this.changeState(EstablishBase.State.CORRUPT);
        } else {
            if (this._log.shouldDebug()) {
                this._log.debug("Finished establishment for " + this + "\nGenerated SipHash key for A->B: " + Base64.encode(sip_ab) + "\nGenerated SipHash key for B->A: " + Base64.encode(sip_ba));
            }
            this._con.finishInboundEstablishment(sender, rcvr, sip_ba, sip_ab, this._peerSkew, this._hisPadding);
            this.changeState(EstablishBase.State.VERIFIED);
            if (buf.hasRemaining()) {
                if (this._log.shouldInfo()) {
                    this._log.info("extra data " + buf.remaining() + " on " + this);
                }
                this._con.recvEncryptedI2NP(buf);
            }
        }
        this.releaseBufs(true);
        this._handshakeState.destroy();
        Arrays.fill(sip_ab, (byte)0);
        Arrays.fill(sip_ba, (byte)0);
    }

    @Override
    public void gotRI(RouterInfo ri, boolean isHandshake, boolean flood) throws DataFormatException {
        RouterAddress addr;
        String v;
        List<RouterAddress> addrs = ri.getTargetAddresses("NTCP", "NTCP2");
        if (addrs.isEmpty()) {
            this._msg3p2FailReason = 16;
            throw new DataFormatException("no NTCP in RI: " + ri);
        }
        String s = null;
        Iterator<RouterAddress> iterator = addrs.iterator();
        while (iterator.hasNext() && ((v = (addr = iterator.next()).getOption("v")) == null || !v.equals(NTCPTransport.NTCP2_VERSION) && !v.startsWith(NTCPTransport.NTCP2_VERSION_ALT) || (s = addr.getOption("s")) == null)) {
        }
        if (s == null) {
            this._msg3p2FailReason = 16;
            throw new DataFormatException("no s in RI: " + ri);
        }
        byte[] sb = Base64.decode(s);
        if (sb == null || sb.length != 32) {
            this._msg3p2FailReason = 16;
            throw new DataFormatException("bad s in RI: " + ri);
        }
        byte[] nb = new byte[32];
        this._handshakeState.getRemotePublicKey().getPublicKey(nb, 0);
        if (!DataHelper.eqCT(sb, 0, nb, 0, 32)) {
            this._msg3p2FailReason = 16;
            throw new DataFormatException("s mismatch in RI: " + ri);
        }
        this._aliceIdent = ri.getIdentity();
        Hash h = this._aliceIdent.calculateHash();
        boolean ok = this.verifyInbound(h);
        if (!ok) {
            throw new DataFormatException("NTCP2 verifyInbound() fail");
        }
        ok = this.verifyInboundNetworkID(ri);
        if (!ok) {
            throw new DataFormatException("NTCP2 network ID mismatch");
        }
        try {
            RouterInfo old = this._context.netDb().store(h, ri);
            if (flood && !ri.equals(old)) {
                FloodfillNetworkDatabaseFacade fndf = (FloodfillNetworkDatabaseFacade)this._context.netDb();
                if (fndf.floodConditional(ri)) {
                    if (this._log.shouldDebug()) {
                        this._log.debug("Flooded the RI: " + h);
                    }
                } else if (this._log.shouldInfo()) {
                    this._log.info("Flood request but we didn't: " + h);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            this._msg3p2FailReason = 13;
            throw new DataFormatException("RI store fail: " + ri, iae);
        }
        this._con.setRemotePeer(this._aliceIdent);
    }

    @Override
    public void gotOptions(byte[] options, boolean isHandshake) {
        NTCP2Options hisPadding = NTCP2Options.fromByteArray(options);
        if (hisPadding == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("Got options length " + options.length + " on: " + this);
            }
            return;
        }
        this._hisPadding = hisPadding;
    }

    @Override
    public void gotPadding(int paddingLength, int frameLength) {
    }

    @Override
    public void gotTermination(int reason, long lastReceived) {
    }

    @Override
    public void gotUnknown(int type, int len) {
    }

    @Override
    public void gotDateTime(long time) {
    }

    @Override
    public void gotI2NP(I2NPMessage msg) {
    }

    @Override
    protected synchronized void fail(String reason, Exception e, boolean bySkew) {
        super.fail(reason, e, bySkew);
        if (this._handshakeState != null) {
            if (this._log.shouldWarn()) {
                this._log.warn("State at failure: " + this._handshakeState.toString());
            }
            this._handshakeState.destroy();
        }
    }

    @Override
    protected void releaseBufs(boolean isVerified) {
        if (this._released) {
            return;
        }
        this._released = true;
        super.releaseBufs(isVerified);
        if (!isVerified) {
            SimpleByteCache.release(this._curEncrypted);
        }
        Arrays.fill(this._X, (byte)0);
        SimpleByteCache.release(this._X);
        if (this._msg3tmp != null) {
            _dataReadBufs.release(this._msg3tmp, false);
            this._msg3tmp = null;
        }
    }
}

