/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.util.Calendar;
import java.util.Locale;
import org.rrd4j.graph.Markers;

public interface RrdGraphConstants {
    public static final String DEFAULT_START = "end-1d";
    public static final String DEFAULT_END = "now";
    public static final String HH_MM = "HH:mm";
    public static final int SECOND = 13;
    public static final int MINUTE = 12;
    public static final int HOUR = 11;
    public static final int DAY = 5;
    public static final int WEEK = 3;
    public static final int MONTH = 2;
    public static final int YEAR = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int SUNDAY = 1;
    @Deprecated
    public static final int COLOR_CANVAS = 0;
    @Deprecated
    public static final int COLOR_BACK = 1;
    @Deprecated
    public static final int COLOR_SHADEA = 2;
    @Deprecated
    public static final int COLOR_SHADEB = 3;
    @Deprecated
    public static final int COLOR_GRID = 4;
    @Deprecated
    public static final int COLOR_MGRID = 5;
    @Deprecated
    public static final int COLOR_FONT = 6;
    @Deprecated
    public static final int COLOR_FRAME = 7;
    @Deprecated
    public static final int COLOR_ARROW = 8;
    @Deprecated
    public static final int COLOR_XAXIS = 9;
    @Deprecated
    public static final int COLOR_YAXIS = 10;
    public static final int FIRST_DAY_OF_WEEK = Calendar.getInstance(Locale.getDefault()).getFirstDayOfWeek();
    public static final Color DEFAULT_CANVAS_COLOR = Color.WHITE;
    public static final Color DEFAULT_BACK_COLOR = new Color(245, 245, 245);
    public static final Color DEFAULT_SHADEA_COLOR = new Color(200, 200, 200);
    public static final Color DEFAULT_SHADEB_COLOR = new Color(150, 150, 150);
    public static final Color DEFAULT_GRID_COLOR = new Color(171, 171, 171, 95);
    public static final Color DEFAULT_MGRID_COLOR = new Color(255, 91, 91, 95);
    public static final Color DEFAULT_FONT_COLOR = Color.BLACK;
    public static final Color DEFAULT_FRAME_COLOR = Color.BLACK;
    public static final Color DEFAULT_ARROW_COLOR = new Color(128, 31, 31);
    public static final Color DEFAULT_XAXIS_COLOR = Color.BLACK;
    public static final Color DEFAULT_YAXIS_COLOR = Color.BLACK;
    public static final Color BLIND_COLOR = new Color(0, 0, 0, 0);
    @Deprecated
    public static final String ALIGN_LEFT_MARKER = Markers.ALIGN_LEFT_MARKER.marker;
    @Deprecated
    public static final String ALIGN_LEFTNONL_MARKER = Markers.ALIGN_LEFTNONL_MARKER.marker;
    @Deprecated
    public static final String ALIGN_CENTER_MARKER = Markers.ALIGN_CENTER_MARKER.marker;
    @Deprecated
    public static final String ALIGN_RIGHT_MARKER = Markers.ALIGN_RIGHT_MARKER.marker;
    @Deprecated
    public static final String ALIGN_JUSTIFIED_MARKER = Markers.ALIGN_JUSTIFIED_MARKER.marker;
    @Deprecated
    public static final String GLUE_MARKER = Markers.GLUE_MARKER.marker;
    @Deprecated
    public static final String VERTICAL_SPACING_MARKER = Markers.VERTICAL_SPACING_MARKER.marker;
    @Deprecated
    public static final String NO_JUSTIFICATION_MARKER = Markers.NO_JUSTIFICATION_MARKER.marker;
    public static final String IN_MEMORY_IMAGE = "-";
    public static final int DEFAULT_UNITS_LENGTH = 9;
    public static final int DEFAULT_WIDTH = 400;
    public static final int DEFAULT_HEIGHT = 100;
    public static final String DEFAULT_IMAGE_FORMAT = "gif";
    public static final float DEFAULT_IMAGE_QUALITY = 0.8f;
    public static final double DEFAULT_BASE = 1000.0;
    public static final Font DEFAULT_SMALL_FONT = FontConstructor.getFont(0, 10);
    public static final Font DEFAULT_LARGE_FONT = FontConstructor.getFont(1, 12);
    public static final Font GATOR_FONT = FontConstructor.getFont(0, 9);
    public static final double LEGEND_LEADING = 1.2;
    public static final double LEGEND_LEADING_SMALL = 0.7;
    public static final double LEGEND_BOX_SPACE = 1.2;
    public static final double LEGEND_BOX = 0.9;
    public static final int LEGEND_INTERSPACING = 2;
    public static final int PADDING_LEFT = 10;
    public static final int PADDING_TOP = 12;
    public static final int PADDING_TITLE = 6;
    public static final int PADDING_RIGHT = 16;
    public static final int PADDING_PLOT = 2;
    public static final int PADDING_LEGEND = 2;
    public static final int PADDING_BOTTOM = 6;
    public static final int PADDING_VLABEL = 7;
    public static final Stroke GRID_STROKE = new BasicStroke(1.0f);
    public static final Stroke TICK_STROKE = new BasicStroke(1.0f);
    public static final FontTag FONTTAG_DEFAULT = FontTag.DEFAULT;
    public static final FontTag FONTTAG_TITLE = FontTag.TITLE;
    public static final FontTag FONTTAG_AXIS = FontTag.AXIS;
    public static final FontTag FONTTAG_UNIT = FontTag.AXIS;
    public static final FontTag FONTTAG_LEGEND = FontTag.LEGEND;
    public static final FontTag FONTTAG_WATERMARK = FontTag.WATERMARK;

    public static class FontConstructor {
        private FontConstructor() {
        }

        public static Font getFont(int type, int size) {
            return new Font("Monospaced", type, size);
        }
    }

    public static enum FontTag {
        DEFAULT,
        TITLE,
        AXIS,
        UNIT,
        LEGEND,
        WATERMARK;


        public void set(Font f, Font[] fonts) {
            fonts[this.ordinal()] = f;
        }

        public Font get(Font f, Font[] fonts) {
            return fonts[this.ordinal()];
        }
    }
}

