/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.Lease;
import net.i2p.data.TunnelId;

public class MetaLease
extends Lease {
    public static final int LENGTH = 40;
    private int _cost;
    private int _type;

    public int getCost() {
        return this._cost;
    }

    public void setCost(int cost) {
        this._cost = cost;
    }

    public int getType() {
        return this._type;
    }

    public void setType(int type) {
        this._type = type;
    }

    @Override
    public TunnelId getTunnelId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTunnelId(TunnelId id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readBytes(InputStream in) throws DataFormatException, IOException {
        this._gateway = Hash.create(in);
        DataHelper.skip(in, 2L);
        this._type = in.read();
        this._cost = in.read();
        this._end = new Date(DataHelper.readLong(in, 4) * 1000L);
    }

    @Override
    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._gateway == null) {
            throw new DataFormatException("Not enough data to write out a Lease");
        }
        this._gateway.writeBytes(out);
        DataHelper.writeLong(out, 2, 0L);
        out.write(this._type);
        out.write(this._cost);
        DataHelper.writeLong(out, 4, this._end.getTime() / 1000L);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof MetaLease)) {
            return false;
        }
        MetaLease lse = (MetaLease)object;
        return DataHelper.eq(this._end, lse.getEndDate()) && this._type == lse._type && this._cost == lse._cost && DataHelper.eq(this._gateway, lse.getGateway());
    }

    @Override
    public int hashCode() {
        return (int)this._end.getTime() ^ DataHelper.hashCode(this._gateway) ^ this._cost;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("[Meta Lease: ");
        buf.append("\n\tEnd Date: ").append(this._end);
        buf.append("\n\tTarget: ").append(this._gateway);
        buf.append("\n\tCost: ").append(this._cost);
        buf.append("\n\tType: ").append(this._type);
        buf.append("]");
        return buf.toString();
    }
}

