/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.CPUInformation;

import freenet.support.CPUInformation.CPUID;
import freenet.support.CPUInformation.CPUIDCPUInfo;
import freenet.support.CPUInformation.IntelCPUInfo;
import freenet.support.CPUInformation.UnknownCPUException;

class IntelInfoImpl
extends CPUIDCPUInfo
implements IntelCPUInfo {
    private static boolean isPentiumCompatible;
    private static boolean isPentiumMMXCompatible;
    private static boolean isPentium2Compatible;
    private static boolean isPentium3Compatible;
    private static boolean isPentium4Compatible;
    private static boolean isPentiumMCompatible;
    private static boolean isAtomCompatible;
    private static boolean isCore2Compatible;
    private static boolean isCoreiCompatible;
    private static boolean isSandyCompatible;
    private static boolean isIvyCompatible;
    private static boolean isHaswellCompatible;
    private static boolean isBroadwellCompatible;
    private static boolean isSkylakeCompatible;
    private static final String smodel;

    IntelInfoImpl() {
    }

    @Override
    public boolean IsPentiumCompatible() {
        return isPentiumCompatible;
    }

    @Override
    public boolean IsPentiumMMXCompatible() {
        return isPentiumMMXCompatible;
    }

    @Override
    public boolean IsPentium2Compatible() {
        return isPentium2Compatible;
    }

    @Override
    public boolean IsPentium3Compatible() {
        return isPentium3Compatible;
    }

    @Override
    public boolean IsPentium4Compatible() {
        return isPentium4Compatible;
    }

    @Override
    public boolean IsPentiumMCompatible() {
        return isPentiumMCompatible;
    }

    @Override
    public boolean IsAtomCompatible() {
        return isAtomCompatible;
    }

    @Override
    public boolean IsCore2Compatible() {
        return isCore2Compatible;
    }

    @Override
    public boolean IsCoreiCompatible() {
        return isCoreiCompatible;
    }

    @Override
    public boolean IsSandyCompatible() {
        return isSandyCompatible;
    }

    @Override
    public boolean IsIvyCompatible() {
        return isIvyCompatible;
    }

    @Override
    public boolean IsHaswellCompatible() {
        return isHaswellCompatible;
    }

    @Override
    public boolean IsBroadwellCompatible() {
        return isBroadwellCompatible;
    }

    @Override
    public boolean IsSkylakeCompatible() {
        return isSkylakeCompatible;
    }

    @Override
    public String getCPUModelString() throws UnknownCPUException {
        if (smodel != null) {
            return smodel;
        }
        throw new UnknownCPUException("Unknown Intel CPU; Family=" + CPUID.getCPUFamily() + '/' + CPUID.getCPUExtendedFamily() + ", Model=" + CPUID.getCPUModel() + '/' + CPUID.getCPUExtendedModel());
    }

    private static String identifyCPU() {
        String modelString = null;
        int family = CPUID.getCPUFamily();
        int model = CPUID.getCPUModel();
        if (family == 15 || family == 6) {
            model += CPUID.getCPUExtendedModel() << 4;
        }
        if (family == 15) {
            family += CPUID.getCPUExtendedFamily();
        }
        block0 : switch (family) {
            case 4: {
                switch (model) {
                    case 0: {
                        modelString = "486 DX-25/33";
                        break block0;
                    }
                    case 1: {
                        modelString = "486 DX-50";
                        break block0;
                    }
                    case 2: {
                        modelString = "486 SX";
                        break block0;
                    }
                    case 3: {
                        modelString = "486 DX/2";
                        break block0;
                    }
                    case 4: {
                        modelString = "486 SL";
                        break block0;
                    }
                    case 5: {
                        modelString = "486 SX/2";
                        break block0;
                    }
                    case 7: {
                        modelString = "486 DX/2-WB";
                        break block0;
                    }
                    case 8: {
                        modelString = "486 DX/4";
                        break block0;
                    }
                    case 9: {
                        modelString = "486 DX/4-WB";
                        break block0;
                    }
                }
                modelString = "Intel 486/586 model " + model;
                break;
            }
            case 5: {
                isPentiumCompatible = true;
                switch (model) {
                    case 0: {
                        modelString = "Pentium 60/66 A-step";
                        break block0;
                    }
                    case 1: {
                        modelString = "Pentium 60/66";
                        break block0;
                    }
                    case 2: {
                        modelString = "Pentium 75 - 200";
                        break block0;
                    }
                    case 3: {
                        modelString = "OverDrive PODP5V83";
                        break block0;
                    }
                    case 4: {
                        isPentiumMMXCompatible = true;
                        modelString = "Pentium MMX";
                        break block0;
                    }
                    case 7: {
                        modelString = "Mobile Pentium 75 - 200";
                        break block0;
                    }
                    case 8: {
                        isPentiumMMXCompatible = true;
                        modelString = "Mobile Pentium MMX";
                        break block0;
                    }
                }
                modelString = "Intel Pentium model " + model;
                break;
            }
            case 6: {
                isPentiumCompatible = true;
                isPentiumMMXCompatible = true;
                int extmodel = model >> 4;
                if (extmodel >= 1) {
                    isPentium2Compatible = true;
                    isPentium3Compatible = true;
                    isPentium4Compatible = true;
                    isPentiumMCompatible = true;
                    isCore2Compatible = true;
                    if (extmodel >= 2) {
                        isCoreiCompatible = true;
                    }
                }
                switch (model) {
                    case 0: {
                        modelString = "Pentium Pro A-step";
                        break block0;
                    }
                    case 1: {
                        modelString = "Pentium Pro";
                        break block0;
                    }
                    case 3: {
                        isPentium2Compatible = true;
                        modelString = "Pentium II (Klamath)";
                        break block0;
                    }
                    case 5: {
                        isPentium2Compatible = true;
                        modelString = "Pentium II (Deschutes), Celeron (Covington), Mobile Pentium II (Dixon)";
                        break block0;
                    }
                    case 6: {
                        isPentium2Compatible = true;
                        modelString = "Mobile Pentium II, Celeron (Mendocino)";
                        break block0;
                    }
                    case 7: {
                        isPentium2Compatible = true;
                        isPentium3Compatible = true;
                        modelString = "Pentium III (Katmai)";
                        break block0;
                    }
                    case 8: {
                        isPentium2Compatible = true;
                        isPentium3Compatible = true;
                        modelString = "Pentium III (Coppermine), Celeron w/SSE";
                        break block0;
                    }
                    case 9: {
                        isPentium2Compatible = true;
                        isPentium3Compatible = true;
                        isPentiumMCompatible = true;
                        modelString = "Pentium M (Banias)";
                        break block0;
                    }
                    case 10: {
                        isPentium2Compatible = true;
                        isPentium3Compatible = true;
                        modelString = "Pentium III Xeon (Cascades)";
                        break block0;
                    }
                    case 11: {
                        isPentium2Compatible = true;
                        isPentium3Compatible = true;
                        modelString = "Pentium III (130 nm)";
                        break block0;
                    }
                    case 13: {
                        isPentium2Compatible = true;
                        isPentium3Compatible = true;
                        isPentiumMCompatible = true;
                        modelString = "Core (Yonah)";
                        break block0;
                    }
                    case 14: 
                    case 15: {
                        isPentium2Compatible = true;
                        isPentium3Compatible = true;
                        isPentiumMCompatible = true;
                        isCore2Compatible = true;
                        modelString = "Penryn";
                        break block0;
                    }
                    case 22: {
                        modelString = "Merom";
                        break block0;
                    }
                    case 23: {
                        modelString = "Penryn";
                        break block0;
                    }
                    case 26: {
                        isCoreiCompatible = true;
                        modelString = "Nehalem";
                        break block0;
                    }
                    case 28: {
                        isAtomCompatible = true;
                        isCore2Compatible = false;
                        isPentium4Compatible = false;
                        modelString = "Atom";
                        break block0;
                    }
                    case 29: {
                        isCoreiCompatible = true;
                        modelString = "Penryn";
                        break block0;
                    }
                    case 30: {
                        isCoreiCompatible = true;
                        modelString = "Nehalem";
                        break block0;
                    }
                    case 37: {
                        modelString = "Westmere";
                        break block0;
                    }
                    case 38: {
                        isAtomCompatible = true;
                        isCoreiCompatible = false;
                        modelString = "Atom";
                        break block0;
                    }
                    case 42: {
                        isSandyCompatible = true;
                        modelString = "Sandy Bridge";
                        break block0;
                    }
                    case 43: {
                        modelString = "Core i7/i5 (32nm)";
                        break block0;
                    }
                    case 44: {
                        modelString = "Westmere";
                        break block0;
                    }
                    case 45: {
                        isSandyCompatible = true;
                        modelString = "Sandy Bridge";
                        break block0;
                    }
                    case 46: {
                        modelString = "Nehalem";
                        break block0;
                    }
                    case 47: {
                        modelString = "Westemere";
                        break block0;
                    }
                    case 54: {
                        isAtomCompatible = true;
                        isCore2Compatible = false;
                        isCoreiCompatible = false;
                        modelString = "Atom";
                        break block0;
                    }
                    case 55: {
                        isAtomCompatible = true;
                        isCore2Compatible = false;
                        isCoreiCompatible = false;
                        modelString = "Atom";
                        break block0;
                    }
                    case 58: {
                        isSandyCompatible = true;
                        isIvyCompatible = true;
                        modelString = "Ivy Bridge";
                        break block0;
                    }
                    case 61: 
                    case 71: {
                        CPUIDCPUInfo c = new CPUIDCPUInfo();
                        if (c.hasAVX2() && c.hasBMI1() && c.hasBMI2() && c.hasFMA3() && c.hasMOVBE() && c.hasABM()) {
                            isSandyCompatible = true;
                            isIvyCompatible = true;
                            isHaswellCompatible = true;
                            if (c.hasADX()) {
                                isBroadwellCompatible = true;
                            }
                            modelString = "Broadwell Core i3/i5/i7";
                            break block0;
                        }
                        if (c.hasAVX()) {
                            isSandyCompatible = true;
                            isIvyCompatible = true;
                            modelString = "Broadwell Celeron/Pentium w/ AVX";
                            break block0;
                        }
                        modelString = "Broadwell Celeron/Pentium";
                        break block0;
                    }
                    case 62: {
                        isSandyCompatible = true;
                        isIvyCompatible = true;
                        modelString = "Ivy Bridge";
                        break block0;
                    }
                    case 60: 
                    case 63: 
                    case 69: 
                    case 70: {
                        CPUIDCPUInfo c = new CPUIDCPUInfo();
                        if (c.hasAVX2() && c.hasBMI1() && c.hasBMI2() && c.hasFMA3() && c.hasMOVBE() && c.hasABM()) {
                            isSandyCompatible = true;
                            isIvyCompatible = true;
                            isHaswellCompatible = true;
                            modelString = "Haswell Core i3/i5/i7 model " + model;
                            break block0;
                        }
                        if (c.hasAVX()) {
                            isSandyCompatible = true;
                            isIvyCompatible = true;
                            modelString = "Haswell Celeron/Pentium w/ AVX model " + model;
                            break block0;
                        }
                        modelString = "Haswell Celeron/Pentium model " + model;
                        break block0;
                    }
                    case 74: {
                        isCore2Compatible = false;
                        isCoreiCompatible = false;
                        modelString = "Quark";
                        break block0;
                    }
                    case 77: {
                        isAtomCompatible = true;
                        modelString = "Atom";
                        break block0;
                    }
                    case 78: 
                    case 85: 
                    case 92: 
                    case 94: 
                    case 102: 
                    case 103: 
                    case 108: {
                        CPUIDCPUInfo c = new CPUIDCPUInfo();
                        if (c.hasAVX2() && c.hasBMI1() && c.hasBMI2() && c.hasFMA3() && c.hasMOVBE() && c.hasABM()) {
                            isSandyCompatible = true;
                            isIvyCompatible = true;
                            isHaswellCompatible = true;
                            if (c.hasADX()) {
                                isBroadwellCompatible = true;
                                if (c.hasAVX512()) {
                                    isSkylakeCompatible = true;
                                }
                            }
                            modelString = "Skylake Core i3/i5/i7";
                            break block0;
                        }
                        if (c.hasAVX()) {
                            isSandyCompatible = true;
                            isIvyCompatible = true;
                            modelString = "Skylake Celeron/Pentium w/ AVX";
                            break block0;
                        }
                        modelString = "Skylake Celeron/Pentium";
                        break block0;
                    }
                    case 142: 
                    case 158: 
                    case 165: 
                    case 166: {
                        CPUIDCPUInfo c = new CPUIDCPUInfo();
                        if (c.hasAVX2() && c.hasBMI1() && c.hasBMI2() && c.hasFMA3() && c.hasMOVBE() && c.hasABM()) {
                            isSandyCompatible = true;
                            isIvyCompatible = true;
                            isHaswellCompatible = true;
                            if (c.hasADX()) {
                                isBroadwellCompatible = true;
                                if (c.hasAVX512()) {
                                    isSkylakeCompatible = true;
                                }
                            }
                            modelString = "Kaby Lake Core i3/i5/i7";
                            break block0;
                        }
                        if (c.hasAVX()) {
                            isSandyCompatible = true;
                            isIvyCompatible = true;
                            modelString = "Kaby Lake Celeron/Pentium w/ AVX";
                            break block0;
                        }
                        modelString = "Kaby Lake Celeron/Pentium";
                        break block0;
                    }
                }
                modelString = "Intel model " + model;
                break;
            }
            case 7: {
                modelString = "Intel Itanium model " + model;
                break;
            }
            case 15: {
                isPentiumCompatible = true;
                isPentiumMMXCompatible = true;
                isPentium2Compatible = true;
                isPentium3Compatible = true;
                isPentium4Compatible = true;
                switch (model) {
                    case 0: 
                    case 1: {
                        modelString = "Pentium IV (180 nm)";
                        break block0;
                    }
                    case 2: {
                        modelString = "Pentium IV (130 nm)";
                        break block0;
                    }
                    case 3: {
                        modelString = "Pentium IV (90 nm)";
                        break block0;
                    }
                    case 4: {
                        modelString = "Pentium IV (90 nm)";
                        break block0;
                    }
                    case 6: {
                        modelString = "Pentium IV (65 nm)";
                        break block0;
                    }
                }
                modelString = "Intel Pentium IV model " + model;
                break;
            }
            case 16: {
                modelString = "Intel Itanium II model " + model;
            }
        }
        return modelString;
    }

    static {
        smodel = IntelInfoImpl.identifyCPU();
    }
}

