/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientApp;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.startup.ClientAppConfig;
import net.i2p.router.startup.LoadClientAppsJob;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.router.web.Messages;
import net.i2p.router.web.NavHelper;
import net.i2p.router.web.NewsHelper;
import net.i2p.router.web.RouterConsoleRunner;
import net.i2p.router.web.UpdateHandler;
import net.i2p.router.web.WebAppStarter;
import net.i2p.update.UpdateType;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.FileSuffixFilter;
import net.i2p.util.FileUtil;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;
import net.i2p.util.SystemVersion;
import net.i2p.util.Translate;
import net.i2p.util.VersionComparator;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;

public class PluginStarter
implements Runnable {
    protected RouterContext _context;
    private static final String CONFIG_FILE = "plugins.config";
    public static final String PREFIX = "plugin.";
    public static final String ENABLED = ".startOnLoad";
    public static final String DELETED = "deleted";
    public static final String PLUGIN_DIR = "plugins";
    private static final String[] STANDARD_WEBAPPS = new String[]{"i2psnark", "i2ptunnel", "imagegen", "susidns", "susimail", "addressbook", "routerconsole"};
    private static final String[] STANDARD_THEMES = new String[]{"images", "light", "dark", "classic", "midnight"};
    private static Map<String, ThreadGroup> pluginThreadGroups = new ConcurrentHashMap<String, ThreadGroup>();
    private static Map<String, Collection<SimpleTimer2.TimedEvent>> _pendingPluginClients = new ConcurrentHashMap<String, Collection<SimpleTimer2.TimedEvent>>();
    private static Map<String, ClassLoader> _clCache = new ConcurrentHashMap<String, ClassLoader>();
    private static Map<String, Collection<String>> pluginWars = new ConcurrentHashMap<String, Collection<String>>();
    public static final Map<String, String> jetty9Blacklist;
    public static final Map<String, String> java9Blacklist;

    public PluginStarter(RouterContext ctx) {
        this._context = ctx;
    }

    public static boolean pluginsEnabled(I2PAppContext ctx) {
        return ctx.getBooleanPropertyDefaultTrue("router.enablePlugins");
    }

    @Override
    public void run() {
        String prev;
        PluginStarter.deferredDeletePlugins(this._context);
        if (this._context.getBooleanPropertyDefaultTrue("plugins.autoUpdate") && !NewsHelper.isUpdateInProgress() && (prev = this._context.getProperty("router.previousVersion")) != null && VersionComparator.comp("0.9.47", prev) > 0) {
            PluginStarter.updateAll(this._context, true);
        }
        PluginStarter.startPlugins(this._context);
    }

    public static void updateAll(RouterContext ctx) {
        I2PAppThread t = new I2PAppThread(new PluginUpdater(ctx), "PluginUpdater", true);
        ((Thread)t).start();
    }

    private static void updateAll(RouterContext ctx, boolean delay) {
        List<String> plugins = PluginStarter.getPlugins();
        HashMap<String, String> toUpdate = new HashMap<String, String>();
        for (String appName : plugins) {
            Properties props = PluginStarter.pluginProperties(ctx, appName);
            String url = props.getProperty("updateURL");
            if (url == null) continue;
            toUpdate.put(appName, url);
        }
        if (toUpdate.isEmpty()) {
            return;
        }
        ConsoleUpdateManager mgr = UpdateHandler.updateManager(ctx);
        if (mgr == null) {
            return;
        }
        if (mgr.isUpdateInProgress()) {
            return;
        }
        if (delay) {
            int loop = 0;
            while (!ctx.router().isRunning()) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    return;
                }
                if (loop++ <= 180) continue;
                return;
            }
            mgr.update(UpdateType.TYPE_DUMMY, 180000L);
            mgr.notifyProgress(null, Messages.getString("Checking for plugin updates", ctx));
            loop = 0;
            do {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ie) {
                    break;
                }
            } while (loop++ <= 40 && mgr.isUpdateInProgress(UpdateType.TYPE_DUMMY));
        }
        String proxyHost = ctx.getProperty("router.updateProxyHost", "127.0.0.1");
        int proxyPort = ConfigUpdateHandler.proxyPort(ctx);
        if (proxyPort == 4444 && proxyHost.equals("127.0.0.1") && !ctx.portMapper().isRegistered("HTTP")) {
            mgr.notifyComplete(null, Messages.getString("Plugin update check failed", ctx) + " - " + Messages.getString("HTTP client proxy tunnel must be running", ctx));
            return;
        }
        if (ctx.commSystem().isDummy()) {
            mgr.notifyComplete(null, Messages.getString("Plugin update check failed", ctx) + " - VM Comm System");
            return;
        }
        Log log = ctx.logManager().getLog(PluginStarter.class);
        int updated = 0;
        for (Map.Entry entry : toUpdate.entrySet()) {
            String appName = (String)entry.getKey();
            if (log.shouldLog(30)) {
                log.warn("Checking for update plugin: " + appName);
            }
            if (mgr.checkAvailable(UpdateType.PLUGIN, appName, 60000L) == null) {
                if (!log.shouldLog(30)) continue;
                log.warn("No update available for plugin: " + appName);
                continue;
            }
            if (log.shouldLog(30)) {
                log.warn("Updating plugin: " + appName);
            }
            mgr.update(UpdateType.PLUGIN, appName, 1800000L);
            int loop = 0;
            do {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (loop++ <= 48 && mgr.isUpdateInProgress(UpdateType.PLUGIN, appName));
            if (mgr.getUpdateAvailable(UpdateType.PLUGIN, appName) == null) continue;
            ++updated;
        }
        if (updated > 0) {
            mgr.notifyComplete(null, PluginStarter.ngettext("1 plugin updated", "{0} plugins updated", updated, ctx));
        } else {
            mgr.notifyComplete(null, Messages.getString("Plugin update check complete", ctx));
        }
    }

    static void startPlugins(RouterContext ctx) {
        Log log = ctx.logManager().getLog(PluginStarter.class);
        Properties props = PluginStarter.pluginProperties();
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            String app;
            String name = (String)e.getKey();
            if (!name.startsWith(PREFIX) || !name.endsWith(ENABLED) || !Boolean.parseBoolean((String)e.getValue()) || PluginStarter.isPluginRunning(app = name.substring(PREFIX.length(), name.lastIndexOf(ENABLED)), ctx)) continue;
            try {
                if (PluginStarter.startPlugin(ctx, app)) continue;
                log.error("Failed to start plugin: " + app);
            }
            catch (Throwable t) {
                log.error("Failed to start plugin: " + app, t);
            }
        }
    }

    private static void deferredDeletePlugins(RouterContext ctx) {
        Log log = ctx.logManager().getLog(PluginStarter.class);
        boolean changed = false;
        Properties props = PluginStarter.pluginProperties();
        Iterator<Map.Entry<Object, Object>> iter = props.entrySet().iterator();
        while (iter.hasNext()) {
            String app;
            Map.Entry<Object, Object> e = iter.next();
            String name = (String)e.getKey();
            if (!name.startsWith(PREFIX) || !name.endsWith(ENABLED) || !e.getValue().equals(DELETED) || PluginStarter.isPluginRunning(app = name.substring(PREFIX.length(), name.lastIndexOf(ENABLED)), ctx)) continue;
            File pluginDir = new File(ctx.getConfigDir(), "plugins/" + app);
            boolean deleted = FileUtil.rmdir(pluginDir, false);
            if (deleted) {
                log.logAlways(30, "Deferred deletion of " + pluginDir + " successful");
                iter.remove();
                changed = true;
                continue;
            }
            if (!log.shouldLog(30)) continue;
            log.warn("Deferred deletion of " + pluginDir + " failed");
        }
        if (changed) {
            PluginStarter.storePluginProperties(props);
        }
    }

    public static boolean startPlugin(RouterContext ctx, String appName) throws Exception {
        String name;
        File[] files;
        ContextHandlerCollection server;
        File clientConfig;
        String fullprop;
        File dir;
        File[] tfiles;
        Properties props;
        String minVersion;
        Log log = ctx.logManager().getLog(PluginStarter.class);
        File pluginDir = new File(ctx.getConfigDir(), "plugins/" + appName);
        String iconfile = null;
        if (!pluginDir.exists() || !pluginDir.isDirectory()) {
            log.error("Cannot start nonexistent plugin: " + appName);
            PluginStarter.disablePlugin(appName);
            return false;
        }
        File pluginUpdate = new File(ctx.getConfigDir(), "plugins/" + appName + "/app.xpi2p.zip");
        if (pluginUpdate.exists() && ctx.router().getWhenStarted() > pluginUpdate.lastModified()) {
            if (!FileUtil.extractZip(pluginUpdate, pluginDir)) {
                pluginUpdate.delete();
                String foo = "Plugin '" + appName + "' failed to update! File '" + pluginUpdate + "' deleted. You may need to remove and install the plugin again.";
                log.error(foo);
                PluginStarter.disablePlugin(appName);
                throw new Exception(foo);
            }
            pluginUpdate.delete();
            System.err.println("INFO: Plugin updated: " + appName);
        }
        if ((minVersion = PluginStarter.stripHTML(props = PluginStarter.pluginProperties(ctx, appName), "min-i2p-version")) != null && VersionComparator.comp("0.9.47", minVersion) < 0) {
            String foo = "Plugin " + appName + " requires I2P version " + minVersion + " or higher";
            log.error(foo);
            PluginStarter.disablePlugin(appName);
            foo = PluginStarter.gettext("This plugin requires I2P version {0} or higher", minVersion, ctx);
            throw new Exception(foo);
        }
        minVersion = PluginStarter.stripHTML(props, "min-java-version");
        if (minVersion != null && !SystemVersion.isJava(minVersion)) {
            String foo = "Plugin " + appName + " requires Java version " + minVersion + " or higher";
            log.error(foo);
            PluginStarter.disablePlugin(appName);
            foo = PluginStarter.gettext("This plugin requires Java version {0} or higher", minVersion, ctx);
            throw new Exception(foo);
        }
        String jVersion = RouterConsoleRunner.jettyVersion();
        minVersion = PluginStarter.stripHTML(props, "min-jetty-version");
        if (minVersion != null && VersionComparator.comp(minVersion, jVersion) > 0) {
            String foo = "Plugin " + appName + " requires Jetty version " + minVersion + " or higher";
            log.error(foo);
            PluginStarter.disablePlugin(appName);
            foo = PluginStarter.gettext("Plugin requires Jetty version {0} or higher", minVersion, ctx);
            throw new Exception(foo);
        }
        String blacklistVersion = jetty9Blacklist.get(appName);
        String curVersion = PluginStarter.stripHTML(props, "version");
        if (blacklistVersion != null && VersionComparator.comp(curVersion, blacklistVersion) <= 0) {
            String foo = "Plugin " + appName + " requires Jetty version 8.9999 or lower";
            log.error(foo);
            PluginStarter.disablePlugin(appName);
            foo = PluginStarter.gettext("Plugin requires Jetty version {0} or lower", "8.9999", ctx);
            throw new Exception(foo);
        }
        if (SystemVersion.isJava9() && (blacklistVersion = java9Blacklist.get(appName)) != null && VersionComparator.comp(curVersion, blacklistVersion) <= 0) {
            String foo = "Plugin " + appName + " requires Jetty version 8.9999 or lower";
            log.error(foo);
            PluginStarter.disablePlugin(appName);
            foo = PluginStarter.gettext("Plugin requires Java version {0} or lower", "8.9999", ctx);
            throw new Exception(foo);
        }
        String maxVersion = PluginStarter.stripHTML(props, "max-jetty-version");
        if (maxVersion != null && VersionComparator.comp(maxVersion, jVersion) < 0) {
            String foo = "Plugin " + appName + " requires Jetty version " + maxVersion + " or lower";
            log.error(foo);
            PluginStarter.disablePlugin(appName);
            foo = PluginStarter.gettext("Plugin requires Jetty version {0} or lower", maxVersion, ctx);
            throw new Exception(foo);
        }
        if (log.shouldLog(20)) {
            log.info("Starting plugin: " + appName);
        }
        if ((tfiles = (dir = new File(pluginDir, "console/themes")).listFiles()) != null) {
            for (int i = 0; i < tfiles.length; ++i) {
                String name2 = tfiles[i].getName();
                if (!tfiles[i].isDirectory() || Arrays.asList(STANDARD_THEMES).contains(tfiles[i])) continue;
                ctx.router().setConfigSetting("routerconsole.theme." + name2, tfiles[i].getAbsolutePath());
            }
        }
        if ((fullprop = props.getProperty("icon-code")) != null && fullprop.length() > 1) {
            byte[] decoded = Base64.decode(fullprop);
            if (decoded != null) {
                NavHelper.setBinary(appName, decoded);
                iconfile = "/Plugins/pluginicon?plugin=" + appName;
            } else {
                iconfile = "/themes/console/images/plugin.png";
            }
        }
        if ((clientConfig = new File(pluginDir, "clients.config")).exists()) {
            Properties cprops = new Properties();
            DataHelper.loadProps(cprops, clientConfig);
            List<ClientAppConfig> clients = ClientAppConfig.getClientApps(clientConfig);
            PluginStarter.runClientApps(ctx, pluginDir, clients, "start");
        }
        if ((server = WebAppStarter.getConsoleServer(ctx)) != null) {
            File consoleDir = new File(pluginDir, "console");
            Properties wprops = RouterConsoleRunner.webAppProperties(consoleDir.getAbsolutePath());
            File webappDir = new File(consoleDir, "webapps");
            File[] files2 = webappDir.listFiles(RouterConsoleRunner.WAR_FILTER);
            if (files2 != null) {
                if (!pluginWars.containsKey(appName)) {
                    pluginWars.put(appName, new ConcurrentHashSet());
                }
                for (int i = 0; i < files2.length; ++i) {
                    try {
                        String warName = files2[i].getName();
                        warName = warName.substring(0, warName.lastIndexOf(".war"));
                        if (Arrays.asList(STANDARD_WEBAPPS).contains(warName)) {
                            log.error("Skipping duplicate webapp " + warName + " in plugin " + appName);
                            continue;
                        }
                        String enabled = wprops.getProperty("webapps." + warName + ENABLED);
                        if ("false".equals(enabled)) continue;
                        if (log.shouldLog(20)) {
                            log.info("Starting webapp: " + warName);
                        }
                        String path = files2[i].getCanonicalPath();
                        WebAppStarter.startWebApp(ctx, server, warName, path);
                        pluginWars.get(appName).add(warName);
                        continue;
                    }
                    catch (IOException ioe) {
                        log.error("Error resolving '" + files2[i] + "' in '" + webappDir, ioe);
                    }
                }
                String icfile = PluginStarter.stripHTML(props, "console-icon");
                if (icfile != null && !icfile.contains("..")) {
                    StringBuilder buf = new StringBuilder(32);
                    buf.append('/').append(appName);
                    if (!icfile.startsWith("/")) {
                        buf.append('/');
                    }
                    buf.append(icfile);
                    iconfile = buf.toString();
                }
            }
        } else {
            log.error("No console web server to start plugins?");
        }
        File localeDir = new File(pluginDir, "console/locale");
        if (localeDir.exists() && localeDir.isDirectory() && (files = localeDir.listFiles(new FileSuffixFilter(".jar"))) != null) {
            boolean added = false;
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                try {
                    PluginStarter.addPath(f.toURI().toURL());
                    log.info("INFO: Adding translation plugin to classpath: " + f);
                    added = true;
                    continue;
                }
                catch (ClassCastException e) {
                    log.logAlways(30, "Java version: " + System.getProperty("java.version") + " does not support adding classpath element: " + f + " for plugin " + appName);
                    continue;
                }
                catch (RuntimeException e) {
                    log.error("Plugin " + appName + " bad classpath element: " + f, e);
                }
            }
            if (added) {
                Translate.clearCache();
            }
        }
        if ((name = PluginStarter.stripHTML(props, "consoleLinkName_" + Messages.getLanguage(ctx))) == null) {
            name = PluginStarter.stripHTML(props, "consoleLinkName");
        }
        String url = PluginStarter.stripHTML(props, "consoleLinkURL");
        if (name != null && url != null && name.length() > 0 && url.length() > 0) {
            String tip = PluginStarter.stripHTML(props, "consoleLinkTooltip_" + Messages.getLanguage(ctx));
            if (tip == null) {
                tip = PluginStarter.stripHTML(props, "consoleLinkTooltip");
            }
            NavHelper.registerApp(appName, name, url, tip, iconfile);
        }
        return true;
    }

    public static boolean stopPlugin(RouterContext ctx, String appName) throws Exception {
        Server s = RouterConsoleRunner.getConsoleServer(ctx);
        return PluginStarter.stopPlugin(ctx, s, appName);
    }

    protected static boolean stopPlugin(RouterContext ctx, Server s, String appName) throws Exception {
        Collection<String> wars;
        File clientConfig;
        Log log = ctx.logManager().getLog(PluginStarter.class);
        File pluginDir = new File(ctx.getConfigDir(), "plugins/" + appName);
        if (!pluginDir.exists() || !pluginDir.isDirectory()) {
            log.error("Cannot stop nonexistent plugin: " + appName);
            return false;
        }
        if (log.shouldLog(30)) {
            log.warn("Stopping plugin: " + appName);
        }
        if ((clientConfig = new File(pluginDir, "clients.config")).exists()) {
            Properties props = new Properties();
            DataHelper.loadProps(props, clientConfig);
            List<ClientAppConfig> clients = ClientAppConfig.getClientApps(clientConfig);
            PluginStarter.runClientApps(ctx, pluginDir, clients, "stop");
        }
        if (s != null && (wars = pluginWars.get(appName)) != null) {
            for (String warName : wars) {
                if (log.shouldInfo()) {
                    log.info("Stopping webapp " + warName + " in plugin " + appName);
                }
                WebAppStarter.stopWebApp(ctx, s, warName);
            }
            wars.clear();
        }
        NavHelper.unregisterApp(appName);
        return true;
    }

    public static boolean deletePlugin(RouterContext ctx, String appName) throws Exception {
        File dir;
        File[] tfiles;
        Log log = ctx.logManager().getLog(PluginStarter.class);
        File pluginDir = new File(ctx.getConfigDir(), "plugins/" + appName);
        if (!pluginDir.exists() || !pluginDir.isDirectory()) {
            log.error("Cannot delete nonexistent plugin: " + appName);
            return false;
        }
        File clientConfig = new File(pluginDir, "clients.config");
        if (clientConfig.exists()) {
            Properties props = new Properties();
            DataHelper.loadProps(props, clientConfig);
            List<ClientAppConfig> clients = ClientAppConfig.getClientApps(clientConfig);
            PluginStarter.runClientApps(ctx, pluginDir, clients, "uninstall");
        }
        if ((tfiles = (dir = new File(pluginDir, "console/themes")).listFiles()) != null) {
            String current = ctx.getProperty("routerconsole.theme");
            HashMap<String, String> changes = new HashMap<String, String>();
            ArrayList<String> removes = new ArrayList<String>();
            for (int i = 0; i < tfiles.length; ++i) {
                String name = tfiles[i].getName();
                if (!tfiles[i].isDirectory() || Arrays.asList(STANDARD_THEMES).contains(tfiles[i])) continue;
                removes.add("routerconsole.theme." + name);
                if (!name.equals(current)) continue;
                changes.put("routerconsole.theme", "light");
            }
            ctx.router().saveConfig(changes, removes);
        }
        boolean deleted = FileUtil.rmdir(pluginDir, false);
        Properties props = PluginStarter.pluginProperties();
        Iterator<Object> iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!name.startsWith(PREFIX + appName + '.')) continue;
            iter.remove();
        }
        if (!deleted) {
            log.logAlways(30, "Deletion of " + pluginDir + " failed, will try again at restart");
            props.setProperty(PREFIX + appName + ENABLED, DELETED);
        }
        PluginStarter.storePluginProperties(props);
        return true;
    }

    public static Properties pluginProperties(I2PAppContext ctx, String appName) {
        File cfgFile = new File(ctx.getConfigDir(), "plugins/" + appName + '/' + "plugin.config");
        Properties rv = new Properties();
        try {
            DataHelper.loadProps(rv, cfgFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return rv;
    }

    public static Properties pluginProperties() {
        File dir = I2PAppContext.getGlobalContext().getConfigDir();
        Properties rv = new Properties();
        File cfgFile = new File(dir, CONFIG_FILE);
        try {
            DataHelper.loadProps(rv, cfgFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        List<String> names = PluginStarter.getAllPlugins();
        for (String name : names) {
            String prop = PREFIX + name + ENABLED;
            if (rv.getProperty(prop) != null) continue;
            rv.setProperty(prop, "true");
        }
        return rv;
    }

    public static boolean isPluginEnabled(String appName) {
        Properties props = PluginStarter.pluginProperties();
        String prop = PREFIX + appName + ENABLED;
        return Boolean.parseBoolean(props.getProperty(prop, "true"));
    }

    public static void disablePlugin(String appName) {
        String prop;
        Properties props = PluginStarter.pluginProperties();
        if (Boolean.parseBoolean(props.getProperty(prop = PREFIX + appName + ENABLED, "true"))) {
            props.setProperty(prop, "false");
            PluginStarter.storePluginProperties(props);
        }
    }

    public static List<String> getPlugins() {
        List<String> rv = PluginStarter.getAllPlugins();
        Properties props = PluginStarter.pluginProperties();
        Iterator<String> iter = rv.iterator();
        while (iter.hasNext()) {
            String app = iter.next();
            if (!DELETED.equals(props.getProperty(PREFIX + app + ENABLED))) continue;
            iter.remove();
        }
        Collections.sort(rv);
        return rv;
    }

    private static List<String> getAllPlugins() {
        ArrayList<String> rv = new ArrayList<String>();
        File pluginDir = new File(I2PAppContext.getGlobalContext().getConfigDir(), PLUGIN_DIR);
        File[] files = pluginDir.listFiles();
        if (files == null) {
            return rv;
        }
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            rv.add(files[i].getName());
        }
        return rv;
    }

    public static Map<String, String> getPluginKeys(I2PAppContext ctx) {
        HashMap<String, String> rv = new HashMap<String, String>();
        List<String> names = PluginStarter.getPlugins();
        for (String name : names) {
            Properties props = PluginStarter.pluginProperties(ctx, name);
            String pubkey = props.getProperty("key");
            String signer = props.getProperty("signer");
            if (pubkey == null || signer == null || pubkey.length() != 172 || signer.length() <= 0) continue;
            rv.put(pubkey, signer);
        }
        return rv;
    }

    public static void storePluginProperties(Properties props) {
        File cfgFile = new File(I2PAppContext.getGlobalContext().getConfigDir(), CONFIG_FILE);
        try {
            DataHelper.storeProps(props, cfgFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void runClientApps(RouterContext ctx, File pluginDir, List<ClientAppConfig> apps, String action) throws Exception {
        Log log = ctx.logManager().getLog(PluginStarter.class);
        String pluginName = pluginDir.getName();
        if (!pluginThreadGroups.containsKey(pluginName)) {
            pluginThreadGroups.put(pluginName, new ThreadGroup(pluginName));
        }
        ThreadGroup pluginThreadGroup = pluginThreadGroups.get(pluginName);
        if (action.equals("start")) {
            _pendingPluginClients.put(pluginName, new ConcurrentHashSet());
        }
        for (ClientAppConfig app : apps) {
            String[] argVal;
            if (action.equals("stop")) {
                argVal = LoadClientAppsJob.parseArgs(app.args);
                for (int i = 0; i < argVal.length; ++i) {
                    if (argVal[i].indexOf(36) < 0) continue;
                    argVal[i] = argVal[i].replace("$I2P", ctx.getBaseDir().getAbsolutePath());
                    argVal[i] = argVal[i].replace("$CONFIG", ctx.getConfigDir().getAbsolutePath());
                    argVal[i] = argVal[i].replace("$PLUGIN", pluginDir.getAbsolutePath());
                }
                ClientApp ca = ctx.routerAppManager().getClientApp(app.className, argVal);
                if (ca != null) {
                    try {
                        ca.shutdown(LoadClientAppsJob.parseArgs(app.stopargs));
                        continue;
                    }
                    catch (Throwable t) {
                        throw new Exception(t);
                    }
                }
            }
            if (action.equals("start") && app.disabled) continue;
            if (action.equals("start")) {
                argVal = LoadClientAppsJob.parseArgs(app.args);
            } else {
                String args;
                if (action.equals("stop")) {
                    args = app.stopargs;
                } else if (action.equals("uninstall")) {
                    args = app.uninstallargs;
                } else {
                    throw new IllegalArgumentException("bad action");
                }
                if (args == null || args.length() <= 0) continue;
                argVal = LoadClientAppsJob.parseArgs(args);
            }
            for (int i = 0; i < argVal.length; ++i) {
                if (argVal[i].indexOf(36) < 0) continue;
                argVal[i] = argVal[i].replace("$I2P", ctx.getBaseDir().getAbsolutePath());
                argVal[i] = argVal[i].replace("$CONFIG", ctx.getConfigDir().getAbsolutePath());
                argVal[i] = argVal[i].replace("$PLUGIN", pluginDir.getAbsolutePath());
            }
            ClassLoader cl = null;
            if (app.classpath != null) {
                URL[] urls;
                String cp = app.classpath;
                if (cp.indexOf(36) >= 0) {
                    cp = cp.replace("$I2P", ctx.getBaseDir().getAbsolutePath());
                    cp = cp.replace("$CONFIG", ctx.getConfigDir().getAbsolutePath());
                    cp = cp.replace("$PLUGIN", pluginDir.getAbsolutePath());
                }
                String clCacheKey = pluginName + app.className + app.args;
                if (!action.equals("start")) {
                    cl = _clCache.get(clCacheKey);
                }
                if (cl == null && (urls = PluginStarter.classpathToURLArray(cp, app.clientName, log)) != null) {
                    cl = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
                    if (action.equals("start")) {
                        _clCache.put(clCacheKey, cl);
                    }
                }
            }
            if (app.delay < 0L && action.equals("start")) {
                LoadClientAppsJob.runClientInline(app.className, app.clientName, argVal, log, cl);
                continue;
            }
            if (app.delay == 0L || !action.equals("start")) {
                LoadClientAppsJob.testClient(app.className, cl);
                LoadClientAppsJob.runClient(app.className, app.clientName, argVal, ctx, log, pluginThreadGroup, cl);
                continue;
            }
            try {
                LoadClientAppsJob.testClient(app.className, cl);
            }
            catch (ClassNotFoundException ex) {
                try {
                    if (app.delay > 1L) {
                        Thread.sleep(2000L);
                    } else {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                LoadClientAppsJob.testClient(app.className, cl);
            }
            TrackedDelayedClient evt = new TrackedDelayedClient(pluginName, ctx.simpleTimer2(), ctx, app.className, app.clientName, argVal, pluginThreadGroup, cl);
            evt.schedule(app.delay);
        }
    }

    public static boolean isPluginRunning(String pluginName, RouterContext ctx) {
        Server s = RouterConsoleRunner.getConsoleServer(ctx);
        return PluginStarter.isPluginRunning(pluginName, ctx, s);
    }

    protected static boolean isPluginRunning(String pluginName, RouterContext ctx, Server s) {
        Collection<String> wars;
        Log log = ctx.logManager().getLog(PluginStarter.class);
        boolean isJobRunning = false;
        Collection<SimpleTimer2.TimedEvent> pending = _pendingPluginClients.get(pluginName);
        if (pending != null && !pending.isEmpty()) {
            isJobRunning = true;
        }
        boolean isWarRunning = false;
        if (s != null && (wars = pluginWars.get(pluginName)) != null) {
            for (String warName : wars) {
                if (!WebAppStarter.isWebAppRunning(s, warName)) continue;
                isWarRunning = true;
                break;
            }
        }
        boolean isClientThreadRunning = PluginStarter.isClientThreadRunning(pluginName, ctx);
        if (log.shouldLog(10)) {
            log.debug("plugin name = <" + pluginName + ">; threads running? " + isClientThreadRunning + "; webapp running? " + isWarRunning + "; jobs running? " + isJobRunning);
        }
        return isClientThreadRunning || isWarRunning || isJobRunning;
    }

    private static boolean isClientThreadRunning(String pluginName, RouterContext ctx) {
        boolean rv;
        ThreadGroup group = pluginThreadGroups.get(pluginName);
        if (group == null) {
            return false;
        }
        boolean bl = rv = group.activeCount() > 0;
        if (rv) {
            Log log = ctx.logManager().getLog(PluginStarter.class);
            Thread[] activeThreads = new Thread[128];
            int count = group.enumerate(activeThreads);
            boolean notRollover = false;
            for (int i = 0; i < count; ++i) {
                if (activeThreads[i] == null) continue;
                String name = activeThreads[i].getName();
                if (!"org.eclipse.jetty.util.RolloverFileOutputStream".equals(name) && !name.startsWith("HSQLDB Timer")) {
                    notRollover = true;
                }
                if (!log.shouldLog(10)) continue;
                log.debug("Found " + (Object)((Object)activeThreads[i].getState()) + " thread " + name + " for " + pluginName + ": " + name);
            }
            rv = notRollover;
        }
        return rv;
    }

    private static URL[] classpathToURLArray(String classpath, String clientName, Log log) {
        StringTokenizer tok = new StringTokenizer(classpath, ",");
        ArrayList<URL> urls = new ArrayList<URL>();
        while (tok.hasMoreTokens()) {
            String elem = tok.nextToken().trim();
            File f = new File(elem);
            if (!f.isAbsolute()) {
                log.error("Plugin client " + clientName + " classpath element is not absolute: " + f);
                continue;
            }
            try {
                urls.add(f.toURI().toURL());
                if (!log.shouldLog(30)) continue;
                log.warn("INFO: Adding plugin to classpath: " + f);
            }
            catch (IOException e) {
                log.error("Plugin client " + clientName + " bad classpath element: " + f, e);
            }
        }
        if (urls.isEmpty()) {
            return null;
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static void addPath(URL u) throws Exception {
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> urlClass = URLClassLoader.class;
        Method method = urlClass.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)urlClassLoader, u);
    }

    public static String stripHTML(Properties props, String key) {
        String orig = props.getProperty(key);
        if (orig == null) {
            return null;
        }
        String t1 = orig.replace('<', ' ');
        String rv = t1.replace('>', ' ');
        return rv;
    }

    private static String gettext(String s, Object o, I2PAppContext ctx) {
        return Messages.getString(s, o, ctx);
    }

    private static String ngettext(String s, String p, int n, I2PAppContext ctx) {
        return Messages.getString(n, s, p, ctx);
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("i2pbote", "0.4.5");
        map.put("BwSchedule", "0.0.36");
        jetty9Blacklist = Collections.unmodifiableMap(map);
        map = new HashMap(2);
        map.put("01_neodatis", "2.1-2.14-209-17");
        map.put("02_seedless", "0.1.7-0.1.12");
        java9Blacklist = Collections.unmodifiableMap(map);
    }

    private static class PluginUpdater
    implements Runnable {
        private final RouterContext _ctx;

        public PluginUpdater(RouterContext ctx) {
            this._ctx = ctx;
        }

        @Override
        public void run() {
            PluginStarter.updateAll(this._ctx, false);
        }
    }

    private static class TrackedDelayedClient
    extends LoadClientAppsJob.DelayedRunClient {
        private final String _pluginName;

        public TrackedDelayedClient(String pluginName, SimpleTimer2 pool, RouterContext enclosingContext, String className, String clientName, String[] args, ThreadGroup threadGroup, ClassLoader cl) {
            super(pool, enclosingContext, className, clientName, args, threadGroup, cl);
            this._pluginName = pluginName;
            ((Collection)_pendingPluginClients.get(pluginName)).add(this);
        }

        @Override
        public boolean cancel() {
            boolean rv = super.cancel();
            ((Collection)_pendingPluginClients.get(this._pluginName)).remove(this);
            return rv;
        }

        @Override
        public void timeReached() {
            super.timeReached();
            ((Collection)_pendingPluginClients.get(this._pluginName)).remove(this);
        }
    }
}

