/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.message;

import net.i2p.data.Certificate;
import net.i2p.data.i2np.GarlicClove;

public class CloveSet {
    private final GarlicClove[] _cloves;
    private final Certificate _cert;
    private final long _msgId;
    private final long _expiration;

    public CloveSet(GarlicClove[] cloves, Certificate cert, long msgId, long expiration) {
        this._cloves = cloves;
        this._cert = cert;
        this._msgId = msgId;
        this._expiration = expiration;
    }

    public int getCloveCount() {
        return this._cloves.length;
    }

    public GarlicClove getClove(int index) {
        return this._cloves[index];
    }

    public Certificate getCertificate() {
        return this._cert;
    }

    public long getMessageId() {
        return this._msgId;
    }

    public long getExpiration() {
        return this._expiration;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("{");
        for (int i = 0; i < this._cloves.length; ++i) {
            GarlicClove clove = this._cloves[i];
            if (clove.getData() != null) {
                buf.append(clove.getData().getClass().getName()).append(", ");
                continue;
            }
            buf.append("[null clove], ");
        }
        buf.append("}");
        return buf.toString();
    }
}

