/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import net.i2p.I2PAppContext;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.i2np.DeliveryInstructions;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageHandler;
import net.i2p.data.i2np.I2NPMessageImpl;
import net.i2p.util.Log;

public class GarlicClove
extends DataStructureImpl {
    private static final long serialVersionUID = 1L;
    private final transient I2PAppContext _context;
    private DeliveryInstructions _instructions;
    private I2NPMessage _msg;
    private long _cloveId;
    private Date _expiration;
    private Certificate _certificate;

    public GarlicClove(I2PAppContext context) {
        this._context = context;
        this._cloveId = -1L;
    }

    public DeliveryInstructions getInstructions() {
        return this._instructions;
    }

    public void setInstructions(DeliveryInstructions instr) {
        this._instructions = instr;
    }

    public I2NPMessage getData() {
        return this._msg;
    }

    public void setData(I2NPMessage msg) {
        this._msg = msg;
    }

    public long getCloveId() {
        return this._cloveId;
    }

    public void setCloveId(long id) {
        this._cloveId = id;
    }

    public Date getExpiration() {
        return this._expiration;
    }

    public void setExpiration(Date exp) {
        this._expiration = exp;
    }

    public Certificate getCertificate() {
        return this._certificate;
    }

    public void setCertificate(Certificate cert) {
        this._certificate = cert;
    }

    @Override
    @Deprecated
    public void readBytes(InputStream in) {
        throw new UnsupportedOperationException();
    }

    public int readBytes(byte[] source, int offset) throws DataFormatException {
        int cur = offset;
        this._instructions = DeliveryInstructions.create(source, offset);
        cur += this._instructions.getSize();
        try {
            I2NPMessageHandler handler = new I2NPMessageHandler(this._context);
            cur += handler.readMessage(source, cur);
            this._msg = handler.lastRead();
        }
        catch (I2NPMessageException ime) {
            throw new DataFormatException("Unable to read the message from a garlic clove", ime);
        }
        this._cloveId = DataHelper.fromLong(source, cur, 4);
        this._expiration = DataHelper.fromDate(source, cur += 4);
        this._certificate = Certificate.create(source, cur += 8);
        return (cur += this._certificate.size()) - offset;
    }

    public void readBytesRatchet(byte[] source, int offset, int len) throws DataFormatException {
        this._instructions = DeliveryInstructions.create(source, offset);
        int isz = this._instructions.getSize();
        try {
            I2NPMessageHandler handler = new I2NPMessageHandler(this._context);
            this._msg = I2NPMessageImpl.fromRawByteArrayNTCP2(this._context, source, offset + isz, len - isz, handler);
            this._cloveId = this._msg.getUniqueId();
            this._expiration = new Date(this._msg.getMessageExpiration());
            this._certificate = Certificate.NULL_CERT;
        }
        catch (I2NPMessageException ime) {
            throw new DataFormatException("Unable to read the message from a garlic clove", ime);
        }
    }

    @Override
    @Deprecated
    public void writeBytes(OutputStream out) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] toByteArray() {
        byte[] rv = new byte[this.estimateSize()];
        int offset = this._instructions.writeBytes(rv, 0);
        offset = this._msg.toByteArray(rv, offset);
        DataHelper.toLong(rv, offset, 4, this._cloveId);
        DataHelper.toDate(rv, offset += 4, this._expiration.getTime());
        offset += 8;
        offset += this._certificate.writeBytes(rv, offset);
        if (offset != rv.length) {
            Log log = I2PAppContext.getGlobalContext().logManager().getLog(GarlicClove.class);
            log.error("Clove offset: " + offset + " but estimated length: " + rv.length);
        }
        return rv;
    }

    public int writeBytesRatchet(byte[] tgt, int offset) {
        offset += this._instructions.writeBytes(tgt, offset);
        offset = this._msg.toRawByteArrayNTCP2(tgt, offset);
        return offset;
    }

    public int getSizeRatchet() {
        return this._instructions.getSize() + this._msg.getMessageSize() - 7;
    }

    public int estimateSize() {
        return this._instructions.getSize() + this._msg.getMessageSize() + 4 + 8 + this._certificate.size();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof GarlicClove)) {
            return false;
        }
        GarlicClove clove = (GarlicClove)obj;
        return DataHelper.eq(this._certificate, clove._certificate) && this._cloveId == clove._cloveId && DataHelper.eq(this._msg, clove._msg) && DataHelper.eq(this._expiration, clove._expiration) && DataHelper.eq(this._instructions, clove._instructions);
    }

    public int hashCode() {
        return DataHelper.hashCode(this._certificate) ^ (int)this._cloveId ^ DataHelper.hashCode(this._msg) ^ DataHelper.hashCode(this._expiration) ^ DataHelper.hashCode(this._instructions);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("[GarlicClove: ");
        buf.append("\n\tInstructions: ").append(this._instructions);
        buf.append("\n\tCertificate: ").append(this._certificate);
        buf.append("\n\tClove ID: ").append(this._cloveId);
        buf.append("\n\tExpiration: ").append(this._expiration);
        buf.append("\n\tData: ").append(this._msg);
        buf.append("]");
        return buf.toString();
    }
}

