/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.naming;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import net.i2p.I2PAppContext;
import net.i2p.client.naming.DummyNamingService;
import net.i2p.client.naming.NamingService;
import net.i2p.client.naming.NamingServiceListener;
import net.i2p.client.naming.SingleFileNamingService;
import net.i2p.crypto.SigType;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.LHMCache;
import net.i2p.util.Log;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;
import net.metanotion.io.RAIFile;
import net.metanotion.io.Serializer;
import net.metanotion.io.block.BlockFile;
import net.metanotion.io.block.index.BSkipList;
import net.metanotion.io.data.IntBytes;
import net.metanotion.io.data.UTF8StringBytes;
import net.metanotion.util.skiplist.SkipIterator;
import net.metanotion.util.skiplist.SkipList;

public class BlockfileNamingService
extends DummyNamingService {
    private final BlockFile _bf;
    private final RAIFile _raf;
    private final List<String> _lists;
    private final List<InvalidEntry> _invalid;
    private final Map<String, String> _negativeCache;
    private volatile boolean _isClosed;
    private final boolean _readOnly;
    private String _version;
    private volatile boolean _isVersion4;
    private boolean _needsUpgrade;
    private static final Serializer<Properties> _infoSerializer = new PropertiesSerializer();
    private static final Serializer<String> _stringSerializer = new UTF8StringBytes();
    private static final Serializer<DestEntry> _destSerializerV1 = new DestEntrySerializer();
    private static final Serializer<DestEntry> _destSerializerV4 = new DestEntrySerializerV4();
    private volatile Serializer<DestEntry> _destSerializer;
    private static final Serializer<Integer> _hashIndexSerializer = new IntBytes();
    private static final String HOSTS_DB = "hostsdb.blockfile";
    private static final String FALLBACK_LIST = "hosts.txt";
    private static final String PROP_FORCE = "i2p.naming.blockfile.writeInAppContext";
    private static final String INFO_SKIPLIST = "%%__INFO__%%";
    private static final String REVERSE_SKIPLIST = "%%__REVERSE__%%";
    private static final String PROP_INFO = "info";
    private static final String PROP_VERSION = "version";
    private static final String PROP_LISTVERSION = "listversion";
    private static final String PROP_LISTS = "lists";
    private static final String PROP_CREATED = "created";
    private static final String PROP_UPGRADED = "upgraded";
    private static final String VERSION = "4";
    private static final String PROP_ADDED = "a";
    private static final String PROP_SOURCE = "s";
    private static final String DUMMY = "";
    private static final int NEGATIVE_CACHE_SIZE = 32;
    private static final int MAX_VALUE_LENGTH = 4096;
    private static final int MAX_DESTS_PER_HOST = 8;

    public BlockfileNamingService(I2PAppContext context) {
        File f;
        boolean readOnly;
        RAIFile raf;
        BlockFile bf;
        block17: {
            super(context);
            this._version = "0";
            this._destSerializer = _destSerializerV1;
            this._lists = new ArrayList<String>();
            this._invalid = new ArrayList<InvalidEntry>();
            this._negativeCache = new LHMCache(32);
            bf = null;
            raf = null;
            readOnly = false;
            f = new File(this._context.getRouterDir(), HOSTS_DB);
            if (f.exists()) {
                try {
                    readOnly = !f.canWrite() || !context.isRouterContext() && !context.getBooleanProperty(PROP_FORCE);
                    raf = new RAIFile(f, true, !readOnly);
                    bf = this.initExisting(raf);
                    if (readOnly && context.isRouterContext()) {
                        this._log.logAlways(30, "Read-only hosts database in router context");
                    }
                    if (bf.wasMounted()) {
                        if (context.isRouterContext()) {
                            this._log.logAlways(30, "The hosts database was not closed cleanly or is still open by another process");
                        } else {
                            this._log.logAlways(30, "The hosts database is possibly in use by another process, perhaps the router? The database is not designed for simultaneous access by multiple processes.\nIf you are using clients outside the router JVM, consider using the hosts.txt naming service with i2p.naming.impl=net.i2p.client.naming.HostsTxtNamingService");
                        }
                    }
                }
                catch (IOException ioe) {
                    if (raf != null) {
                        try {
                            raf.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    File corrupt = new File(this._context.getRouterDir(), "hostsdb.blockfile." + System.currentTimeMillis() + ".corrupt");
                    this._log.log(50, "Corrupt, unsupported version, or unreadable database " + f + ", moving to " + corrupt + " and creating new database", (Throwable)ioe);
                    boolean success = f.renameTo(corrupt);
                    if (success) break block17;
                    this._log.log(50, "Failed to move corrupt database " + f + " to " + corrupt);
                }
            }
        }
        if (bf == null) {
            try {
                raf = new RAIFile(f, true, true);
                SecureFileOutputStream.setPerms((File)f);
                bf = this.initNew(raf);
            }
            catch (IOException ioe) {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this._log.log(50, "Failed to initialize database", (Throwable)ioe);
                throw new RuntimeException(ioe);
            }
            readOnly = false;
        }
        this._bf = bf;
        this._raf = raf;
        this._readOnly = readOnly;
        if (this._needsUpgrade) {
            this.upgrade();
        }
        this._context.addShutdownTask((Runnable)new Shutdown());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockFile initNew(RAIFile f) throws IOException {
        long start = this._context.clock().now();
        this._version = VERSION;
        this._destSerializer = _destSerializerV4;
        this._isVersion4 = true;
        try {
            BlockFile rv = new BlockFile(f, true);
            BSkipList<String, Properties> hdr = rv.makeIndex(INFO_SKIPLIST, _stringSerializer, _infoSerializer);
            Properties info = new Properties();
            info.setProperty(PROP_VERSION, VERSION);
            info.setProperty(PROP_CREATED, Long.toString(this._context.clock().now()));
            String list = this._context.getProperty("i2p.hostsfilelist", "privatehosts.txt,userhosts.txt,hosts.txt");
            info.setProperty(PROP_LISTS, list);
            hdr.put(PROP_INFO, info);
            rv.makeIndex(REVERSE_SKIPLIST, _hashIndexSerializer, _infoSerializer);
            int total = 0;
            for (String hostsfile : BlockfileNamingService.getFilenames(list)) {
                this._lists.add(hostsfile);
                File file = new File(this._context.getRouterDir(), hostsfile);
                if (!file.exists() || !file.canRead()) continue;
                int count = 0;
                BufferedReader in = null;
                String sourceMsg = "Imported from " + hostsfile + " file";
                try {
                    in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"), 16384);
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        int split;
                        if (line.startsWith("#") || (split = line.indexOf(61)) <= 0) continue;
                        String key = line.substring(0, split).toLowerCase(Locale.US);
                        if (line.indexOf(35) > 0 && (line = line.substring(0, line.indexOf(35)).trim()).length() < split + 1) continue;
                        String b64 = line.substring(split + 1).trim();
                        Destination d = this.lookupBase64(b64);
                        if (d != null) {
                            this.addEntry(rv, hostsfile, key, d, sourceMsg);
                            BlockfileNamingService.addReverseEntry(rv, key, d, this._log);
                            ++count;
                            continue;
                        }
                        this._log.logAlways(30, "Unable to import entry for " + key + " from file " + file + " - bad Base 64: " + b64);
                    }
                }
                catch (IOException ioe) {
                    this._log.error("Failed to read hosts from " + file, (Throwable)ioe);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                total += count;
                this._log.logAlways(20, "Migrating " + count + " hosts from " + file + " to new hosts database");
            }
            if (this._log.shouldLog(20)) {
                this._log.info("DB init took " + DataHelper.formatDuration((long)(this._context.clock().now() - start)));
            }
            if (total <= 0) {
                this._log.logAlways(30, "No hosts.txt files found, Initialized hosts database with zero entries");
            }
            return rv;
        }
        catch (RuntimeException e) {
            this._log.error("Failed to initialize database", (Throwable)e);
            throw new IOException(e.toString());
        }
    }

    private BlockFile initExisting(RAIFile raf) throws IOException {
        long start = this._context.clock().now();
        try {
            List<String> skiplists;
            String version;
            BlockFile bf = new BlockFile(raf, false);
            BSkipList<String, Properties> hdr = bf.getIndex(INFO_SKIPLIST, _stringSerializer, _infoSerializer);
            if (hdr == null) {
                throw new IOException("No db header");
            }
            Properties info = (Properties)hdr.get(PROP_INFO);
            if (info == null) {
                throw new IOException("No header info");
            }
            String list = info.getProperty(PROP_LISTS);
            if (list == null) {
                throw new IOException("No lists");
            }
            long createdOn = 0L;
            String created = info.getProperty(PROP_CREATED);
            if (created != null) {
                try {
                    createdOn = Long.parseLong(created);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((version = info.getProperty(PROP_VERSION)) == null) {
                throw new IOException("No version");
            }
            if (VersionComparator.comp((String)version, (String)VERSION) > 0) {
                throw new IOException("Database version is " + version + " but this implementation only supports versions 1-" + VERSION + " Did you downgrade I2P??");
            }
            this._version = version;
            if (VersionComparator.comp((String)version, (String)VERSION) >= 0) {
                this._destSerializer = _destSerializerV4;
                this._isVersion4 = true;
            }
            this._needsUpgrade = this.needsUpgrade(bf);
            if (this._needsUpgrade) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Upgrading database from version " + this._version + " to " + VERSION + ", created " + new Date(createdOn).toString() + " containing lists: " + list);
                }
            } else if (this._log.shouldLog(20)) {
                this._log.info("Found database version " + this._version + " created " + new Date(createdOn).toString() + " containing lists: " + list);
            }
            if ((skiplists = BlockfileNamingService.getFilenames(list)).isEmpty()) {
                skiplists.add(FALLBACK_LIST);
            }
            this._lists.addAll(skiplists);
            if (this._log.shouldLog(20)) {
                this._log.info("DB init took " + DataHelper.formatDuration((long)(this._context.clock().now() - start)));
            }
            return bf;
        }
        catch (RuntimeException e) {
            this._log.error("Failed to initialize database", (Throwable)e);
            throw new IOException(e.toString());
        }
    }

    private boolean needsUpgrade(BlockFile bf) throws IOException {
        if (VersionComparator.comp((String)this._version, (String)VERSION) >= 0) {
            return false;
        }
        if (!bf.file.canWrite()) {
            this._log.logAlways(30, "Not upgrading read-only database version " + this._version);
            return false;
        }
        return true;
    }

    private boolean upgrade() {
        try {
            if (VersionComparator.comp((String)this._version, (String)"2") < 0) {
                BSkipList<Integer, Properties> rev = this._bf.getIndex(REVERSE_SKIPLIST, _hashIndexSerializer, _infoSerializer);
                if (rev == null) {
                    rev = this._bf.makeIndex(REVERSE_SKIPLIST, _hashIndexSerializer, _infoSerializer);
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Created reverse index");
                    }
                }
                this.setVersion("2");
            }
            if (VersionComparator.comp((String)this._version, (String)"3") < 0) {
                Map entries = this.getEntries();
                int i = 0;
                for (Map.Entry entry : entries.entrySet()) {
                    this.addReverseEntry((String)entry.getKey(), (Destination)entry.getValue());
                    ++i;
                }
                if (this._log.shouldLog(30)) {
                    this._log.warn("Updated reverse index with " + i + " entries");
                }
                this.setVersion("3");
            }
            if (VersionComparator.comp((String)this._version, (String)VERSION) < 0) {
                if (SystemVersion.isAndroid()) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Deferring upgrade to version 4 on Android");
                    }
                    return true;
                }
                BSkipList<String, Properties> hdr = this._bf.getIndex(INFO_SKIPLIST, _stringSerializer, _infoSerializer);
                if (hdr == null) {
                    throw new IOException("No db header");
                }
                Properties info = (Properties)hdr.get(PROP_INFO);
                if (info == null) {
                    throw new IOException("No header info");
                }
                for (String list : this._lists) {
                    try {
                        String vprop = "listversion_" + list;
                        String listVersion = info.getProperty(vprop);
                        if (listVersion == null || VersionComparator.comp((String)listVersion, (String)VERSION) < 0) {
                            if (this._log.shouldWarn()) {
                                this._log.warn("Upgrading " + list + " from database version 3 to 4");
                            }
                            this._bf.reformatIndex(list, _stringSerializer, _destSerializerV1, _stringSerializer, _destSerializerV4);
                            info.setProperty(vprop, VERSION);
                            hdr.put(PROP_INFO, info);
                            continue;
                        }
                        if (!this._log.shouldWarn()) continue;
                        this._log.warn("Partial upgrade, " + list + " already at version " + listVersion);
                    }
                    catch (IOException ioe) {
                        this._log.error("Failed upgrade of list " + list + " to version 4", (Throwable)ioe);
                    }
                }
                this._destSerializer = _destSerializerV4;
                this._isVersion4 = true;
                this.setVersion(VERSION);
            }
            return true;
        }
        catch (IOException ioe) {
            this._log.error("Error upgrading DB", (Throwable)ioe);
        }
        catch (RuntimeException e) {
            this._log.error("Error upgrading DB", (Throwable)e);
        }
        return false;
    }

    private void setVersion(String version) throws IOException {
        BSkipList<String, Properties> hdr = this._bf.getIndex(INFO_SKIPLIST, _stringSerializer, _infoSerializer);
        if (hdr == null) {
            throw new IOException("No db header");
        }
        Properties info = (Properties)hdr.get(PROP_INFO);
        if (info == null) {
            throw new IOException("No header info");
        }
        info.setProperty(PROP_VERSION, version);
        info.setProperty(PROP_UPGRADED, Long.toString(this._context.clock().now()));
        hdr.put(PROP_INFO, info);
        if (this._log.shouldLog(30)) {
            this._log.warn("Upgraded database from version " + this._version + " to version " + version);
        }
        this._version = version;
    }

    private DestEntry getEntry(String listname, String key) throws IOException {
        try {
            BSkipList<String, DestEntry> sl = this._bf.getIndex(listname, _stringSerializer, this._destSerializer);
            if (sl == null) {
                return null;
            }
            DestEntry rv = (DestEntry)sl.get(key);
            return rv;
        }
        catch (IOException ioe) {
            this._log.error("DB Lookup error", (Throwable)ioe);
            throw ioe;
        }
        catch (RuntimeException e) {
            this._log.error("DB Lookup error", (Throwable)e);
            throw new IOException(e.toString());
        }
    }

    private void addEntry(BlockFile bf, String listname, String key, Destination dest, String source) throws IOException {
        try {
            BSkipList<String, DestEntry> sl = bf.getIndex(listname, _stringSerializer, this._destSerializer);
            if (sl == null) {
                sl = bf.makeIndex(listname, _stringSerializer, this._destSerializer);
            }
            Properties props = new Properties();
            props.setProperty(PROP_ADDED, Long.toString(this._context.clock().now()));
            if (source != null) {
                props.setProperty(PROP_SOURCE, source);
            }
            BlockfileNamingService.addEntry(sl, key, dest, props);
        }
        catch (IOException ioe) {
            this._log.error("DB add error", (Throwable)ioe);
            throw ioe;
        }
        catch (RuntimeException e) {
            this._log.error("DB add error", (Throwable)e);
            throw new IOException(e.toString());
        }
    }

    private static void addEntry(SkipList<String, DestEntry> sl, String key, Destination dest, Properties props) {
        DestEntry de = new DestEntry();
        de.dest = dest;
        de.props = props;
        sl.put(key, de);
    }

    private static void addEntry(SkipList<String, DestEntry> sl, String key, List<Destination> dests, List<Properties> propsList) {
        DestEntry de = new DestEntry();
        de.destList = dests;
        de.dest = dests.get(0);
        de.propsList = propsList;
        if (propsList != null) {
            de.props = propsList.get(0);
        }
        sl.put(key, de);
    }

    private static List<String> getFilenames(String list) {
        StringTokenizer tok = new StringTokenizer(list, ",");
        ArrayList<String> rv = new ArrayList<String>(tok.countTokens());
        while (tok.hasMoreTokens()) {
            rv.add(tok.nextToken());
        }
        return rv;
    }

    private static <V> V removeEntry(SkipList<String, V> sl, String key) {
        return sl.remove(key);
    }

    private List<String> getReverseEntries(Hash hash) {
        try {
            BSkipList<Integer, Properties> rev = this._bf.getIndex(REVERSE_SKIPLIST, _hashIndexSerializer, _infoSerializer);
            if (rev == null) {
                return null;
            }
            Integer idx = BlockfileNamingService.getReverseKey(hash);
            Properties props = (Properties)rev.get(idx);
            if (props == null) {
                return null;
            }
            ArrayList<String> rv = new ArrayList<String>(props.size());
            block3: for (String key : props.stringPropertyNames()) {
                List ld = this.lookupAll(key);
                if (ld == null) continue;
                for (Destination d : ld) {
                    if (!d.calculateHash().equals((Object)hash)) continue;
                    rv.add(key);
                    continue block3;
                }
            }
            if (!rv.isEmpty()) {
                return rv;
            }
        }
        catch (IOException ioe) {
            this._log.error("DB get reverse error", (Throwable)ioe);
        }
        catch (RuntimeException e) {
            this._log.error("DB get reverse error", (Throwable)e);
        }
        return null;
    }

    private void addReverseEntry(String key, Destination dest) {
        BlockfileNamingService.addReverseEntry(this._bf, key, dest, this._log);
    }

    private static void addReverseEntry(BlockFile bf, String key, Destination dest, Log log) {
        try {
            BSkipList<Integer, Properties> rev = bf.getIndex(REVERSE_SKIPLIST, _hashIndexSerializer, _infoSerializer);
            if (rev == null) {
                return;
            }
            Integer idx = BlockfileNamingService.getReverseKey(dest);
            Properties props = (Properties)rev.get(idx);
            if (props != null) {
                if (props.getProperty(key) != null) {
                    return;
                }
            } else {
                props = new Properties();
            }
            props.put(key, DUMMY);
            rev.put(idx, props);
        }
        catch (IOException ioe) {
            log.error("DB add reverse error", (Throwable)ioe);
        }
        catch (RuntimeException e) {
            log.error("DB add reverse error", (Throwable)e);
        }
    }

    private void removeReverseEntry(String key, Destination dest) {
        try {
            BSkipList<Integer, Properties> rev = this._bf.getIndex(REVERSE_SKIPLIST, _hashIndexSerializer, _infoSerializer);
            if (rev == null) {
                return;
            }
            Integer idx = BlockfileNamingService.getReverseKey(dest);
            Properties props = (Properties)rev.get(idx);
            if (props == null || props.remove(key) == null) {
                return;
            }
            if (props.isEmpty()) {
                rev.remove(idx);
            } else {
                rev.put(idx, props);
            }
        }
        catch (IOException ioe) {
            this._log.error("DB remove reverse error", (Throwable)ioe);
        }
        catch (RuntimeException e) {
            this._log.error("DB remove reverse error", (Throwable)e);
        }
    }

    private static Integer getReverseKey(Destination dest) {
        return BlockfileNamingService.getReverseKey(dest.calculateHash());
    }

    private static Integer getReverseKey(Hash hash) {
        byte[] hashBytes = hash.getData();
        int i = (int)DataHelper.fromLong((byte[])hashBytes, (int)0, (int)4);
        return i;
    }

    public Destination lookup(String hostname, Properties lookupOptions, Properties storedOptions) {
        Destination rv = this.lookup2(hostname, lookupOptions, storedOptions);
        if (rv == null && (hostname = hostname.toLowerCase(Locale.US)).startsWith("www.") && hostname.length() > 7) {
            hostname = hostname.substring(4);
            rv = this.lookup2(hostname, lookupOptions, storedOptions);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Destination lookup2(String hostname, Properties lookupOptions, Properties storedOptions) {
        String listname = null;
        if (lookupOptions != null) {
            listname = lookupOptions.getProperty("list");
        }
        Destination d = null;
        if (listname == null && storedOptions == null) {
            d = super.lookup(hostname, null, null);
            if (d != null) {
                return d;
            }
            if (hostname.length() == 60 && hostname.toLowerCase(Locale.US).endsWith(".b32.i2p")) {
                return null;
            }
        }
        String key = hostname.toLowerCase(Locale.US);
        Map<String, String> map = this._negativeCache;
        synchronized (map) {
            if (this._negativeCache.get(key) != null) {
                return null;
            }
        }
        map = this._bf;
        synchronized (map) {
            if (this._isClosed) {
                return null;
            }
            for (String list : this._lists) {
                if (listname != null && !list.equals(listname)) continue;
                try {
                    DestEntry de = this.getEntry(list, key);
                    if (de == null || !this.validate(key, de, listname)) continue;
                    d = de.dest;
                    if (storedOptions == null || de.props == null) break;
                    storedOptions.putAll((Map<?, ?>)de.props);
                }
                catch (IOException ioe) {}
                break;
            }
            this.deleteInvalid();
        }
        if (d != null) {
            BlockfileNamingService.putCache((String)hostname, (Destination)d);
        } else {
            map = this._negativeCache;
            synchronized (map) {
                this._negativeCache.put(key, DUMMY);
            }
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Destination> lookupAll2(String hostname, Properties lookupOptions, List<Properties> storedOptions) {
        if (hostname.length() == 60 && hostname.toLowerCase(Locale.US).endsWith(".b32.i2p")) {
            Destination d = super.lookup(hostname, null, null);
            if (d != null) {
                if (storedOptions != null) {
                    storedOptions.add(null);
                }
                return Collections.singletonList(d);
            }
            return null;
        }
        String key = hostname.toLowerCase(Locale.US);
        Map<String, String> map = this._negativeCache;
        synchronized (map) {
            if (this._negativeCache.get(key) != null) {
                return null;
            }
        }
        String listname = null;
        if (lookupOptions != null) {
            listname = lookupOptions.getProperty("list");
        }
        List<Destination> rv = null;
        Object object = this._bf;
        synchronized (object) {
            if (this._isClosed) {
                return null;
            }
            for (String list : this._lists) {
                if (listname != null && !list.equals(listname)) continue;
                try {
                    DestEntry de = this.getEntry(list, key);
                    if (de == null || !this.validate(key, de, listname)) continue;
                    if (de.destList != null) {
                        rv = de.destList;
                        if (storedOptions == null) break;
                        storedOptions.addAll(de.propsList);
                        break;
                    }
                    rv = Collections.singletonList(de.dest);
                    if (storedOptions == null) break;
                    storedOptions.add(de.props);
                }
                catch (IOException ioe) {}
                break;
            }
            this.deleteInvalid();
        }
        if (rv != null) {
            BlockfileNamingService.putCache((String)hostname, (Destination)((Destination)rv.get(0)));
        } else {
            object = this._negativeCache;
            synchronized (object) {
                this._negativeCache.put(key, DUMMY);
            }
        }
        return rv;
    }

    public boolean put(String hostname, Destination d, Properties options) {
        return this.put(hostname, d, options, false);
    }

    public boolean putIfAbsent(String hostname, Destination d, Properties options) {
        return this.put(hostname, d, options, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean put(String hostname, Destination d, Properties options, boolean checkExisting) {
        if (this._readOnly) {
            this._log.error("Add entry failed, read-only hosts database");
            return false;
        }
        String key = hostname.toLowerCase(Locale.US);
        Map<String, String> map = this._negativeCache;
        synchronized (map) {
            this._negativeCache.remove(key);
        }
        String listname = FALLBACK_LIST;
        Properties props = new Properties();
        props.setProperty(PROP_ADDED, Long.toString(this._context.clock().now()));
        if (options != null) {
            props.putAll((Map<?, ?>)options);
            String list = options.getProperty("list");
            if (list != null) {
                listname = list;
                props.remove("list");
            }
        }
        BlockFile blockFile = this._bf;
        synchronized (blockFile) {
            if (this._isClosed) {
                return false;
            }
            try {
                boolean changed;
                BSkipList<String, DestEntry> sl = this._bf.getIndex(listname, _stringSerializer, this._destSerializer);
                if (sl == null) {
                    sl = this._bf.makeIndex(listname, _stringSerializer, this._destSerializer);
                }
                boolean bl = changed = (checkExisting || !this._listeners.isEmpty()) && sl.get(key) != null;
                if (changed && checkExisting) {
                    return false;
                }
                BlockfileNamingService.addEntry(sl, key, d, props);
                if (changed) {
                    BlockfileNamingService.removeCache((String)hostname);
                }
                this.addReverseEntry(key, d);
                for (NamingServiceListener nsl : this._listeners) {
                    if (changed) {
                        nsl.entryChanged((NamingService)this, hostname, d, options);
                        continue;
                    }
                    nsl.entryAdded((NamingService)this, hostname, d, options);
                }
                return true;
            }
            catch (IOException ioe) {
                this._log.error("DB add error", (Throwable)ioe);
                return false;
            }
            catch (RuntimeException re) {
                this._log.error("DB add error", (Throwable)re);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean put(String hostname, List<Destination> dests, List<Properties> propsList, boolean checkExisting) {
        int sz = dests.size();
        if (sz <= 0) {
            throw new IllegalArgumentException();
        }
        if (sz == 1) {
            return this.put(hostname, dests.get(0), propsList != null ? propsList.get(0) : null, checkExisting);
        }
        if (this._readOnly) {
            this._log.error("Add entry failed, read-only hosts database");
            return false;
        }
        String key = hostname.toLowerCase(Locale.US);
        Map<String, String> map = this._negativeCache;
        synchronized (map) {
            this._negativeCache.remove(key);
        }
        String listname = FALLBACK_LIST;
        String date = Long.toString(this._context.clock().now());
        ArrayList<Properties> outProps = new ArrayList<Properties>(propsList.size());
        for (Properties options : propsList) {
            Properties props = new Properties();
            props.setProperty(PROP_ADDED, date);
            if (options != null) {
                props.putAll((Map<?, ?>)options);
                String list = options.getProperty("list");
                if (list != null) {
                    listname = list;
                    props.remove("list");
                }
            }
            outProps.add(props);
        }
        BlockFile blockFile = this._bf;
        synchronized (blockFile) {
            if (this._isClosed) {
                return false;
            }
            try {
                boolean changed;
                BSkipList<String, DestEntry> sl = this._bf.getIndex(listname, _stringSerializer, this._destSerializer);
                if (sl == null) {
                    sl = this._bf.makeIndex(listname, _stringSerializer, this._destSerializer);
                }
                boolean bl = changed = (checkExisting || !this._listeners.isEmpty()) && sl.get(key) != null;
                if (changed && checkExisting) {
                    return false;
                }
                BlockfileNamingService.addEntry(sl, key, dests, outProps);
                if (changed) {
                    BlockfileNamingService.removeCache((String)hostname);
                }
                for (int i = 0; i < dests.size(); ++i) {
                    Destination d = dests.get(i);
                    Properties options = propsList.get(i);
                    this.addReverseEntry(key, d);
                    for (NamingServiceListener nsl : this._listeners) {
                        if (changed) {
                            nsl.entryChanged((NamingService)this, hostname, d, options);
                            continue;
                        }
                        nsl.entryAdded((NamingService)this, hostname, d, options);
                    }
                }
                return true;
            }
            catch (IOException ioe) {
                this._log.error("DB add error", (Throwable)ioe);
                return false;
            }
            catch (RuntimeException re) {
                this._log.error("DB add error", (Throwable)re);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String hostname, Properties options) {
        String list;
        if (this._readOnly) {
            this._log.error("Remove entry failed, read-only hosts database");
            return false;
        }
        String key = hostname.toLowerCase(Locale.US);
        String listname = FALLBACK_LIST;
        if (options != null && (list = options.getProperty("list")) != null) {
            listname = list;
        }
        BlockFile blockFile = this._bf;
        synchronized (blockFile) {
            if (this._isClosed) {
                return false;
            }
            try {
                boolean rv;
                BSkipList<String, DestEntry> sl = this._bf.getIndex(listname, _stringSerializer, this._destSerializer);
                if (sl == null) {
                    return false;
                }
                DestEntry removed = BlockfileNamingService.removeEntry(sl, key);
                boolean bl = rv = removed != null;
                if (rv) {
                    BlockfileNamingService.removeCache((String)hostname);
                    try {
                        this.removeReverseEntry(key, removed.dest);
                    }
                    catch (ClassCastException cce) {
                        this._log.error("DB reverse remove error", (Throwable)cce);
                    }
                    for (NamingServiceListener nsl : this._listeners) {
                        nsl.entryRemoved((NamingService)this, key);
                    }
                }
                return rv;
            }
            catch (IOException ioe) {
                this._log.error("DB remove error", (Throwable)ioe);
                return false;
            }
            catch (RuntimeException re) {
                this._log.error("DB remove error", (Throwable)re);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Destination> getEntries(Properties options) {
        Object sk;
        String listname = FALLBACK_LIST;
        String search = null;
        String startsWith = null;
        String beginWith = null;
        int limit = Integer.MAX_VALUE;
        int skip = 0;
        if (options != null) {
            String ln = options.getProperty("list");
            if (ln != null) {
                listname = ln;
            }
            search = options.getProperty("search");
            startsWith = options.getProperty("startsWith");
            beginWith = options.getProperty("beginWith");
            if (beginWith == null && startsWith != null) {
                beginWith = startsWith.equals("[0-9]") ? "0" : startsWith;
            }
            String lim = options.getProperty("limit");
            try {
                limit = Integer.parseInt(lim);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            sk = options.getProperty("skip");
            try {
                skip = Integer.parseInt((String)sk);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Searching " + listname + " beginning with " + beginWith + " starting with " + startsWith + " search string " + search + " limit=" + limit + " skip=" + skip);
        }
        BlockFile blockFile = this._bf;
        synchronized (blockFile) {
            Map<String, Destination> map;
            if (this._isClosed) {
                return Collections.emptyMap();
            }
            try {
                int i;
                BSkipList<String, DestEntry> sl = this._bf.getIndex(listname, _stringSerializer, this._destSerializer);
                if (sl == null) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("No skiplist found for lookup in " + listname);
                    }
                    sk = Collections.emptyMap();
                    return sk;
                }
                SkipIterator iter = beginWith != null ? ((SkipList)sl).find(beginWith) : ((SkipList)sl).iterator();
                TreeMap<String, Destination> rv = new TreeMap<String, Destination>();
                for (i = 0; i < skip && iter.hasNext(); ++i) {
                    iter.next();
                }
                i = 0;
                while (i < limit && iter.hasNext()) {
                    String key = iter.nextKey();
                    if (startsWith != null && (!startsWith.equals("[0-9]") ? !key.startsWith(startsWith) : key.charAt(0) > '9')) break;
                    DestEntry de = (DestEntry)iter.next();
                    if (!this.validate(key, de, listname) || search != null && key.indexOf(search) < 0) continue;
                    rv.put(key, de.dest);
                    ++i;
                }
                TreeMap<String, Destination> treeMap = rv;
                return treeMap;
            }
            catch (IOException ioe) {
                this._log.error("DB lookup error", (Throwable)ioe);
                map = Collections.emptyMap();
                return map;
            }
            catch (RuntimeException re) {
                this._log.error("DB lookup error", (Throwable)re);
                map = Collections.emptyMap();
                return map;
            }
            finally {
                this.deleteInvalid();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> getBase64Entries(Properties options) {
        Object sk;
        String listname = FALLBACK_LIST;
        String search = null;
        String startsWith = null;
        String beginWith = null;
        int limit = Integer.MAX_VALUE;
        int skip = 0;
        if (options != null) {
            String ln = options.getProperty("list");
            if (ln != null) {
                listname = ln;
            }
            search = options.getProperty("search");
            startsWith = options.getProperty("startsWith");
            beginWith = options.getProperty("beginWith");
            if (beginWith == null && startsWith != null) {
                beginWith = startsWith.equals("[0-9]") ? "0" : startsWith;
            }
            String lim = options.getProperty("limit");
            try {
                limit = Integer.parseInt(lim);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            sk = options.getProperty("skip");
            try {
                skip = Integer.parseInt((String)sk);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        BlockFile blockFile = this._bf;
        synchronized (blockFile) {
            Map<String, String> map;
            if (this._isClosed) {
                return Collections.emptyMap();
            }
            try {
                int i;
                BSkipList<String, DestEntry> sl = this._bf.getIndex(listname, _stringSerializer, this._destSerializer);
                if (sl == null) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("No skiplist found for lookup in " + listname);
                    }
                    sk = Collections.emptyMap();
                    return sk;
                }
                SkipIterator iter = beginWith != null ? ((SkipList)sl).find(beginWith) : ((SkipList)sl).iterator();
                TreeMap<String, String> rv = new TreeMap<String, String>();
                for (i = 0; i < skip && iter.hasNext(); ++i) {
                    iter.next();
                }
                i = 0;
                while (i < limit && iter.hasNext()) {
                    String key = iter.nextKey();
                    if (startsWith != null && (!startsWith.equals("[0-9]") ? !key.startsWith(startsWith) : key.charAt(0) > '9')) break;
                    DestEntry de = (DestEntry)iter.next();
                    if (!this.validate(key, de, listname) || search != null && key.indexOf(search) < 0) continue;
                    rv.put(key, de.dest.toBase64());
                    ++i;
                }
                TreeMap<String, String> treeMap = rv;
                return treeMap;
            }
            catch (IOException ioe) {
                this._log.error("DB lookup error", (Throwable)ioe);
                map = Collections.emptyMap();
                return map;
            }
            catch (RuntimeException re) {
                this._log.error("DB lookup error", (Throwable)re);
                map = Collections.emptyMap();
                return map;
            }
            finally {
                this.deleteInvalid();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void export(Writer out, Properties options) throws IOException {
        String listname = FALLBACK_LIST;
        String search = null;
        String startsWith = null;
        String beginWith = null;
        if (options != null) {
            String ln = options.getProperty("list");
            if (ln != null) {
                listname = ln;
            }
            search = options.getProperty("search");
            startsWith = options.getProperty("startsWith");
            beginWith = options.getProperty("beginWith");
            if (beginWith == null && startsWith != null) {
                beginWith = startsWith.equals("[0-9]") ? "0" : startsWith;
            }
        }
        out.write("# Address book: ");
        out.write(this.getName());
        out.write(" (" + listname + ')');
        String nl = System.getProperty("line.separator", "\n");
        out.write(nl);
        out.write("# Exported: ");
        out.write(new Date().toString());
        out.write(nl);
        BlockFile blockFile = this._bf;
        synchronized (blockFile) {
            int cnt;
            block25: {
                if (this._isClosed) {
                    return;
                }
                try {
                    BSkipList<String, DestEntry> sl = this._bf.getIndex(listname, _stringSerializer, this._destSerializer);
                    if (sl == null) {
                        if (!this._log.shouldLog(30)) return;
                        this._log.warn("No skiplist found for lookup in " + listname);
                        return;
                    }
                    if (beginWith == null && search == null) {
                        int sz = sl.size();
                        if (sz <= 0) {
                            out.write("# No entries");
                            out.write(nl);
                            return;
                        }
                        if (sz > 1) {
                            out.write("# " + sz + " entries");
                            out.write(nl);
                        }
                    }
                    SkipIterator iter = beginWith != null ? ((SkipList)sl).find(beginWith) : ((SkipList)sl).iterator();
                    cnt = 0;
                    while (iter.hasNext()) {
                        String key = iter.nextKey();
                        if (startsWith != null && (!startsWith.equals("[0-9]") ? !key.startsWith(startsWith) : key.charAt(0) > '9')) break;
                        DestEntry de = (DestEntry)iter.next();
                        if (!this.validate(key, de, listname) || search != null && key.indexOf(search) < 0) continue;
                        int dsz = de.destList != null ? de.destList.size() : 1;
                        for (int i = dsz - 1; i >= 0; ++cnt, --i) {
                            Destination d;
                            Properties p;
                            if (i == 0) {
                                p = de.props;
                                d = de.dest;
                            } else {
                                p = de.propsList.get(i);
                                d = de.destList.get(i);
                            }
                            out.write("# ");
                            out.write(key);
                            out.write(": ");
                            out.write(d.toBase32());
                            out.write(nl);
                            out.write(key);
                            out.write(61);
                            out.write(d.toBase64());
                            if (p != null) {
                                SingleFileNamingService.writeOptions((Properties)p, (Writer)out);
                            }
                            out.write(nl);
                        }
                    }
                }
                catch (RuntimeException re) {
                    throw new IOException("DB lookup error", re);
                }
                if (beginWith == null) {
                    if (search == null) return;
                }
                if (cnt <= 0) {
                    out.write("# No entries");
                    out.write(nl);
                    return;
                }
                break block25;
                finally {
                    this.deleteInvalid();
                }
            }
            if (cnt <= 1) return;
            out.write("# " + cnt + " entries");
            out.write(nl);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getNames(Properties options) {
        String listname = FALLBACK_LIST;
        String search = null;
        String startsWith = null;
        String beginWith = null;
        int limit = Integer.MAX_VALUE;
        int skip = 0;
        if (options != null) {
            String ln = options.getProperty("list");
            if (ln != null) {
                listname = ln;
            }
            search = options.getProperty("search");
            startsWith = options.getProperty("startsWith");
            beginWith = options.getProperty("beginWith");
            if (beginWith == null && startsWith != null) {
                beginWith = startsWith.equals("[0-9]") ? "0" : startsWith;
            }
            String lim = options.getProperty("limit");
            try {
                limit = Integer.parseInt(lim);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String sk = options.getProperty("skip");
            try {
                skip = Integer.parseInt(sk);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        BlockFile blockFile = this._bf;
        synchronized (blockFile) {
            if (this._isClosed) {
                return Collections.emptySet();
            }
            try {
                int i;
                BSkipList<String, DestEntry> sl = this._bf.getIndex(listname, _stringSerializer, this._destSerializer);
                if (sl == null) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("No skiplist found for lookup in " + listname);
                    }
                    return Collections.emptySet();
                }
                SkipIterator iter = beginWith != null ? ((SkipList)sl).find(beginWith) : ((SkipList)sl).iterator();
                HashSet<String> rv = new HashSet<String>();
                for (i = 0; i < skip && iter.hasNext(); ++i) {
                    iter.next();
                }
                i = 0;
                while (i < limit && iter.hasNext()) {
                    String key = iter.nextKey();
                    if (startsWith != null && (!startsWith.equals("[0-9]") ? !key.startsWith(startsWith) : key.charAt(0) > '9')) break;
                    if (search != null && key.indexOf(search) < 0) continue;
                    rv.add(key);
                    ++i;
                }
                return rv;
            }
            catch (IOException ioe) {
                this._log.error("DB lookup error", (Throwable)ioe);
                return Collections.emptySet();
            }
            catch (RuntimeException re) {
                this._log.error("DB lookup error", (Throwable)re);
                return Collections.emptySet();
            }
        }
    }

    public String reverseLookup(Destination d, Properties options) {
        return this.reverseLookup(d.calculateHash());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String reverseLookup(Hash h) {
        List<String> ls;
        BlockFile blockFile = this._bf;
        synchronized (blockFile) {
            if (this._isClosed) {
                return null;
            }
            ls = this.getReverseEntries(h);
        }
        return ls != null ? ls.get(0) : null;
    }

    public List<String> reverseLookupAll(Destination d, Properties options) {
        return this.reverseLookupAll(d.calculateHash());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> reverseLookupAll(Hash h) {
        BlockFile blockFile = this._bf;
        synchronized (blockFile) {
            if (this._isClosed) {
                return null;
            }
            return this.getReverseEntries(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size(Properties options) {
        String list;
        String listname = FALLBACK_LIST;
        if (options != null && (list = options.getProperty("list")) != null) {
            listname = list;
        }
        BlockFile blockFile = this._bf;
        synchronized (blockFile) {
            if (this._isClosed) {
                return 0;
            }
            try {
                BSkipList<String, DestEntry> sl = this._bf.getIndex(listname, _stringSerializer, this._destSerializer);
                if (sl == null) {
                    return 0;
                }
                return sl.size();
            }
            catch (IOException ioe) {
                this._log.error("DB size error", (Throwable)ioe);
                return 0;
            }
            catch (RuntimeException re) {
                this._log.error("DB size error", (Throwable)re);
                return 0;
            }
        }
    }

    public void shutdown() {
        this.close();
    }

    public List<Destination> lookupAll(String hostname, Properties lookupOptions, List<Properties> storedOptions) {
        if (!this._isVersion4) {
            return super.lookupAll(hostname, lookupOptions, storedOptions);
        }
        List<Destination> rv = this.lookupAll2(hostname, lookupOptions, storedOptions);
        if (rv == null && (hostname = hostname.toLowerCase(Locale.US)).startsWith("www.") && hostname.length() > 7) {
            hostname = hostname.substring(4);
            rv = this.lookupAll2(hostname, lookupOptions, storedOptions);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addDestination(String hostname, Destination d, Properties options) {
        if (!this._isVersion4) {
            return this.putIfAbsent(hostname, d, options);
        }
        ArrayList<Properties> storedOptions = new ArrayList<Properties>(4);
        BlockFile blockFile = this._bf;
        synchronized (blockFile) {
            List<Destination> dests = this.lookupAll2(hostname, options, storedOptions);
            if (dests == null) {
                return this.put(hostname, d, options, false);
            }
            if (dests.contains(d)) {
                return false;
            }
            if (dests.size() >= 8) {
                return false;
            }
            ArrayList<Destination> newDests = new ArrayList<Destination>(dests.size() + 1);
            newDests.addAll(dests);
            SigType type = d.getSigningPublicKey().getType();
            if (type != SigType.DSA_SHA1 && type.isAvailable()) {
                newDests.add(0, d);
                storedOptions.add(0, options);
            } else {
                newDests.add(d);
                storedOptions.add(options);
            }
            return this.put(hostname, newDests, storedOptions, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String hostname, Destination d, Properties options) {
        if (!this._isVersion4) {
            BlockFile blockFile = this._bf;
            synchronized (blockFile) {
                return super.remove(hostname, d, options);
            }
        }
        ArrayList<Properties> storedOptions = new ArrayList<Properties>(4);
        BlockFile blockFile = this._bf;
        synchronized (blockFile) {
            List<Destination> dests = this.lookupAll2(hostname, options, storedOptions);
            if (dests == null) {
                return false;
            }
            for (int i = 0; i < dests.size(); ++i) {
                String list;
                Destination dd = dests.get(i);
                if (!dd.equals((Object)d)) continue;
                if (dests.size() == 1) {
                    return this.remove(hostname, options);
                }
                ArrayList<Destination> newDests = new ArrayList<Destination>(dests.size() - 1);
                for (int j = 0; j < dests.size(); ++j) {
                    if (j == i) continue;
                    newDests.add(dests.get(j));
                }
                storedOptions.remove(i);
                this.removeReverseEntry(hostname, d);
                if (options != null && (list = options.getProperty("list")) != null) {
                    ((Properties)storedOptions.get(0)).setProperty("list", list);
                }
                return this.put(hostname, newDests, storedOptions, false);
            }
        }
        return false;
    }

    private boolean validate(String key, DestEntry de, String listname) {
        boolean rv;
        if (key == null) {
            return false;
        }
        boolean bl = rv = key.length() > 0 && de != null && de.dest != null && de.dest.getPublicKey() != null;
        if (this._isVersion4 && rv && de.destList != null) {
            boolean bl2 = rv = de.propsList != null && de.destList.size() == de.propsList.size() && !de.destList.contains(null);
        }
        if (!rv && !this._readOnly) {
            this._invalid.add(new InvalidEntry(key, listname));
        }
        return rv;
    }

    private void deleteInvalid() {
        if (this._invalid.isEmpty()) {
            return;
        }
        this._log.error("Removing " + this._invalid.size() + " corrupt entries from database");
        for (InvalidEntry ie : this._invalid) {
            String key = ie.key;
            String list = ie.list;
            try {
                boolean success;
                BSkipList<String, DestEntry> sl = this._bf.getIndex(list, _stringSerializer, this._destSerializer);
                if (sl == null) {
                    this._log.error("No list found to remove corrupt \"" + key + "\" from database " + list);
                    continue;
                }
                boolean bl = success = BlockfileNamingService.removeEntry(sl, key) != null;
                if (success) {
                    this._log.error("Removed corrupt \"" + key + "\" from database " + list);
                    continue;
                }
                this._log.error("May have Failed to remove corrupt \"" + key + "\" from database " + list);
            }
            catch (RuntimeException re) {
                this._log.error("Error while removing corrupt \"" + key + "\" from database " + list, (Throwable)re);
            }
            catch (IOException ioe) {
                this._log.error("Error while removing corrput \"" + key + "\" from database " + list, (Throwable)ioe);
            }
        }
        this._invalid.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        Object object = this._bf;
        synchronized (object) {
            block12: {
                try {
                    this._bf.close();
                }
                catch (IOException ioe) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Error closing", (Throwable)ioe);
                    }
                }
                catch (RuntimeException e) {
                    if (!this._log.shouldLog(30)) break block12;
                    this._log.warn("Error closing", (Throwable)e);
                }
            }
            try {
                this._raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._isClosed = true;
        }
        object = this._negativeCache;
        synchronized (object) {
            this._negativeCache.clear();
        }
        BlockfileNamingService.clearCache();
    }

    private static void logError(String msg, Throwable t) {
        I2PAppContext.getGlobalContext().logManager().getLog(BlockfileNamingService.class).error(msg, t);
    }

    private static void writeProperties(ByteArrayOutputStream rawStream, Properties p) throws DataFormatException, IOException {
        if (p != null && !p.isEmpty()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(p.size() * 32);
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                DataHelper.writeStringUTF8((OutputStream)baos, (String)key);
                baos.write(61);
                BlockfileNamingService.writeLongStringUTF8(baos, val);
                baos.write(59);
            }
            if (baos.size() > 65535) {
                throw new DataFormatException("Properties too big (65535 max): " + baos.size());
            }
            byte[] propBytes = baos.toByteArray();
            DataHelper.writeLong((OutputStream)rawStream, (int)2, (long)propBytes.length);
            rawStream.write(propBytes);
        } else {
            DataHelper.writeLong((OutputStream)rawStream, (int)2, (long)0L);
        }
    }

    public static Properties readProperties(ByteArrayInputStream in) throws DataFormatException, IOException {
        Properties props = new Properties();
        int size = (int)DataHelper.readLong((InputStream)in, (int)2);
        int ignore = in.available() - size;
        while (in.available() > ignore) {
            String key = DataHelper.readString((InputStream)in);
            int b = in.read();
            if (b != 61) {
                throw new DataFormatException("Bad key " + b);
            }
            String val = BlockfileNamingService.readLongString(in);
            b = in.read();
            if (b != 59) {
                throw new DataFormatException("Bad value");
            }
            Object old = props.put(key, val);
            if (old == null) continue;
            throw new DataFormatException("Duplicate key " + key);
        }
        return props;
    }

    private static void writeLongStringUTF8(ByteArrayOutputStream out, String string) throws DataFormatException, IOException {
        if (string == null) {
            out.write(0);
        } else {
            byte[] raw = string.getBytes("UTF-8");
            int len = raw.length;
            if (len >= 255) {
                if (len > 4096) {
                    throw new DataFormatException("4096 max, but this is " + len + " [" + string + "]");
                }
                out.write(255);
                DataHelper.writeLong((OutputStream)out, (int)2, (long)len);
            } else {
                out.write(len);
            }
            out.write(raw);
        }
    }

    private static String readLongString(ByteArrayInputStream in) throws DataFormatException, IOException {
        int size = in.read();
        if (size < 0) {
            throw new EOFException("EOF reading string");
        }
        if (size == 255 && (size = (int)DataHelper.readLong((InputStream)in, (int)2)) > 4096) {
            throw new DataFormatException("4096 max, but this is " + size);
        }
        if (size == 0) {
            return DUMMY;
        }
        byte[] raw = new byte[size];
        int read = DataHelper.read((InputStream)in, (byte[])raw);
        if (read != size) {
            throw new EOFException("EOF reading string");
        }
        return new String(raw, "UTF-8");
    }

    public static void main(String[] args) {
        Properties ctxProps = new Properties();
        if (args.length > 0 && args[0].equals("force")) {
            ctxProps.setProperty(PROP_FORCE, "true");
        }
        I2PAppContext ctx = new I2PAppContext(ctxProps);
        BlockfileNamingService bns = new BlockfileNamingService(ctx);
        Properties sprops = new Properties();
        String lname = "privatehosts.txt";
        sprops.setProperty("list", lname);
        System.out.println("List " + lname + " contains " + bns.size(sprops));
        lname = "userhosts.txt";
        sprops.setProperty("list", lname);
        System.out.println("List " + lname + " contains " + bns.size(sprops));
        lname = FALLBACK_LIST;
        sprops.setProperty("list", lname);
        System.out.println("List " + lname + " contains " + bns.size(sprops));
        bns.close();
        ctx.logManager().flush();
        System.out.flush();
    }

    private static class DestEntry {
        public Properties props;
        public Destination dest;
        public List<Properties> propsList;
        public List<Destination> destList;

        private DestEntry() {
        }

        public String toString() {
            return "DestEntry (" + DataHelper.toString((Properties)this.props) + ") " + this.dest.toString();
        }
    }

    private static class DestEntrySerializer
    implements Serializer<DestEntry> {
        private DestEntrySerializer() {
        }

        @Override
        public byte[] getBytes(DestEntry de) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            try {
                try {
                    DataHelper.writeProperties((OutputStream)baos, (Properties)de.props, (boolean)true, (boolean)false);
                }
                catch (DataFormatException dfe) {
                    BlockfileNamingService.logError("DB Write Fail - properties too big?", dfe);
                    baos.write(new byte[2]);
                }
                de.dest.writeBytes((OutputStream)baos);
            }
            catch (IOException ioe) {
                BlockfileNamingService.logError("DB Write Fail", ioe);
            }
            catch (DataFormatException dfe) {
                BlockfileNamingService.logError("DB Write Fail", dfe);
            }
            return baos.toByteArray();
        }

        @Override
        public DestEntry construct(byte[] b) {
            DestEntry rv = new DestEntry();
            ByteArrayInputStream bais = new ByteArrayInputStream(b);
            try {
                rv.props = DataHelper.readProperties((InputStream)bais);
                rv.dest = Destination.create((InputStream)bais);
            }
            catch (IOException ioe) {
                BlockfileNamingService.logError("DB Read Fail", ioe);
                return null;
            }
            catch (DataFormatException dfe) {
                BlockfileNamingService.logError("DB Read Fail", dfe);
                return null;
            }
            return rv;
        }
    }

    private static class DestEntrySerializerV4
    implements Serializer<DestEntry> {
        private DestEntrySerializerV4() {
        }

        @Override
        public byte[] getBytes(DestEntry de) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            int sz = de.destList != null ? de.destList.size() : 1;
            try {
                baos.write((byte)sz);
                for (int i = 0; i < sz; ++i) {
                    Destination d;
                    Properties p;
                    if (i == 0) {
                        p = de.props;
                        d = de.dest;
                    } else {
                        p = de.propsList.get(i);
                        d = de.destList.get(i);
                    }
                    try {
                        BlockfileNamingService.writeProperties(baos, p);
                    }
                    catch (DataFormatException dfe) {
                        BlockfileNamingService.logError("DB Write Fail - properties too big?", dfe);
                        baos.write(new byte[2]);
                    }
                    d.writeBytes((OutputStream)baos);
                }
            }
            catch (IOException ioe) {
                BlockfileNamingService.logError("DB Write Fail", ioe);
            }
            catch (DataFormatException dfe) {
                BlockfileNamingService.logError("DB Write Fail", dfe);
            }
            return baos.toByteArray();
        }

        @Override
        public DestEntry construct(byte[] b) {
            DestEntry rv = new DestEntry();
            ByteArrayInputStream bais = new ByteArrayInputStream(b);
            try {
                int sz = bais.read() & 0xFF;
                if (sz <= 0) {
                    throw new DataFormatException("bad dest count " + sz);
                }
                rv.props = BlockfileNamingService.readProperties(bais);
                rv.dest = Destination.create((InputStream)bais);
                if (sz > 1) {
                    rv.propsList = new ArrayList<Properties>(sz);
                    rv.destList = new ArrayList<Destination>(sz);
                    rv.propsList.add(rv.props);
                    rv.destList.add(rv.dest);
                    for (int i = 1; i < sz; ++i) {
                        rv.propsList.add(BlockfileNamingService.readProperties(bais));
                        rv.destList.add(Destination.create((InputStream)bais));
                    }
                }
            }
            catch (IOException ioe) {
                BlockfileNamingService.logError("DB Read Fail", ioe);
                return null;
            }
            catch (DataFormatException dfe) {
                BlockfileNamingService.logError("DB Read Fail", dfe);
                return null;
            }
            return rv;
        }
    }

    private static class InvalidEntry {
        public final String key;
        public final String list;

        public InvalidEntry(String k, String l) {
            this.key = k;
            this.list = l;
        }
    }

    private static class PropertiesSerializer
    implements Serializer<Properties> {
        private PropertiesSerializer() {
        }

        @Override
        public byte[] getBytes(Properties p) {
            try {
                return DataHelper.toProperties((Properties)p);
            }
            catch (DataFormatException dfe) {
                BlockfileNamingService.logError("DB Write Fail - properties too big?", dfe);
                return new byte[2];
            }
        }

        @Override
        public Properties construct(byte[] b) {
            Properties rv = new Properties();
            try {
                DataHelper.fromProperties((byte[])b, (int)0, (Properties)rv);
            }
            catch (DataFormatException dfe) {
                BlockfileNamingService.logError("DB Read Fail", dfe);
                return null;
            }
            return rv;
        }
    }

    private class Shutdown
    implements Runnable {
        private Shutdown() {
        }

        @Override
        public void run() {
            BlockfileNamingService.this.close();
        }
    }
}

