/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.Messages;
import net.i2p.router.web.NewsHelper;
import net.i2p.servlet.util.ServletUtil;
import net.i2p.util.RandomSource;

public class CSSHelper
extends HelperBase {
    private static final Map<String, Boolean> _UACache = new ConcurrentHashMap<String, Boolean>();
    public static final String PROP_UNIVERSAL_THEMING = "routerconsole.universal.theme";
    public static final String PROP_THEME_NAME = "routerconsole.theme";
    public static final String PROP_THEME_PFX = "routerconsole.theme.";
    public static final String DEFAULT_THEME = "light";
    public static final String BASE_THEME_PATH = "/themes/console/";
    private static final String FORCE = "classic";
    public static final String PROP_REFRESH = "routerconsole.summaryRefresh";
    public static final String DEFAULT_REFRESH = "60";
    public static final int MIN_REFRESH = 3;
    public static final String PROP_DISABLE_REFRESH = "routerconsole.summaryDisableRefresh";
    private static final String PROP_XFRAME = "routerconsole.disableXFrame";
    public static final String PROP_FORCE_MOBILE_CONSOLE = "routerconsole.forceMobileConsole";
    public static final String PROP_EMBED_APPS = "routerconsole.embedApps";
    public static final String PROP_DISABLE_OLD = "routerconsole.disableOldThemes";
    public static final boolean DEFAULT_DISABLE_OLD = true;
    private static final String _consoleNonce = Long.toString(RandomSource.getInstance().nextLong());

    public static String getNonce() {
        return _consoleNonce;
    }

    public String getTheme(String userAgent) {
        String url = BASE_THEME_PATH;
        if (userAgent != null && userAgent.contains("MSIE") && !userAgent.contains("Trident/6") && !this._context.getProperty(PROP_DISABLE_OLD, true)) {
            url = url + "classic/";
        } else {
            if (this._context == null) {
                throw new IllegalStateException("No contexts. This is usually because the router is either starting up or shutting down.");
            }
            String theme = this._context.getProperty(PROP_THEME_NAME, DEFAULT_THEME);
            if (theme.equals("midnight")) {
                if (this._context.getProperty(PROP_DISABLE_OLD, true)) {
                    theme = "dark";
                }
            } else if (theme.equals(FORCE) && this._context.getProperty(PROP_DISABLE_OLD, true)) {
                theme = DEFAULT_THEME;
            }
            url = url + theme + "/";
        }
        return url;
    }

    public boolean embedApps() {
        return this._context.getBooleanProperty(PROP_EMBED_APPS);
    }

    public void setLang(String lang) {
        if (lang != null && lang.length() >= 2 && lang.length() <= 6 && lang.replaceAll("[a-zA-Z_]", "").length() == 0) {
            HashMap<String, String> m = new HashMap<String, String>(2);
            int under = lang.indexOf(95);
            if (under < 0) {
                m.put("routerconsole.lang", lang.toLowerCase(Locale.US));
                m.put("routerconsole.country", "");
                this._context.router().saveConfig(m, null);
            } else if (under > 0 && lang.length() > under + 1) {
                m.put("routerconsole.lang", lang.substring(0, under).toLowerCase(Locale.US));
                m.put("routerconsole.country", lang.substring(under + 1).toUpperCase(Locale.US));
                this._context.router().saveConfig(m, null);
            }
        }
    }

    public String getLang() {
        return Messages.getLanguage(this._context);
    }

    public void setNews(String val) {
        if (val != null) {
            NewsHelper.showNews(this._context, val.equals("1"));
        }
    }

    public boolean shouldSendXFrame() {
        return !this._context.getBooleanProperty(PROP_XFRAME);
    }

    public void setRefresh(String r) {
        try {
            if (Integer.parseInt(r) < 3) {
                r = Integer.toString(3);
            }
            this._context.router().saveConfig(PROP_REFRESH, r);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public String getRefresh() {
        String r = this._context.getProperty(PROP_REFRESH, DEFAULT_REFRESH);
        try {
            if (Integer.parseInt(r) < 3) {
                r = Integer.toString(3);
            }
        }
        catch (RuntimeException e) {
            r = Integer.toString(3);
        }
        return r;
    }

    public void setDisableRefresh(String r) {
        String disableRefresh = "false";
        if ("0".equals(r)) {
            disableRefresh = "true";
        }
        this._context.router().saveConfig(PROP_DISABLE_REFRESH, disableRefresh);
    }

    public boolean getDisableRefresh() {
        return this._context.getBooleanProperty(PROP_DISABLE_REFRESH);
    }

    public String title(String s) {
        StringBuilder buf = new StringBuilder(128);
        buf.append("<title>").append(this._t("I2P Router Console")).append(" - ").append(this._t(s)).append("</title>");
        return buf.toString();
    }

    public boolean allowIFrame(String ua) {
        boolean forceMobileConsole = this._context.getBooleanProperty(PROP_FORCE_MOBILE_CONSOLE);
        if (forceMobileConsole) {
            return false;
        }
        if (ua == null) {
            return true;
        }
        Boolean brv = _UACache.get(ua);
        if (brv != null) {
            return brv;
        }
        boolean rv = CSSHelper.shouldAllowIFrame(ua);
        _UACache.put(ua, rv);
        return rv;
    }

    private static boolean shouldAllowIFrame(String ua) {
        return !ServletUtil.isSmallBrowser((String)ua);
    }
}

