/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.ACKBitfield;
import net.i2p.router.transport.udp.InboundMessageState;
import net.i2p.router.transport.udp.OutboundMessageState;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.router.util.CachedIteratorCollection;
import net.i2p.router.util.PriBlockingQueue;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

public class PeerState {
    private final RouterContext _context;
    private final Log _log;
    private final Hash _remotePeer;
    private SessionKey _currentMACKey;
    private SessionKey _currentCipherKey;
    private SessionKey _nextMACKey;
    private SessionKey _nextCipherKey;
    private long _keyEstablishedTime;
    private long _clockSkew;
    private final Object _clockSkewLock = new Object();
    private long _currentReceiveSecond;
    private long _lastSendTime;
    private long _lastSendFullyTime;
    private long _lastPingTime;
    private long _lastReceiveTime;
    private int _consecutiveFailedSends;
    private final Set<Long> _currentACKs;
    private final Queue<ResendACK> _currentACKsResend;
    private volatile long _lastACKSend;
    private volatile long _wantACKSendSince;
    private boolean _currentSecondECNReceived;
    private int _sendWindowBytes;
    private int _sendWindowBytesRemaining;
    private long _lastSendRefill;
    private int _sendBps;
    private int _sendBytes;
    private int _receiveBps;
    private int _receiveBytes;
    private long _receivePeriodBegin;
    private volatile long _lastCongestionOccurred;
    private volatile int _slowStartThreshold;
    private final byte[] _remoteIP;
    private volatile InetAddress _remoteIPAddress;
    private volatile int _remotePort;
    private volatile RemoteHostId _remoteHostId;
    private long _weRelayToThemAs;
    private long _theyRelayToUsAs;
    private int _mtu;
    private int _mtuReceive;
    private int _largeMTU;
    private long _consecutiveSmall;
    private int _mtuIncreases;
    private int _mtuDecreases;
    private int _rtt;
    private int _rttDeviation;
    private int _rto;
    static final long RETRANSMISSION_PERIOD_WIDTH = 100L;
    private int _messagesReceived;
    private int _messagesSent;
    private int _packetsTransmitted;
    private int _packetsRetransmitted;
    private int _packetsReceivedDuplicate;
    private int _packetsReceived;
    private boolean _mayDisconnect;
    private final Map<Long, InboundMessageState> _inboundMessages;
    private final CachedIteratorCollection<OutboundMessageState> _outboundMessages;
    private final PriBlockingQueue<OutboundMessageState> _outboundQueue;
    private OutboundMessageState _retransmitter;
    private final UDPTransport _transport;
    private volatile boolean _dead;
    private static final int MIN_CONCURRENT_MSGS = 8;
    private static final int INIT_CONCURRENT_MSGS = 20;
    private int _concurrentMessagesAllowed = 20;
    private int _concurrentMessagesActive;
    private int _consecutiveRejections;
    private final boolean _isInbound;
    private long _lastIntroducerTime;
    private static final int DEFAULT_SEND_WINDOW_BYTES = 8192;
    private static final int MINIMUM_WINDOW_BYTES = 8192;
    private static final int MAX_SEND_WINDOW_BYTES = 0x100000;
    private static final int MAX_ALLOCATE_SEND = 2;
    private static final int MAX_SEND_MSGS_PENDING = 128;
    public static final int MIN_MTU = 620;
    public static final int MIN_IPV6_MTU = 1280;
    public static final int MAX_IPV6_MTU = 1488;
    private static final int DEFAULT_MTU = 620;
    public static final int LARGE_MTU = 1484;
    public static final int MAX_MTU = Math.max(1484, 1488);
    private static final int MIN_RTO = 1000;
    private static final int INIT_RTO = 1000;
    private static final int INIT_RTT = 0;
    private static final int MAX_RTO = 60000;
    private static final int CLOCK_SKEW_FUDGE = 100;
    private static final int MAX_RESEND_ACKS = 64;
    private static final int MAX_RESEND_ACKS_LARGE = 21;
    private static final int MAX_RESEND_ACKS_SMALL = 12;
    private static final long RESEND_ACK_TIMEOUT = 300000L;
    private static final float RTT_DAMPENING = 0.125f;
    private static final int MTU_RCV_DISPLAY_THRESHOLD = 20;
    private static final int OVERHEAD_SIZE = 60;
    private static final int IPV6_OVERHEAD_SIZE = 80;
    private static final boolean THROTTLE_RESENDS = true;
    private static final boolean THROTTLE_INITIAL_SEND = true;
    private static final int MIN_EXPLICIT_ACKS = 3;
    private static final int MIN_ACK_SIZE = 13;

    public PeerState(RouterContext ctx, UDPTransport transport, byte[] remoteIP, int remotePort, Hash remotePeer, boolean isInbound, int rtt) {
        long now;
        this._context = ctx;
        this._log = ctx.logManager().getLog(PeerState.class);
        this._transport = transport;
        this._keyEstablishedTime = now = ctx.clock().now();
        this._currentReceiveSecond = now - now % 1000L;
        this._lastSendTime = now;
        this._lastReceiveTime = now;
        this._currentACKs = new ConcurrentHashSet<Long>();
        this._currentACKsResend = new LinkedBlockingQueue<ResendACK>();
        this._sendWindowBytes = 8192;
        this._sendWindowBytesRemaining = 8192;
        this._slowStartThreshold = 524288;
        this._lastSendRefill = now;
        this._receivePeriodBegin = now;
        this._lastCongestionOccurred = -1L;
        this._remotePort = remotePort;
        if (remoteIP.length == 4) {
            this._mtu = 620;
            this._mtuReceive = 620;
            this._largeMTU = transport.getMTU(false);
        } else {
            this._mtu = 1280;
            this._mtuReceive = 1280;
            this._largeMTU = transport.getMTU(true);
        }
        this._lastACKSend = -1L;
        this._rto = 1000;
        this._rtt = 0;
        if (rtt > 0) {
            this.recalculateTimeouts(rtt);
        } else {
            this._rttDeviation = this._rtt;
        }
        this._inboundMessages = new HashMap<Long, InboundMessageState>(8);
        this._outboundMessages = new CachedIteratorCollection();
        this._outboundQueue = new PriBlockingQueue(ctx, "UDP-PeerState", 32);
        this._remoteIP = remoteIP;
        this._remotePeer = remotePeer;
        this._isInbound = isInbound;
        this._remoteHostId = new RemoteHostId(remoteIP, remotePort);
    }

    public void changePort(int newPort) {
        if (newPort != this._remotePort) {
            this._remoteHostId = new RemoteHostId(this._remoteIP, newPort);
            this._remotePort = newPort;
        }
    }

    public Hash getRemotePeer() {
        return this._remotePeer;
    }

    public SessionKey getCurrentMACKey() {
        return this._currentMACKey;
    }

    public SessionKey getCurrentCipherKey() {
        return this._currentCipherKey;
    }

    public SessionKey getNextMACKey() {
        return this._nextMACKey;
    }

    public SessionKey getNextCipherKey() {
        return this._nextCipherKey;
    }

    public long getKeyEstablishedTime() {
        return this._keyEstablishedTime;
    }

    public long getClockSkew() {
        return this._clockSkew;
    }

    public long getCurrentReceiveSecond() {
        return this._currentReceiveSecond;
    }

    public long getLastSendTime() {
        return this._lastSendTime;
    }

    public long getLastSendFullyTime() {
        return this._lastSendFullyTime;
    }

    public long getLastReceiveTime() {
        return this._lastReceiveTime;
    }

    public int getConsecutiveFailedSends() {
        return this._consecutiveFailedSends;
    }

    @Deprecated
    public boolean getCurrentSecondECNReceived() {
        return this._currentSecondECNReceived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSendWindowBytes() {
        CachedIteratorCollection<OutboundMessageState> cachedIteratorCollection = this._outboundMessages;
        synchronized (cachedIteratorCollection) {
            return this._sendWindowBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSendWindowBytesRemaining() {
        CachedIteratorCollection<OutboundMessageState> cachedIteratorCollection = this._outboundMessages;
        synchronized (cachedIteratorCollection) {
            return this._sendWindowBytesRemaining;
        }
    }

    public byte[] getRemoteIP() {
        return this._remoteIP;
    }

    public InetAddress getRemoteIPAddress() {
        block3: {
            if (this._remoteIPAddress == null) {
                try {
                    this._remoteIPAddress = InetAddress.getByAddress(this._remoteIP);
                }
                catch (UnknownHostException uhe) {
                    if (!this._log.shouldLog(40)) break block3;
                    this._log.error("Invalid IP? ", uhe);
                }
            }
        }
        return this._remoteIPAddress;
    }

    public int getRemotePort() {
        return this._remotePort;
    }

    public long getWeRelayToThemAs() {
        return this._weRelayToThemAs;
    }

    public long getTheyRelayToUsAs() {
        return this._theyRelayToUsAs;
    }

    public int getMTU() {
        return this._mtu;
    }

    public int getReceiveMTU() {
        return this._mtuReceive;
    }

    public void setCurrentMACKey(SessionKey key) {
        this._currentMACKey = key;
    }

    public void setCurrentCipherKey(SessionKey key) {
        this._currentCipherKey = key;
    }

    @Deprecated
    public void setNextMACKey(SessionKey key) {
        this._nextMACKey = key;
    }

    @Deprecated
    public void setNextCipherKey(SessionKey key) {
        this._nextCipherKey = key;
    }

    @Deprecated
    public void setKeyEstablishedTime(long when) {
        this._keyEstablishedTime = when;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustClockSkew(long skew) {
        long actualSkew = skew + 100L - (long)(this._rtt / 2);
        if (this._packetsReceived <= 1) {
            Object object = this._clockSkewLock;
            synchronized (object) {
                this._clockSkew = actualSkew;
            }
            return;
        }
        double adj = 0.1 * (double)actualSkew;
        Object object = this._clockSkewLock;
        synchronized (object) {
            this._clockSkew = (long)(0.9 * (double)this._clockSkew + adj);
        }
    }

    public void setCurrentReceiveSecond(long sec) {
        this._currentReceiveSecond = sec;
    }

    public void setLastSendTime(long when) {
        this._lastSendTime = when;
    }

    public void setLastReceiveTime(long when) {
        this._lastReceiveTime = when;
    }

    public void setLastPingTime(long when) {
        this._lastPingTime = when;
    }

    public long getLastSendOrPingTime() {
        return Math.max(Math.max(this._lastSendTime, this._lastACKSend), this._lastPingTime);
    }

    public int getSendBps() {
        return this._sendBps;
    }

    public synchronized int getReceiveBps() {
        return this._receiveBps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int incrementConsecutiveFailedSends() {
        CachedIteratorCollection<OutboundMessageState> cachedIteratorCollection = this._outboundMessages;
        synchronized (cachedIteratorCollection) {
            --this._concurrentMessagesActive;
            if (this._concurrentMessagesActive < 0) {
                this._concurrentMessagesActive = 0;
            }
            ++this._consecutiveFailedSends;
            return this._consecutiveFailedSends;
        }
    }

    public long getInactivityTime() {
        long now = this._context.clock().now();
        long lastActivity = Math.max(this._lastReceiveTime, this._lastSendFullyTime);
        return now - lastActivity;
    }

    private boolean allocateSendingBytes(int size, int messagePushCount) {
        return this.allocateSendingBytes(size, false, messagePushCount);
    }

    private boolean allocateSendingBytes(int size, boolean isForACK, int messagePushCount) {
        long now = this._context.clock().now();
        long duration = now - this._lastSendRefill;
        if (duration >= 1000L) {
            this._sendWindowBytesRemaining = this._sendWindowBytes;
            this._sendBytes += size;
            this._sendBps = (int)(0.9f * (float)this._sendBps + 0.1f * ((float)this._sendBytes * (1000.0f / (float)duration)));
            this._sendBytes = 0;
            this._lastSendRefill = now;
        }
        if (size <= this._sendWindowBytesRemaining || size > this._sendWindowBytes && this._sendWindowBytesRemaining >= this._sendWindowBytes) {
            if (messagePushCount == 0 && this._concurrentMessagesActive > this._concurrentMessagesAllowed) {
                ++this._consecutiveRejections;
                this._context.statManager().addRateData("udp.rejectConcurrentActive", this._concurrentMessagesActive, this._consecutiveRejections);
                return false;
            }
            if (messagePushCount == 0) {
                this._context.statManager().addRateData("udp.allowConcurrentActive", this._concurrentMessagesActive, this._concurrentMessagesAllowed);
                ++this._concurrentMessagesActive;
                if (this._consecutiveRejections > 0) {
                    this._context.statManager().addRateData("udp.rejectConcurrentSequence", this._consecutiveRejections, this._concurrentMessagesActive);
                }
                this._consecutiveRejections = 0;
            }
            this._sendWindowBytesRemaining -= size;
            if (this._sendWindowBytesRemaining < 0) {
                this._sendWindowBytesRemaining = 0;
            }
            this._sendBytes += size;
            this._lastSendTime = now;
            return true;
        }
        return false;
    }

    public void setWeRelayToThemAs(long tag) {
        this._weRelayToThemAs = tag;
    }

    public void setTheyRelayToUsAs(long tag) {
        this._theyRelayToUsAs = tag;
    }

    public int getSlowStartThreshold() {
        return this._slowStartThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConcurrentSends() {
        CachedIteratorCollection<OutboundMessageState> cachedIteratorCollection = this._outboundMessages;
        synchronized (cachedIteratorCollection) {
            return this._concurrentMessagesActive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConcurrentSendWindow() {
        CachedIteratorCollection<OutboundMessageState> cachedIteratorCollection = this._outboundMessages;
        synchronized (cachedIteratorCollection) {
            return this._concurrentMessagesAllowed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConsecutiveSendRejections() {
        CachedIteratorCollection<OutboundMessageState> cachedIteratorCollection = this._outboundMessages;
        synchronized (cachedIteratorCollection) {
            return this._consecutiveRejections;
        }
    }

    public boolean isInbound() {
        return this._isInbound;
    }

    public boolean isIPv6() {
        return this._remoteIP.length == 16;
    }

    public long getIntroducerTime() {
        return this._lastIntroducerTime;
    }

    public void setIntroducerTime() {
        this._lastIntroducerTime = this._context.clock().now();
    }

    public void messageFullyReceived(Long messageId, int bytes) {
        this.messageFullyReceived(messageId, bytes, false);
    }

    private synchronized void messageFullyReceived(Long messageId, int bytes, boolean isForACK) {
        if (bytes > 0) {
            this._receiveBytes += bytes;
            ++this._messagesReceived;
        } else {
            ++this._packetsReceivedDuplicate;
        }
        long now = this._context.clock().now();
        long duration = now - this._receivePeriodBegin;
        if (duration >= 1000L) {
            this._receiveBps = (int)(0.9f * (float)this._receiveBps + 0.1f * ((float)this._receiveBytes * (1000.0f / (float)duration)));
            this._receiveBytes = 0;
            this._receivePeriodBegin = now;
            this._context.statManager().addRateData("udp.receiveBps", this._receiveBps);
        }
        if (this._wantACKSendSince <= 0L) {
            this._wantACKSendSince = now;
        }
        this._currentACKs.add(messageId);
    }

    public void messagePartiallyReceived() {
        if (this._wantACKSendSince <= 0L) {
            this._wantACKSendSince = this._context.clock().now();
        }
    }

    public Map<Long, InboundMessageState> getInboundMessages() {
        return this._inboundMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int expireInboundMessages() {
        int rv = 0;
        Map<Long, InboundMessageState> map = this._inboundMessages;
        synchronized (map) {
            Iterator<InboundMessageState> iter = this._inboundMessages.values().iterator();
            while (iter.hasNext()) {
                InboundMessageState state = iter.next();
                if (state.isExpired() || this._dead) {
                    iter.remove();
                    continue;
                }
                if (state.isComplete()) {
                    this._log.error("inbound message is complete, but wasn't handled inline? " + state + " with " + this);
                    iter.remove();
                    continue;
                }
                ++rv;
            }
        }
        return rv;
    }

    private boolean congestionOccurred() {
        long now = this._context.clock().now();
        if (this._lastCongestionOccurred + (long)this._rto > now) {
            return false;
        }
        this._lastCongestionOccurred = now;
        int congestionAt = this._sendWindowBytes;
        this._sendWindowBytes /= 2;
        if (this._sendWindowBytes < 8192) {
            this._sendWindowBytes = 8192;
        }
        this._slowStartThreshold = congestionAt / 2;
        return true;
    }

    public List<Long> getCurrentFullACKs() {
        ArrayList<Long> rv = new ArrayList<Long>(this._currentACKs);
        return rv;
    }

    public List<Long> getCurrentResendACKs() {
        int sz = this._currentACKsResend.size();
        ArrayList<Long> randomResends = new ArrayList<Long>(sz);
        if (sz > 0) {
            long cutoff = this._context.clock().now() - 300000L;
            int i = 0;
            Iterator iter = this._currentACKsResend.iterator();
            while (iter.hasNext()) {
                ResendACK rack = (ResendACK)iter.next();
                if (rack.time > cutoff && i++ < 64) {
                    randomResends.add(rack.id);
                    continue;
                }
                iter.remove();
                if (!this._log.shouldLog(20)) continue;
                this._log.info("Expired ack " + rack.id + " sent " + (cutoff + 300000L - rack.time) + " ago, now " + i + " resend acks");
            }
            if (i > 1) {
                Collections.shuffle(randomResends, this._context.random());
            }
        }
        return randomResends;
    }

    public void removeACKMessage(Long messageId) {
        boolean removed = this._currentACKs.remove(messageId);
        if (removed) {
            this._currentACKsResend.offer(new ResendACK(messageId, this._context.clock().now()));
            if (this._log.shouldLog(20)) {
                this._log.info("Sent ack " + messageId + " now " + this._currentACKs.size() + " current and " + this._currentACKsResend.size() + " resend acks");
            }
        }
        this._lastACKSend = this._context.clock().now();
    }

    @Deprecated
    public List<ACKBitfield> retrieveACKBitfields() {
        return this.retrieveACKBitfields(true);
    }

    public List<ACKBitfield> retrieveACKBitfields(boolean alwaysIncludeRetransmissions) {
        int bytesRemaining;
        int resendSize = this._currentACKsResend.size();
        int maxResendAcks = bytesRemaining < 620 ? 12 : 21;
        ArrayList<ACKBitfield> rv = new ArrayList<ACKBitfield>(maxResendAcks);
        ArrayList<Long> currentACKsRemoved = new ArrayList<Long>(this._currentACKs.size());
        Iterator<Long> iter = this._currentACKs.iterator();
        for (bytesRemaining = this.countMaxACKData(); bytesRemaining >= 4 && iter.hasNext(); bytesRemaining -= 4) {
            Long val = iter.next();
            iter.remove();
            long id = val;
            rv.add(new FullACKBitfield(id));
            currentACKsRemoved.add(val);
        }
        if (this._currentACKs.isEmpty()) {
            this._wantACKSendSince = -1L;
        }
        if (alwaysIncludeRetransmissions || !rv.isEmpty()) {
            List<Long> randomResends = this.getCurrentResendACKs();
            int oldIndex = Math.min(resendSize, maxResendAcks);
            iter = randomResends.iterator();
            while (bytesRemaining >= 4 && oldIndex-- > 0 && iter.hasNext()) {
                Long cur = iter.next();
                long c = cur;
                FullACKBitfield bf = new FullACKBitfield(c);
                rv.add(bf);
                bytesRemaining -= 4;
            }
            if (!currentACKsRemoved.isEmpty()) {
                long now = this._context.clock().now();
                for (Long val : currentACKsRemoved) {
                    this._currentACKsResend.offer(new ResendACK(val, now));
                }
            }
        }
        int partialIncluded = 0;
        if (bytesRemaining > 4) {
            ArrayList<ACKBitfield> partial = new ArrayList<ACKBitfield>();
            this.fetchPartialACKs(partial);
            for (int i = 0; bytesRemaining > 4 && i < partial.size(); ++i) {
                ACKBitfield bitfield = (ACKBitfield)partial.get(i);
                int bytes = bitfield.fragmentCount() / 7 + 1;
                if (bytesRemaining <= bytes + 4) continue;
                rv.add(bitfield);
                bytesRemaining -= bytes + 4;
                ++partialIncluded;
            }
        }
        if (!rv.isEmpty()) {
            this._lastACKSend = this._context.clock().now();
        }
        if (partialIncluded > 0) {
            this._context.statManager().addRateData("udp.sendACKPartial", partialIncluded, rv.size() - partialIncluded);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fetchPartialACKs(List<ACKBitfield> rv) {
        ArrayList<InboundMessageState> states = null;
        boolean curState = false;
        Map<Long, InboundMessageState> map = this._inboundMessages;
        synchronized (map) {
            int numMessages = this._inboundMessages.size();
            if (numMessages <= 0) {
                return;
            }
            Iterator<InboundMessageState> iter = this._inboundMessages.values().iterator();
            while (iter.hasNext()) {
                InboundMessageState state = iter.next();
                if (state.isExpired()) {
                    iter.remove();
                    continue;
                }
                if (state.isComplete()) continue;
                if (states == null) {
                    states = new ArrayList<InboundMessageState>(numMessages);
                }
                states.add(state);
            }
        }
        if (states != null) {
            for (InboundMessageState ims : states) {
                ACKBitfield abf = ims.createACKBitfield();
                if (abf.receivedComplete()) continue;
                rv.add(abf);
            }
        }
    }

    private void locked_messageACKed(int bytesACKed, long lifetime, int numSends) {
        --this._concurrentMessagesActive;
        if (this._concurrentMessagesActive < 0) {
            this._concurrentMessagesActive = 0;
        }
        this._consecutiveFailedSends = 0;
        if (numSends < 2) {
            if (this._context.random().nextInt(this._concurrentMessagesAllowed) <= 0) {
                ++this._concurrentMessagesAllowed;
            }
            if (this._sendWindowBytes <= this._slowStartThreshold) {
                this._sendWindowBytes += bytesACKed;
            } else {
                float prob = (float)bytesACKed / (float)(this._sendWindowBytes << 1);
                float v = this._context.random().nextFloat();
                if (v < 0.0f) {
                    v = 0.0f - v;
                }
                if (v <= prob) {
                    this._sendWindowBytes += bytesACKed;
                }
            }
        } else {
            int allow = this._concurrentMessagesAllowed - 1;
            if (allow < 8) {
                allow = 8;
            }
            this._concurrentMessagesAllowed = allow;
        }
        if (this._sendWindowBytes > 0x100000) {
            this._sendWindowBytes = 0x100000;
        }
        this._lastSendFullyTime = this._lastReceiveTime = this._context.clock().now();
        this._sendWindowBytesRemaining = this._sendWindowBytesRemaining + bytesACKed <= this._sendWindowBytes ? (this._sendWindowBytesRemaining += bytesACKed) : this._sendWindowBytes;
        if (numSends < 2) {
            this.recalculateTimeouts(lifetime);
            this.adjustMTU();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void messageACKed(int bytesACKed, long lifetime, int numSends) {
        PeerState peerState = this;
        synchronized (peerState) {
            this.locked_messageACKed(bytesACKed, lifetime, numSends);
        }
        if (numSends >= 2 && this._log.shouldLog(20)) {
            this._log.info("acked after numSends=" + numSends + " w/ lifetime=" + lifetime + " and size=" + bytesACKed);
        }
        this._context.statManager().addRateData("udp.sendBps", this._sendBps);
    }

    private void recalculateTimeouts(long lifetime) {
        if (this._rtt <= 0) {
            this._rtt = (int)lifetime;
            this._rttDeviation = this._rtt / 2;
        } else {
            this._rttDeviation = (int)(0.75 * (double)this._rttDeviation + 0.25 * (double)Math.abs(lifetime - (long)this._rtt));
            this._rtt = (int)((float)this._rtt * 0.875f + 0.125f * (float)lifetime);
        }
        this._rto = Math.min(60000, Math.max(this.minRTO(), this._rtt + (this._rttDeviation << 2)));
    }

    private void adjustMTU() {
        double retransPct = 0.0;
        if (this._packetsTransmitted > 10) {
            boolean wantLarge;
            retransPct = (double)this._packetsRetransmitted / (double)this._packetsTransmitted;
            boolean bl = wantLarge = retransPct < 0.3;
            if (wantLarge && this._mtu != this._largeMTU) {
                if (this._context.random().nextLong(this._mtuDecreases) <= 0L) {
                    this._mtu = this._largeMTU;
                    ++this._mtuIncreases;
                    this._context.statManager().addRateData("udp.mtuIncrease", this._mtuIncreases);
                }
            } else if (!wantLarge && this._mtu == this._largeMTU) {
                this._mtu = this._remoteIP.length == 4 ? 620 : 1280;
                ++this._mtuDecreases;
                this._context.statManager().addRateData("udp.mtuDecrease", this._mtuDecreases);
            }
        } else {
            this._mtu = this._remoteIP.length == 4 ? 620 : 1280;
        }
    }

    public synchronized void setHisMTU(int mtu) {
        if (mtu <= 620 || mtu >= this._largeMTU || this._remoteIP.length == 16 && mtu <= 1280) {
            return;
        }
        this._largeMTU = mtu;
        if (mtu < this._mtu) {
            this._mtu = mtu;
        }
    }

    public synchronized void messageRetransmitted(int packets) {
        this._context.statManager().addRateData("udp.congestionOccurred", this._sendWindowBytes);
        this._context.statManager().addRateData("udp.congestedRTO", this._rto, this._rttDeviation);
        this._packetsRetransmitted += packets;
        this.congestionOccurred();
        this.adjustMTU();
    }

    public synchronized void packetsTransmitted(int packets) {
        this._packetsTransmitted += packets;
    }

    public synchronized int getRTT() {
        return this._rtt;
    }

    public synchronized int getRTO() {
        return this._rto;
    }

    public synchronized int getRTTDeviation() {
        return this._rttDeviation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessagesSent() {
        CachedIteratorCollection<OutboundMessageState> cachedIteratorCollection = this._outboundMessages;
        synchronized (cachedIteratorCollection) {
            return this._messagesSent;
        }
    }

    public synchronized int getMessagesReceived() {
        return this._messagesReceived;
    }

    public synchronized int getPacketsTransmitted() {
        return this._packetsTransmitted;
    }

    public synchronized int getPacketsRetransmitted() {
        return this._packetsRetransmitted;
    }

    public synchronized int getPacketsReceived() {
        return this._packetsReceived;
    }

    public synchronized int getPacketsReceivedDuplicate() {
        return this._packetsReceivedDuplicate;
    }

    public synchronized void packetReceived(int size) {
        int minMTU;
        ++this._packetsReceived;
        if (this._remoteIP.length == 4) {
            size += 60;
            minMTU = 620;
        } else {
            size += 80;
            minMTU = 1280;
        }
        if (size <= minMTU) {
            ++this._consecutiveSmall;
            if (this._consecutiveSmall >= 20L) {
                this._mtuReceive = minMTU;
            }
        } else {
            this._consecutiveSmall = 0L;
            if (size > this._mtuReceive) {
                this._mtuReceive = size;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ECNReceived() {
        PeerState peerState = this;
        synchronized (peerState) {
            this.congestionOccurred();
        }
        this._context.statManager().addRateData("udp.congestionOccurred", this._sendWindowBytes);
        this._currentSecondECNReceived = true;
        this._lastReceiveTime = this._context.clock().now();
    }

    public void dataReceived() {
        this._lastReceiveTime = this._context.clock().now();
    }

    public long getLastACKSend() {
        return this._lastACKSend;
    }

    @Deprecated
    public void setLastACKSend(long when) {
        this._lastACKSend = when;
    }

    public long getWantedACKSendSince() {
        return this._wantACKSendSince;
    }

    public boolean unsentACKThresholdReached() {
        return this._currentACKs.size() >= 32;
    }

    private int countMaxACKData() {
        return Math.min(1020, this._mtu - (this._remoteIP.length == 4 ? 20 : 40) - 8 - 16 - 16 - 1 - 4 - 1 - 1 - 16);
    }

    private int minRTO() {
        return 1000;
    }

    RemoteHostId getRemoteHostId() {
        return this._remoteHostId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(OutboundMessageState state) {
        boolean fail;
        if (this._dead) {
            this._transport.failed(state, false);
            return;
        }
        if (state.getPeer() != this) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Not for me!", new Exception("I did it"));
            }
            this._transport.failed(state, false);
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Adding to " + this._remotePeer + ": " + state.getMessageId());
        }
        boolean rv = false;
        PriBlockingQueue<OutboundMessageState> priBlockingQueue = this._outboundQueue;
        synchronized (priBlockingQueue) {
            fail = !this._outboundQueue.offer(state);
        }
        if (fail) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Dropping msg, OB queue full for " + this.toString());
            }
            this._transport.failed(state, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropOutbound() {
        ArrayList<OutboundMessageState> tempList;
        this._dead = true;
        Object object = this._outboundMessages;
        synchronized (object) {
            this._retransmitter = null;
            tempList = new ArrayList<OutboundMessageState>(this._outboundMessages);
            this._outboundMessages.clear();
        }
        object = this._outboundQueue;
        synchronized (object) {
            this._outboundQueue.drainTo(tempList);
        }
        for (OutboundMessageState oms : tempList) {
            this._transport.failed(oms, false);
        }
        this._wantACKSendSince = -1L;
    }

    public int getOutboundMessageCount() {
        if (this._dead) {
            return 0;
        }
        return this._outboundMessages.size() + this._outboundQueue.size();
    }

    public void setMayDisconnect() {
        this._mayDisconnect = true;
    }

    public boolean getMayDisconnect() {
        return this._mayDisconnect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int finishMessages(long now) {
        OutNetMessage msg;
        OutboundMessageState state;
        int i;
        if (this._outboundMessages.isEmpty()) {
            return this._outboundQueue.size();
        }
        if (this._dead) {
            this.dropOutbound();
            return 0;
        }
        int rv = 0;
        ArrayList<OutboundMessageState> succeeded = null;
        ArrayList<OutboundMessageState> failed = null;
        CachedIteratorCollection<OutboundMessageState> cachedIteratorCollection = this._outboundMessages;
        synchronized (cachedIteratorCollection) {
            Iterator<OutboundMessageState> iter = this._outboundMessages.iterator();
            while (iter.hasNext()) {
                OutboundMessageState state2 = iter.next();
                if (state2.isComplete()) {
                    iter.remove();
                    if (this._retransmitter == state2) {
                        this._retransmitter = null;
                    }
                    if (succeeded == null) {
                        succeeded = new ArrayList<OutboundMessageState>(4);
                    }
                    succeeded.add(state2);
                    continue;
                }
                if (state2.isExpired(now)) {
                    iter.remove();
                    if (this._retransmitter == state2) {
                        this._retransmitter = null;
                    }
                    this._context.statManager().addRateData("udp.sendFailed", state2.getPushCount());
                    if (failed == null) {
                        failed = new ArrayList<OutboundMessageState>(4);
                    }
                    failed.add(state2);
                    continue;
                }
                if (state2.getPushCount() <= 10) continue;
                iter.remove();
                if (state2 == this._retransmitter) {
                    this._retransmitter = null;
                }
                this._context.statManager().addRateData("udp.sendAggressiveFailed", state2.getPushCount());
                if (failed == null) {
                    failed = new ArrayList(4);
                }
                failed.add(state2);
            }
            rv = this._outboundMessages.size();
        }
        for (i = 0; succeeded != null && i < succeeded.size(); ++i) {
            state = (OutboundMessageState)succeeded.get(i);
            this._transport.succeeded(state);
            msg = state.getMessage();
            if (msg == null) continue;
            msg.timestamp("sending complete");
        }
        for (i = 0; failed != null && i < failed.size(); ++i) {
            state = (OutboundMessageState)failed.get(i);
            msg = state.getMessage();
            if (msg != null) {
                msg.timestamp("expired in the active pool");
                this._transport.failed(state);
                continue;
            }
            if (!this._log.shouldLog(30)) continue;
            this._log.warn("Unable to send a direct message: " + state);
        }
        return rv + this._outboundQueue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OutboundMessageState> allocateSend() {
        if (this._dead) {
            return null;
        }
        ArrayList<OutboundMessageState> rv = null;
        CachedIteratorCollection<OutboundMessageState> cachedIteratorCollection = this._outboundMessages;
        synchronized (cachedIteratorCollection) {
            for (OutboundMessageState state : this._outboundMessages) {
                ShouldSend should = this.locked_shouldSend(state);
                if (should == ShouldSend.YES) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Allocate sending (OLD) to " + this._remotePeer + ": " + state.getMessageId());
                    }
                    if (rv == null) {
                        rv = new ArrayList<OutboundMessageState>(2);
                    }
                    rv.add(state);
                    if (rv.size() < 2) continue;
                    return rv;
                }
                if (should != ShouldSend.NO_BW) continue;
                if (rv == null && this._log.shouldLog(10)) {
                    this._log.debug("Nothing to send (BW) to " + this._remotePeer + ", with " + this._outboundMessages.size() + " / " + this._outboundQueue.size() + " remaining");
                }
                return rv;
            }
            PriBlockingQueue<OutboundMessageState> priBlockingQueue = this._outboundQueue;
            synchronized (priBlockingQueue) {
                OutboundMessageState state;
                while ((state = (OutboundMessageState)this._outboundQueue.peek()) != null && ShouldSend.YES == this.locked_shouldSend(state)) {
                    OutboundMessageState dequeuedState = (OutboundMessageState)this._outboundQueue.poll();
                    if (dequeuedState == null) continue;
                    this._outboundMessages.add(dequeuedState);
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Allocate sending (NEW) to " + this._remotePeer + ": " + dequeuedState.getMessageId());
                    }
                    if (rv == null) {
                        rv = new ArrayList(2);
                    }
                    rv.add(dequeuedState);
                    if (rv.size() < 2) continue;
                    return rv;
                }
            }
        }
        if (rv == null && this._log.shouldLog(10)) {
            this._log.debug("Nothing to send to " + this._remotePeer + ", with " + this._outboundMessages.size() + " / " + this._outboundQueue.size() + " remaining");
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextDelay() {
        int rv = Integer.MAX_VALUE;
        if (this._dead) {
            return rv;
        }
        long now = this._context.clock().now();
        CachedIteratorCollection<OutboundMessageState> cachedIteratorCollection = this._outboundMessages;
        synchronized (cachedIteratorCollection) {
            if (this._retransmitter != null) {
                rv = (int)(this._retransmitter.getNextSendTime() - now);
                return rv;
            }
            for (OutboundMessageState state : this._outboundMessages) {
                int delay = (int)(state.getNextSendTime() - now);
                if (delay <= 0) {
                    return delay;
                }
                if (delay >= rv) continue;
                rv = delay;
            }
        }
        if (rv > 100 && !this._outboundQueue.isEmpty()) {
            rv = 100;
        }
        return rv;
    }

    public boolean isBacklogged() {
        return this._dead || this._outboundQueue.isBacklogged();
    }

    public int fragmentSize() {
        return this._mtu - (this._remoteIP.length == 4 ? 74 : 94) - 13;
    }

    private ShouldSend locked_shouldSend(OutboundMessageState state) {
        long now = this._context.clock().now();
        if (state.getNextSendTime() <= now) {
            OutboundMessageState retrans = this._retransmitter;
            if (retrans != null && (retrans.isExpired(now) || retrans.isComplete())) {
                this._retransmitter = null;
                retrans = null;
            }
            if (retrans != null && retrans != state) {
                this._context.statManager().addRateData("udp.blockedRetransmissions", this._packetsRetransmitted);
                int max = state.getMaxSends();
                if (max <= 0) {
                    // empty if block
                }
                if (max > 0) {
                    // empty if block
                }
                return ShouldSend.NO;
            }
            int size = state.getUnackedSize();
            if (this.allocateSendingBytes(size, state.getPushCount())) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Allocation of " + size + " allowed with " + this.getSendWindowBytesRemaining() + "/" + this.getSendWindowBytes() + " remaining for message " + state.getMessageId() + ": " + state);
                }
                int rto = this.getRTO();
                if (state.getPushCount() > 0) {
                    this._retransmitter = state;
                    rto = Math.min(60000, rto << state.getPushCount());
                }
                if (state.push()) {
                    ++this._messagesSent;
                }
                state.setNextSendTime(now + (long)rto);
                return ShouldSend.YES;
            }
            this._context.statManager().addRateData("udp.sendRejected", state.getPushCount());
            if (this._log.shouldLog(20)) {
                this._log.info("Allocation of " + size + " rejected w/ wsize=" + this.getSendWindowBytes() + " available=" + this.getSendWindowBytesRemaining() + " for message " + state.getMessageId() + ": " + state);
            }
            state.setNextSendTime(now + 75L + (long)this._context.random().nextInt(150));
            if (this._log.shouldLog(20)) {
                this._log.info("Retransmit after choke for next send time in " + (state.getNextSendTime() - now) + "ms");
            }
            return ShouldSend.NO_BW;
        }
        return ShouldSend.NO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acked(long messageId) {
        if (this._dead) {
            return false;
        }
        OutboundMessageState state = null;
        CachedIteratorCollection<OutboundMessageState> cachedIteratorCollection = this._outboundMessages;
        synchronized (cachedIteratorCollection) {
            Iterator<OutboundMessageState> iter = this._outboundMessages.iterator();
            while (iter.hasNext()) {
                state = iter.next();
                if (state.getMessageId() == messageId) {
                    iter.remove();
                    break;
                }
                if (state.getPushCount() <= 0) {
                    state = null;
                    break;
                }
                state = null;
            }
            if (state != null && state == this._retransmitter) {
                this._retransmitter = null;
            }
        }
        if (state != null) {
            int numSends = state.getMaxSends();
            if (this._log.shouldLog(20)) {
                this._log.info("Received ack of " + messageId + " by " + this._remotePeer + " after " + state.getLifetime() + " and " + numSends + " sends");
            }
            this._context.statManager().addRateData("udp.sendConfirmTime", state.getLifetime());
            if (state.getFragmentCount() > 1) {
                this._context.statManager().addRateData("udp.sendConfirmFragments", state.getFragmentCount());
            }
            this._context.statManager().addRateData("udp.sendConfirmVolley", numSends);
            this._transport.succeeded(state);
            this.messageACKed(state.getMessageSize(), state.getLifetime(), numSends);
        }
        return state != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acked(ACKBitfield bitfield) {
        if (this._dead) {
            return false;
        }
        long messageId = bitfield.getMessageId();
        if (bitfield.receivedComplete()) {
            return this.acked(messageId);
        }
        OutboundMessageState state = null;
        boolean isComplete = false;
        CachedIteratorCollection<OutboundMessageState> cachedIteratorCollection = this._outboundMessages;
        synchronized (cachedIteratorCollection) {
            Iterator<OutboundMessageState> iter = this._outboundMessages.iterator();
            while (iter.hasNext()) {
                state = iter.next();
                if (state.getMessageId() == messageId) {
                    boolean complete = state.acked(bitfield);
                    if (!complete) break;
                    isComplete = true;
                    iter.remove();
                    if (state != this._retransmitter) break;
                    this._retransmitter = null;
                    break;
                }
                if (state.getPushCount() <= 0) {
                    state = null;
                    break;
                }
                state = null;
            }
        }
        if (state != null) {
            int numSends = state.getMaxSends();
            int numACKed = bitfield.ackCount();
            this._context.statManager().addRateData("udp.partialACKReceived", numACKed);
            if (this._log.shouldLog(20)) {
                this._log.info("Received partial ack of " + state.getMessageId() + " by " + this._remotePeer + " after " + state.getLifetime() + " and " + numSends + " sends: " + bitfield + ": completely removed? " + isComplete + ": " + state);
            }
            if (isComplete) {
                this._context.statManager().addRateData("udp.sendConfirmTime", state.getLifetime());
                if (state.getFragmentCount() > 1) {
                    this._context.statManager().addRateData("udp.sendConfirmFragments", state.getFragmentCount());
                }
                this._context.statManager().addRateData("udp.sendConfirmVolley", numSends);
                this._transport.succeeded(state);
                this.messageACKed(state.getMessageSize(), state.getLifetime(), numSends);
            }
            return isComplete;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Received an ACK for a message not pending: " + bitfield);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFrom(PeerState oldPeer) {
        this._rto = oldPeer._rto;
        this._rtt = oldPeer._rtt;
        this._rttDeviation = oldPeer._rttDeviation;
        this._slowStartThreshold = oldPeer._slowStartThreshold;
        this._sendWindowBytes = oldPeer._sendWindowBytes;
        oldPeer._dead = true;
        ArrayList<Long> tmp = new ArrayList<Long>();
        for (Long l : oldPeer._currentACKs) {
            tmp.add(l);
        }
        oldPeer._currentACKs.clear();
        if (!this._dead) {
            this._currentACKs.addAll(tmp);
        }
        ArrayList<ResendACK> tmp3 = new ArrayList<ResendACK>();
        tmp3.addAll(oldPeer._currentACKsResend);
        oldPeer._currentACKsResend.clear();
        if (!this._dead) {
            this._currentACKsResend.addAll(tmp3);
        }
        HashMap<Long, InboundMessageState> msgs = new HashMap<Long, InboundMessageState>();
        Map<Long, InboundMessageState> map = oldPeer._inboundMessages;
        synchronized (map) {
            msgs.putAll(oldPeer._inboundMessages);
            oldPeer._inboundMessages.clear();
        }
        if (!this._dead) {
            map = this._inboundMessages;
            synchronized (map) {
                this._inboundMessages.putAll(msgs);
            }
        }
        msgs.clear();
        ArrayList<OutboundMessageState> tmp2 = new ArrayList<OutboundMessageState>();
        OutboundMessageState retransmitter = null;
        CachedIteratorCollection<OutboundMessageState> cachedIteratorCollection = oldPeer._outboundMessages;
        synchronized (cachedIteratorCollection) {
            tmp2.addAll(oldPeer._outboundMessages);
            oldPeer._outboundMessages.clear();
            retransmitter = oldPeer._retransmitter;
            oldPeer._retransmitter = null;
        }
        if (!this._dead) {
            cachedIteratorCollection = this._outboundMessages;
            synchronized (cachedIteratorCollection) {
                this._outboundMessages.addAll(tmp2);
                this._retransmitter = retransmitter;
            }
        }
    }

    public UDPTransport getTransport() {
        return this._transport;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append(this._remoteHostId.toString());
        if (this._remotePeer != null) {
            buf.append(" ").append(this._remotePeer.toBase64().substring(0, 6));
        }
        buf.append(this._isInbound ? " IB " : " OB ");
        long now = this._context.clock().now();
        buf.append(" recvAge: ").append(now - this._lastReceiveTime);
        buf.append(" sendAge: ").append(now - this._lastSendFullyTime);
        buf.append(" sendAttemptAge: ").append(now - this._lastSendTime);
        buf.append(" sendACKAge: ").append(now - this._lastACKSend);
        buf.append(" lifetime: ").append(now - this._keyEstablishedTime);
        buf.append(" cwin: ").append(this._sendWindowBytes);
        buf.append(" acwin: ").append(this._sendWindowBytesRemaining);
        buf.append(" consecFail: ").append(this._consecutiveFailedSends);
        buf.append(" msgs rcvd: ").append(this._messagesReceived);
        buf.append(" msgs sent: ").append(this._messagesSent);
        buf.append(" pkts rcvd OK/Dup: ").append(this._packetsReceived).append('/').append(this._packetsReceivedDuplicate);
        buf.append(" pkts sent OK/Dup: ").append(this._packetsTransmitted).append('/').append(this._packetsRetransmitted);
        buf.append(" IBM: ").append(this._inboundMessages.size());
        buf.append(" OBQ: ").append(this._outboundQueue.size());
        buf.append(" OBL: ").append(this._outboundMessages.size());
        return buf.toString();
    }

    private static class FullACKBitfield
    implements ACKBitfield {
        private final long _msgId;

        public FullACKBitfield(long id) {
            this._msgId = id;
        }

        @Override
        public int fragmentCount() {
            return 1;
        }

        @Override
        public int ackCount() {
            return 1;
        }

        @Override
        public int highestReceived() {
            return 0;
        }

        @Override
        public long getMessageId() {
            return this._msgId;
        }

        @Override
        public boolean received(int fragmentNum) {
            return true;
        }

        @Override
        public boolean receivedComplete() {
            return true;
        }

        public int hashCode() {
            return (int)this._msgId;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FullACKBitfield)) {
                return false;
            }
            return this._msgId == ((ACKBitfield)o).getMessageId();
        }

        public String toString() {
            return "Full ACK " + this._msgId;
        }
    }

    private static class ResendACK {
        public final Long id;
        public final long time;

        public ResendACK(Long id, long time) {
            this.id = id;
            this.time = time;
        }
    }

    private static enum ShouldSend {
        YES,
        NO,
        NO_BW;

    }
}

