/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.transport.TransportUtil;
import net.i2p.util.Addresses;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.Translate;
import org.cybergarage.upnp.Action;
import org.cybergarage.upnp.ActionList;
import org.cybergarage.upnp.Argument;
import org.cybergarage.upnp.ArgumentList;
import org.cybergarage.upnp.ControlPoint;
import org.cybergarage.upnp.Device;
import org.cybergarage.upnp.DeviceList;
import org.cybergarage.upnp.Service;
import org.cybergarage.upnp.ServiceList;
import org.cybergarage.upnp.ServiceStateTable;
import org.cybergarage.upnp.StateVariable;
import org.cybergarage.upnp.UPnPStatus;
import org.cybergarage.upnp.device.DeviceChangeListener;
import org.cybergarage.upnp.event.EventListener;
import org.cybergarage.upnp.ssdp.SSDPPacket;
import org.cybergarage.util.Debug;
import org.freenetproject.DetectedIP;
import org.freenetproject.ForwardPort;
import org.freenetproject.ForwardPortCallback;
import org.freenetproject.ForwardPortStatus;

public class UPnP
extends ControlPoint
implements DeviceChangeListener,
EventListener {
    private final Log _log;
    private final I2PAppContext _context;
    private static final String ROUTER_DEVICE = "urn:schemas-upnp-org:device:InternetGatewayDevice:1";
    private static final String WAN_DEVICE = "urn:schemas-upnp-org:device:WANDevice:1";
    private static final String WANCON_DEVICE = "urn:schemas-upnp-org:device:WANConnectionDevice:1";
    private static final String WAN_IP_CONNECTION = "urn:schemas-upnp-org:service:WANIPConnection:1";
    private static final String WAN_PPP_CONNECTION = "urn:schemas-upnp-org:service:WANPPPConnection:1";
    private static final String ROUTER_DEVICE_2 = "urn:schemas-upnp-org:device:InternetGatewayDevice:2";
    private static final String WAN_DEVICE_2 = "urn:schemas-upnp-org:device:WANDevice:2";
    private static final String WANCON_DEVICE_2 = "urn:schemas-upnp-org:device:WANConnectionDevice:2";
    private static final String WAN_IP_CONNECTION_2 = "urn:schemas-upnp-org:service:WANIPConnection:2";
    private static final String WAN_IPV6_CONNECTION = "urn:schemas-upnp-org:service:WANIPv6FirewallControl:1";
    private Device _router;
    private Service _service;
    private final Map<String, String> _otherUDNs;
    private final Map<String, String> _eventVars;
    private boolean isDisabled = false;
    private volatile boolean _serviceLacksAPM;
    private final Object lock = new Object();
    private volatile boolean thinksWeAreDoubleNatted = false;
    private final Set<ForwardPort> portsToForward;
    private final Set<ForwardPort> portsForwarded;
    private ForwardPortCallback forwardCallback;
    private static final String PROP_ADVANCED = "routerconsole.advanced";
    private static final String PROP_IGNORE = "i2np.upnp.ignore";
    private static final boolean ALLOW_SAME_HOST = false;
    private String _lastAction;
    private Service _lastService;
    private ArgumentList _lastArgumentList;
    private final Object toStringLock = new Object();
    private static final long UINT_MAX = 0xFFFFFFFFL;
    private static final AtomicInteger __id = new AtomicInteger();
    private static final String BUNDLE_NAME = "net.i2p.router.web.messages";

    public UPnP(I2PAppContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(UPnP.class);
        this.portsToForward = new HashSet<ForwardPort>();
        this.portsForwarded = new HashSet<ForwardPort>();
        this._otherUDNs = new HashMap<String, String>(4);
        this._eventVars = new HashMap<String, String>(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean runPlugin() {
        this.addDeviceChangeListener(this);
        this.addEventListener(this);
        Object object = this.lock;
        synchronized (object) {
            this.portsToForward.clear();
            this.portsForwarded.clear();
            this._eventVars.clear();
        }
        return super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void terminate() {
        this.removeDeviceChangeListener(this);
        this.removeEventListener(this);
        Object object = this.lock;
        synchronized (object) {
            this.portsToForward.clear();
            this._eventVars.clear();
        }
        this.unregisterPortMappings();
        int i = 0;
        while (i++ < 20 && !this.portsForwarded.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        super.stop();
        Object object2 = this.lock;
        synchronized (object2) {
            this._router = null;
            this._service = null;
            this._serviceLacksAPM = false;
        }
    }

    public DetectedIP[] getAddress() {
        this._log.info("UP&P.getAddress() is called \\o/");
        if (this.isDisabled) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Plugin has been disabled previously, ignoring request.");
            }
            return null;
        }
        if (!this.isNATPresent()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("No UP&P device found, detection of the external ip address using the plugin has failed");
            }
            return null;
        }
        DetectedIP result = null;
        String natAddress = this.getNATAddress();
        if (natAddress == null || natAddress.length() <= 0) {
            if (this._log.shouldLog(30)) {
                this._log.warn("No external address returned");
            }
            return null;
        }
        try {
            InetAddress detectedIP = InetAddress.getByName(natAddress);
            short status = 1;
            boolean bl = this.thinksWeAreDoubleNatted = !TransportUtil.isPubliclyRoutable(detectedIP.getAddress(), false);
            if (this._log.shouldLog(30)) {
                this._log.warn("NATAddress: \"" + natAddress + "\" detectedIP: " + detectedIP + " double? " + this.thinksWeAreDoubleNatted);
            }
            if (this.portsForwarded.size() > 1 && !this.thinksWeAreDoubleNatted) {
                status = 2;
            }
            result = new DetectedIP(detectedIP, status);
            if (this._log.shouldLog(30)) {
                this._log.warn("Successful UP&P discovery :" + result);
            }
            return new DetectedIP[]{result};
        }
        catch (UnknownHostException e) {
            this._log.error("Caught an UnknownHostException resolving " + natAddress, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deviceAdded(Device dev) {
        String pktIP;
        String type;
        String name;
        String udn = dev.getUDN();
        if (udn == null) {
            udn = "???";
        }
        if ((name = dev.getFriendlyName()) == null) {
            name = "???";
        }
        boolean isIGD = (ROUTER_DEVICE.equals(type = dev.getDeviceType()) || ROUTER_DEVICE_2.equals(type)) && dev.isRootDevice();
        name = name + (isIGD ? " IGD" : ' ' + type);
        String ip = UPnP.getIP(dev);
        if (ip != null) {
            name = name + ' ' + ip;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isDisabled) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Plugin has been disabled previously, ignoring " + name + " UDN: " + udn);
                }
                this._otherUDNs.put(udn, name);
                return;
            }
        }
        if (!isIGD) {
            if (this._log.shouldLog(30)) {
                this._log.warn("UP&P non-IGD device found, ignoring " + name + ' ' + dev.getDeviceType());
            }
            object = this.lock;
            synchronized (object) {
                this._otherUDNs.put(udn, name);
            }
            return;
        }
        if (this.isNATPresent()) {
            this._log.logAlways(30, "UP&P ignoring additional device " + name + " UDN: " + udn);
            object = this.lock;
            synchronized (object) {
                this._otherUDNs.put(udn, name);
            }
            return;
        }
        boolean ignore = false;
        String toIgnore = this._context.getProperty(PROP_IGNORE);
        if (toIgnore != null) {
            String[] ignores = DataHelper.split(toIgnore, "[,; \r\n\t]");
            for (int i = 0; i < ignores.length; ++i) {
                if (!ignores[i].equals(udn)) continue;
                ignore = true;
                this._log.logAlways(30, "Ignoring by config: " + name + " UDN: " + udn);
                break;
            }
        }
        SortedSet<String> myAddresses = Addresses.getAddresses(true, false);
        if (!ignore && ip != null && myAddresses.contains(ip)) {
            ignore = true;
            this._log.logAlways(30, "Ignoring UPnP on same host: " + name + " UDN: " + udn);
        }
        SSDPPacket pkt = dev.getSSDPPacket();
        if (!ignore && pkt != null && !UPnP.stringEquals(ip, pktIP = pkt.getRemoteAddress())) {
            ignore = true;
            this._log.logAlways(30, "Ignoring UPnP with IP mismatch: " + name + " UDN: " + udn);
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (ignore) {
                this._otherUDNs.put(udn, name);
                return;
            }
            this._router = dev;
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("UP&P IGD found : " + name + " UDN: " + udn + " lease time: " + dev.getLeaseTime());
        }
        this.discoverService();
        object2 = this.lock;
        synchronized (object2) {
            if (this._service == null) {
                this._log.error("The IGD device we got isn't suiting our needs, let's disable the plugin");
                this._router = null;
                return;
            }
            this.subscribe(this._service);
        }
        this.registerPortMappings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPortMappings() {
        HashSet<ForwardPort> ports;
        Object object = this.lock;
        synchronized (object) {
            ports = new HashSet<ForwardPort>(this.portsForwarded);
        }
        if (ports.isEmpty()) {
            return;
        }
        this.registerPorts(ports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverService() {
        Object object = this.lock;
        synchronized (object) {
            for (Device current : this._router.getDeviceList()) {
                String type = current.getDeviceType();
                if (!WAN_DEVICE.equals(type) && !WAN_DEVICE_2.equals(type)) continue;
                DeviceList l = current.getDeviceList();
                for (int i = 0; i < current.getDeviceList().size(); ++i) {
                    Service svc2;
                    Device current2 = l.getDevice(i);
                    type = current2.getDeviceType();
                    if (!WANCON_DEVICE.equals(type) && !WANCON_DEVICE_2.equals(type)) continue;
                    this._service = current2.getService(WAN_IP_CONNECTION_2);
                    if (this._service == null) {
                        this._service = current2.getService(WAN_IP_CONNECTION);
                        if (this._service == null) {
                            this._service = current2.getService(WAN_PPP_CONNECTION);
                            if (this._service == null && this._log.shouldWarn()) {
                                this._log.warn(this._router.getFriendlyName() + " doesn't have any recognized connection type; we won't be able to use it!");
                            }
                        }
                    }
                    if (this._log.shouldWarn() && (svc2 = current2.getService(WAN_IPV6_CONNECTION)) != null) {
                        this._log.warn(this._router.getFriendlyName() + " supports WANIPv6Connection, but we don't");
                    }
                    this._serviceLacksAPM = false;
                    return;
                }
            }
        }
    }

    private boolean tryAddMapping(String protocol, int port, String description, ForwardPort fp) {
        if (this._log.shouldLog(30)) {
            this._log.warn("Registering a port mapping for " + port + "/" + protocol);
        }
        int nbOfTries = 0;
        boolean isPortForwarded = false;
        while (!(this._serviceLacksAPM || nbOfTries++ >= 5 || (isPortForwarded = this.addMapping(protocol, port, description, fp)) || this._serviceLacksAPM)) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this._log.shouldLog(30)) {
            this._log.warn((isPortForwarded ? "Mapping is successful!" : "Mapping has failed!") + " (" + nbOfTries + " tries)");
        }
        return isPortForwarded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPortMappings() {
        HashSet<ForwardPort> ports;
        Object object = this.lock;
        synchronized (object) {
            ports = new HashSet<ForwardPort>(this.portsForwarded);
        }
        if (ports.isEmpty()) {
            return;
        }
        this.unregisterPorts(ports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deviceRemoved(Device dev) {
        String udn = dev.getUDN();
        if (this._log.shouldLog(30)) {
            this._log.warn("UP&P device removed : " + dev.getFriendlyName() + " UDN: " + udn);
        }
        ForwardPortCallback fpc = null;
        HashMap removeMap = null;
        Object object = this.lock;
        synchronized (object) {
            if (udn != null) {
                this._otherUDNs.remove(udn);
            } else {
                this._otherUDNs.remove("???");
            }
            if (this._router == null) {
                return;
            }
            String type = dev.getDeviceType();
            if ((ROUTER_DEVICE.equals(type) || ROUTER_DEVICE_2.equals(type)) && dev.isRootDevice() && UPnP.stringEquals(this._router.getFriendlyName(), dev.getFriendlyName()) && UPnP.stringEquals(this._router.getUDN(), udn)) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("UP&P IGD device removed : " + dev.getFriendlyName());
                }
                this._otherUDNs.clear();
                this._router = null;
                this._service = null;
                this._eventVars.clear();
                this._serviceLacksAPM = false;
                if (!this.portsForwarded.isEmpty()) {
                    fpc = this.forwardCallback;
                    removeMap = new HashMap(this.portsForwarded.size());
                    for (ForwardPort port : this.portsForwarded) {
                        ForwardPortStatus forwardPortStatus = new ForwardPortStatus(-2, "UPnP device removed", port.portNumber);
                    }
                }
                this.portsForwarded.clear();
            }
        }
        if (fpc != null) {
            fpc.portForwardStatus(removeMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventNotifyReceived(String uuid, long seq, String varName, String value) {
        if (uuid == null || varName == null || value == null) {
            return;
        }
        if (varName.length() > 128 || value.length() > 128) {
            return;
        }
        String old = null;
        Object object = this.lock;
        synchronized (object) {
            if (this._service == null || !uuid.equals(this._service.getSID())) {
                return;
            }
            if (this._eventVars.size() >= 20 && !this._eventVars.containsKey(varName)) {
                return;
            }
            old = this._eventVars.put(varName, value);
        }
        if (!value.equals(old) && this._log.shouldDebug()) {
            this._log.debug("Event: " + varName + " changed from " + old + " to " + value);
        }
    }

    private static boolean stringEquals(String a, String b) {
        if (a != null) {
            return a.equals(b);
        }
        return b == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNATPresent() {
        Object object = this.lock;
        synchronized (object) {
            return this._router != null && this._service != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNATAddress() {
        Service service;
        Object object = this.lock;
        synchronized (object) {
            if (!this.isNATPresent()) {
                return null;
            }
            service = this._service;
        }
        Action getIP = service.getAction("GetExternalIPAddress");
        if (getIP == null || !getIP.postControlAction()) {
            return null;
        }
        Argument a = getIP.getOutputArgumentList().getArgument("NewExternalIPAddress");
        if (a == null) {
            return null;
        }
        String rv = a.getValue();
        if ("0.0.0.0".equals(rv) || rv == null || rv.length() <= 0) {
            return null;
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUpstreamMaxBitRate() {
        Service service;
        Object object = this.lock;
        synchronized (object) {
            if (!this.isNATPresent() || this.thinksWeAreDoubleNatted) {
                return -1;
            }
            service = this._service;
        }
        Action getIP = service.getAction("GetLinkLayerMaxBitRates");
        if (getIP == null || !getIP.postControlAction()) {
            return -1;
        }
        Argument a = getIP.getOutputArgumentList().getArgument("NewUpstreamMaxBitRate");
        if (a == null) {
            return -1;
        }
        try {
            return Integer.parseInt(a.getValue());
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDownstreamMaxBitRate() {
        Service service;
        Object object = this.lock;
        synchronized (object) {
            if (!this.isNATPresent() || this.thinksWeAreDoubleNatted) {
                return -1;
            }
            service = this._service;
        }
        Action getIP = service.getAction("GetLinkLayerMaxBitRates");
        if (getIP == null || !getIP.postControlAction()) {
            return -1;
        }
        Argument a = getIP.getOutputArgumentList().getArgument("NewDownstreamMaxBitRate");
        if (a == null) {
            return -1;
        }
        try {
            return Integer.parseInt(a.getValue());
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private static void listStateTable(Service serv, StringBuilder sb) {
        ServiceStateTable table;
        try {
            table = serv.getServiceStateTable();
        }
        catch (RuntimeException e) {
            sb.append(" : no state");
            return;
        }
        sb.append("<ul><small>");
        for (int i = 0; i < table.size(); ++i) {
            StateVariable current = table.getStateVariable(i);
            sb.append("<li>").append(DataHelper.escapeHTML(current.getName())).append(" : \"").append(DataHelper.escapeHTML(current.getValue())).append("\"</li>");
        }
        sb.append("</small></ul>");
    }

    private static void listActionsArguments(Action action, StringBuilder sb) {
        ArgumentList ar = action.getArgumentList();
        sb.append("<ol>");
        for (int i = 0; i < ar.size(); ++i) {
            Argument argument = ar.getArgument(i);
            if (argument == null) continue;
            sb.append("<li><small>argument : ").append(DataHelper.escapeHTML(argument.getName())).append("</small></li>");
        }
        sb.append("</ol>");
    }

    private static void listActions(Service service, StringBuilder sb) {
        ActionList al = service.getActionList();
        sb.append("<ul>");
        for (int i = 0; i < al.size(); ++i) {
            Action action = al.getAction(i);
            if (action == null) continue;
            sb.append("<li>").append(DataHelper.escapeHTML(action.getName()));
            UPnP.listActionsArguments(action, sb);
            sb.append("</li>");
        }
        sb.append("</ul>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toString(String action, String arg, Service serv) {
        Object object = this.toStringLock;
        synchronized (object) {
            Argument a;
            if (!action.equals(this._lastAction) || !serv.equals(this._lastService) || this._lastArgumentList == null) {
                Action getIP = serv.getAction(action);
                if (getIP == null || !getIP.postControlAction()) {
                    this._lastAction = null;
                    return null;
                }
                this._lastAction = action;
                this._lastService = serv;
                this._lastArgumentList = getIP.getOutputArgumentList();
            }
            if ((a = this._lastArgumentList.getArgument(arg)) == null) {
                return "";
            }
            String rv = a.getValue();
            return DataHelper.escapeHTML(rv);
        }
    }

    private String toLong(String action, String arg, Service serv) {
        String rv = this.toString(action, arg, serv);
        if (rv != null && rv.length() > 0) {
            try {
                long l = Long.parseLong(rv);
                rv = DataHelper.formatSize2Decimal(l);
                if (l == 0xFFFFFFFFL) {
                    rv = "&gt; " + rv;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return rv;
    }

    private String toTime(String action, String arg, Service serv) {
        String rv = this.toString(action, arg, serv);
        if (rv != null && rv.length() > 0) {
            try {
                long l = Long.parseLong(rv);
                rv = DataHelper.formatDuration2(l * 1000L);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return rv;
    }

    private String toBoolean(String action, String arg, Service serv) {
        String rv = this.toString(action, arg, serv);
        return Boolean.toString("1".equals(rv));
    }

    private void listSubServices(Device dev, StringBuilder sb) {
        ServiceList sl = dev.getServiceList();
        if (sl.isEmpty()) {
            return;
        }
        sb.append("<ul>\n");
        for (int i = 0; i < sl.size(); ++i) {
            Service serv = sl.getService(i);
            if (serv == null) continue;
            sb.append("<li>").append(this._t("Service")).append(": ");
            String type = serv.getServiceType();
            if ("urn:schemas-upnp-org:service:WANCommonInterfaceConfig:1".equals(type)) {
                sb.append(this._t("WAN Common Interface Configuration"));
                sb.append("<ul><li>").append(this._t("Status")).append(": ").append(this.toString("GetCommonLinkProperties", "NewPhysicalLinkStatus", serv));
                sb.append("<li>").append(this._t("Type")).append(": ").append(this.toString("GetCommonLinkProperties", "NewWANAccessType", serv));
                sb.append("<li>").append(this._t("Upstream")).append(": ").append(this.toLong("GetCommonLinkProperties", "NewLayer1UpstreamMaxBitRate", serv)).append("bps");
                sb.append("<li>").append(this._t("Downstream")).append(": ").append(this.toLong("GetCommonLinkProperties", "NewLayer1DownstreamMaxBitRate", serv)).append("bps");
                if (this._context.getBooleanProperty(PROP_ADVANCED)) {
                    sb.append("<li>").append("Sent: ").append(this.toLong("GetTotalBytesSent", "NewTotalBytesSent", serv)).append('B');
                    sb.append("<li>").append("Received: ").append(this.toLong("GetTotalBytesReceived", "NewTotalBytesReceived", serv)).append('B');
                    sb.append("<li>").append("Sent packets: ").append(this.toLong("GetTotalPacketsSent", "NewTotalPacketsSent", serv));
                    sb.append("<li>").append("Received packets: ").append(this.toLong("GetTotalPacketsReceived", "NewTotalPacketsReceived", serv));
                }
            } else if (WAN_PPP_CONNECTION.equals(type)) {
                sb.append(this._t("WAN PPP Connection"));
                sb.append("<ul><li>").append(this._t("Status")).append(": ").append(this.toString("GetStatusInfo", "NewConnectionStatus", serv));
                sb.append("<li>").append(this._t("Uptime")).append(": ").append(this.toTime("GetStatusInfo", "NewUptime", serv));
                sb.append("<li>").append(this._t("Type")).append(": ").append(this.toString("GetConnectionTypeInfo", "NewConnectionType", serv));
                sb.append("<li>").append(this._t("Upstream")).append(": ").append(this.toLong("GetLinkLayerMaxBitRates", "NewUpstreamMaxBitRate", serv)).append("bps");
                sb.append("<li>").append(this._t("Downstream")).append(": ").append(this.toLong("GetLinkLayerMaxBitRates", "NewDownstreamMaxBitRate", serv)).append("bps");
                sb.append("<li>").append(this._t("External IP")).append(": ").append(this.toString("GetExternalIPAddress", "NewExternalIPAddress", serv));
            } else if ("urn:schemas-upnp-org:service:Layer3Forwarding:1".equals(type)) {
                sb.append(this._t("Layer 3 Forwarding"));
                sb.append("<ul><li>").append(this._t("Default Connection Service")).append(": ").append(this.toString("GetDefaultConnectionService", "NewDefaultConnectionService", serv));
            } else if (WAN_IP_CONNECTION.equals(type) || WAN_IP_CONNECTION_2.equals(type)) {
                sb.append(this._t("WAN IP Connection"));
                sb.append("<ul><li>").append(this._t("Status")).append(": ").append(this.toString("GetStatusInfo", "NewConnectionStatus", serv));
                sb.append("<li>").append(this._t("Uptime")).append(": ").append(this.toTime("GetStatusInfo", "NewUptime", serv));
                String error = this.toString("GetStatusInfo", "NewLastConnectionError", serv);
                if (error != null && error.length() > 0 && !error.equals("ERROR_NONE")) {
                    sb.append("<li>").append("Last Error").append(": ").append(error);
                }
                sb.append("<li>").append(this._t("Type")).append(": ").append(this.toString("GetConnectionTypeInfo", "NewConnectionType", serv));
                sb.append("<li>").append(this._t("External IP")).append(": ").append(this.toString("GetExternalIPAddress", "NewExternalIPAddress", serv));
            } else if (WAN_IPV6_CONNECTION.equals(type)) {
                sb.append("WAN IPv6 Connection");
                sb.append("<ul><li>").append("Firewall Enabled").append(": ").append(this.toBoolean("GetFirewallStatus", "FirewallEnabled", serv));
                sb.append("<li>").append("Pinhole Allowed").append(": ").append(this.toBoolean("GetFirewallStatus", "InboundPinholeAllowed", serv));
            } else if ("urn:schemas-upnp-org:service:WANEthernetLinkConfig:1".equals(type)) {
                sb.append(this._t("WAN Ethernet Link Configuration"));
                sb.append("<ul><li>").append(this._t("Status")).append(": ").append(this.toString("GetEthernetLinkStatus", "NewEthernetLinkStatus", serv));
            } else {
                sb.append(DataHelper.escapeHTML(type)).append("<ul>");
            }
            if (this._context.getBooleanProperty(PROP_ADVANCED)) {
                sb.append("<li>Actions");
                UPnP.listActions(serv, sb);
                sb.append("</li><li>States");
                UPnP.listStateTable(serv, sb);
                sb.append("</li>");
            }
            sb.append("</ul>\n");
        }
        sb.append("</ul>\n");
    }

    private void listSubDev(String prefix, Device dev, StringBuilder sb) {
        if (prefix == null) {
            sb.append("<p>").append(this._t("Found Device")).append(": ");
        } else {
            sb.append("<li>").append(this._t("Subdevice")).append(": ");
        }
        sb.append(DataHelper.escapeHTML(dev.getFriendlyName()));
        if (prefix == null) {
            String udn;
            String ip = UPnP.getIP(dev);
            if (ip != null) {
                sb.append("<br>IP: ").append(ip);
            }
            if ((udn = dev.getUDN()) != null) {
                sb.append("<br>UDN: ").append(DataHelper.escapeHTML(udn));
            }
        }
        this.listSubServices(dev, sb);
        DeviceList dl = dev.getDeviceList();
        if (dl.isEmpty()) {
            return;
        }
        sb.append("<ul>\n");
        for (int j = 0; j < dl.size(); ++j) {
            Device subDev = dl.getDevice(j);
            if (subDev == null) continue;
            this.listSubDev(dev.getFriendlyName(), subDev, sb);
        }
        sb.append("</ul>\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String renderStatusHTML() {
        Device router;
        StringBuilder sb = new StringBuilder();
        sb.append("<h3 id=\"upnp\">").append(this._t("UPnP Status")).append("</h3><div id=\"upnpscan\">");
        Map<String, String> map = this._otherUDNs;
        synchronized (map) {
            if (!this._otherUDNs.isEmpty()) {
                sb.append(this._t("Disabled UPnP Devices"));
                sb.append("<ul>");
                for (Map.Entry<String, String> e : this._otherUDNs.entrySet()) {
                    String udn = e.getKey();
                    String name = e.getValue();
                    sb.append("<li>").append(DataHelper.escapeHTML(name));
                    sb.append("<br>UDN: ").append(DataHelper.escapeHTML(udn)).append("</li>");
                }
                sb.append("</ul>");
            }
        }
        if (this.isDisabled) {
            sb.append("<p>");
            sb.append(this._t("UPnP has been disabled; Do you have more than one UPnP Internet Gateway Device on your LAN ?"));
            return sb.toString();
        }
        if (!this.isNATPresent()) {
            sb.append("<p>");
            sb.append(this._t("UPnP has not found any UPnP-aware, compatible device on your LAN."));
            return sb.toString();
        }
        Iterator<Map.Entry<String, String>> iterator = this.lock;
        synchronized (iterator) {
            router = this._router;
        }
        if (router != null) {
            this.listSubDev(null, router, sb);
        }
        String addr = this.getNATAddress();
        sb.append("<p>");
        if (addr != null) {
            sb.append(this._t("The current external IP address reported by UPnP is {0}", DataHelper.escapeHTML(addr)));
        } else {
            sb.append(this._t("The current external IP address is not available."));
        }
        int downstreamMaxBitRate = this.getDownstreamMaxBitRate();
        int upstreamMaxBitRate = this.getUpstreamMaxBitRate();
        if (downstreamMaxBitRate > 0) {
            sb.append("<br>").append(this._t("UPnP reports the maximum downstream bit rate is {0}bits/sec", DataHelper.formatSize2Decimal(downstreamMaxBitRate)));
        }
        if (upstreamMaxBitRate > 0) {
            sb.append("<br>").append(this._t("UPnP reports the maximum upstream bit rate is {0}bits/sec", DataHelper.formatSize2Decimal(upstreamMaxBitRate)));
        }
        Object object = this.lock;
        synchronized (object) {
            for (ForwardPort port : this.portsToForward) {
                sb.append("<br>");
                if (this.portsForwarded.contains(port)) {
                    sb.append(this._t("{0} port {1,number,#####} was successfully forwarded by UPnP.", UPnP.protoToString(port.protocol), port.portNumber));
                    continue;
                }
                sb.append(this._t("{0} port {1,number,#####} was not forwarded by UPnP.", UPnP.protoToString(port.protocol), port.portNumber));
            }
        }
        sb.append("</p></div>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addMapping(String protocol, int port, String description, ForwardPort fp) {
        int level;
        Service service;
        Object object = this.lock;
        synchronized (object) {
            if (this.isDisabled || !this.isNATPresent() || this._router == null) {
                this._log.error("Can't addMapping: " + this.isDisabled + " " + this.isNATPresent() + " " + this._router);
                return false;
            }
            service = this._service;
        }
        Action add = service.getAction("AddPortMapping");
        if (add == null) {
            if (this._serviceLacksAPM) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Couldn't find AddPortMapping action!");
                }
            } else {
                this._serviceLacksAPM = true;
                this._log.logAlways(30, "UPnP device does not support port forwarding");
            }
            return false;
        }
        add.setArgumentValue("NewRemoteHost", "");
        add.setArgumentValue("NewExternalPort", port);
        String intf = this._router.getInterfaceAddress();
        String us = this.getOurAddress(intf);
        if (this._log.shouldLog(30) && !us.equals(intf)) {
            this._log.warn("Requesting port forward to " + us + ':' + port + " when cybergarage wanted " + intf);
        }
        add.setArgumentValue("NewInternalClient", us);
        add.setArgumentValue("NewInternalPort", port);
        add.setArgumentValue("NewProtocol", protocol);
        add.setArgumentValue("NewPortMappingDescription", description);
        add.setArgumentValue("NewEnabled", "1");
        add.setArgumentValue("NewLeaseDuration", 10800);
        boolean rv = add.postControlAction();
        if (rv) {
            Object object2 = this.lock;
            synchronized (object2) {
                this.portsForwarded.add(fp);
            }
        }
        int n = level = rv ? 20 : 30;
        if (this._log.shouldLog(level)) {
            StringBuilder buf = new StringBuilder();
            buf.append("AddPortMapping result for ").append(protocol).append(" port ").append(port);
            UPnPStatus status = add.getStatus();
            if (status != null) {
                buf.append(" Status: ").append(status.getCode()).append(' ').append(status.getDescription());
            }
            if ((status = add.getControlStatus()) != null) {
                buf.append(" ControlStatus: ").append(status.getCode()).append(' ').append(status.getDescription());
            }
            this._log.log(level, buf.toString());
        }
        return rv;
    }

    private static String getIP(Device dev) {
        URI url2;
        String rv = null;
        String him = dev.getURLBase();
        if (him != null && him.length() > 0) {
            try {
                url2 = new URI(him);
                rv = url2.getHost();
            }
            catch (URISyntaxException url2) {
                // empty catch block
            }
        }
        if (rv == null && (him = dev.getLocation()) != null && him.length() > 0) {
            try {
                url2 = new URI(him);
                rv = url2.getHost();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return rv;
    }

    private String getOurAddress(String deflt) {
        String rv = deflt;
        String hisIP = UPnP.getIP(this._router);
        if (hisIP == null) {
            return rv;
        }
        try {
            byte[] hisBytes = InetAddress.getByName(hisIP).getAddress();
            if (hisBytes.length != 4) {
                return deflt;
            }
            long hisLong = DataHelper.fromLong(hisBytes, 0, 4);
            long distance = Long.MAX_VALUE;
            SortedSet<String> myAddresses = Addresses.getAddresses(true, false);
            myAddresses.add(deflt);
            for (String me : myAddresses) {
                if (me.startsWith("127.") || me.equals("0.0.0.0")) continue;
                try {
                    byte[] myBytes = InetAddress.getByName(me).getAddress();
                    long myLong = DataHelper.fromLong(myBytes, 0, 4);
                    long newDistance = myLong ^ hisLong;
                    if (newDistance >= distance) continue;
                    rv = me;
                    distance = newDistance;
                }
                catch (UnknownHostException unknownHostException) {}
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeMapping(String protocol, int port, ForwardPort fp, boolean noLog) {
        Service service;
        Object object = this.lock;
        synchronized (object) {
            if (this.isDisabled || !this.isNATPresent()) {
                this._log.error("Can't removeMapping: " + this.isDisabled + " " + this.isNATPresent() + " " + this._router);
                return false;
            }
            service = this._service;
        }
        Action remove = service.getAction("DeletePortMapping");
        if (remove == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Couldn't find DeletePortMapping action!");
            }
            return false;
        }
        remove.setArgumentValue("NewExternalPort", port);
        remove.setArgumentValue("NewProtocol", protocol);
        boolean retval = remove.postControlAction();
        Object object2 = this.lock;
        synchronized (object2) {
            this.portsForwarded.remove(fp);
        }
        if (this._log.shouldLog(30) && !noLog) {
            this._log.warn("UPnP: Removed mapping for " + fp.name + " " + port + " / " + protocol);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChangePublicPorts(Set<ForwardPort> ports, ForwardPortCallback cb) {
        Set<ForwardPort> portsToDumpNow = null;
        Set<ForwardPort> portsToForwardNow = null;
        if (this._log.shouldLog(20)) {
            this._log.info("UP&P Forwarding " + ports.size() + " ports...", new Exception());
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.forwardCallback != null && this.forwardCallback != cb && cb != null) {
                this._log.error("ForwardPortCallback changed from " + this.forwardCallback + " to " + cb + " - using new value, but this is very strange!");
            }
            this.forwardCallback = cb;
            if (this.portsToForward.isEmpty()) {
                this.portsToForward.addAll(ports);
                portsToForwardNow = ports;
                portsToDumpNow = null;
            } else if (ports.isEmpty()) {
                portsToDumpNow = this.portsToForward;
                this.portsToForward.clear();
                portsToForwardNow = null;
            } else {
                for (ForwardPort port : ports) {
                    if (portsToForwardNow == null) {
                        portsToForwardNow = new HashSet<ForwardPort>();
                    }
                    portsToForwardNow.add(port);
                }
                for (ForwardPort port : this.portsToForward) {
                    if (ports.contains(port)) continue;
                    if (portsToDumpNow == null) {
                        portsToDumpNow = new HashSet<ForwardPort>();
                    }
                    portsToDumpNow.add(port);
                }
                this.portsToForward.clear();
                this.portsToForward.addAll(ports);
            }
            if (this._router == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("No UPnP router available to update");
                }
                return;
            }
        }
        if (portsToDumpNow != null && !portsToDumpNow.isEmpty()) {
            this.unregisterPorts(portsToDumpNow);
        }
        if (portsToForwardNow != null && !portsToForwardNow.isEmpty()) {
            this.registerPorts(portsToForwardNow);
        }
    }

    private static String protoToString(int p) {
        if (p == 17) {
            return "UDP";
        }
        if (p == 6) {
            return "TCP";
        }
        return "?";
    }

    private void registerPorts(Set<ForwardPort> portsToForwardNow) {
        if (this._serviceLacksAPM) {
            if (this._log.shouldLog(30)) {
                this._log.warn("UPnP device does not support port forwarding");
            }
            HashMap<ForwardPort, ForwardPortStatus> map = new HashMap<ForwardPort, ForwardPortStatus>(portsToForwardNow.size());
            for (ForwardPort port : portsToForwardNow) {
                ForwardPortStatus fps = new ForwardPortStatus(-2, "UPnP device does not support port forwarding", port.portNumber);
                map.put(port, fps);
            }
            this.forwardCallback.portForwardStatus(map);
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Starting thread to forward " + portsToForwardNow.size() + " ports");
        }
        I2PThread t = new I2PThread(new RegisterPortsThread(portsToForwardNow));
        t.setName("UPnP Port Opener " + __id.incrementAndGet());
        t.setDaemon(true);
        ((Thread)t).start();
    }

    private void unregisterPorts(Set<ForwardPort> portsToForwardNow) {
        if (this._log.shouldLog(20)) {
            this._log.info("Starting thread to un-forward " + portsToForwardNow.size() + " ports");
        }
        I2PThread t = new I2PThread(new UnregisterPortsThread(portsToForwardNow));
        t.setName("UPnP Port Closer " + __id.incrementAndGet());
        t.setDaemon(true);
        ((Thread)t).start();
    }

    public static void main(String[] args) throws Exception {
        Properties props = new Properties();
        props.setProperty(PROP_ADVANCED, "true");
        I2PAppContext ctx = new I2PAppContext(props);
        UPnP cp = new UPnP(ctx);
        org.cybergarage.upnp.UPnP.setEnable(9);
        Debug.initialize(ctx);
        cp.setHTTPPort(49152 + ctx.random().nextInt(5000));
        cp.setSSDPPort(54152 + ctx.random().nextInt(5000));
        long start = System.currentTimeMillis();
        cp.start();
        long s2 = System.currentTimeMillis();
        System.err.println("Start took " + (s2 - start) + "ms");
        System.err.println("Searching for UPnP devices");
        start = System.currentTimeMillis();
        cp.search();
        s2 = System.currentTimeMillis();
        System.err.println("Search kickoff took " + (s2 - start) + "ms");
        System.err.println("Waiting 10 seconds for responses");
        Thread.sleep(10000L);
        DeviceList list = cp.getDeviceList();
        if (list.isEmpty()) {
            System.err.println("No UPnP devices found");
            System.exit(1);
        }
        System.err.println("Found " + list.size() + " devices.");
        System.err.println("Redirect the following output to an html file and view in a browser.");
        StringBuilder sb = new StringBuilder();
        Iterator it = list.iterator();
        int i = 0;
        while (it.hasNext()) {
            Device device = (Device)it.next();
            cp.listSubDev(device.toString(), device, sb);
            System.out.println("<h3>Device " + ++i + ": " + DataHelper.escapeHTML(device.getFriendlyName()) + "</h3>");
            System.out.println("<p>UDN: " + DataHelper.escapeHTML(device.getUDN()));
            System.out.println("<br>IP: " + UPnP.getIP(device));
            System.out.println(sb.toString());
            sb.setLength(0);
        }
        System.exit(0);
    }

    private final String _t(String s) {
        return Translate.getString(s, this._context, BUNDLE_NAME);
    }

    private final String _t(String s, Object o) {
        return Translate.getString(s, o, this._context, BUNDLE_NAME);
    }

    private final String _t(String s, Object o, Object o2) {
        return Translate.getString(s, o, o2, this._context, BUNDLE_NAME);
    }

    private class RegisterPortsThread
    implements Runnable {
        private Set<ForwardPort> portsToForwardNow;

        public RegisterPortsThread(Set<ForwardPort> ports) {
            this.portsToForwardNow = ports;
        }

        @Override
        public void run() {
            HashMap<ForwardPort, ForwardPortStatus> map = new HashMap<ForwardPort, ForwardPortStatus>(this.portsToForwardNow.size());
            for (ForwardPort port : this.portsToForwardNow) {
                String proto = UPnP.protoToString(port.protocol);
                ForwardPortStatus fps = proto.length() <= 1 ? new ForwardPortStatus(-2, "Protocol not supported", port.portNumber) : (UPnP.this.tryAddMapping(proto, port.portNumber, port.name, port) ? new ForwardPortStatus(1, "Port apparently forwarded by UPnP", port.portNumber) : new ForwardPortStatus(-1, "UPnP port forwarding apparently failed", port.portNumber));
                map.put(port, fps);
            }
            UPnP.this.forwardCallback.portForwardStatus(map);
        }
    }

    private class UnregisterPortsThread
    implements Runnable {
        private Set<ForwardPort> portsToForwardNow;

        public UnregisterPortsThread(Set<ForwardPort> ports) {
            this.portsToForwardNow = ports;
        }

        @Override
        public void run() {
            for (ForwardPort port : this.portsToForwardNow) {
                String proto = UPnP.protoToString(port.protocol);
                if (proto.length() <= 1) continue;
                UPnP.this.removeMapping(proto, port.portNumber, port, false);
            }
        }
    }
}

