/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.io.IOException;
import java.io.Writer;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.crypto.SigType;
import net.i2p.data.Hash;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.TransportBid;
import net.i2p.router.transport.TransportEventListener;
import net.i2p.router.transport.TransportImpl;
import net.i2p.router.transport.UPnPManager;
import net.i2p.router.transport.crypto.DHSessionKeyBuilder;
import net.i2p.router.transport.crypto.X25519KeyFactory;
import net.i2p.router.transport.ntcp.NTCPTransport;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Addresses;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SystemVersion;
import net.i2p.util.Translate;
import net.i2p.util.VersionComparator;

public class TransportManager
implements TransportEventListener {
    private final Log _log;
    private final Map<String, Transport> _transports;
    private final Map<String, Transport> _pluggableTransports;
    private final RouterContext _context;
    private final UPnPManager _upnpManager;
    private final DHSessionKeyBuilder.PrecalcRunner _dhThread;
    private final X25519KeyFactory _xdhThread;
    private final boolean _enableUDP;
    private final boolean _enableNTCP1;
    private boolean _upnpUpdateQueued;
    public static final String PROP_ENABLE_UDP = "i2np.udp.enable";
    public static final String PROP_ENABLE_NTCP = "i2np.ntcp.enable";
    public static final String PROP_ENABLE_UPNP = "i2np.upnp.enable";
    private static final String PROP_NTCP1_ENABLE = "i2np.ntcp1.enable";
    private static final boolean DEFAULT_NTCP1_ENABLE = false;
    private static final String PROP_NTCP2_ENABLE = "i2np.ntcp2.enable";
    private static final boolean DEFAULT_NTCP2_ENABLE = true;
    private static final String PROP_ADVANCED = "routerconsole.advanced";
    private static final long SIGTYPE_BANLIST_DURATION = 129600000L;
    private static final int HIGH_CAPACITY_PCT = 50;
    private static final String BUNDLE_NAME = "net.i2p.router.web.messages";

    public TransportManager(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(TransportManager.class);
        this._context.statManager().createRateStat("transport.banlistOnUnreachable", "Add a peer to the banlist since none of the transports can reach them", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.banlistOnUsupportedSigType", "Add a peer to the banlist since signature type is unsupported", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.noBidsYetNotAllUnreachable", "Add a peer to the banlist since none of the transports can reach them", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.bidFailBanlisted", "Could not attempt to bid on message, as they were banlisted", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.bidFailSelf", "Could not attempt to bid on message, as it targeted ourselves", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.bidFailNoTransports", "Could not attempt to bid on message, as none of the transports could attempt it", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.bidFailAllTransports", "Could not attempt to bid on message, as all of the transports had failed", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._transports = new ConcurrentHashMap<String, Transport>(2);
        this._pluggableTransports = new HashMap<String, Transport>(2);
        this._upnpManager = this._context.getBooleanPropertyDefaultTrue(PROP_ENABLE_UPNP) ? new UPnPManager(context, this) : null;
        this._enableUDP = this._context.getBooleanPropertyDefaultTrue(PROP_ENABLE_UDP);
        this._enableNTCP1 = TransportManager.isNTCPEnabled(context) && context.getProperty(PROP_NTCP1_ENABLE, false);
        boolean enableNTCP2 = TransportManager.isNTCPEnabled(context) && context.getProperty(PROP_NTCP2_ENABLE, true);
        this._dhThread = this._enableUDP || enableNTCP2 ? new DHSessionKeyBuilder.PrecalcRunner(context) : null;
        this._xdhThread = enableNTCP2 ? new X25519KeyFactory(context) : null;
    }

    synchronized void registerAndStart(Transport t) {
        String style = t.getStyle();
        if (style.equals("NTCP") || style.equals("SSU")) {
            throw new IllegalArgumentException("Builtin transport");
        }
        if (this._transports.containsKey(style) || this._pluggableTransports.containsKey(style)) {
            throw new IllegalStateException("Dup transport");
        }
        boolean shouldStart = !this._transports.isEmpty();
        this._pluggableTransports.put(style, t);
        this.addTransport(t);
        t.setListener(this);
        if (shouldStart) {
            this.initializeAddress(t);
            t.startListening();
            this._context.router().rebuildRouterInfo();
        }
    }

    synchronized void stopAndUnregister(Transport t) {
        String style = t.getStyle();
        if (style.equals("NTCP") || style.equals("SSU")) {
            throw new IllegalArgumentException("Builtin transport");
        }
        t.setListener(null);
        this._pluggableTransports.remove(style);
        this.removeTransport(t);
        t.stopListening();
        this._context.router().rebuildRouterInfo();
    }

    DHSessionKeyBuilder.Factory getDHFactory() {
        return this._dhThread;
    }

    private void addTransport(Transport transport) {
        if (transport == null) {
            return;
        }
        Transport old = this._transports.put(transport.getStyle(), transport);
        if (old != null && old != transport && this._log.shouldLog(30)) {
            this._log.warn("Replacing transport " + transport.getStyle());
        }
        transport.setListener(this);
    }

    private void removeTransport(Transport transport) {
        if (transport == null) {
            return;
        }
        transport.setListener(null);
        Transport old = this._transports.remove(transport.getStyle());
        if (old != null && this._log.shouldLog(30)) {
            this._log.warn("Removing transport " + transport.getStyle());
        }
    }

    private void configTransports() {
        UDPTransport udp = null;
        if (this._enableUDP) {
            udp = new UDPTransport(this._context, this._dhThread);
            this.addTransport(udp);
            this.initializeAddress(udp);
        }
        if (TransportManager.isNTCPEnabled(this._context)) {
            DHSessionKeyBuilder.PrecalcRunner dh = this._enableNTCP1 ? this._dhThread : null;
            NTCPTransport ntcp = new NTCPTransport(this._context, dh, this._xdhThread);
            this.addTransport(ntcp);
            this.initializeAddress(ntcp);
            if (udp != null) {
                int port = udp.getRequestedPort();
                if (port > 0) {
                    ntcp.externalAddressReceived(Transport.AddressSource.SOURCE_CONFIG, null, port);
                }
            } else {
                int port = ntcp.getRequestedPort();
                if (port > 0) {
                    ntcp.externalAddressReceived(Transport.AddressSource.SOURCE_CONFIG, null, port);
                }
            }
        }
        if (this._transports.isEmpty()) {
            this._log.log(50, "No transports are enabled");
        }
    }

    public static boolean isNTCPEnabled(RouterContext ctx) {
        return ctx.getBooleanPropertyDefaultTrue(PROP_ENABLE_NTCP);
    }

    private void initializeAddress(Transport t) {
        this.initializeAddress(Collections.singleton(t));
    }

    void initializeAddress() {
        this.initializeAddress(this._transports.values());
    }

    private void initializeAddress(Collection<Transport> ts) {
        if (ts.isEmpty()) {
            return;
        }
        SortedSet<String> ipset = Addresses.getAddresses(this._context.getBooleanProperty("i2np.allowLocal"), false, true);
        String lastv4 = this._context.getProperty("i2np.lastIP");
        String lastv6 = this._context.getProperty("i2np.lastIPv6");
        boolean preferTemp = this._context.getBooleanProperty("i2np.laptopMode");
        boolean hasPreferredV6Address = false;
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>(4);
        ArrayList<Inet6Address> nonPreferredV6Addresses = new ArrayList<Inet6Address>(4);
        for (String ips : ipset) {
            try {
                InetAddress addr = InetAddress.getByName(ips);
                if (ips.contains(":") && addr instanceof Inet6Address) {
                    Inet6Address v6addr = (Inet6Address)addr;
                    boolean isTemp = Addresses.isTemporary(v6addr);
                    if (preferTemp) {
                        if (!isTemp) {
                            nonPreferredV6Addresses.add(v6addr);
                            continue;
                        }
                    } else if (isTemp && !ips.equals(lastv6)) {
                        nonPreferredV6Addresses.add(v6addr);
                        continue;
                    }
                    hasPreferredV6Address = true;
                }
                if (ips.equals(lastv4) || ips.equals(lastv6)) {
                    addresses.add(0, addr);
                    continue;
                }
                addresses.add(addr);
            }
            catch (UnknownHostException e) {
                this._log.error("UDP failed to bind to local address", e);
            }
        }
        if (!nonPreferredV6Addresses.isEmpty()) {
            if (hasPreferredV6Address) {
                if (this._log.shouldWarn()) {
                    for (Inet6Address addr : nonPreferredV6Addresses) {
                        this._log.warn("Not binding to address " + addr.getHostAddress());
                    }
                }
            } else {
                addresses.addAll(nonPreferredV6Addresses);
            }
        }
        if (this._log.shouldWarn()) {
            for (InetAddress ia : addresses) {
                this._log.warn("Transport address: " + ia.getHostAddress());
            }
        }
        for (Transport t : ts) {
            boolean hasv4 = false;
            boolean hasv6 = false;
            for (InetAddress ia : addresses) {
                byte[] ip = ia.getAddress();
                if (ip.length == 4) {
                    if (hasv4) continue;
                    hasv4 = true;
                } else {
                    if (hasv6) continue;
                    hasv6 = true;
                }
                t.externalAddressReceived(Transport.AddressSource.SOURCE_INTERFACE, ip, 0);
            }
        }
    }

    void externalAddressReceived(Transport.AddressSource source, byte[] ip, int port) {
        for (Transport t : this._transports.values()) {
            if (source == Transport.AddressSource.SOURCE_SSU && t.getStyle().equals("SSU")) continue;
            t.externalAddressReceived(source, ip, port);
        }
    }

    void externalAddressRemoved(Transport.AddressSource source, boolean ipv6) {
        for (Transport t : this._transports.values()) {
            if (source == Transport.AddressSource.SOURCE_SSU && t.getStyle().equals("SSU")) continue;
            t.externalAddressRemoved(source, ipv6);
        }
    }

    void forwardPortStatus(String style, byte[] ip, int port, int externalPort, boolean success, String reason) {
        Transport t = this.getTransport(style);
        if (t != null) {
            t.forwardPortStatus(ip, port, externalPort, success, reason);
        }
    }

    synchronized void startListening() {
        if (this._dhThread != null && this._dhThread.getState() == Thread.State.NEW) {
            this._dhThread.start();
        }
        if (this._xdhThread != null && this._xdhThread.getState() == Thread.State.NEW) {
            this._xdhThread.start();
        }
        if (this._upnpManager != null && (SystemVersion.isAndroid() || Addresses.getAnyAddress() == null)) {
            this._upnpManager.start();
        }
        this.configTransports();
        this._log.debug("Starting up the transport manager");
        ArrayList<Transport> tps = new ArrayList<Transport>();
        Transport tp = this.getTransport("NTCP");
        if (tp != null) {
            tps.add(tp);
        }
        if ((tp = this.getTransport("SSU")) != null) {
            tps.add(tp);
        }
        for (Transport t : this._pluggableTransports.values()) {
            tps.add(t);
        }
        for (Transport t : tps) {
            t.startListening();
            if (!this._log.shouldLog(10)) continue;
            this._log.debug("Transport " + t.getStyle() + " started");
        }
        this.transportAddressChanged();
        this._log.debug("Done start listening on transports");
        this._context.router().rebuildRouterInfo();
    }

    synchronized void restart() {
        this.stopListening();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.startListening();
    }

    synchronized void stopListening() {
        if (this._upnpManager != null) {
            this._upnpManager.stop();
        }
        for (Transport t : this._transports.values()) {
            t.stopListening();
        }
        this._transports.clear();
    }

    synchronized void shutdown() {
        this.stopListening();
        if (this._dhThread != null) {
            this._dhThread.shutdown();
        }
        if (this._xdhThread != null) {
            this._xdhThread.shutdown();
        }
        Addresses.clearCaches();
        TransportImpl.clearCaches();
    }

    Transport getTransport(String style) {
        return this._transports.get(style);
    }

    int getTransportCount() {
        return this._transports.size();
    }

    SortedMap<String, Transport> getTransports() {
        TreeMap<String, Transport> rv = new TreeMap<String, Transport>();
        rv.putAll(this._transports);
        return rv;
    }

    int countActivePeers() {
        int peers = 0;
        for (Transport t : this._transports.values()) {
            peers += t.countActivePeers();
        }
        return peers;
    }

    int countActiveSendPeers() {
        int peers = 0;
        for (Transport t : this._transports.values()) {
            peers += t.countActiveSendPeers();
        }
        return peers;
    }

    boolean haveOutboundCapacity(int pct) {
        for (Transport t : this._transports.values()) {
            if (!t.haveCapacity(pct)) continue;
            return true;
        }
        return false;
    }

    boolean haveHighOutboundCapacity() {
        if (this._transports.isEmpty()) {
            return false;
        }
        for (Transport t : this._transports.values()) {
            if (t.haveCapacity(50)) continue;
            return false;
        }
        return true;
    }

    boolean haveInboundCapacity(int pct) {
        for (Transport t : this._transports.values()) {
            if (!t.hasCurrentAddress() || !t.haveCapacity(pct)) continue;
            return true;
        }
        return false;
    }

    Vector<Long> getClockSkews() {
        Vector<Long> skews = new Vector<Long>();
        for (Transport t : this._transports.values()) {
            Vector<Long> tempSkews = t.getClockSkews();
            if (tempSkews == null || tempSkews.isEmpty()) continue;
            skews.addAll(tempSkews);
        }
        return skews;
    }

    CommSystemFacade.Status getReachabilityStatus() {
        CommSystemFacade.Status rv = CommSystemFacade.Status.UNKNOWN;
        for (Transport t : this._transports.values()) {
            CommSystemFacade.Status s = t.getReachabilityStatus();
            if (s.getCode() >= rv.getCode()) continue;
            rv = s;
        }
        return rv;
    }

    @Deprecated
    void recheckReachability() {
        for (Transport t : this._transports.values()) {
            t.recheckReachability();
        }
    }

    boolean isBacklogged(Hash peer) {
        for (Transport t : this._transports.values()) {
            if (!t.isBacklogged(peer)) continue;
            return true;
        }
        return false;
    }

    boolean isEstablished(Hash peer) {
        for (Transport t : this._transports.values()) {
            if (!t.isEstablished(peer)) continue;
            return true;
        }
        return false;
    }

    public Set<Hash> getEstablished() {
        Transport t = this._transports.get("NTCP");
        Set<Hash> rv = t != null ? t.getEstablished() : new HashSet<Hash>(256);
        t = this._transports.get("SSU");
        if (t != null) {
            rv.addAll(t.getEstablished());
        }
        return rv;
    }

    void mayDisconnect(Hash peer) {
        for (Transport t : this._transports.values()) {
            t.mayDisconnect(peer);
        }
    }

    void forceDisconnect(Hash peer) {
        for (Transport t : this._transports.values()) {
            t.forceDisconnect(peer);
        }
    }

    boolean wasUnreachable(Hash peer) {
        for (Transport t : this._transports.values()) {
            if (t.wasUnreachable(peer)) continue;
            return false;
        }
        return true;
    }

    byte[] getIP(Hash peer) {
        return TransportImpl.getIP(peer);
    }

    List<RouterAddress> getAddresses() {
        ArrayList<RouterAddress> rv = new ArrayList<RouterAddress>(4);
        for (Transport t : this._transports.values()) {
            t.updateAddress();
        }
        for (Transport t : this._transports.values()) {
            rv.addAll(t.getCurrentAddresses());
        }
        return rv;
    }

    private Set<Port> getPorts() {
        HashSet<Port> rv = new HashSet<Port>(4);
        for (Transport t : this._transports.values()) {
            Transport udp;
            int port = t.getRequestedPort();
            if (t.getStyle().equals("NTCP") && port <= 0 && this._context.getBooleanProperty("i2np.ntcp.autoport") && (udp = this.getTransport("SSU")) != null) {
                port = udp.getRequestedPort();
            }
            if (port <= 0) continue;
            rv.add(new Port(t.getStyle(), port));
        }
        return rv;
    }

    TransportBid getBid(OutNetMessage msg) {
        List<TransportBid> bids = this.getBids(msg);
        if (bids == null || bids.isEmpty()) {
            return null;
        }
        return bids.get(0);
    }

    List<TransportBid> getBids(OutNetMessage msg) {
        if (msg == null) {
            throw new IllegalArgumentException("Null message?  no bidding on a null outNetMessage!");
        }
        if (this._context.router().getRouterInfo().equals(msg.getTarget())) {
            throw new IllegalArgumentException("Bids for a message bound to ourselves?");
        }
        ArrayList<TransportBid> rv = new ArrayList<TransportBid>(this._transports.size());
        Set<String> failedTransports = msg.getFailedTransports();
        for (Transport t : this._transports.values()) {
            if (failedTransports.contains(t.getStyle())) {
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Skipping transport " + t.getStyle() + " as it already failed");
                continue;
            }
            TransportBid bid = t.bid(msg.getTarget(), msg.getMessageSize());
            if (bid != null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Transport " + t.getStyle() + " bid: " + bid);
                }
                rv.add(bid);
                continue;
            }
            if (!this._log.shouldLog(10)) continue;
            this._log.debug("Transport " + t.getStyle() + " did not produce a bid");
        }
        return rv;
    }

    TransportBid getNextBid(OutNetMessage msg) {
        int unreachableTransports = 0;
        Hash peer = msg.getTarget().getIdentity().calculateHash();
        Set<String> failedTransports = msg.getFailedTransports();
        TransportBid rv = null;
        for (Transport t : this._transports.values()) {
            if (t.isUnreachable(peer)) {
                ++unreachableTransports;
                msg.transportFailed(t.getStyle());
                continue;
            }
            if (failedTransports.contains(t.getStyle())) {
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Skipping transport " + t.getStyle() + " as it already failed");
                continue;
            }
            TransportBid bid = t.bid(msg.getTarget(), msg.getMessageSize());
            if (bid != null) {
                if (bid.getLatencyMs() == 999999) {
                    msg.transportFailed(t.getStyle());
                } else if (rv == null || rv.getLatencyMs() > bid.getLatencyMs()) {
                    rv = bid;
                }
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Transport " + t.getStyle() + " bid: " + bid + " currently winning? " + (rv == bid) + " (winning latency: " + rv.getLatencyMs() + " / " + rv + ")");
                continue;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Transport " + t.getStyle() + " did not produce a bid");
            }
            if (!t.isUnreachable(peer)) continue;
            ++unreachableTransports;
        }
        if (unreachableTransports >= this._transports.size()) {
            if (msg.getTarget().getIdentity().getSigningPublicKey().getType() == null) {
                this._context.statManager().addRateData("transport.banlistOnUnsupportedSigType", 1L);
                this._context.banlist().banlistRouterForever(peer, TransportManager._x("Unsupported signature type"));
            } else if (unreachableTransports >= this._transports.size() && this.countActivePeers() > 0) {
                String v;
                RouterIdentity id;
                boolean incompat = false;
                RouterInfo us = this._context.router().getRouterInfo();
                if (us != null && (id = us.getIdentity()).getSigType() != SigType.DSA_SHA1 && VersionComparator.comp(v = msg.getTarget().getVersion(), "0.9.16") < 0) {
                    incompat = true;
                }
                if (incompat) {
                    this._context.statManager().addRateData("transport.banlistOnUnsupportedSigType", 1L);
                    this._context.banlist().banlistRouter(peer, TransportManager._x("No support for our signature type"), null, null, this._context.clock().now() + 129600000L);
                } else {
                    this._context.statManager().addRateData("transport.banlistOnUnreachable", msg.getLifetime(), msg.getLifetime());
                    this._context.banlist().banlistRouter(peer, TransportManager._x("Unreachable on any transport"));
                }
            }
        } else if (rv == null) {
            this._context.statManager().addRateData("transport.noBidsYetNotAllUnreachable", unreachableTransports, msg.getLifetime());
        }
        return rv;
    }

    @Override
    public void messageReceived(I2NPMessage message, RouterIdentity fromRouter, Hash fromRouterHash) {
        block3: {
            if (this._log.shouldLog(10)) {
                this._log.debug("I2NPMessage received: " + message.getClass().getSimpleName());
            }
            try {
                this._context.inNetMessagePool().add(message, fromRouter, fromRouterHash);
            }
            catch (IllegalArgumentException iae) {
                if (!this._log.shouldLog(30)) break block3;
                this._log.warn("Error receiving message", iae);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transportAddressChanged() {
        if (this._upnpManager != null) {
            UPnPManager uPnPManager = this._upnpManager;
            synchronized (uPnPManager) {
                if (!this._upnpUpdateQueued) {
                    boolean shouldWait = this._upnpManager.rescan();
                    if (shouldWait) {
                        this._upnpUpdateQueued = true;
                        this._context.simpleTimer2().addEvent(new UpdatePorts(), 3250L);
                    } else {
                        this._upnpManager.update(this.getPorts());
                    }
                }
            }
        }
    }

    List<String> getMostRecentErrorMessages() {
        ArrayList<String> rv = new ArrayList<String>(16);
        for (Transport t : this._transports.values()) {
            rv.addAll(t.getMostRecentErrorMessages());
        }
        return rv;
    }

    public void renderStatusHTML(Writer out, String urlBase, int sortFlags) throws IOException {
        if (!SystemVersion.isAndroid()) {
            if (this._upnpManager != null) {
                out.write(this._upnpManager.renderStatusHTML());
            } else {
                out.write("<h3 id=\"upnpstatus\"><a name=\"upnp\"></a>" + this._t("UPnP is not enabled") + "</h3>\n");
            }
        }
    }

    private static final String _x(String s) {
        return s;
    }

    private final String _t(String s) {
        return Translate.getString(s, this._context, BUNDLE_NAME);
    }

    static class Port {
        public final String style;
        public final int port;

        public Port(String style, int port) {
            this.style = style;
            this.port = port;
        }

        public int hashCode() {
            return this.style.hashCode() ^ this.port;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Port)) {
                return false;
            }
            Port p = (Port)o;
            return this.port == p.port && this.style.equals(p.style);
        }
    }

    private class UpdatePorts
    implements SimpleTimer.TimedEvent {
        private UpdatePorts() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void timeReached() {
            UPnPManager uPnPManager = TransportManager.this._upnpManager;
            synchronized (uPnPManager) {
                TransportManager.this._upnpUpdateQueued = false;
                TransportManager.this._upnpManager.update(TransportManager.this.getPorts());
            }
        }
    }
}

