/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;
import net.i2p.data.i2cp.SessionId;

public class SessionStatusMessage
extends I2CPMessageImpl {
    public static final int MESSAGE_TYPE = 20;
    private SessionId _sessionId;
    private int _status;
    public static final int STATUS_DESTROYED = 0;
    public static final int STATUS_CREATED = 1;
    public static final int STATUS_UPDATED = 2;
    public static final int STATUS_INVALID = 3;
    public static final int STATUS_REFUSED = 4;

    public SessionStatusMessage() {
        this.setStatus(3);
    }

    public SessionId getSessionId() {
        return this._sessionId;
    }

    @Override
    public SessionId sessionId() {
        return this._sessionId;
    }

    public void setSessionId(SessionId id) {
        this._sessionId = id;
    }

    public int getStatus() {
        return this._status;
    }

    public void setStatus(int status) {
        this._status = status;
    }

    @Override
    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        try {
            this._sessionId = new SessionId();
            this._sessionId.readBytes(in);
            this._status = in.read();
            if (this._status < 0) {
                throw new EOFException();
            }
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to load the message data", dfe);
        }
    }

    @Override
    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        if (this._sessionId == null) {
            throw new I2CPMessageException("Unable to write out the message as there is not enough data");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(64);
        try {
            this._sessionId.writeBytes(os);
            os.write((byte)this._status);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error writing out the message data", dfe);
        }
        return os.toByteArray();
    }

    @Override
    public int getType() {
        return 20;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[SessionStatusMessage: ");
        buf.append("\n\tSessionId: ").append(this.getSessionId());
        buf.append("\n\tStatus: ").append(this.getStatus());
        buf.append("]");
        return buf.toString();
    }
}

