/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.util.Arrays;
import javax.security.auth.Destroyable;
import net.i2p.crypto.EncType;
import net.i2p.crypto.KeyGenerator;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.PublicKey;
import net.i2p.data.SimpleDataStructure;
import net.i2p.util.SimpleByteCache;

public class PrivateKey
extends SimpleDataStructure
implements Destroyable {
    private static final EncType DEF_TYPE = EncType.ELGAMAL_2048;
    public static final int KEYSIZE_BYTES = DEF_TYPE.getPrivkeyLen();
    private final EncType _type;

    public PrivateKey() {
        this(DEF_TYPE);
    }

    public PrivateKey(EncType type) {
        this._type = type;
    }

    public PrivateKey(byte[] data) {
        this(DEF_TYPE, data);
    }

    public PrivateKey(EncType type, byte[] data) {
        this(type);
        if (data == null) {
            throw new IllegalArgumentException("Data must be specified");
        }
        this.setData(data);
    }

    public PrivateKey(String base64Data) throws DataFormatException {
        this(DEF_TYPE);
        this.fromBase64(base64Data);
    }

    @Override
    public int length() {
        return this._type.getPrivkeyLen();
    }

    public EncType getType() {
        return this._type;
    }

    public PublicKey toPublic() {
        return KeyGenerator.getPublicKey(this);
    }

    @Override
    public void destroy() {
        byte[] data = this._data;
        if (data != null) {
            this._data = null;
            Arrays.fill(data, (byte)0);
            SimpleByteCache.release(data);
        }
    }

    @Override
    public boolean isDestroyed() {
        return this._data == null;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("[PrivateKey ").append((Object)this._type).append(' ');
        if (this._data == null) {
            buf.append("null");
        } else {
            int length = this.length();
            if (length <= 32) {
                buf.append(this.toBase64());
            } else {
                buf.append("size: ").append(length);
            }
        }
        buf.append(']');
        return buf.toString();
    }

    @Override
    public int hashCode() {
        if (this._data == null) {
            return 0;
        }
        if (this._type != DEF_TYPE) {
            return DataHelper.hashCode(this._data);
        }
        int rv = this._data[KEYSIZE_BYTES - 4];
        for (int i = 1; i < 4; ++i) {
            rv ^= this._data[i + (KEYSIZE_BYTES - 4)] << i * 8;
        }
        return rv;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof PrivateKey)) {
            return false;
        }
        PrivateKey p = (PrivateKey)obj;
        return this._type == p._type && Arrays.equals(this._data, p._data);
    }
}

