/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Random;
import net.i2p.data.DataHelper;
import net.i2p.util.Log;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.Peer;
import org.klomp.snark.PeerCoordinator;
import org.klomp.snark.Storage;
import org.klomp.snark.dht.DHT;

class PeerCheckerTask
implements Runnable {
    private static final long KILOPERSECOND = 40960L;
    private final PeerCoordinator coordinator;
    private final I2PSnarkUtil _util;
    private final Log _log;
    private final Random random;
    private int _runCount;

    PeerCheckerTask(I2PSnarkUtil util, PeerCoordinator coordinator) {
        this._util = util;
        this._log = util.getContext().logManager().getLog(PeerCheckerTask.class);
        this.random = util.getContext().random();
        this.coordinator = coordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void run() {
        Storage storage;
        ++this._runCount;
        List<Peer> peerList = this.coordinator.peerList();
        if (peerList.isEmpty() || this.coordinator.halted()) {
            this.coordinator.setRateHistory(0L, 0L);
            return;
        }
        long worstdownload = Long.MAX_VALUE;
        Peer worstDownloader = null;
        int uploaders = 0;
        int interestedUploaders = 0;
        int removedCount = 0;
        long uploaded = 0L;
        long downloaded = 0L;
        ArrayList<Peer> removed = new ArrayList<Peer>();
        int uploadLimit = this.coordinator.allowedUploaders();
        boolean overBWLimit = this.coordinator.overUpBWLimit();
        if (this._log.shouldLog(10)) {
            this._log.debug("START peers: " + peerList.size() + " uploaders: " + this.coordinator.getUploaders() + " interested: " + this.coordinator.getInterestedUploaders() + " limit: " + uploadLimit + " overBW? " + overBWLimit);
        }
        DHT dht = this._util.getDHT();
        boolean fetchComments = this._util.utCommentsEnabled();
        int i = 0;
        for (Peer peer : peerList) {
            ++i;
            if (!peer.isConnected()) continue;
            if (peer.getInactiveTime() > peer.getMaxInactiveTime()) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Disconnecting peer idle " + DataHelper.formatDuration(peer.getInactiveTime()) + ": " + peer);
                }
                peer.disconnect();
                continue;
            }
            if (peer.isInterested() && !peer.isChoking()) {
                ++uploaders;
            }
            long upload = peer.getUploaded();
            uploaded += upload;
            long download = peer.getDownloaded();
            downloaded += download;
            peer.setRateHistory(upload, download);
            peer.resetCounters();
            if (this._log.shouldLog(10)) {
                this._log.debug(peer + ": ul: " + upload * 1024L / 40960L + " dl: " + download * 1024L / 40960L + " i: " + peer.isInterested() + " I: " + peer.isInteresting() + " c: " + peer.isChoking() + " C: " + peer.isChoked());
            }
            boolean overBWLimitChoke = upload > 0L && (overBWLimit && this.random.nextInt(8) > (this.coordinator.completed() ? 2 : 4) || this.coordinator.overUpBWLimit(uploaded));
            int cup = this.coordinator.getUploaders();
            if ((cup == uploadLimit && this.coordinator.getInterestedAndChoking() > 0 || cup > uploadLimit || overBWLimitChoke) && !peer.isChoking()) {
                if (!peer.isInterested()) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Choke uninterested peer: " + peer);
                    }
                    peer.setChoking(true);
                    --uploaders;
                    this.coordinator.decrementUploaders(false);
                    removed.add(peer);
                } else if (overBWLimitChoke) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("BW limit (" + upload + "/" + uploaded + "), choke peer: " + peer);
                    }
                    peer.setChoking(true);
                    --uploaders;
                    --interestedUploaders;
                    this.coordinator.decrementUploaders(true);
                    ++removedCount;
                    removed.add(peer);
                } else if (peer.isInteresting() && peer.isChoked()) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Choke choking peer: " + peer);
                    }
                    peer.setChoking(true);
                    --uploaders;
                    --interestedUploaders;
                    this.coordinator.decrementUploaders(true);
                    ++removedCount;
                    removed.add(peer);
                } else if (!peer.isInteresting() && !this.coordinator.completed()) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Choke uninteresting peer: " + peer);
                    }
                    peer.setChoking(true);
                    --uploaders;
                    --interestedUploaders;
                    this.coordinator.decrementUploaders(true);
                    ++removedCount;
                    removed.add(peer);
                } else if (peer.isInteresting() && !peer.isChoked() && download == 0L) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Choke downloader that doesn't deliver: " + peer);
                    }
                    peer.setChoking(true);
                    --uploaders;
                    --interestedUploaders;
                    this.coordinator.decrementUploaders(true);
                    ++removedCount;
                    removed.add(peer);
                } else if (peer.isInteresting() && !peer.isChoked() && download < worstdownload) {
                    worstdownload = download;
                    worstDownloader = peer;
                } else if (upload < worstdownload && this.coordinator.completed()) {
                    worstdownload = upload;
                    worstDownloader = peer;
                }
            }
            peer.retransmitRequests();
            if ((this._runCount + i) % 17 == 0 && !peer.isCompleted()) {
                this.coordinator.sendPeers(peer);
            }
            if (fetchComments && (this._runCount + i) % 47 == 0) {
                this.coordinator.sendCommentReq(peer);
            }
            if (this.coordinator.getNeededLength() > 0L || !peer.isCompleted()) {
                peer.keepAlive();
            }
            if (dht == null || this._runCount % 5 != 0) continue;
            dht.announce(this.coordinator.getInfoHash(), peer.getPeerID().getDestHash(), peer.isCompleted());
        }
        this.coordinator.setUploaders(uploaders, interestedUploaders);
        if ((uploaders == uploadLimit && this.coordinator.getInterestedAndChoking() > 0 || uploaders > uploadLimit) && worstDownloader != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Choke worst downloader: " + worstDownloader);
            }
            worstDownloader.setChoking(true);
            this.coordinator.decrementUploaders(worstDownloader.isInterested());
            ++removedCount;
            removed.add(worstDownloader);
        }
        boolean coordOver = this.coordinator.overUpBWLimit(uploaded);
        Deque<Peer> deque = this.coordinator.peers;
        synchronized (deque) {
            if (!overBWLimit && !coordOver) {
                this.coordinator.unchokePeer();
            }
            for (Peer peer : removed) {
                if (!this.coordinator.peers.remove(peer)) continue;
                this.coordinator.peers.add(peer);
            }
        }
        this.coordinator.addInterestedAndChoking(removedCount);
        this.coordinator.setRateHistory(uploaded, downloaded);
        if (this._log.shouldLog(10)) {
            this._log.debug("END peers: " + peerList.size() + " uploaders: " + uploaders + " interested: " + interestedUploaders);
        }
        if ((storage = this.coordinator.getStorage()) != null) {
            void var21_32;
            int files = storage.getFileCount();
            if (files == 1) {
                int n = 6;
            } else if (files <= 4) {
                int n = 4;
            } else if (files <= 20) {
                int n = 3;
            } else if (files <= 50) {
                int n = 2;
            } else {
                boolean bl = true;
            }
            if (this._runCount % var21_32 == 0) {
                storage.cleanRAFs();
            }
        }
        if (dht != null && this._runCount % 16 == 0) {
            dht.announce(this.coordinator.getInfoHash(), this.coordinator.completed());
        }
    }
}

