/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import net.i2p.crypto.EncType;
import net.i2p.data.DataFormatException;
import net.i2p.data.SDSCache;
import net.i2p.data.SimpleDataStructure;

public class PublicKey
extends SimpleDataStructure {
    private static final EncType DEF_TYPE = EncType.ELGAMAL_2048;
    public static final int KEYSIZE_BYTES = DEF_TYPE.getPubkeyLen();
    private static final int CACHE_SIZE = 1024;
    private static final SDSCache<PublicKey> _cache = new SDSCache<PublicKey>(PublicKey.class, KEYSIZE_BYTES, 1024);
    private final EncType _type;
    private final int _unknownTypeCode;

    public static PublicKey create(byte[] data, int off) {
        return _cache.get(data, off);
    }

    public static PublicKey create(InputStream in) throws IOException {
        return _cache.get(in);
    }

    public PublicKey() {
        this(DEF_TYPE);
    }

    public PublicKey(EncType type) {
        this._type = type;
        this._unknownTypeCode = type != null ? type.getCode() : -1;
    }

    public PublicKey(byte[] data) {
        this(DEF_TYPE, data);
    }

    public PublicKey(EncType type, byte[] data) {
        this(type);
        if (data == null) {
            throw new IllegalArgumentException("Data must be specified");
        }
        this.setData(data);
    }

    public PublicKey(int typeCode, byte[] data) {
        this._type = null;
        if (data == null) {
            throw new IllegalArgumentException("Data must be specified");
        }
        this._data = data;
        if (typeCode <= 0 || typeCode > 255) {
            throw new IllegalArgumentException();
        }
        this._unknownTypeCode = typeCode;
    }

    public PublicKey(String base64Data) throws DataFormatException {
        this(DEF_TYPE);
        this.fromBase64(base64Data);
    }

    @Override
    public int length() {
        if (this._type != null) {
            return this._type.getPubkeyLen();
        }
        if (this._data != null) {
            return this._data.length;
        }
        return KEYSIZE_BYTES;
    }

    public EncType getType() {
        return this._type;
    }

    public int getUnknownTypeCode() {
        return this._unknownTypeCode;
    }

    public static void clearCache() {
        _cache.clear();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("[PublicKey ").append(this._type != null ? this._type.toString() : "unknown type: " + this._unknownTypeCode).append(' ');
        if (this._data == null) {
            buf.append("null");
        } else {
            int length = this.length();
            if (length <= 32) {
                buf.append(this.toBase64());
            } else {
                buf.append("size: ").append(length);
            }
        }
        buf.append(']');
        return buf.toString();
    }
}

