/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.util.Date;
import net.i2p.I2PAppContext;
import net.i2p.crypto.Blinding;
import net.i2p.crypto.SigType;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.PrivateKey;
import net.i2p.data.RoutingKeyGenerator;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;

public class BlindData {
    private final I2PAppContext _context;
    private final SigningPublicKey _clearSPK;
    private final String _secret;
    private SigningPublicKey _blindSPK;
    private final SigType _blindType;
    private final int _authType;
    private final PrivateKey _authKey;
    private Hash _blindHash;
    private SigningPrivateKey _alpha;
    private Destination _dest;
    private long _routingKeyGenMod;
    private boolean _secretRequired;
    private boolean _authRequired;
    private long _date;
    private String _b32;
    public static final int AUTH_NONE = 0;
    public static final int AUTH_DH = 1;
    public static final int AUTH_PSK = 3;
    public static final int AUTH_ON = 999;

    public BlindData(I2PAppContext ctx, Destination dest, SigType blindType, String secret) {
        this(ctx, dest, blindType, secret, 0, null);
    }

    public BlindData(I2PAppContext ctx, Destination dest, SigType blindType, String secret, int authType, PrivateKey authKey) {
        this(ctx, dest.getSigningPublicKey(), blindType, secret, authType, authKey);
        this._dest = dest;
    }

    public BlindData(I2PAppContext ctx, SigningPublicKey spk, SigType blindType, String secret) {
        this(ctx, spk, blindType, secret, 0, null);
    }

    public BlindData(I2PAppContext ctx, SigningPublicKey spk, SigType blindType, String secret, int authType, PrivateKey authKey) {
        this._context = ctx;
        this._clearSPK = spk;
        this._blindType = blindType;
        this._secret = secret;
        if (authType < 0) {
            authType = 0;
        }
        if (authType != 0 && authKey == null || authType == 0 && authKey != null) {
            throw new IllegalArgumentException();
        }
        this._authType = authType;
        this._authKey = authKey;
        if (secret != null) {
            this._secretRequired = true;
        }
        if (authKey != null) {
            this._authRequired = true;
        }
        this._date = this._context.clock().now();
    }

    public SigningPublicKey getUnblindedPubKey() {
        return this._clearSPK;
    }

    public SigType getBlindedSigType() {
        return this._blindType;
    }

    public synchronized SigningPublicKey getBlindedPubKey() {
        this.calculate();
        return this._blindSPK;
    }

    public synchronized Hash getDestHash() {
        return this._dest != null ? this._dest.getHash() : null;
    }

    public synchronized Hash getBlindedHash() {
        this.calculate();
        return this._blindHash;
    }

    public synchronized SigningPrivateKey getAlpha() {
        this.calculate();
        return this._alpha;
    }

    public synchronized Destination getDestination() {
        return this._dest;
    }

    public synchronized void setDestination(Destination d) {
        if (this._dest != null) {
            if (!this._dest.equals(d)) {
                throw new IllegalArgumentException("Dest mismatch");
            }
            return;
        }
        if (!d.getSigningPublicKey().equals(this._clearSPK)) {
            throw new IllegalArgumentException("Dest mismatch");
        }
        this._dest = d;
    }

    public String getSecret() {
        return this._secret;
    }

    public int getAuthType() {
        return this._authType;
    }

    public PrivateKey getAuthPrivKey() {
        return this._authKey;
    }

    private synchronized void calculate() {
        if (this._context.isRouterContext()) {
            RoutingKeyGenerator gen = this._context.routingKeyGenerator();
            long mod = gen.getLastChanged();
            if (mod == this._routingKeyGenMod) {
                return;
            }
            this._routingKeyGenMod = mod;
        }
        this._alpha = Blinding.generateAlpha(this._context, this._clearSPK, this._secret);
        this._blindSPK = Blinding.blind(this._clearSPK, this._alpha);
        SigType bsigt2 = this._blindSPK.getType();
        if (this._blindType != bsigt2) {
            throw new IllegalArgumentException("Requested blinded sig type " + (Object)((Object)this._blindType) + " supported type " + (Object)((Object)bsigt2));
        }
        byte[] hashData = new byte[34];
        DataHelper.toLong(hashData, 0, 2, this._blindType.getCode());
        System.arraycopy(this._blindSPK.getData(), 0, hashData, 2, this._blindSPK.length());
        this._blindHash = this._context.sha().calculateHash(hashData);
    }

    public synchronized String toBase32() {
        if (this._b32 == null) {
            this._b32 = Blinding.encode(this._clearSPK, this._secretRequired, this._authRequired);
        }
        return this._b32;
    }

    public synchronized void setSecretRequired() {
        this._secretRequired = true;
        this._b32 = null;
    }

    public boolean getSecretRequired() {
        return this._secretRequired;
    }

    public synchronized void setAuthRequired() {
        this._authRequired = true;
        this._b32 = null;
    }

    public boolean getAuthRequired() {
        return this._authRequired;
    }

    public void setDate(long date) {
        this._date = date;
    }

    public long getDate() {
        return this._date;
    }

    public synchronized String toString() {
        this.calculate();
        StringBuilder buf = new StringBuilder(1024);
        buf.append("[BlindData: ");
        buf.append("\n\tSigningPublicKey: ").append(this._clearSPK);
        buf.append("\n\tAlpha           : ").append(this._alpha);
        buf.append("\n\tBlindedPublicKey: ").append(this._blindSPK);
        buf.append("\n\tBlinded Hash    : ").append(this._blindHash);
        if (this._secret != null) {
            buf.append("\n\tSecret          : \"").append(this._secret).append('\"');
        } else {
            buf.append("\n\tSecret Required : ").append(this._secretRequired);
        }
        buf.append("\n\tAuth Type       : ");
        if (this._authType > 0) {
            buf.append(this._authType);
        } else {
            buf.append("none");
        }
        if (this._authKey != null) {
            buf.append("\n\tAuth Key   : ").append(this._authKey);
        } else {
            buf.append("\n\tAuth Required   : ").append(this._authRequired);
        }
        if (this._dest != null) {
            buf.append("\n\tDestination     : ").append(this._dest);
        } else {
            buf.append("\n\tDestination     : unknown");
        }
        buf.append("\n\tB32             : ").append(this.toBase32());
        buf.append("\n\tCreated         : ").append(new Date(this._date).toString());
        buf.append(']');
        return buf.toString();
    }
}

