/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import net.i2p.data.DataHelper;

public class Base32 {
    private static final char[] ALPHABET = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '2', '3', '4', '5', '6', '7'};
    private static final byte[] DECODABET = new byte[]{26, 27, 28, 29, 30, 31, -9, -9, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9};
    private static final byte BAD_ENCODING = -9;
    private static final byte[] emask = new byte[]{31, 1, 3, 7, 15};
    private static final byte[] dmask = new byte[]{-8, 124, 62, 31, 15, 7, 3, 1};

    private Base32() {
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            Base32.help();
            return;
        }
        Base32.runApp(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runApp(String[] args) {
        block30: {
            String cmd = args[0].toLowerCase(Locale.US);
            if ("encodestring".equals(cmd)) {
                System.out.println(Base32.encode(DataHelper.getUTF8(args[1])));
                return;
            }
            InputStream in = System.in;
            OutputStream out = System.out;
            try {
                if (args.length >= 3) {
                    out = new FileOutputStream(args[2]);
                }
                if (args.length >= 2) {
                    in = new FileInputStream(args[1]);
                }
                if ("encode".equals(cmd)) {
                    Base32.encode(in, out);
                    return;
                }
                if (!"decode".equals(cmd)) break block30;
                Base32.decode(in, out);
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.err);
                break block30;
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            return;
        }
    }

    private static byte[] read(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(64);
        DataHelper.copy(in, baos);
        return baos.toByteArray();
    }

    private static void encode(InputStream in, OutputStream out) throws IOException {
        String encoded = Base32.encode(Base32.read(in));
        for (int i = 0; i < encoded.length(); ++i) {
            out.write((byte)(encoded.charAt(i) & 0xFF));
        }
    }

    private static void decode(InputStream in, OutputStream out) throws IOException {
        byte[] decoded = Base32.decode(DataHelper.getUTF8(Base32.read(in)));
        if (decoded == null) {
            System.err.println("FAIL");
            return;
        }
        out.write(decoded);
    }

    private static void help() {
        System.out.println("Syntax: Base32 encode <inFile> <outFile>");
        System.out.println("or    : Base32 encode <inFile>");
        System.out.println("or    : Base32 encodestring <string>");
        System.out.println("or    : Base32 encode");
        System.out.println("or    : Base32 decode <inFile> <outFile>");
        System.out.println("or    : Base32 decode <inFile>");
        System.out.println("or    : Base32 decode");
    }

    public static String encode(String source) {
        return source != null ? Base32.encode(DataHelper.getUTF8(source)) : "";
    }

    public static String encode(byte[] source) {
        StringBuilder buf = new StringBuilder((source.length + 7) * 8 / 5);
        Base32.encodeBytes(source, buf);
        return buf.toString();
    }

    private static void encodeBytes(byte[] source, StringBuilder out) {
        int usedbits = 0;
        int i = 0;
        while (i < source.length) {
            int fivebits;
            if (usedbits < 3) {
                fivebits = source[i] >> 3 - usedbits & 0x1F;
                usedbits += 5;
            } else if (usedbits == 3) {
                fivebits = source[i++] & 0x1F;
                usedbits = 0;
            } else {
                fivebits = source[i++] << usedbits - 3 & 0x1F;
                if (i < source.length) {
                    fivebits |= source[i] >> 8 - (usedbits -= 3) & emask[usedbits];
                }
            }
            out.append(ALPHABET[fivebits]);
        }
    }

    public static String decodeToString(String s) {
        byte[] b = Base32.decode(s);
        if (b == null) {
            return null;
        }
        return DataHelper.getUTF8(b);
    }

    public static byte[] decode(String s) {
        return Base32.decode(DataHelper.getASCII(s));
    }

    private static byte[] decode(byte[] source) {
        int len58 = source.length <= 1 ? source.length : source.length * 5 / 8;
        byte[] outBuff = new byte[len58];
        int outBuffPosn = 0;
        int usedbits = 0;
        for (int i = 0; i < source.length; ++i) {
            int fivebits = (source[i] & 0x80) != 0 || source[i] < 50 || source[i] > 122 ? -9 : DECODABET[source[i] - 50];
            if (fivebits >= 0) {
                if (usedbits == 0) {
                    outBuff[outBuffPosn] = (byte)(fivebits << 3 & 0xF8);
                    usedbits = 5;
                    continue;
                }
                if (usedbits < 3) {
                    int n = outBuffPosn;
                    outBuff[n] = (byte)(outBuff[n] | fivebits << 3 - usedbits & dmask[usedbits]);
                    usedbits += 5;
                    continue;
                }
                if (usedbits == 3) {
                    int n = outBuffPosn++;
                    outBuff[n] = (byte)(outBuff[n] | fivebits);
                    usedbits = 0;
                    continue;
                }
                int n = outBuffPosn++;
                outBuff[n] = (byte)(outBuff[n] | fivebits >> usedbits - 3 & dmask[usedbits]);
                byte next = (byte)(fivebits << 11 - usedbits);
                if (outBuffPosn < len58) {
                    outBuff[outBuffPosn] = next;
                    usedbits -= 3;
                    continue;
                }
                if (next == 0) continue;
                return null;
            }
            return null;
        }
        return outBuff;
    }
}

