/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.I2PAppContext;
import net.i2p.data.Hash;
import net.i2p.router.tunnel.HashSetIVValidator;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.IVValidator;
import net.i2p.util.Log;

class HopProcessor {
    protected final I2PAppContext _context;
    private final Log _log;
    protected final HopConfig _config;
    private final IVValidator _validator;
    static final int IV_LENGTH = 16;

    @Deprecated
    HopProcessor(I2PAppContext ctx, HopConfig config) {
        this(ctx, config, HopProcessor.createValidator());
    }

    public HopProcessor(I2PAppContext ctx, HopConfig config, IVValidator validator) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(HopProcessor.class);
        this._config = config;
        this._validator = validator;
    }

    @Deprecated
    private static IVValidator createValidator() {
        return new HashSetIVValidator();
    }

    public boolean process(byte[] orig, int offset, int length, Hash prev) {
        boolean okIV;
        if (prev != null) {
            if (this._config.getReceiveFrom() == null) {
                this._config.setReceiveFrom(prev);
            } else if (!this._config.getReceiveFrom().equals(prev)) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Attempted mid-tunnel injection from " + prev + ", expected " + this._config.getReceiveFrom());
                }
                return false;
            }
        }
        if (!(okIV = this._validator.receiveIV(orig, offset, orig, offset + 16))) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid IV, dropping at hop " + this._config);
            }
            return false;
        }
        this.updateIV(orig, offset);
        this.encrypt(orig, offset, length);
        this.updateIV(orig, offset);
        return true;
    }

    private final void encrypt(byte[] data, int offset, int length) {
        for (int off = offset + 16; off < length; off += 16) {
            for (int j = 0; j < 16; ++j) {
                int n = off + j;
                data[n] = (byte)(data[n] ^ data[off - 16 + j]);
            }
            this._context.aes().encryptBlock(data, off, this._config.getLayerKey(), data, off);
        }
    }

    private final void updateIV(byte[] orig, int offset) {
        this._context.aes().encryptBlock(orig, offset, this._config.getIVKey(), orig, offset);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " for " + this._config;
    }
}

