/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.crypto;

import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.I2PAppContext;
import net.i2p.crypto.EncType;
import net.i2p.crypto.KeyPair;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

public class X25519KeyFactory
extends I2PThread {
    private final I2PAppContext _context;
    private final Log _log;
    private final int _minSize;
    private final int _maxSize;
    private final int _calcDelay;
    private final LinkedBlockingQueue<KeyPair> _keys;
    private volatile boolean _isRunning;
    private long _checkDelay = 10000L;
    private static final String PROP_DH_PRECALC_MIN = "crypto.xdh.precalc.min";
    private static final String PROP_DH_PRECALC_MAX = "crypto.xdh.precalc.max";
    private static final String PROP_DH_PRECALC_DELAY = "crypto.xdh.precalc.delay";
    private static final int DEFAULT_DH_PRECALC_MIN = 20;
    private static final int DEFAULT_DH_PRECALC_MAX = 60;
    private static final int DEFAULT_DH_PRECALC_DELAY = 25;

    public X25519KeyFactory(I2PAppContext ctx) {
        super("XDH Precalc");
        this._context = ctx;
        this._log = ctx.logManager().getLog(X25519KeyFactory.class);
        ctx.statManager().createRateStat("crypto.XDHGenerateTime", "How long it takes to create x and X", "Encryption", new long[]{3600000L});
        ctx.statManager().createRateStat("crypto.XDHUsed", "Need a DH from the queue", "Encryption", new long[]{3600000L});
        ctx.statManager().createRateStat("crypto.XDHReused", "Unused DH requeued", "Encryption", new long[]{3600000L});
        ctx.statManager().createRateStat("crypto.XDHEmpty", "DH queue empty", "Encryption", new long[]{3600000L});
        long maxMemory = SystemVersion.getMaxMemory();
        int factor = (int)Math.max(1L, Math.min(4L, 1L + maxMemory / 0x8000000L));
        int defaultMin = 20 * factor;
        int defaultMax = 60 * factor;
        this._minSize = ctx.getProperty(PROP_DH_PRECALC_MIN, defaultMin);
        this._maxSize = ctx.getProperty(PROP_DH_PRECALC_MAX, defaultMax);
        this._calcDelay = ctx.getProperty(PROP_DH_PRECALC_DELAY, 25);
        if (this._log.shouldLog(10)) {
            this._log.debug("XDH Precalc (minimum: " + this._minSize + " max: " + this._maxSize + ", delay: " + this._calcDelay + ")");
        }
        this._keys = new LinkedBlockingQueue(this._maxSize);
        if (!SystemVersion.isWindows()) {
            this.setPriority(4);
        }
    }

    public void shutdown() {
        this._isRunning = false;
        this.interrupt();
        this._keys.clear();
    }

    @Override
    public void run() {
        block2: {
            try {
                this.run2();
            }
            catch (IllegalStateException ise) {
                if (!this._isRunning) break block2;
                throw ise;
            }
        }
    }

    private void run2() {
        this._isRunning = true;
        while (this._isRunning) {
            int startSize = this.getSize();
            if (startSize <= this._minSize * 2 / 3 && this._checkDelay > 1000L) {
                this._checkDelay -= 1000L;
            } else if (startSize > this._minSize * 3 / 2 && this._checkDelay < 60000L) {
                this._checkDelay += 1000L;
            }
            if (startSize < this._minSize) {
                while (this.getSize() < this._maxSize && this._isRunning) {
                    long curStart = System.currentTimeMillis();
                    if (!this.addKeys(this.precalc())) break;
                    long curCalc = System.currentTimeMillis() - curStart;
                    if (X25519KeyFactory.interrupted()) continue;
                    try {
                        Thread.sleep(Math.min(200L, Math.max(10L, (long)this._calcDelay + curCalc * 3L)));
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!this._isRunning) break;
            try {
                Thread.sleep(this._checkDelay);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public KeyPair getKeys() {
        this._context.statManager().addRateData("crypto.XDHUsed", 1L);
        KeyPair rv = this._keys.poll();
        if (rv == null) {
            this._context.statManager().addRateData("crypto.XDHEmpty", 1L);
            rv = this.precalc();
            this.interrupt();
        }
        return rv;
    }

    private KeyPair precalc() {
        long start = System.currentTimeMillis();
        KeyPair rv = this._context.keyGenerator().generatePKIKeys(EncType.ECIES_X25519);
        long end = System.currentTimeMillis();
        long diff = end - start;
        this._context.statManager().addRateData("crypto.XDHGenerateTime", diff);
        if (this._log.shouldLog(10)) {
            this._log.debug("Took " + diff + "ms to generate local DH value");
        }
        return rv;
    }

    public void returnUnused(KeyPair kp) {
        this._context.statManager().addRateData("crypto.XDHReused", 1L);
        this._keys.offer(kp);
    }

    private final boolean addKeys(KeyPair kp) {
        return this._keys.offer(kp);
    }

    private final int getSize() {
        return this._keys.size();
    }
}

