/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.crypto;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.crypto.CryptoConstants;
import net.i2p.crypto.SHA256Generator;
import net.i2p.crypto.SigUtil;
import net.i2p.data.ByteArray;
import net.i2p.data.SessionKey;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.NativeBigInteger;
import net.i2p.util.RandomSource;
import net.i2p.util.SystemVersion;

public class DHSessionKeyBuilder {
    private final BigInteger _myPrivateValue;
    private final BigInteger _myPublicValue;
    private BigInteger _peerValue;
    private SessionKey _sessionKey;
    private final ByteArray _extraExchangedBytes;
    private static final String PROP_DH_PRECALC_MIN = "crypto.dh.precalc.min";
    private static final String PROP_DH_PRECALC_MAX = "crypto.dh.precalc.max";
    private static final String PROP_DH_PRECALC_DELAY = "crypto.dh.precalc.delay";
    private static final int DEFAULT_DH_PRECALC_MIN = 20;
    private static final int DEFAULT_DH_PRECALC_MAX = 60;
    private static final int DEFAULT_DH_PRECALC_DELAY = 25;

    DHSessionKeyBuilder() {
        this(I2PAppContext.getGlobalContext());
    }

    DHSessionKeyBuilder(I2PAppContext ctx) {
        this._myPrivateValue = new NativeBigInteger(ctx.keyGenerator().getElGamalExponentSize(), ctx.random());
        this._myPublicValue = CryptoConstants.elgg.modPow(this._myPrivateValue, CryptoConstants.elgp);
        this._extraExchangedBytes = new ByteArray();
    }

    public BigInteger getMyPublicValue() {
        return this._myPublicValue;
    }

    public byte[] getMyPublicValueBytes() {
        return DHSessionKeyBuilder.toByteArray(this.getMyPublicValue());
    }

    private static final byte[] toByteArray(BigInteger bi) {
        try {
            return SigUtil.rectify(bi, 256);
        }
        catch (InvalidKeyException ike) {
            throw new IllegalArgumentException(ike);
        }
    }

    public synchronized void setPeerPublicValue(BigInteger peerVal) throws InvalidPublicParameterException {
        if (this._peerValue != null) {
            if (!this._peerValue.equals(peerVal)) {
                throw new IllegalStateException();
            }
            return;
        }
        DHSessionKeyBuilder.validatePublic(peerVal);
        this._peerValue = peerVal;
    }

    public void setPeerPublicValue(byte[] val) throws InvalidPublicParameterException {
        if (val.length != 256) {
            throw new IllegalArgumentException("Peer public value must be exactly 256 bytes");
        }
        this.setPeerPublicValue(new NativeBigInteger(1, val));
    }

    public synchronized BigInteger getPeerPublicValue() {
        return this._peerValue;
    }

    public byte[] getPeerPublicValueBytes() {
        return DHSessionKeyBuilder.toByteArray(this.getPeerPublicValue());
    }

    public synchronized SessionKey getSessionKey() {
        if (this._sessionKey != null) {
            return this._sessionKey;
        }
        if (this._peerValue != null) {
            this._sessionKey = this.calculateSessionKey(this._myPrivateValue, this._peerValue);
        }
        return this._sessionKey;
    }

    public ByteArray getExtraBytes() {
        return this._extraExchangedBytes;
    }

    private final SessionKey calculateSessionKey(BigInteger myPrivateValue, BigInteger publicPeerValue) {
        byte[] remaining;
        long start = System.currentTimeMillis();
        SessionKey key = new SessionKey();
        BigInteger exchangedKey = publicPeerValue.modPow(myPrivateValue, CryptoConstants.elgp);
        byte[] buf = exchangedKey.toByteArray();
        byte[] val = new byte[32];
        if (buf.length < 64) {
            System.arraycopy(buf, 0, val, 0, Math.min(buf.length, 32));
            remaining = new byte[32];
            SHA256Generator.getInstance().calculateHash(buf, 0, buf.length, remaining, 0);
            this._extraExchangedBytes.setData(remaining);
        } else {
            System.arraycopy(buf, 0, val, 0, 32);
            RandomSource.getInstance().harvester().feedEntropy("DH", buf, val.length, buf.length - val.length);
            remaining = new byte[buf.length - val.length];
            System.arraycopy(buf, val.length, remaining, 0, remaining.length);
            this._extraExchangedBytes.setData(remaining);
        }
        key.setData(val);
        long end = System.currentTimeMillis();
        long diff = end - start;
        I2PAppContext.getGlobalContext().statManager().addRateData("crypto.dhCalculateSessionTime", diff);
        return key;
    }

    private static final void validatePublic(BigInteger publicValue) throws InvalidPublicParameterException {
        int cmp = publicValue.compareTo(NativeBigInteger.ONE);
        if (cmp <= 0) {
            throw new InvalidPublicParameterException("Public value is below two: " + publicValue.toString());
        }
        cmp = publicValue.compareTo(CryptoConstants.elgp);
        if (cmp >= 0) {
            throw new InvalidPublicParameterException("Public value is above p-1: " + publicValue.toString());
        }
    }

    public static interface Factory {
        public DHSessionKeyBuilder getBuilder();

        public void returnUnused(DHSessionKeyBuilder var1);
    }

    public static class InvalidPublicParameterException
    extends I2PException {
        public InvalidPublicParameterException() {
        }

        public InvalidPublicParameterException(String msg) {
            super(msg);
        }

        public InvalidPublicParameterException(String msg, Throwable t) {
            super(msg, t);
        }
    }

    public static class PrecalcRunner
    extends I2PThread
    implements Factory {
        private final I2PAppContext _context;
        private final Log _log;
        private final int _minSize;
        private final int _maxSize;
        private final int _calcDelay;
        private final LinkedBlockingQueue<DHSessionKeyBuilder> _builders;
        private volatile boolean _isRunning;
        private long _checkDelay = 10000L;

        public PrecalcRunner(I2PAppContext ctx) {
            super("DH Precalc");
            this._context = ctx;
            this._log = ctx.logManager().getLog(DHSessionKeyBuilder.class);
            ctx.statManager().createRateStat("crypto.dhGeneratePublicTime", "How long it takes to create x and X", "Encryption", new long[]{3600000L});
            ctx.statManager().createRateStat("crypto.dhCalculateSessionTime", "How long it takes to create the session key", "Encryption", new long[]{3600000L});
            ctx.statManager().createRateStat("crypto.DHUsed", "Need a DH from the queue", "Encryption", new long[]{3600000L});
            ctx.statManager().createRateStat("crypto.DHReused", "Unused DH requeued", "Encryption", new long[]{3600000L});
            ctx.statManager().createRateStat("crypto.DHEmpty", "DH queue empty", "Encryption", new long[]{3600000L});
            long maxMemory = SystemVersion.getMaxMemory();
            int factor = (int)Math.max(1L, Math.min(4L, 1L + maxMemory / 0x8000000L));
            int defaultMin = 20 * factor;
            int defaultMax = 60 * factor;
            this._minSize = ctx.getProperty(DHSessionKeyBuilder.PROP_DH_PRECALC_MIN, defaultMin);
            this._maxSize = ctx.getProperty(DHSessionKeyBuilder.PROP_DH_PRECALC_MAX, defaultMax);
            this._calcDelay = ctx.getProperty(DHSessionKeyBuilder.PROP_DH_PRECALC_DELAY, 25);
            if (this._log.shouldLog(10)) {
                this._log.debug("DH Precalc (minimum: " + this._minSize + " max: " + this._maxSize + ", delay: " + this._calcDelay + ")");
            }
            this._builders = new LinkedBlockingQueue(this._maxSize);
            if (!SystemVersion.isWindows()) {
                this.setPriority(4);
            }
        }

        public void shutdown() {
            this._isRunning = false;
            this.interrupt();
            this._builders.clear();
        }

        @Override
        public void run() {
            block2: {
                try {
                    this.run2();
                }
                catch (IllegalStateException ise) {
                    if (!this._isRunning) break block2;
                    throw ise;
                }
            }
        }

        private void run2() {
            this._isRunning = true;
            while (this._isRunning) {
                int startSize = this.getSize();
                if (startSize <= this._minSize * 2 / 3 && this._checkDelay > 1000L) {
                    this._checkDelay -= 1000L;
                } else if (startSize > this._minSize * 3 / 2 && this._checkDelay < 60000L) {
                    this._checkDelay += 1000L;
                }
                if (startSize < this._minSize) {
                    while (this.getSize() < this._maxSize && this._isRunning) {
                        long curStart = System.currentTimeMillis();
                        if (!this.addBuilder(this.precalc())) break;
                        long curCalc = System.currentTimeMillis() - curStart;
                        if (PrecalcRunner.interrupted()) continue;
                        try {
                            Thread.sleep(Math.min(200L, Math.max(10L, (long)this._calcDelay + curCalc * 3L)));
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (!this._isRunning) break;
                try {
                    Thread.sleep(this._checkDelay);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        @Override
        public DHSessionKeyBuilder getBuilder() {
            this._context.statManager().addRateData("crypto.DHUsed", 1L);
            DHSessionKeyBuilder builder = this._builders.poll();
            if (builder == null) {
                if (this._log.shouldLog(20)) {
                    this._log.info("No more builders, creating one now");
                }
                this._context.statManager().addRateData("crypto.DHEmpty", 1L);
                builder = this.precalc();
                this.interrupt();
            }
            return builder;
        }

        private DHSessionKeyBuilder precalc() {
            long start = System.currentTimeMillis();
            DHSessionKeyBuilder builder = new DHSessionKeyBuilder(this._context);
            long end = System.currentTimeMillis();
            long diff = end - start;
            this._context.statManager().addRateData("crypto.dhGeneratePublicTime", diff);
            if (diff > 1000L) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Took more than a second (" + diff + "ms) to generate local DH value");
                }
            } else if (this._log.shouldLog(10)) {
                this._log.debug("Took " + diff + "ms to generate local DH value");
            }
            return builder;
        }

        @Override
        public void returnUnused(DHSessionKeyBuilder builder) {
            if (builder.getPeerPublicValue() != null) {
                this._log.error("builder returned used", new Exception());
                return;
            }
            this._context.statManager().addRateData("crypto.DHReused", 1L);
            this._builders.offer(builder);
        }

        private final boolean addBuilder(DHSessionKeyBuilder builder) {
            return this._builders.offer(builder);
        }

        private final int getSize() {
            return this._builders.size();
        }
    }
}

