/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import com.maxmind.db.CHMCache;
import com.maxmind.geoip.LookupService;
import com.maxmind.geoip2.DatabaseReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.GeoIPv6;
import net.i2p.util.Addresses;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

public class GeoIP {
    private final Log _log;
    private final I2PAppContext _context;
    private final Map<String, String> _codeToName;
    private final Map<String, String> _codeCache;
    private final Map<Long, String> _IPToCountry;
    private final Set<Long> _pendingSearch;
    private final Set<Long> _pendingIPv6Search;
    private final Set<Long> _notFound;
    private final AtomicBoolean _lock;
    private int _lookupRunCount;
    static final String PROP_GEOIP_ENABLED = "routerconsole.geoip.enable";
    public static final String PROP_GEOIP_DIR = "geoip.dir";
    public static final String GEOIP_DIR_DEFAULT = "geoip";
    static final String GEOIP_FILE_DEFAULT = "geoip.txt";
    static final String GEOIP2_FILE_DEFAULT = "GeoLite2-Country.mmdb";
    static final String COUNTRY_FILE_DEFAULT = "countries.txt";
    public static final String PROP_IP_COUNTRY = "i2np.lastCountry";
    public static final String PROP_DEBIAN_GEOIP = "geoip.dat";
    public static final String PROP_DEBIAN_GEOIPV6 = "geoip.v6.dat";
    private static final String DEBIAN_GEOIP_FILE = "/usr/share/GeoIP/GeoIP.dat";
    private static final String DEBIAN_GEOIPV6_FILE = "/usr/share/GeoIP/GeoIPv6.dat";
    private static final boolean DISABLE_DEBIAN = false;
    private static final boolean ENABLE_DEBIAN = !SystemVersion.isWindows() && !SystemVersion.isAndroid();
    private static final String UNKNOWN_COUNTRY_CODE = "--";

    public GeoIP(I2PAppContext context) {
        this._context = context;
        this._log = context.logManager().getLog(GeoIP.class);
        this._codeToName = new ConcurrentHashMap<String, String>(512);
        this._codeCache = new ConcurrentHashMap<String, String>(512);
        this._IPToCountry = new ConcurrentHashMap<Long, String>();
        this._pendingSearch = new ConcurrentHashSet<Long>();
        this._pendingIPv6Search = new ConcurrentHashSet<Long>();
        this._notFound = new ConcurrentHashSet<Long>();
        this._lock = new AtomicBoolean();
        this.readCountryFile();
    }

    public void shutdown() {
        this._codeToName.clear();
        this._codeCache.clear();
        this._IPToCountry.clear();
        this._pendingSearch.clear();
        this._pendingIPv6Search.clear();
        this._notFound.clear();
    }

    public void blockingLookup() {
        if (!this._context.getBooleanPropertyDefaultTrue(PROP_GEOIP_ENABLED)) {
            this._pendingSearch.clear();
            this._pendingIPv6Search.clear();
            return;
        }
        int pri = Thread.currentThread().getPriority();
        if (pri > 1) {
            Thread.currentThread().setPriority(pri - 1);
        }
        try {
            LookupJob j = new LookupJob();
            j.run();
            this.updateOurCountry();
        }
        finally {
            if (pri > 1) {
                Thread.currentThread().setPriority(pri);
            }
        }
    }

    private File getGeoIP2() {
        String geoDir = this._context.getProperty(PROP_GEOIP_DIR, GEOIP_DIR_DEFAULT);
        File geoFile = new File(geoDir);
        if (!geoFile.isAbsolute()) {
            geoFile = new File(this._context.getBaseDir(), geoDir);
        }
        if (!(geoFile = new File(geoFile, GEOIP2_FILE_DEFAULT)).exists()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("GeoIP2 file not found: " + geoFile.getAbsolutePath());
            }
            return null;
        }
        return geoFile;
    }

    private DatabaseReader openGeoIP2(File geoFile) throws IOException {
        DatabaseReader.Builder b = new DatabaseReader.Builder(geoFile);
        b.withCache(new CHMCache(256));
        DatabaseReader rv = b.build();
        if (this._log.shouldDebug()) {
            this._log.debug("Opened GeoIP2 Database, Metadata: " + rv.getMetadata());
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCountryFile() {
        String geoDir = this._context.getProperty(PROP_GEOIP_DIR, GEOIP_DIR_DEFAULT);
        File geoFile = new File(geoDir);
        if (!geoFile.isAbsolute()) {
            geoFile = new File(this._context.getBaseDir(), geoDir);
        }
        if (!(geoFile = new File(geoFile, COUNTRY_FILE_DEFAULT)).exists()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Country file not found: " + geoFile.getAbsolutePath());
            }
            return;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(geoFile), "UTF-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                try {
                    if (line.charAt(0) == '#') continue;
                    String[] s = DataHelper.split(line, ",");
                    String lc = s[0].toLowerCase(Locale.US);
                    this._codeToName.put(lc, s[1]);
                    this._codeCache.put(lc, lc);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            }
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error reading the Country File", ioe);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] readGeoIPFile(Long[] search) {
        String geoDir = this._context.getProperty(PROP_GEOIP_DIR, GEOIP_DIR_DEFAULT);
        File geoFile = new File(geoDir);
        if (!geoFile.isAbsolute()) {
            geoFile = new File(this._context.getBaseDir(), geoDir);
        }
        if (!(geoFile = new File(geoFile, GEOIP_FILE_DEFAULT)).exists()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("GeoIP file not found: " + geoFile.getAbsolutePath());
            }
            return new String[0];
        }
        String[] rv = new String[search.length];
        int idx = 0;
        BufferedReader br = null;
        try {
            String buf = null;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(geoFile), "ISO-8859-1"));
            while ((buf = br.readLine()) != null && idx < search.length) {
                try {
                    if (buf.charAt(0) == '#') continue;
                    String[] s = DataHelper.split(buf, ",");
                    long ip1 = Long.parseLong(s[0]);
                    long ip2 = Long.parseLong(s[1]);
                    while (idx < search.length && search[idx] < ip1) {
                        ++idx;
                    }
                    while (idx < search.length && search[idx] >= ip1 && search[idx] <= ip2) {
                        String lc = s[2].toLowerCase(Locale.US);
                        String cached = this._codeCache.get(lc);
                        if (cached == null) {
                            cached = lc;
                        }
                        rv[idx++] = cached;
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error reading the geoFile", ioe);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return rv;
    }

    private void updateOurCountry() {
        Object ra;
        Object ip;
        if (!(this._context instanceof RouterContext)) {
            return;
        }
        RouterContext ctx = (RouterContext)this._context;
        String oldCountry = ctx.router().getConfigSetting(PROP_IP_COUNTRY);
        RouterInfo us = ctx.router().getRouterInfo();
        String country = null;
        if (us != null) {
            Iterator<RouterAddress> iterator = us.getAddresses().iterator();
            while (iterator.hasNext() && ((ip = ((RouterAddress)(ra = iterator.next())).getIP()) == null || (country = this.get((byte[])ip)) == null)) {
            }
        }
        if (country == null) {
            String lastIP;
            SortedSet<String> addrs = Addresses.getAddresses(false, true);
            ra = addrs.iterator();
            while (ra.hasNext() && (country = this.get((String)(ip = (Object)((String)ra.next())))) == null) {
            }
            if (country == null && (lastIP = this._context.getProperty("i2np.lastIP")) != null) {
                country = this.get(lastIP);
            }
        }
        if (this._log.shouldInfo()) {
            this._log.info("Old country was " + oldCountry + " new country is " + country);
        }
        if (country != null && !country.equals(oldCountry)) {
            boolean wasStrict = ctx.commSystem().isInStrictCountry();
            ctx.router().saveConfig(PROP_IP_COUNTRY, country);
            boolean isStrict = ctx.commSystem().isInStrictCountry();
            if (this._log.shouldInfo()) {
                this._log.info("Old country was strict? " + wasStrict + "; new country is strict? " + isStrict);
            }
            if (wasStrict != isStrict && ctx.getProperty("router.isHidden") == null) {
                if (isStrict) {
                    String name = this.fullName(country);
                    if (name == null) {
                        name = country;
                    }
                    this._log.logAlways(30, "Setting hidden mode to protect you in " + name + ", you may override on the network configuration page");
                }
                ctx.router().rebuildRouterInfo();
            }
        }
    }

    public void add(String ip) {
        byte[] pib = Addresses.getIP(ip);
        if (pib == null) {
            return;
        }
        this.add(pib);
    }

    public void add(byte[] ip) {
        this.add(GeoIP.toLong(ip));
    }

    private void add(long ip) {
        Long li = ip;
        if (!this._IPToCountry.containsKey(li) && !this._notFound.contains(li)) {
            if (ip >= 0L && ip < 0x100000000L) {
                this._pendingSearch.add(li);
            } else {
                this._pendingIPv6Search.add(li);
            }
        }
    }

    public String get(String ip) {
        byte[] pib = Addresses.getIP(ip);
        if (pib == null) {
            return null;
        }
        return this.get(pib);
    }

    String get(byte[] ip) {
        return this.get(GeoIP.toLong(ip));
    }

    private String get(long ip) {
        return this._IPToCountry.get(ip);
    }

    private static long toLong(byte[] ip) {
        long rv = 0L;
        if (ip.length == 16) {
            for (int i = 0; i < 8; ++i) {
                rv |= ((long)ip[i] & 0xFFL) << (7 - i) * 8;
            }
            return rv;
        }
        for (int i = 0; i < 4; ++i) {
            rv |= (long)((ip[i] & 0xFF) << (3 - i) * 8);
        }
        return rv & 0xFFFFFFFFL;
    }

    private static String toV4(long ip) {
        StringBuilder buf = new StringBuilder(15);
        for (int i = 0; i < 4; ++i) {
            buf.append(Long.toString(ip >> (3 - i) * 8 & 0xFFL));
            if (i == 3) break;
            buf.append('.');
        }
        return buf.toString();
    }

    private static String toV6(long ip) {
        StringBuilder buf = new StringBuilder(21);
        for (int i = 0; i < 4; ++i) {
            buf.append(Long.toHexString(ip >> (3 - i) * 16 & 0xFFFFL));
            buf.append(':');
        }
        buf.append(':');
        return buf.toString();
    }

    public String fullName(String code) {
        return this._codeToName.get(code);
    }

    private class LookupJob
    implements Runnable {
        private static final int CLEAR = 8;

        private LookupJob() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long start;
            block57: {
                if (GeoIP.this._lock.getAndSet(true)) {
                    return;
                }
                File geoip2 = GeoIP.this.getGeoIP2();
                DatabaseReader dbr = null;
                start = GeoIP.this._context.clock().now();
                try {
                    String cached;
                    String lc;
                    Object ipl;
                    int i;
                    File f;
                    if (++GeoIP.this._lookupRunCount % 8 == 0) {
                        GeoIP.this._notFound.clear();
                    }
                    SortedSet<String> addrs = Addresses.getAddresses(false, true);
                    for (String ip : addrs) {
                        GeoIP.this.add(ip);
                    }
                    String lastIP = GeoIP.this._context.getProperty("i2np.lastIP");
                    if (lastIP != null) {
                        GeoIP.this.add(lastIP);
                    }
                    Object[] search = GeoIP.this._pendingSearch.toArray(new Long[GeoIP.this._pendingSearch.size()]);
                    GeoIP.this._pendingSearch.clear();
                    if (search.length > 0) {
                        Arrays.sort(search);
                        f = new File(GeoIP.this._context.getProperty(GeoIP.PROP_DEBIAN_GEOIP, GeoIP.DEBIAN_GEOIP_FILE));
                        if (ENABLE_DEBIAN && f.exists()) {
                            try (LookupService ls = null;){
                                ls = new LookupService(f, 0);
                                for (i = 0; i < search.length; ++i) {
                                    ipl = search[i];
                                    long ip = (Long)ipl;
                                    String uc = ls.getCountry(ip).getCode();
                                    if (!uc.equals(GeoIP.UNKNOWN_COUNTRY_CODE)) {
                                        String lc2 = uc.toLowerCase(Locale.US);
                                        String cached2 = (String)GeoIP.this._codeCache.get(lc2);
                                        if (cached2 == null) {
                                            cached2 = lc2;
                                        }
                                        GeoIP.this._IPToCountry.put(ipl, cached2);
                                        continue;
                                    }
                                    GeoIP.this._notFound.add(ipl);
                                }
                            }
                        } else if (geoip2 != null) {
                            try {
                                dbr = GeoIP.this.openGeoIP2(geoip2);
                                for (int i2 = 0; i2 < search.length; ++i2) {
                                    Object ipl2 = search[i2];
                                    String ipv4 = GeoIP.toV4((Long)ipl2);
                                    String uc = dbr.country(ipv4);
                                    if (uc != null) {
                                        lc = uc.toLowerCase(Locale.US);
                                        cached = (String)GeoIP.this._codeCache.get(lc);
                                        if (cached == null) {
                                            cached = lc;
                                        }
                                        GeoIP.this._IPToCountry.put(ipl2, cached);
                                        continue;
                                    }
                                    GeoIP.this._notFound.add(ipl2);
                                }
                            }
                            catch (IOException ioe) {
                                GeoIP.this._log.error("GeoIP2 failure", ioe);
                            }
                        } else {
                            String[] countries = GeoIP.this.readGeoIPFile((Long[])search);
                            for (int i3 = 0; i3 < countries.length; ++i3) {
                                if (countries[i3] != null) {
                                    GeoIP.this._IPToCountry.put(search[i3], countries[i3]);
                                    continue;
                                }
                                GeoIP.this._notFound.add(search[i3]);
                            }
                        }
                    }
                    search = GeoIP.this._pendingIPv6Search.toArray(new Long[GeoIP.this._pendingIPv6Search.size()]);
                    GeoIP.this._pendingIPv6Search.clear();
                    if (search.length <= 0) break block57;
                    Arrays.sort(search);
                    f = new File(GeoIP.this._context.getProperty(GeoIP.PROP_DEBIAN_GEOIPV6, GeoIP.DEBIAN_GEOIPV6_FILE));
                    if (ENABLE_DEBIAN && f.exists()) {
                        try (LookupService ls = null;){
                            ls = new LookupService(f, 0);
                            for (i = 0; i < search.length; ++i) {
                                ipl = search[i];
                                long ip = (Long)ipl;
                                String ipv6 = GeoIP.toV6(ip);
                                String uc = ls.getCountryV6(ipv6).getCode();
                                if (!uc.equals(GeoIP.UNKNOWN_COUNTRY_CODE)) {
                                    String lc3 = uc.toLowerCase(Locale.US);
                                    String cached3 = (String)GeoIP.this._codeCache.get(lc3);
                                    if (cached3 == null) {
                                        cached3 = lc3;
                                    }
                                    GeoIP.this._IPToCountry.put(ipl, cached3);
                                    continue;
                                }
                                GeoIP.this._notFound.add(ipl);
                            }
                            break block57;
                        }
                    }
                    if (geoip2 != null) {
                        try {
                            if (dbr == null) {
                                dbr = GeoIP.this.openGeoIP2(geoip2);
                            }
                            for (int i4 = 0; i4 < search.length; ++i4) {
                                Object ipl3 = search[i4];
                                String ipv6 = GeoIP.toV6((Long)ipl3);
                                String uc = dbr.country(ipv6);
                                if (uc != null) {
                                    lc = uc.toLowerCase(Locale.US);
                                    cached = (String)GeoIP.this._codeCache.get(lc);
                                    if (cached == null) {
                                        cached = lc;
                                    }
                                    GeoIP.this._IPToCountry.put(ipl3, cached);
                                    continue;
                                }
                                GeoIP.this._notFound.add(ipl3);
                            }
                            break block57;
                        }
                        catch (IOException ioe) {
                            GeoIP.this._log.error("GeoIP2 failure", ioe);
                            break block57;
                        }
                    }
                    String[] countries = GeoIPv6.readGeoIPFile(GeoIP.this._context, (Long[])search, GeoIP.this._codeCache);
                    for (i = 0; i < countries.length; ++i) {
                        if (countries[i] != null) {
                            GeoIP.this._IPToCountry.put(search[i], countries[i]);
                            continue;
                        }
                        GeoIP.this._notFound.add(search[i]);
                    }
                }
                finally {
                    if (dbr != null) {
                        try {
                            dbr.close();
                        }
                        catch (IOException iOException) {}
                    }
                    GeoIP.this._lock.set(false);
                }
            }
            if (GeoIP.this._log.shouldInfo()) {
                GeoIP.this._log.info("GeoIP processing finished, time: " + (GeoIP.this._context.clock().now() - start));
            }
        }
    }
}

