/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.OutNetMessage;
import net.i2p.router.Service;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.crypto.DHSessionKeyBuilder;

public abstract class CommSystemFacade
implements Service {
    public static final short STATUS_OK = 0;
    public static final short STATUS_IPV4_OK_IPV6_UNKNOWN = 2;
    public static final short STATUS_IPV4_OK_IPV6_FIREWALLED = 1;
    public static final short STATUS_IPV4_UNKNOWN_IPV6_OK = 4;
    public static final short STATUS_IPV4_FIREWALLED_IPV6_OK = 3;
    public static final short STATUS_IPV4_DISABLED_IPV6_OK = 5;
    public static final short STATUS_IPV4_SNAT_IPV6_OK = 6;
    public static final short STATUS_DIFFERENT = 7;
    public static final short STATUS_IPV4_SNAT_IPV6_UNKNOWN = 8;
    public static final short STATUS_IPV4_FIREWALLED_IPV6_UNKNOWN = 10;
    public static final short STATUS_REJECT_UNSOLICITED = 9;
    public static final short STATUS_IPV4_UNKNOWN_IPV6_FIREWALLED = 11;
    public static final short STATUS_IPV4_DISABLED_IPV6_UNKNOWN = 13;
    public static final short STATUS_IPV4_DISABLED_IPV6_FIREWALLED = 12;
    public static final short STATUS_DISCONNECTED = 14;
    public static final short STATUS_HOSED = 15;
    public static final short STATUS_UNKNOWN = 16;

    public abstract void processMessage(OutNetMessage var1);

    public void renderStatusHTML(Writer out, String urlBase, int sortFlags) throws IOException {
    }

    @Override
    public void renderStatusHTML(Writer out) throws IOException {
        this.renderStatusHTML(out, null, 0);
    }

    public List<RouterAddress> createAddresses() {
        return Collections.emptyList();
    }

    public abstract int countActivePeers();

    public abstract int countActiveSendPeers();

    public boolean haveInboundCapacity(int pct) {
        return true;
    }

    public boolean haveOutboundCapacity(int pct) {
        return true;
    }

    public boolean haveHighOutboundCapacity() {
        return true;
    }

    public List<String> getMostRecentErrorMessages() {
        return Collections.emptyList();
    }

    public Long getMedianPeerClockSkew() {
        return null;
    }

    public long getFramedAveragePeerClockSkew(int percentToInclude) {
        return 0L;
    }

    @Deprecated
    public short getReachabilityStatus() {
        return (short)this.getStatus().getCode();
    }

    public Status getStatus() {
        return Status.OK;
    }

    @Deprecated
    public void recheckReachability() {
    }

    public boolean isBacklogged(Hash peer) {
        return false;
    }

    public boolean wasUnreachable(Hash peer) {
        return false;
    }

    public abstract boolean isEstablished(Hash var1);

    public byte[] getIP(Hash dest) {
        return null;
    }

    public void queueLookup(byte[] ip) {
    }

    public void mayDisconnect(Hash peer) {
    }

    public void forceDisconnect(Hash peer) {
    }

    public String getOurCountry() {
        return null;
    }

    public boolean isInStrictCountry() {
        return false;
    }

    public boolean isInStrictCountry(Hash peer) {
        return false;
    }

    public boolean isInStrictCountry(RouterInfo ri) {
        return false;
    }

    public String getCountry(Hash peer) {
        return null;
    }

    public String getCountryName(String code) {
        return code;
    }

    public String renderPeerHTML(Hash peer) {
        return peer.toBase64().substring(0, 4);
    }

    public SortedMap<String, Transport> getTransports() {
        return new TreeMap<String, Transport>();
    }

    public abstract Set<Hash> getEstablished();

    public boolean isDummy() {
        return true;
    }

    public void notifyReplaceAddress(RouterAddress address) {
    }

    public void notifyRemoveAddress(RouterAddress address) {
    }

    public void notifyRemoveAddress(boolean ipv6) {
    }

    public void registerTransport(Transport t) {
    }

    public void unregisterTransport(Transport t) {
    }

    public DHSessionKeyBuilder.Factory getDHFactory() {
        return null;
    }

    public void initGeoIP() {
    }

    public static enum Status {
        OK(0, Status._x("OK")),
        IPV4_OK_IPV6_UNKNOWN(2, Status._x("IPv4: OK; IPv6: Testing")),
        IPV4_OK_IPV6_FIREWALLED(1, Status._x("IPv4: OK; IPv6: Firewalled")),
        IPV4_UNKNOWN_IPV6_OK(4, Status._x("IPv4: Testing; IPv6: OK")),
        IPV4_FIREWALLED_IPV6_OK(3, Status._x("IPv4: Firewalled; IPv6: OK")),
        IPV4_DISABLED_IPV6_OK(5, Status._x("IPv4: Disabled; IPv6: OK")),
        IPV4_SNAT_IPV6_OK(6, Status._x("IPv4: Symmetric NAT; IPv6: OK")),
        DIFFERENT(7, Status._x("Symmetric NAT")),
        IPV4_SNAT_IPV6_UNKNOWN(8, Status._x("IPv4: Symmetric NAT; IPv6: Testing")),
        IPV4_FIREWALLED_IPV6_UNKNOWN(10, Status._x("IPv4: Firewalled; IPv6: Testing")),
        REJECT_UNSOLICITED(9, Status._x("Firewalled")),
        IPV4_UNKNOWN_IPV6_FIREWALLED(11, Status._x("IPv4: Testing; IPv6: Firewalled")),
        IPV4_DISABLED_IPV6_UNKNOWN(13, Status._x("IPv4: Disabled; IPv6: Testing")),
        IPV4_DISABLED_IPV6_FIREWALLED(12, Status._x("IPv4: Disabled; IPv6: Firewalled")),
        DISCONNECTED(14, Status._x("Disconnected")),
        HOSED(15, Status._x("Port Conflict")),
        UNKNOWN(16, Status._x("Testing"));

        private final int code;
        private final String status;

        private Status(int code, String status) {
            this.code = code;
            this.status = status;
        }

        public int getCode() {
            return this.code;
        }

        public static Status merge(Status oldStatus, Status newStatus) {
            if (oldStatus == newStatus || newStatus == UNKNOWN) {
                return oldStatus;
            }
            if (oldStatus == UNKNOWN || oldStatus == DISCONNECTED || oldStatus == HOSED) {
                return newStatus;
            }
            switch (newStatus) {
                case IPV4_OK_IPV6_UNKNOWN: {
                    switch (oldStatus) {
                        case OK: 
                        case IPV4_FIREWALLED_IPV6_OK: 
                        case IPV4_DISABLED_IPV6_OK: 
                        case IPV4_SNAT_IPV6_OK: {
                            return OK;
                        }
                        case IPV4_OK_IPV6_FIREWALLED: {
                            return oldStatus;
                        }
                        case DIFFERENT: 
                        case REJECT_UNSOLICITED: {
                            return newStatus;
                        }
                        case IPV4_DISABLED_IPV6_FIREWALLED: {
                            return IPV4_OK_IPV6_FIREWALLED;
                        }
                        case IPV4_UNKNOWN_IPV6_OK: {
                            return OK;
                        }
                        case IPV4_UNKNOWN_IPV6_FIREWALLED: {
                            return IPV4_OK_IPV6_FIREWALLED;
                        }
                        case IPV4_OK_IPV6_UNKNOWN: 
                        case IPV4_FIREWALLED_IPV6_UNKNOWN: 
                        case IPV4_DISABLED_IPV6_UNKNOWN: 
                        case IPV4_SNAT_IPV6_UNKNOWN: {
                            return newStatus;
                        }
                    }
                    return newStatus;
                }
                case IPV4_UNKNOWN_IPV6_OK: {
                    switch (oldStatus) {
                        case OK: 
                        case IPV4_OK_IPV6_FIREWALLED: {
                            return OK;
                        }
                        case IPV4_FIREWALLED_IPV6_OK: 
                        case IPV4_DISABLED_IPV6_OK: 
                        case IPV4_SNAT_IPV6_OK: 
                        case DIFFERENT: {
                            return oldStatus;
                        }
                        case REJECT_UNSOLICITED: {
                            return IPV4_FIREWALLED_IPV6_OK;
                        }
                        case IPV4_DISABLED_IPV6_FIREWALLED: {
                            return IPV4_DISABLED_IPV6_OK;
                        }
                        case IPV4_UNKNOWN_IPV6_OK: 
                        case IPV4_UNKNOWN_IPV6_FIREWALLED: {
                            return newStatus;
                        }
                        case IPV4_OK_IPV6_UNKNOWN: {
                            return OK;
                        }
                        case IPV4_FIREWALLED_IPV6_UNKNOWN: {
                            return IPV4_FIREWALLED_IPV6_OK;
                        }
                        case IPV4_DISABLED_IPV6_UNKNOWN: {
                            return IPV4_DISABLED_IPV6_OK;
                        }
                        case IPV4_SNAT_IPV6_UNKNOWN: {
                            return IPV4_SNAT_IPV6_OK;
                        }
                    }
                    return newStatus;
                }
                case IPV4_FIREWALLED_IPV6_UNKNOWN: {
                    switch (oldStatus) {
                        case OK: 
                        case IPV4_FIREWALLED_IPV6_OK: 
                        case IPV4_DISABLED_IPV6_OK: 
                        case IPV4_SNAT_IPV6_OK: {
                            return IPV4_FIREWALLED_IPV6_OK;
                        }
                        case IPV4_OK_IPV6_FIREWALLED: 
                        case IPV4_DISABLED_IPV6_FIREWALLED: {
                            return REJECT_UNSOLICITED;
                        }
                        case DIFFERENT: 
                        case REJECT_UNSOLICITED: {
                            return newStatus;
                        }
                        case IPV4_UNKNOWN_IPV6_OK: {
                            return IPV4_FIREWALLED_IPV6_OK;
                        }
                        case IPV4_UNKNOWN_IPV6_FIREWALLED: {
                            return REJECT_UNSOLICITED;
                        }
                        case IPV4_OK_IPV6_UNKNOWN: 
                        case IPV4_FIREWALLED_IPV6_UNKNOWN: 
                        case IPV4_DISABLED_IPV6_UNKNOWN: 
                        case IPV4_SNAT_IPV6_UNKNOWN: {
                            return newStatus;
                        }
                    }
                    return newStatus;
                }
                case IPV4_UNKNOWN_IPV6_FIREWALLED: {
                    switch (oldStatus) {
                        case OK: {
                            return IPV4_OK_IPV6_FIREWALLED;
                        }
                        case IPV4_OK_IPV6_FIREWALLED: {
                            return oldStatus;
                        }
                        case IPV4_FIREWALLED_IPV6_OK: 
                        case REJECT_UNSOLICITED: 
                        case IPV4_DISABLED_IPV6_FIREWALLED: {
                            return REJECT_UNSOLICITED;
                        }
                        case IPV4_DISABLED_IPV6_OK: {
                            return IPV4_DISABLED_IPV6_FIREWALLED;
                        }
                        case IPV4_SNAT_IPV6_OK: 
                        case DIFFERENT: {
                            return oldStatus;
                        }
                        case IPV4_UNKNOWN_IPV6_OK: 
                        case IPV4_UNKNOWN_IPV6_FIREWALLED: {
                            return newStatus;
                        }
                        case IPV4_OK_IPV6_UNKNOWN: {
                            return IPV4_OK_IPV6_FIREWALLED;
                        }
                        case IPV4_FIREWALLED_IPV6_UNKNOWN: {
                            return REJECT_UNSOLICITED;
                        }
                        case IPV4_DISABLED_IPV6_UNKNOWN: {
                            return IPV4_DISABLED_IPV6_FIREWALLED;
                        }
                        case IPV4_SNAT_IPV6_UNKNOWN: {
                            return DIFFERENT;
                        }
                    }
                    return newStatus;
                }
                case IPV4_DISABLED_IPV6_UNKNOWN: {
                    switch (oldStatus) {
                        case OK: 
                        case IPV4_FIREWALLED_IPV6_OK: 
                        case IPV4_DISABLED_IPV6_OK: 
                        case IPV4_SNAT_IPV6_OK: {
                            return IPV4_DISABLED_IPV6_OK;
                        }
                        case IPV4_OK_IPV6_FIREWALLED: 
                        case REJECT_UNSOLICITED: 
                        case IPV4_DISABLED_IPV6_FIREWALLED: {
                            return IPV4_DISABLED_IPV6_FIREWALLED;
                        }
                        case DIFFERENT: {
                            return newStatus;
                        }
                        case IPV4_UNKNOWN_IPV6_OK: {
                            return IPV4_DISABLED_IPV6_OK;
                        }
                        case IPV4_UNKNOWN_IPV6_FIREWALLED: {
                            return IPV4_DISABLED_IPV6_FIREWALLED;
                        }
                        case IPV4_OK_IPV6_UNKNOWN: 
                        case IPV4_FIREWALLED_IPV6_UNKNOWN: 
                        case IPV4_DISABLED_IPV6_UNKNOWN: 
                        case IPV4_SNAT_IPV6_UNKNOWN: {
                            return newStatus;
                        }
                    }
                    return newStatus;
                }
                case IPV4_SNAT_IPV6_UNKNOWN: {
                    switch (oldStatus) {
                        case OK: 
                        case IPV4_FIREWALLED_IPV6_OK: 
                        case IPV4_DISABLED_IPV6_OK: 
                        case IPV4_SNAT_IPV6_OK: {
                            return IPV4_SNAT_IPV6_OK;
                        }
                        case IPV4_OK_IPV6_FIREWALLED: 
                        case REJECT_UNSOLICITED: 
                        case IPV4_DISABLED_IPV6_FIREWALLED: {
                            return DIFFERENT;
                        }
                        case DIFFERENT: {
                            return newStatus;
                        }
                        case IPV4_UNKNOWN_IPV6_OK: {
                            return IPV4_SNAT_IPV6_OK;
                        }
                        case IPV4_UNKNOWN_IPV6_FIREWALLED: {
                            return DIFFERENT;
                        }
                        case IPV4_OK_IPV6_UNKNOWN: 
                        case IPV4_FIREWALLED_IPV6_UNKNOWN: 
                        case IPV4_DISABLED_IPV6_UNKNOWN: 
                        case IPV4_SNAT_IPV6_UNKNOWN: {
                            return newStatus;
                        }
                    }
                    return newStatus;
                }
                case UNKNOWN: {
                    return oldStatus;
                }
            }
            return newStatus;
        }

        public String toStatusString() {
            return this.status;
        }

        public String toString() {
            return super.toString() + " (" + this.code + "; " + this.status + ')';
        }

        private static String _x(String s) {
            return s;
        }
    }
}

