/*
 * Decompiled with CFR 0.152.
 */
package com.southernstorm.noise.protocol;

import com.southernstorm.noise.protocol.CipherStatePair;
import com.southernstorm.noise.protocol.Curve25519DHState;
import com.southernstorm.noise.protocol.DHState;
import com.southernstorm.noise.protocol.Destroyable;
import com.southernstorm.noise.protocol.Noise;
import com.southernstorm.noise.protocol.Pattern;
import com.southernstorm.noise.protocol.SymmetricState;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.ShortBufferException;
import net.i2p.data.Base64;
import net.i2p.router.transport.crypto.X25519KeyFactory;

public class HandshakeState
implements Destroyable {
    private final SymmetricState symmetric;
    private final boolean isInitiator;
    private DHState localKeyPair;
    private DHState localEphemeral;
    private DHState remotePublicKey;
    private DHState remoteEphemeral;
    private int action;
    private final int requirements;
    private int patternIndex;
    public static final int INITIATOR = 1;
    public static final int RESPONDER = 2;
    public static final int NO_ACTION = 0;
    public static final int WRITE_MESSAGE = 1;
    public static final int READ_MESSAGE = 2;
    public static final int FAILED = 3;
    public static final int SPLIT = 4;
    public static final int COMPLETE = 5;
    private static final int LOCAL_REQUIRED = 1;
    private static final int REMOTE_REQUIRED = 2;
    private static final int PSK_REQUIRED = 4;
    private static final int FALLBACK_PREMSG = 8;
    private static final int LOCAL_PREMSG = 16;
    private static final int REMOTE_PREMSG = 32;
    private static final int FALLBACK_POSSIBLE = 64;
    public static final String protocolName = "Noise_XKaesobfse+hs2+hs3_25519_ChaChaPoly_SHA256";
    private static final String prefix;
    private static final String patternId;
    private static String dh;
    private static final String cipher;
    private static final String hash;
    private static final short[] pattern;
    private static final byte[] emptyPrologue;

    public HandshakeState(int role, X25519KeyFactory xdh) throws NoSuchAlgorithmException {
        short flags = pattern[0];
        int extraReqs = 0;
        if ((flags & 0x400) != 0 && patternId.length() > 1) {
            extraReqs |= 0x40;
        }
        if (role == 2) {
            flags = Pattern.reverseFlags(flags);
        }
        if (role != 1 && role != 2) {
            throw new IllegalArgumentException("Role must be initiator or responder");
        }
        this.symmetric = new SymmetricState(cipher, hash);
        this.isInitiator = role == 1;
        this.action = 0;
        this.requirements = extraReqs | HandshakeState.computeRequirements(flags, prefix, role, false);
        this.patternIndex = 1;
        if ((flags & 1) != 0) {
            this.localKeyPair = new Curve25519DHState(xdh);
        }
        if ((flags & 2) != 0) {
            this.localEphemeral = new Curve25519DHState(xdh);
        }
        if ((flags & 0x100) != 0) {
            this.remotePublicKey = new Curve25519DHState(xdh);
        }
        if ((flags & 0x200) != 0) {
            this.remoteEphemeral = new Curve25519DHState(xdh);
        }
    }

    public String getProtocolName() {
        return this.symmetric.getProtocolName();
    }

    public int getRole() {
        return this.isInitiator ? 1 : 2;
    }

    public DHState getLocalKeyPair() {
        return this.localKeyPair;
    }

    public boolean needsLocalKeyPair() {
        if (this.localKeyPair != null) {
            return !this.localKeyPair.hasPrivateKey();
        }
        return false;
    }

    public boolean hasLocalKeyPair() {
        if (this.localKeyPair != null) {
            return this.localKeyPair.hasPrivateKey();
        }
        return false;
    }

    public DHState getRemotePublicKey() {
        return this.remotePublicKey;
    }

    public boolean needsRemotePublicKey() {
        if (this.remotePublicKey != null) {
            return !this.remotePublicKey.hasPublicKey();
        }
        return false;
    }

    public boolean hasRemotePublicKey() {
        if (this.remotePublicKey != null) {
            return this.remotePublicKey.hasPublicKey();
        }
        return false;
    }

    public void start() {
        if (this.action != 0) {
            throw new IllegalStateException("Handshake has already started; cannot start again");
        }
        if ((pattern[0] & 0x800) != 0 && (this.requirements & 8) == 0) {
            throw new UnsupportedOperationException("Cannot start a fallback pattern");
        }
        if (!((this.requirements & 1) == 0 || this.localKeyPair != null && this.localKeyPair.hasPrivateKey())) {
            throw new IllegalStateException("Local static key required");
        }
        if (!((this.requirements & 2) == 0 || this.remotePublicKey != null && this.remotePublicKey.hasPublicKey())) {
            throw new IllegalStateException("Remote static key required");
        }
        this.symmetric.mixHash(emptyPrologue, 0, 0);
        if (this.isInitiator) {
            if ((this.requirements & 0x10) != 0) {
                this.symmetric.mixPublicKey(this.localKeyPair);
            }
            if ((this.requirements & 8) != 0) {
                this.symmetric.mixPublicKey(this.remoteEphemeral);
            }
            if ((this.requirements & 0x20) != 0) {
                this.symmetric.mixPublicKey(this.remotePublicKey);
            }
        } else {
            if ((this.requirements & 0x20) != 0) {
                this.symmetric.mixPublicKey(this.remotePublicKey);
            }
            if ((this.requirements & 8) != 0) {
                this.symmetric.mixPublicKey(this.localEphemeral);
            }
            if ((this.requirements & 0x10) != 0) {
                this.symmetric.mixPublicKey(this.localKeyPair);
            }
        }
        this.action = this.isInitiator ? 1 : 2;
    }

    public int getAction() {
        return this.action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mixDH(DHState local, DHState remote) {
        if (local == null || remote == null) {
            throw new IllegalStateException("Pattern definition error");
        }
        int len = local.getSharedKeyLength();
        byte[] shared = new byte[len];
        try {
            local.calculate(shared, 0, remote);
            this.symmetric.mixKey(shared, 0, len);
        }
        finally {
            Noise.destroy(shared);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int writeMessage(byte[] message, int messageOffset, byte[] payload, int payloadOffset, int payloadLength) throws ShortBufferException {
        int messagePosn = messageOffset;
        boolean success = false;
        if (this.action != 1) {
            throw new IllegalStateException("Handshake state does not allow writing messages");
        }
        if (payload == null) {
            if (payloadOffset != 0) throw new IllegalArgumentException("Invalid payload argument");
            if (payloadLength != 0) {
                throw new IllegalArgumentException("Invalid payload argument");
            }
        }
        if (messageOffset > message.length) {
            throw new ShortBufferException();
        }
        try {
            block24: {
                short token;
                block10: while (true) {
                    if (this.patternIndex >= pattern.length) {
                        this.action = 4;
                        break block24;
                    }
                    if ((token = pattern[this.patternIndex++]) == 255) {
                        this.action = 2;
                        break block24;
                    }
                    int space = message.length - messagePosn;
                    switch (token) {
                        case 2: {
                            if (this.localEphemeral == null) {
                                throw new IllegalStateException("Pattern definition error");
                            }
                            this.localEphemeral.generateKeyPair();
                            int len = this.localEphemeral.getPublicKeyLength();
                            if (space < len) {
                                throw new ShortBufferException();
                            }
                            this.localEphemeral.getPublicKey(message, messagePosn);
                            this.symmetric.mixHash(message, messagePosn, len);
                            messagePosn += len;
                            continue block10;
                        }
                        case 1: {
                            int macLen;
                            if (this.localKeyPair == null) {
                                throw new IllegalStateException("Pattern definition error");
                            }
                            int len = this.localKeyPair.getPublicKeyLength();
                            if (space < len + (macLen = this.symmetric.getMACLength())) {
                                throw new ShortBufferException();
                            }
                            this.localKeyPair.getPublicKey(message, messagePosn);
                            messagePosn += this.symmetric.encryptAndHash(message, messagePosn, message, messagePosn, len);
                            continue block10;
                        }
                        case 3: {
                            this.mixDH(this.localEphemeral, this.remoteEphemeral);
                            continue block10;
                        }
                        case 4: {
                            if (this.isInitiator) {
                                this.mixDH(this.localEphemeral, this.remotePublicKey);
                                continue block10;
                            }
                            this.mixDH(this.localKeyPair, this.remoteEphemeral);
                            continue block10;
                        }
                        case 5: {
                            if (this.isInitiator) {
                                this.mixDH(this.localKeyPair, this.remoteEphemeral);
                                continue block10;
                            }
                            this.mixDH(this.localEphemeral, this.remotePublicKey);
                            continue block10;
                        }
                    }
                    break;
                }
                throw new IllegalStateException("Unknown handshake token " + Integer.toString(token));
            }
            messagePosn = payload != null ? (messagePosn += this.symmetric.encryptAndHash(payload, payloadOffset, message, messagePosn, payloadLength)) : (messagePosn += this.symmetric.encryptAndHash(message, messagePosn, message, messagePosn, 0));
            success = true;
            return messagePosn - messageOffset;
        }
        finally {
            if (!success) {
                Arrays.fill(message, messageOffset, message.length - messageOffset, (byte)0);
                this.action = 3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readMessage(byte[] message, int messageOffset, int messageLength, byte[] payload, int payloadOffset) throws ShortBufferException, BadPaddingException {
        boolean success = false;
        int messageEnd = messageOffset + messageLength;
        if (this.action != 2) {
            throw new IllegalStateException("Handshake state does not allow reading messages");
        }
        if (messageOffset > message.length) throw new ShortBufferException();
        if (payloadOffset > payload.length) {
            throw new ShortBufferException();
        }
        if (messageLength > message.length - messageOffset) {
            throw new ShortBufferException();
        }
        try {
            block28: {
                short token;
                block13: while (true) {
                    if (this.patternIndex >= pattern.length) {
                        this.action = 4;
                        break block28;
                    }
                    if ((token = pattern[this.patternIndex++]) == 255) {
                        this.action = 1;
                        break block28;
                    }
                    int space = messageEnd - messageOffset;
                    switch (token) {
                        case 2: {
                            if (this.remoteEphemeral == null) {
                                throw new IllegalStateException("Pattern definition error");
                            }
                            int len = this.remoteEphemeral.getPublicKeyLength();
                            if (space < len) {
                                throw new ShortBufferException();
                            }
                            this.symmetric.mixHash(message, messageOffset, len);
                            this.remoteEphemeral.setPublicKey(message, messageOffset);
                            if (this.remoteEphemeral.isNullPublicKey()) {
                                throw new BadPaddingException("Null remote public key");
                            }
                            messageOffset += len;
                            continue block13;
                        }
                        case 1: {
                            int macLen;
                            if (this.remotePublicKey == null) {
                                throw new IllegalStateException("Pattern definition error");
                            }
                            int len = this.remotePublicKey.getPublicKeyLength();
                            if (space < len + (macLen = this.symmetric.getMACLength())) {
                                throw new ShortBufferException();
                            }
                            byte[] temp = new byte[len];
                            try {
                                if (this.symmetric.decryptAndHash(message, messageOffset, temp, 0, len + macLen) != len) {
                                    throw new ShortBufferException();
                                }
                                this.remotePublicKey.setPublicKey(temp, 0);
                            }
                            finally {
                                Noise.destroy(temp);
                            }
                            messageOffset += len + macLen;
                            continue block13;
                        }
                        case 3: {
                            this.mixDH(this.localEphemeral, this.remoteEphemeral);
                            continue block13;
                        }
                        case 4: {
                            if (this.isInitiator) {
                                this.mixDH(this.localEphemeral, this.remotePublicKey);
                                continue block13;
                            }
                            this.mixDH(this.localKeyPair, this.remoteEphemeral);
                            continue block13;
                        }
                        case 5: {
                            if (this.isInitiator) {
                                this.mixDH(this.localKeyPair, this.remoteEphemeral);
                                continue block13;
                            }
                            this.mixDH(this.localEphemeral, this.remotePublicKey);
                            continue block13;
                        }
                    }
                    break;
                }
                throw new IllegalStateException("Unknown handshake token " + Integer.toString(token));
            }
            int payloadLength = this.symmetric.decryptAndHash(message, messageOffset, payload, payloadOffset, messageEnd - messageOffset);
            success = true;
            int n = payloadLength;
            return n;
        }
        finally {
            if (!success) {
                Arrays.fill(payload, payloadOffset, payload.length - payloadOffset, (byte)0);
                this.action = 3;
            }
        }
    }

    public CipherStatePair split() {
        if (this.action != 4) {
            throw new IllegalStateException("Handshake has not finished");
        }
        CipherStatePair pair = this.symmetric.split();
        if (!this.isInitiator) {
            pair.swap();
        }
        this.action = 5;
        return pair;
    }

    public CipherStatePair split(byte[] secondaryKey, int offset, int length) {
        if (this.action != 4) {
            throw new IllegalStateException("Handshake has not finished");
        }
        CipherStatePair pair = this.symmetric.split(secondaryKey, offset, length);
        if (!this.isInitiator) {
            pair.swap();
        }
        this.action = 5;
        return pair;
    }

    public byte[] getHandshakeHash() {
        if (this.action != 4 && this.action != 5) {
            throw new IllegalStateException("Handshake has not completed");
        }
        return this.symmetric.getHandshakeHash();
    }

    @Override
    public void destroy() {
        if (this.symmetric != null) {
            this.symmetric.destroy();
        }
        if (this.localKeyPair != null) {
            this.localKeyPair.destroy();
        }
        if (this.localEphemeral != null) {
            this.localEphemeral.destroy();
        }
        if (this.remotePublicKey != null) {
            this.remotePublicKey.destroy();
        }
        if (this.remoteEphemeral != null) {
            this.remoteEphemeral.destroy();
        }
    }

    private static int computeRequirements(short flags, String prefix, int role, boolean isFallback) {
        int requirements = 0;
        if ((flags & 1) != 0) {
            requirements |= 1;
        }
        if ((flags & 4) != 0) {
            requirements |= 1;
            requirements |= 0x10;
        }
        if ((flags & 0x400) != 0) {
            requirements |= 2;
            requirements |= 0x20;
        }
        if ((flags & 0x808) != 0 && isFallback) {
            requirements |= 8;
        }
        return requirements;
    }

    public void mixHash(byte[] data, int offset, int length) {
        this.symmetric.mixHash(data, offset, length);
    }

    public byte[] getChainingKey() {
        return this.symmetric.getChainingKey();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Handshake State:\n");
        buf.append(this.symmetric.toString());
        byte[] tmp = new byte[32];
        DHState dh = this.localKeyPair;
        buf.append("Local static public key (s) :      ");
        if (dh != null && dh.hasPublicKey()) {
            dh.getPublicKey(tmp, 0);
            buf.append(Base64.encode(tmp));
        } else {
            buf.append("null");
        }
        buf.append('\n');
        dh = this.remotePublicKey;
        buf.append("Remote static public key (rs) :    ");
        if (dh != null && dh.hasPublicKey()) {
            dh.getPublicKey(tmp, 0);
            buf.append(Base64.encode(tmp));
        } else {
            buf.append("null");
        }
        buf.append('\n');
        dh = this.localEphemeral;
        buf.append("Local ephemeral public key (e) :   ");
        if (dh != null && dh.hasPublicKey()) {
            dh.getPublicKey(tmp, 0);
            buf.append(Base64.encode(tmp));
        } else {
            buf.append("null");
        }
        buf.append('\n');
        dh = this.remoteEphemeral;
        buf.append("Remote ephemeral public key (re) : ");
        if (dh != null && dh.hasPublicKey()) {
            dh.getPublicKey(tmp, 0);
            buf.append(Base64.encode(tmp));
        } else {
            buf.append("null");
        }
        buf.append('\n');
        return buf.toString();
    }

    static {
        String[] components = protocolName.split("_");
        if (components.length != 5) {
            throw new IllegalArgumentException("Protocol name must have 5 components");
        }
        prefix = components[0];
        patternId = components[1].substring(0, 2);
        dh = components[2];
        cipher = components[3];
        hash = components[4];
        if (!prefix.equals("Noise") && !prefix.equals("NoisePSK")) {
            throw new IllegalArgumentException("Prefix must be Noise or NoisePSK");
        }
        pattern = Pattern.lookup(patternId);
        if (pattern == null) {
            throw new IllegalArgumentException("Handshake pattern is not recognized");
        }
        if (!dh.equals("25519")) {
            throw new IllegalArgumentException("Unknown Noise DH algorithm name: " + dh);
        }
        emptyPrologue = new byte[0];
    }
}

