/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.access;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import net.i2p.data.Hash;
import net.i2p.i2ptunnel.access.DestTracker;
import net.i2p.i2ptunnel.access.FilterDefinitionElement;
import net.i2p.i2ptunnel.access.InvalidDefinitionException;
import net.i2p.i2ptunnel.access.Threshold;

class FileFilterDefinitionElement
extends FilterDefinitionElement {
    private final File file;

    FileFilterDefinitionElement(File file, Threshold threshold) {
        super(threshold);
        this.file = file;
    }

    @Override
    public void update(Map<Hash, DestTracker> map) throws IOException {
        if (!this.file.exists() || !this.file.isFile()) {
            return;
        }
        BufferedReader reader = null;
        try {
            String b32;
            reader = new BufferedReader(new FileReader(this.file));
            while ((b32 = reader.readLine()) != null) {
                Hash hash = FileFilterDefinitionElement.fromBase32(b32);
                if (map.containsKey(hash)) continue;
                map.put(hash, new DestTracker(hash, this.threshold));
            }
        }
        catch (InvalidDefinitionException bad32) {
            throw new IOException("invalid access list entry", bad32);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

