/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManager;
import net.i2p.app.ClientAppState;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.data.DataHelper;
import net.i2p.i2ptunnel.I2PTunnelClientBase;
import net.i2p.i2ptunnel.TunnelController;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.OrderedProperties;
import net.i2p.util.SystemVersion;

public class TunnelControllerGroup
implements ClientApp {
    private final Log _log;
    private volatile ClientAppState _state;
    private final I2PAppContext _context;
    private final ClientAppManager _mgr;
    private static volatile TunnelControllerGroup _instance;
    static final String DEFAULT_CONFIG_FILE = "i2ptunnel.config";
    private final List<TunnelController> _controllers;
    private final ReadWriteLock _controllersLock;
    private boolean _controllersLoaded;
    private final String _configFile;
    private static final String REGISTERED_NAME = "i2ptunnel";
    private final Map<I2PSession, Set<TunnelController>> _sessions;
    private ThreadPoolExecutor _executor;
    private static final AtomicLong _executorThreadCount;
    private final Object _executorLock = new Object();
    private static final long HANDLER_KEEPALIVE_MS = 120000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TunnelControllerGroup getInstance() {
        Class<TunnelControllerGroup> clazz = TunnelControllerGroup.class;
        synchronized (TunnelControllerGroup.class) {
            I2PAppContext ctx;
            if (_instance == null && !SystemVersion.isAndroid() && !(ctx = I2PAppContext.getGlobalContext()).isRouterContext()) {
                _instance = new TunnelControllerGroup(ctx, null, null);
                _instance.startup();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TunnelControllerGroup getInstance(I2PAppContext ctx) {
        Class<TunnelControllerGroup> clazz = TunnelControllerGroup.class;
        synchronized (TunnelControllerGroup.class) {
            if (_instance == null) {
                if (SystemVersion.isAndroid() || !ctx.isRouterContext()) {
                    _instance = new TunnelControllerGroup(ctx, null, null);
                    _instance.startup();
                }
            } else if (SystemVersion.isAndroid() && TunnelControllerGroup._instance._context != ctx) {
                ctx.logManager().getLog(TunnelControllerGroup.class).warn("Old context in TCG");
                _instance.shutdown();
                _instance = new TunnelControllerGroup(ctx, null, null);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TunnelControllerGroup(I2PAppContext context, ClientAppManager mgr, String[] args) {
        this._state = ClientAppState.UNINITIALIZED;
        this._context = context;
        this._mgr = mgr;
        this._log = this._context.logManager().getLog(TunnelControllerGroup.class);
        this._controllers = new ArrayList<TunnelController>();
        this._controllersLock = new ReentrantReadWriteLock(true);
        if (args == null || args.length <= 0) {
            this._configFile = DEFAULT_CONFIG_FILE;
        } else if (args.length == 1) {
            this._configFile = args[0];
        } else {
            throw new IllegalArgumentException("Usage: TunnelControllerGroup [filename]");
        }
        this._sessions = new HashMap<I2PSession, Set<TunnelController>>(4);
        Class<TunnelControllerGroup> clazz = TunnelControllerGroup.class;
        synchronized (TunnelControllerGroup.class) {
            if (_instance == null) {
                _instance = this;
            } else {
                this._log.logAlways(30, "New TunnelControllerGroup, now you have two");
                if (this._log.shouldLog(30)) {
                    this._log.warn("I did it", new Exception());
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this._state = ClientAppState.INITIALIZED;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Class<TunnelControllerGroup> clazz = TunnelControllerGroup.class;
        synchronized (TunnelControllerGroup.class) {
            if (_instance != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            _instance = new TunnelControllerGroup(I2PAppContext.getGlobalContext(), null, args);
            _instance.startup();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup() {
        try {
            this.loadControllers(this._configFile);
        }
        catch (IllegalArgumentException iae) {
            if (DEFAULT_CONFIG_FILE.equals(this._configFile) && !this._context.isRouterContext()) {
                TunnelControllerGroup tunnelControllerGroup = this;
                synchronized (tunnelControllerGroup) {
                    this._controllersLoaded = true;
                }
                this._log.logAlways(30, "Not in router context and no preconfigured tunnels");
            }
            throw iae;
        }
        this.startControllers();
        if (this._mgr != null) {
            this._mgr.register(this);
        } else {
            this._context.addShutdownTask(new Shutdown());
        }
    }

    @Override
    public ClientAppState getState() {
        return this._state;
    }

    @Override
    public String getName() {
        return REGISTERED_NAME;
    }

    @Override
    public String getDisplayName() {
        return REGISTERED_NAME;
    }

    private void changeState(ClientAppState state) {
        this.changeState(state, null);
    }

    private synchronized void changeState(ClientAppState state, Exception e) {
        this._state = state;
        if (this._mgr != null) {
            this._mgr.notify(this, state, null, e);
        }
    }

    @Override
    public void shutdown(String[] args) {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        if (this._state != ClientAppState.STARTING && this._state != ClientAppState.RUNNING) {
            return;
        }
        this.changeState(ClientAppState.STOPPING);
        if (this._mgr != null) {
            this._mgr.unregister(this);
        }
        this.unloadControllers();
        Class<TunnelControllerGroup> clazz = TunnelControllerGroup.class;
        synchronized (TunnelControllerGroup.class) {
            if (_instance == this) {
                _instance = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.killClientExecutor();
            this.changeState(ClientAppState.STOPPED);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadControllers(String configFile) {
        if (this._controllersLoaded) {
            return;
        }
        Properties cfg = this.loadConfig(configFile);
        int i = 0;
        this._controllersLock.writeLock().lock();
        try {
            String type;
            while ((type = cfg.getProperty("tunnel." + i + ".type")) != null) {
                TunnelController controller = new TunnelController(cfg, "tunnel." + i + ".");
                this._controllers.add(controller);
                ++i;
            }
        }
        finally {
            this._controllersLock.writeLock().unlock();
        }
        this._controllersLoaded = true;
        if (i > 0) {
            if (this._log.shouldLog(20)) {
                this._log.info(i + " controllers loaded from " + configFile);
            }
        } else {
            this._log.logAlways(30, "No i2ptunnel configurations found in " + configFile);
        }
    }

    private synchronized void startControllers() {
        this.changeState(ClientAppState.STARTING);
        I2PAppThread startupThread = new I2PAppThread(new StartControllers(), "Startup tunnels");
        startupThread.start();
        this.changeState(ClientAppState.RUNNING);
    }

    public synchronized void reloadControllers() {
        this.unloadControllers();
        this.loadControllers(this._configFile);
        this.startControllers();
    }

    public synchronized void unloadControllers() {
        if (!this._controllersLoaded) {
            return;
        }
        this._controllersLock.writeLock().lock();
        try {
            this.destroyAllControllers();
            this._controllers.clear();
        }
        finally {
            this._controllersLock.writeLock().unlock();
        }
        this._controllersLoaded = false;
        if (this._log.shouldLog(20)) {
            this._log.info("All controllers stopped and unloaded");
        }
    }

    public synchronized void addController(TunnelController controller) {
        this._controllersLock.writeLock().lock();
        try {
            this._controllers.add(controller);
        }
        finally {
            this._controllersLock.writeLock().unlock();
        }
    }

    public synchronized List<String> removeController(TunnelController controller) {
        if (controller == null) {
            return new ArrayList<String>();
        }
        controller.stopTunnel();
        List<String> msgs = controller.clearMessages();
        this._controllersLock.writeLock().lock();
        try {
            this._controllers.remove(controller);
        }
        finally {
            this._controllersLock.writeLock().unlock();
        }
        msgs.add("Tunnel " + controller.getName() + " removed");
        return msgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<String> stopAllControllers() {
        ArrayList<String> msgs = new ArrayList<String>();
        this._controllersLock.readLock().lock();
        try {
            for (int i = 0; i < this._controllers.size(); ++i) {
                TunnelController controller = this._controllers.get(i);
                controller.stopTunnel();
                msgs.addAll(controller.clearMessages());
            }
            if (this._log.shouldLog(20)) {
                this._log.info(this._controllers.size() + " controllers stopped");
            }
        }
        finally {
            this._controllersLock.readLock().unlock();
        }
        return msgs;
    }

    private void destroyAllControllers() {
        for (int i = 0; i < this._controllers.size(); ++i) {
            TunnelController controller = this._controllers.get(i);
            controller.destroyTunnel();
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this._controllers.size() + " controllers stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<String> startAllControllers() {
        ArrayList<String> msgs = new ArrayList<String>();
        this._controllersLock.readLock().lock();
        try {
            for (int i = 0; i < this._controllers.size(); ++i) {
                TunnelController controller = this._controllers.get(i);
                controller.startTunnelBackground();
                msgs.addAll(controller.clearMessages());
            }
            if (this._log.shouldLog(20)) {
                this._log.info(this._controllers.size() + " controllers started");
            }
        }
        finally {
            this._controllersLock.readLock().unlock();
        }
        return msgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<String> restartAllControllers() {
        ArrayList<String> msgs = new ArrayList<String>();
        this._controllersLock.readLock().lock();
        try {
            for (int i = 0; i < this._controllers.size(); ++i) {
                TunnelController controller = this._controllers.get(i);
                controller.restartTunnel();
                msgs.addAll(controller.clearMessages());
            }
            if (this._log.shouldLog(20)) {
                this._log.info(this._controllers.size() + " controllers restarted");
            }
        }
        finally {
            this._controllersLock.readLock().unlock();
        }
        return msgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> clearAllMessages() {
        ArrayList<String> msgs = new ArrayList<String>();
        this._controllersLock.readLock().lock();
        try {
            for (int i = 0; i < this._controllers.size(); ++i) {
                TunnelController controller = this._controllers.get(i);
                msgs.addAll(controller.clearMessages());
            }
        }
        finally {
            this._controllersLock.readLock().unlock();
        }
        return msgs;
    }

    public void saveConfig() throws IOException {
        this.saveConfig(this._configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveConfig(String configFile) throws IOException {
        File parent;
        File cfgFile = new File(configFile);
        if (!cfgFile.isAbsolute()) {
            cfgFile = new File(I2PAppContext.getGlobalContext().getConfigDir(), configFile);
        }
        if ((parent = cfgFile.getParentFile()) != null && !parent.exists()) {
            parent.mkdirs();
        }
        OrderedProperties map = new OrderedProperties();
        this._controllersLock.readLock().lock();
        try {
            for (int i = 0; i < this._controllers.size(); ++i) {
                TunnelController controller = this._controllers.get(i);
                Properties cur = controller.getConfig("tunnel." + i + ".");
                map.putAll((Map<?, ?>)cur);
            }
        }
        finally {
            this._controllersLock.readLock().unlock();
        }
        DataHelper.storeProps(map, cfgFile);
    }

    private synchronized Properties loadConfig(String configFile) {
        File cfgFile = new File(configFile);
        if (!cfgFile.isAbsolute()) {
            cfgFile = new File(I2PAppContext.getGlobalContext().getConfigDir(), configFile);
        }
        if (!cfgFile.exists()) {
            if (this._log.shouldLog(40)) {
                this._log.error("Unable to load the controllers from " + cfgFile.getAbsolutePath());
            }
            throw new IllegalArgumentException("Unable to load the controllers from " + cfgFile.getAbsolutePath());
        }
        Properties props = new Properties();
        try {
            DataHelper.loadProps(props, cfgFile);
            return props;
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error reading the controllers from " + cfgFile.getAbsolutePath(), ioe);
            }
            throw new IllegalArgumentException("Error reading the controllers from " + cfgFile.getAbsolutePath(), ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TunnelController> getControllers() {
        Object object = this;
        synchronized (object) {
            if (!this._controllersLoaded) {
                this.loadControllers(this._configFile);
            }
        }
        this._controllersLock.readLock().lock();
        try {
            object = new ArrayList<TunnelController>(this._controllers);
            return object;
        }
        finally {
            this._controllersLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acquire(TunnelController controller, I2PSession session) {
        Map<I2PSession, Set<TunnelController>> map = this._sessions;
        synchronized (map) {
            Set<TunnelController> owners = this._sessions.get(session);
            if (owners == null) {
                owners = new HashSet<TunnelController>(2);
                this._sessions.put(session, owners);
            }
            owners.add(controller);
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Acquiring session " + session + " for " + controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(TunnelController controller, I2PSession session) {
        boolean shouldClose = false;
        Map<I2PSession, Set<TunnelController>> map = this._sessions;
        synchronized (map) {
            Set<TunnelController> owners = this._sessions.get(session);
            if (owners != null) {
                owners.remove(controller);
                if (owners.isEmpty()) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("After releasing session " + session + " by " + controller + ", no more owners remain");
                    }
                    shouldClose = true;
                    this._sessions.remove(session);
                } else {
                    if (this._log.shouldLog(20)) {
                        this._log.info("After releasing session " + session + " by " + controller + ", " + owners.size() + " owners remain");
                    }
                    shouldClose = false;
                }
            } else {
                if (this._log.shouldLog(30)) {
                    this._log.warn("After releasing session " + session + " by " + controller + ", no owners were even known?!");
                }
                shouldClose = true;
            }
        }
        if (shouldClose) {
            try {
                session.destroySession();
                if (this._log.shouldLog(20)) {
                    this._log.info("Session destroyed: " + session);
                }
            }
            catch (I2PSessionException ise) {
                this._log.error("Error closing the client session", ise);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ThreadPoolExecutor getClientExecutor() {
        Object object = this._executorLock;
        synchronized (object) {
            if (this._executor == null) {
                this._executor = new CustomThreadPoolExecutor();
            }
        }
        return this._executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killClientExecutor() {
        Object object = this._executorLock;
        synchronized (object) {
            if (this._executor != null) {
                this._executor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
                this._executor.shutdownNow();
                this._executor = null;
            }
        }
        I2PTunnelClientBase.killSharedClient();
    }

    static {
        _executorThreadCount = new AtomicLong();
    }

    private static class CustomThreadFactory
    implements ThreadFactory {
        private CustomThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread rv = Executors.defaultThreadFactory().newThread(r);
            rv.setName("I2PTunnel Client Runner " + _executorThreadCount.incrementAndGet());
            rv.setDaemon(true);
            return rv;
        }
    }

    static class CustomThreadPoolExecutor
    extends ThreadPoolExecutor {
        public CustomThreadPoolExecutor() {
            super(0, Integer.MAX_VALUE, 120000L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new CustomThreadFactory());
        }
    }

    private class Shutdown
    implements Runnable {
        private Shutdown() {
        }

        @Override
        public void run() {
            TunnelControllerGroup.this.shutdown();
        }
    }

    private class StartControllers
    implements Runnable {
        private StartControllers() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TunnelControllerGroup tunnelControllerGroup = TunnelControllerGroup.this;
            synchronized (tunnelControllerGroup) {
                TunnelControllerGroup.this._controllersLock.readLock().lock();
                try {
                    if (TunnelControllerGroup.this._controllers.size() <= 0) {
                        TunnelControllerGroup.this._log.logAlways(30, "No configured tunnels to start");
                        return;
                    }
                    for (int i = 0; i < TunnelControllerGroup.this._controllers.size(); ++i) {
                        TunnelController controller = (TunnelController)TunnelControllerGroup.this._controllers.get(i);
                        if (!controller.getStartOnLoad()) continue;
                        controller.startTunnelBackground();
                    }
                }
                finally {
                    TunnelControllerGroup.this._controllersLock.readLock().unlock();
                }
            }
        }
    }
}

