/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.text.Collator;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.util.HashDistance;
import net.i2p.router.web.Messages;
import net.i2p.util.ObjectCounter;
import net.i2p.util.VersionComparator;

public class NetDbRenderer {
    private final RouterContext _context;
    private static final int SSU = 1;
    private static final int SSUI = 2;
    private static final int NTCP = 4;
    private static final String[] TNAMES = new String[]{NetDbRenderer._x("Hidden or starting up"), NetDbRenderer._x("SSU"), NetDbRenderer._x("SSU with introducers"), "", NetDbRenderer._x("NTCP"), NetDbRenderer._x("NTCP and SSU"), NetDbRenderer._x("NTCP and SSU with introducers"), ""};

    public NetDbRenderer(RouterContext ctx) {
        this._context = ctx;
    }

    public void renderRouterInfoHTML(Writer out, String routerPrefix) throws IOException {
        StringBuilder buf = new StringBuilder(4096);
        if (".".equals(routerPrefix)) {
            this.renderRouterInfo(buf, this._context.router().getRouterInfo(), true, true);
        } else {
            boolean notFound = true;
            Set<RouterInfo> routers = this._context.netDb().getRouters();
            for (RouterInfo ri : routers) {
                Hash key = ri.getIdentity().getHash();
                if (!key.toBase64().startsWith(routerPrefix)) continue;
                this.renderRouterInfo(buf, ri, false, true);
                notFound = false;
            }
            if (notFound) {
                buf.append(this._("Router") + ' ').append(routerPrefix).append(' ' + this._("not found in network database"));
            }
        }
        out.write(buf.toString());
        out.flush();
    }

    public void renderLeaseSetHTML(Writer out, boolean debug) throws IOException {
        DecimalFormat fmt;
        TreeSet<LeaseSet> leases;
        Hash ourRKey;
        StringBuilder buf = new StringBuilder(4096);
        if (debug) {
            buf.append("<p>Debug mode - Sorted by hash distance, closest first</p>\n");
        }
        if (debug) {
            ourRKey = this._context.routerHash();
            leases = new TreeSet<LeaseSet>(new LeaseSetRoutingKeyComparator(ourRKey));
            fmt = new DecimalFormat("#0.00");
        } else {
            ourRKey = null;
            leases = new TreeSet<LeaseSet>(new LeaseSetComparator());
            fmt = null;
        }
        leases.addAll(this._context.netDb().getLeases());
        int medianCount = 0;
        int rapCount = 0;
        BigInteger median = null;
        int c = 0;
        if (debug) {
            for (LeaseSet ls : leases) {
                if (!ls.getReceivedAsPublished()) continue;
                ++rapCount;
            }
            medianCount = rapCount / 2;
        }
        long now = this._context.clock().now();
        for (LeaseSet ls : leases) {
            Destination dest = ls.getDestination();
            Hash key = dest.calculateHash();
            buf.append("<b>").append(this._("LeaseSet")).append(": ").append(key.toBase64());
            if (this._context.clientManager().isLocal(dest)) {
                buf.append(" (<a href=\"tunnels#" + key.toBase64().substring(0, 4) + "\">" + this._("Local") + "</a> ");
                if (!this._context.clientManager().shouldPublishLeaseSet(key)) {
                    buf.append(this._("Unpublished") + ' ');
                }
                buf.append(this._("Destination") + ' ');
                TunnelPoolSettings in = this._context.tunnelManager().getInboundSettings(key);
                if (in != null && in.getDestinationNickname() != null) {
                    buf.append(in.getDestinationNickname());
                } else {
                    buf.append(dest.toBase64().substring(0, 6));
                }
            } else {
                buf.append(" (" + this._("Destination") + ' ');
                String host = this._context.namingService().reverseLookup(dest);
                if (host != null) {
                    buf.append(host);
                } else {
                    buf.append(dest.toBase64().substring(0, 6));
                }
            }
            buf.append(")</b><br>\n");
            long exp = ls.getEarliestLeaseDate() - now;
            if (exp > 0L) {
                buf.append(this._("Expires in {0}", DataHelper.formatDuration2(exp))).append("<br>\n");
            } else {
                buf.append(this._("Expired {0} ago", DataHelper.formatDuration2(0L - exp))).append("<br>\n");
            }
            if (debug) {
                buf.append("RAP? " + ls.getReceivedAsPublished());
                buf.append(" RAR? " + ls.getReceivedAsReply());
                BigInteger dist = HashDistance.getDistance(ourRKey, ls.getRoutingKey());
                if (ls.getReceivedAsPublished() && c++ == medianCount) {
                    median = dist;
                }
                buf.append(" Dist: <b>").append(fmt.format(NetDbRenderer.biLog2(dist))).append("</b><br>");
                buf.append("Routing Key: ").append(ls.getRoutingKey().toBase64());
                buf.append("<br>");
                buf.append("Encryption Key: ").append(ls.getEncryptionKey().toBase64().substring(0, 20)).append("...<br>");
            }
            for (int i = 0; i < ls.getLeaseCount(); ++i) {
                buf.append(this._("Lease")).append(' ').append(i + 1).append(": " + this._("Gateway") + ' ');
                buf.append(this._context.commSystem().renderPeerHTML(ls.getLease(i).getGateway()));
                buf.append(' ' + this._("Tunnel") + ' ').append(ls.getLease(i).getTunnelId().getTunnelId()).append("<br>\n");
            }
            buf.append("<hr>\n");
            out.write(buf.toString());
            buf.setLength(0);
        }
        if (debug) {
            FloodfillNetworkDatabaseFacade netdb = (FloodfillNetworkDatabaseFacade)this._context.netDb();
            buf.append("<p><b>Total Leasesets: ").append(leases.size());
            buf.append("</b></p><p><b>Published (RAP) Leasesets: ").append(netdb.getKnownLeaseSets());
            buf.append("</b></p><p><b>Mod Data: \"").append(DataHelper.getUTF8(this._context.routingKeyGenerator().getModData())).append("\" Last Changed: ").append(new Date(this._context.routingKeyGenerator().getLastChanged()));
            int ff = this._context.peerManager().getPeersByCapability('f').size();
            buf.append("</b></p><p><b>Known Floodfills: ").append(ff);
            buf.append("</b></p><p><b>Currently Floodfill? ");
            buf.append(netdb.floodfillEnabled() ? "yes" : "no");
            buf.append("</b></p><p><b>Network data (only valid if floodfill):");
            if (median != null) {
                double log2 = NetDbRenderer.biLog2(median);
                buf.append("</b></p><p><b>Median distance (bits): ").append(fmt.format(log2));
                int total = (int)Math.round(Math.pow(2.0, 258.0 - log2));
                buf.append("</b></p><p><b>Estimated total floodfills: ").append(total);
                buf.append("</b></p><p><b>Estimated total leasesets: ").append(total * rapCount / 8);
            } else {
                buf.append("</b></p><p><b>Not floodfill or no data");
            }
            buf.append("</b></p>");
        }
        out.write(buf.toString());
        out.flush();
    }

    private static double biLog2(BigInteger a) {
        int b = a.bitLength() - 1;
        double c = 0.0;
        double d = 0.5;
        for (int i = b; i >= 0; --i) {
            if (a.testBit(i)) {
                c += d;
            }
            d /= 2.0;
        }
        return (double)b + c;
    }

    public void renderStatusHTML(Writer out, int mode) throws IOException {
        if (!this._context.netDb().isInitialized()) {
            out.write(this._("Not initialized"));
            out.flush();
            return;
        }
        boolean full = mode == 1;
        boolean shortStats = mode == 2;
        boolean showStats = full || shortStats;
        Hash us = this._context.routerHash();
        StringBuilder buf = new StringBuilder(8192);
        if (showStats) {
            RouterInfo ourInfo = this._context.router().getRouterInfo();
            this.renderRouterInfo(buf, ourInfo, true, true);
            out.write(buf.toString());
            buf.setLength(0);
        }
        ObjectCounter<String> versions = new ObjectCounter<String>();
        ObjectCounter<String> countries = new ObjectCounter<String>();
        int[] transportCount = new int[8];
        TreeSet<RouterInfo> routers = new TreeSet<RouterInfo>(new RouterInfoComparator());
        routers.addAll(this._context.netDb().getRouters());
        for (RouterInfo ri : routers) {
            String country;
            String routerVersion;
            Hash key = ri.getIdentity().getHash();
            boolean isUs = key.equals(us);
            if (isUs) continue;
            if (showStats) {
                this.renderRouterInfo(buf, ri, false, full);
                out.write(buf.toString());
                buf.setLength(0);
            }
            if ((routerVersion = ri.getOption("router.version")) != null) {
                versions.increment(routerVersion);
            }
            if ((country = this._context.commSystem().getCountry(key)) != null) {
                countries.increment(country);
            }
            int n = NetDbRenderer.classifyTransports(ri);
            transportCount[n] = transportCount[n] + 1;
        }
        if (!showStats) {
            buf.append("<table border=\"0\" cellspacing=\"30\"><tr><th colspan=\"3\">").append(this._("Network Database Router Statistics")).append("</th></tr><tr><td style=\"vertical-align: top;\">");
            ArrayList versionList = new ArrayList(versions.objects());
            if (!versionList.isEmpty()) {
                Collections.sort(versionList, Collections.reverseOrder(new VersionComparator()));
                buf.append("<table>\n");
                buf.append("<tr><th>" + this._("Version") + "</th><th>" + this._("Count") + "</th></tr>\n");
                for (String routerVersion : versionList) {
                    int num = versions.count(routerVersion);
                    buf.append("<tr><td align=\"center\">").append(DataHelper.stripHTML(routerVersion));
                    buf.append("</td><td align=\"center\">").append(num).append("</td></tr>\n");
                }
                buf.append("</table>\n");
            }
            buf.append("</td><td style=\"vertical-align: top;\">");
            out.write(buf.toString());
            buf.setLength(0);
            buf.append("<table>\n");
            buf.append("<tr><th align=\"left\">" + this._("Transports") + "</th><th>" + this._("Count") + "</th></tr>\n");
            for (int i = 0; i < 8; ++i) {
                int num = transportCount[i];
                if (num <= 0) continue;
                buf.append("<tr><td>").append(this._(TNAMES[i]));
                buf.append("</td><td align=\"center\">").append(num).append("</td></tr>\n");
            }
            buf.append("</table>\n");
            buf.append("</td><td style=\"vertical-align: top;\">");
            out.write(buf.toString());
            buf.setLength(0);
            ArrayList countryList = new ArrayList(countries.objects());
            if (!countryList.isEmpty()) {
                Collections.sort(countryList, new CountryComparator());
                buf.append("<table>\n");
                buf.append("<tr><th align=\"left\">" + this._("Country") + "</th><th>" + this._("Count") + "</th></tr>\n");
                for (String country : countryList) {
                    int num = countries.count(country);
                    buf.append("<tr><td><img height=\"11\" width=\"16\" alt=\"").append(country.toUpperCase(Locale.US)).append("\"");
                    buf.append(" src=\"/flags.jsp?c=").append(country).append("\"> ");
                    buf.append(this._(this._context.commSystem().getCountryName(country)));
                    buf.append("</td><td align=\"center\">").append(num).append("</td></tr>\n");
                }
                buf.append("</table>\n");
            }
            buf.append("</td></tr></table>");
        }
        out.write(buf.toString());
        out.flush();
    }

    private void renderRouterInfo(StringBuilder buf, RouterInfo info, boolean isUs, boolean full) {
        String hash = info.getIdentity().getHash().toBase64();
        buf.append("<table><tr><th><a name=\"").append(hash.substring(0, 6)).append("\" ></a>");
        if (isUs) {
            buf.append("<a name=\"our-info\" ></a><b>" + this._("Our info") + ": ").append(hash).append("</b></th></tr><tr><td>\n");
        } else {
            buf.append("<b>" + this._("Peer info for") + ":</b> ").append(hash).append("\n");
            if (!full) {
                buf.append("[<a href=\"netdb?r=").append(hash.substring(0, 6)).append("\" >").append(this._("Full entry")).append("</a>]");
            }
            buf.append("</th></tr><tr><td>\n");
        }
        long age = this._context.clock().now() - info.getPublished();
        if (isUs && this._context.router().isHidden()) {
            buf.append("<b>").append(this._("Hidden")).append(", ").append(this._("Updated")).append(":</b> ").append(this._("{0} ago", DataHelper.formatDuration2(age))).append("<br>\n");
        } else if (age > 0L) {
            buf.append("<b>").append(this._("Published")).append(":</b> ").append(this._("{0} ago", DataHelper.formatDuration2(age))).append("<br>\n");
        } else {
            buf.append("<b>" + this._("Published") + ":</b> in ").append(DataHelper.formatDuration2(0L - age)).append("???<br>\n");
        }
        buf.append("<b>" + this._("Address(es)") + ":</b> ");
        String country = this._context.commSystem().getCountry(info.getIdentity().getHash());
        if (country != null) {
            buf.append("<img height=\"11\" width=\"16\" alt=\"").append(country.toUpperCase(Locale.US)).append('\"');
            buf.append(" title=\"").append(this._(this._context.commSystem().getCountryName(country))).append('\"');
            buf.append(" src=\"/flags.jsp?c=").append(country).append("\"> ");
        }
        for (RouterAddress addr : info.getAddresses()) {
            String style = addr.getTransportStyle();
            buf.append("<b>").append(DataHelper.stripHTML(style)).append(":</b> ");
            int cost = addr.getCost();
            if (!(style.equals("SSU") && cost == 5 || style.equals("NTCP") && cost == 10)) {
                buf.append('[').append(this._("cost")).append('=').append("" + cost).append("] ");
            }
            Map p = addr.getOptionsMap();
            for (Map.Entry e : p.entrySet()) {
                String name = (String)e.getKey();
                String val = (String)e.getValue();
                buf.append('[').append(this._(DataHelper.stripHTML(name))).append('=').append(DataHelper.stripHTML(val)).append("] ");
            }
        }
        buf.append("</td></tr>\n");
        if (full) {
            buf.append("<tr><td>" + this._("Stats") + ": <br><code>");
            Map p = info.getOptionsMap();
            for (Map.Entry e : p.entrySet()) {
                String key = (String)e.getKey();
                String val = (String)e.getValue();
                buf.append(DataHelper.stripHTML(key)).append(" = ").append(DataHelper.stripHTML(val)).append("<br>\n");
            }
            buf.append("</code></td></tr>\n");
        }
        buf.append("</table>\n");
    }

    private static int classifyTransports(RouterInfo info) {
        int rv = 0;
        for (RouterAddress addr : info.getAddresses()) {
            String style = addr.getTransportStyle();
            if (style.equals("NTCP")) {
                rv |= 4;
                continue;
            }
            if (!style.equals("SSU")) continue;
            if (addr.getOption("iport0") != null) {
                rv |= 2;
                continue;
            }
            rv |= 1;
        }
        return rv;
    }

    private String _(String s) {
        return Messages.getString(s, this._context);
    }

    private static final String _x(String s) {
        return s;
    }

    private String _(String s, Object o) {
        return Messages.getString(s, o, this._context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CountryComparator
    implements Comparator<String> {
        Collator coll;

        public CountryComparator() {
            this.coll = Collator.getInstance(new Locale(Messages.getLanguage(NetDbRenderer.this._context)));
        }

        @Override
        public int compare(String l, String r) {
            return this.coll.compare(NetDbRenderer.this._(NetDbRenderer.this._context.commSystem().getCountryName(l)), NetDbRenderer.this._(NetDbRenderer.this._context.commSystem().getCountryName(r)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LeaseSetComparator
    implements Comparator<LeaseSet> {
        private LeaseSetComparator() {
        }

        @Override
        public int compare(LeaseSet l, LeaseSet r) {
            Destination dl = l.getDestination();
            Destination dr = r.getDestination();
            boolean locall = NetDbRenderer.this._context.clientManager().isLocal(dl);
            boolean localr = NetDbRenderer.this._context.clientManager().isLocal(dr);
            if (locall && !localr) {
                return -1;
            }
            if (localr && !locall) {
                return 1;
            }
            return dl.calculateHash().toBase64().compareTo(dr.calculateHash().toBase64());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LeaseSetRoutingKeyComparator
    implements Comparator<LeaseSet> {
        private final Hash _us;

        public LeaseSetRoutingKeyComparator(Hash us) {
            this._us = us;
        }

        @Override
        public int compare(LeaseSet l, LeaseSet r) {
            return HashDistance.getDistance(this._us, l.getRoutingKey()).subtract(HashDistance.getDistance(this._us, r.getRoutingKey())).signum();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RouterInfoComparator
    implements Comparator<RouterInfo> {
        private RouterInfoComparator() {
        }

        @Override
        public int compare(RouterInfo l, RouterInfo r) {
            return l.getIdentity().getHash().toBase64().compareTo(r.getIdentity().getHash().toBase64());
        }
    }
}

