/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.i2p.I2PAppContext;
import net.i2p.router.web.WebAppStarter;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.jetty.webapp.WebAppContext;

public class LocaleWebAppHandler
extends WebAppContext {
    private final I2PAppContext _context;

    public LocaleWebAppHandler(I2PAppContext ctx, String path, String warPath) {
        super(warPath, path);
        this._context = ctx;
        this.setInitParams(WebAppStarter.INIT_PARAMS);
    }

    public void handle(String pathInContext, HttpServletRequest httpRequest, HttpServletResponse httpResponse, int dispatch) throws IOException, ServletException {
        int len;
        if ("OPTIONS".equals(httpRequest.getMethod())) {
            this.handleOptions(httpRequest, httpResponse);
            return;
        }
        if (pathInContext.equals("/") || pathInContext.equals("/index.html")) {
            pathInContext = "/index.jsp";
        } else if (pathInContext.indexOf("/", 1) < 0 && !pathInContext.endsWith(".jsp") && !pathInContext.endsWith(".txt")) {
            pathInContext = pathInContext + ".jsp";
        }
        String newPath = pathInContext;
        if (pathInContext.equals("/help.jsp") && ((len = pathInContext.length()) < 8 || pathInContext.charAt(len - 7) != '_')) {
            String lang = this._context.getProperty("routerconsole.lang");
            if (lang == null || lang.length() <= 0) {
                lang = Locale.getDefault().getLanguage();
            }
            if (lang != null && lang.length() > 0 && !lang.equals("en")) {
                String servletPath;
                String testPath = pathInContext.substring(0, len - 4) + '_' + lang + ".jsp";
                PathMap.Entry servlet = this.getServletHandler().getHolderEntry(testPath);
                if (servlet != null && (servletPath = (String)servlet.getKey()) != null && !servletPath.startsWith("*")) {
                    newPath = testPath;
                }
            }
        }
        super.handle(newPath, httpRequest, httpResponse, dispatch);
    }

    public void handleOptions(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(405);
    }
}

