/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import net.i2p.router.RouterContext;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.Messages;
import net.i2p.router.web.NavHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomeHelper
extends HelperBase {
    private static final char S = ',';
    private static final String I = "/themes/console/images/";
    static final String PROP_SERVICES = "routerconsole.services";
    static final String PROP_FAVORITES = "routerconsole.favorites";
    static final String PROP_OLDHOME = "routerconsole.oldHomePage";
    private static final String PROP_SEARCH = "routerconsole.showSearch";
    static final String DEFAULT_SERVICES = HomeHelper._x("Addressbook") + ',' + HomeHelper._x("Manage your I2P hosts file here (I2P domain name resolution)") + ',' + "/dns" + ',' + "/themes/console/images/" + "book_addresses.png" + ',' + HomeHelper._x("Configure Bandwidth") + ',' + HomeHelper._x("I2P Bandwidth Configuration") + ',' + "/config" + ',' + "/themes/console/images/" + "action_log.png" + ',' + HomeHelper._x("Configure Language") + ',' + HomeHelper._x("Console Language Selection") + ',' + "/configui" + ',' + "/themes/console/images/" + "wrench_orange.png" + ',' + HomeHelper._x("Customize Home Page") + ',' + HomeHelper._x("I2P Home Page Configuration") + ',' + "/confighome" + ',' + "/themes/console/images/" + "home_page.png" + ',' + HomeHelper._x("Email") + ',' + HomeHelper._x("Anonymous webmail client") + ',' + "/susimail/susimail" + ',' + "/themes/console/images/" + "email.png" + ',' + HomeHelper._x("Help") + ',' + HomeHelper._x("I2P Router Help") + ',' + "/help" + ',' + "/themes/console/images/" + "support.png" + ',' + HomeHelper._x("Router Console") + ',' + HomeHelper._x("I2P Router Console") + ',' + "/console" + ',' + "/themes/console/images/" + "toolbox.png" + ',' + HomeHelper._x("Torrents") + ',' + HomeHelper._x("Built-in anonymous BitTorrent Client") + ',' + "/i2psnark/" + ',' + "/themes/console/images/" + "magnet.png" + ',' + HomeHelper._x("Website") + ',' + HomeHelper._x("Local web server") + ',' + "http://127.0.0.1:7658/" + ',' + "/themes/console/images/" + "server_32x32.png" + ',' + "";
    static final String DEFAULT_FAVORITES = HomeHelper._x("Bug Reports") + ',' + HomeHelper._x("Bug tracker") + ',' + "http://trac.i2p2.i2p/report/1" + ',' + "/themes/console/images/" + "bug.png" + ',' + HomeHelper._x("Dev Forum") + ',' + HomeHelper._x("Development forum") + ',' + "http://zzz.i2p/" + ',' + "/themes/console/images/" + "eepsite.png" + ',' + HomeHelper._x("diftracker") + ',' + HomeHelper._x("Bittorrent tracker") + ',' + "http://diftracker.i2p/" + ',' + "/themes/console/images/" + "eepsite.png" + ',' + "echelon.i2p" + ',' + HomeHelper._x("I2P Applications") + ',' + "http://echelon.i2p/" + ',' + "/themes/console/images/" + "eepsite.png" + ',' + HomeHelper._x("FAQ") + ',' + HomeHelper._x("Frequently Asked Questions") + ',' + "http://www.i2p2.i2p/faq" + ',' + "/themes/console/images/" + "question.png" + ',' + HomeHelper._x("Forum") + ',' + HomeHelper._x("Community forum") + ',' + "http://forum.i2p/" + ',' + "/themes/console/images/" + "eepsite.png" + ',' + HomeHelper._x("Anonymous Git Hosting") + ',' + HomeHelper._x("A public anonymous Git hosting site - supports pulling via Git and HTTP and pushing via SSH") + ',' + "http://git.repo.i2p/" + ',' + "/themes/console/images/" + "git-logo.png" + ',' + "Ident " + HomeHelper._x("Microblog") + ',' + HomeHelper._x("Your premier microblogging service on I2P") + ',' + "http://id3nt.i2p/" + ',' + "/themes/console/images/" + "ident_icon_blue.png" + ',' + HomeHelper._x("Javadocs") + ',' + HomeHelper._x("Technical documentation") + ',' + "http://i2p-javadocs.i2p/" + ',' + "/themes/console/images/" + "education.png" + ',' + HomeHelper._x("killyourtv.i2p") + ',' + HomeHelper._x("Debian and Tahoe-LAFS repositories") + ',' + "http://killyourtv.i2p/" + ',' + "/themes/console/images/" + "eepsite.png" + ',' + HomeHelper._x("Pastebin") + ',' + HomeHelper._x("I2P Pastebin") + ',' + "http://pastethis.i2p/" + ',' + "/themes/console/images/" + "eepsite.png" + ',' + "Planet I2P" + ',' + HomeHelper._x("I2P News") + ',' + "http://planet.i2p/" + ',' + "/themes/console/images/" + "eepsite.png" + ',' + HomeHelper._x("Plugins") + ',' + HomeHelper._x("Add-on directory") + ',' + "http://plugins.i2p/" + ',' + "/themes/console/images/" + "plugin.png" + ',' + HomeHelper._x("Postman's Tracker") + ',' + HomeHelper._x("Bittorrent tracker") + ',' + "http://tracker2.postman.i2p/" + ',' + "/themes/console/images/" + "eepsite.png" + ',' + HomeHelper._x("Project Website") + ',' + HomeHelper._x("I2P home page") + ',' + "http://www.i2p2.i2p/" + ',' + "/themes/console/images/" + "info_rhombus.png" + ',' + "stats.i2p" + ',' + HomeHelper._x("I2P Network Statistics") + ',' + "http://stats.i2p/cgi-bin/dashboard.cgi" + ',' + "/themes/console/images/" + "eepsite.png" + ',' + HomeHelper._x("Technical Docs") + ',' + HomeHelper._x("Technical documentation") + ',' + "http://www.i2p2.i2p/how" + ',' + "/themes/console/images/" + "education.png" + ',' + HomeHelper._x("Trac Wiki") + ',' + ',' + "http://trac.i2p2.i2p/" + ',' + "/themes/console/images/" + "eepsite.png" + ',' + HomeHelper._x("Ugha's Wiki") + ',' + ',' + "http://ugha.i2p/" + ',' + "/themes/console/images/" + "eepsite.png" + ',' + HomeHelper._x("Sponge's main site") + ',' + HomeHelper._x("Seedless and the Robert BitTorrent applications") + ',' + "http://sponge.i2p/" + ',' + "/themes/console/images/" + "eepsite.png" + ',' + "";

    public boolean shouldShowWelcome() {
        return this._context.getProperty("routerconsole.lang") == null;
    }

    public boolean shouldShowSearch() {
        return this._context.getBooleanProperty(PROP_SEARCH);
    }

    public String getServices() {
        List<App> plugins = NavHelper.getClientApps(this._context);
        return this.homeTable(PROP_SERVICES, DEFAULT_SERVICES, plugins);
    }

    public String getFavorites() {
        return this.homeTable(PROP_FAVORITES, DEFAULT_FAVORITES, null);
    }

    public String getConfigServices() {
        return this.configTable(PROP_SERVICES, DEFAULT_SERVICES);
    }

    public String getConfigFavorites() {
        return this.configTable(PROP_FAVORITES, DEFAULT_FAVORITES);
    }

    public String getConfigSearch() {
        return this.configTable("routerconsole.searchEngines", "eepsites.i2p,http://eepsites.i2p/Content/Search/SearchResults.aspx?inpQuery=%s&amp;ref=console,epsilon.i2p,http://epsilon.i2p/search.jsp?q=%s&amp;ref=console,");
    }

    public String getConfigHome() {
        boolean oldHome = this._context.getBooleanProperty(PROP_OLDHOME);
        return oldHome ? "checked=\"true\"" : "";
    }

    public String getProxyStatus() {
        int port = this._context.portMapper().getPort("HTTP");
        if (port <= 0) {
            return this._("The HTTP proxy is not up");
        }
        return "<img src=\"http://console.i2p/onepixel.png?" + this._context.random().nextInt() + "\"" + " alt=\"" + this._("Your browser is not properly configured to use the HTTP proxy at {0}", this._context.getProperty("router.updateProxyHost", "127.0.0.1") + ':' + port) + "\">";
    }

    private String homeTable(String prop, String dflt, Collection<App> toAdd) {
        String config = this._context.getProperty(prop, dflt);
        Collection<App> apps = HomeHelper.buildApps(this._context, config);
        if (toAdd != null) {
            apps.addAll(toAdd);
        }
        return HomeHelper.renderApps(apps);
    }

    private String configTable(String prop, String dflt) {
        String config = this._context.getProperty(prop, dflt);
        Collection<App> apps = prop.equals("routerconsole.searchEngines") ? HomeHelper.buildSearchApps(config) : HomeHelper.buildApps(this._context, config);
        return this.renderConfig(apps);
    }

    static Collection<App> buildApps(RouterContext ctx, String config) {
        String[] args = config.split(",");
        TreeSet<App> apps = new TreeSet<App>(new AppComparator());
        for (int i = 0; i < args.length - 3; i += 4) {
            String name = Messages.getString(args[i], ctx);
            String desc = Messages.getString(args[i + 1], ctx);
            String url = args[i + 2];
            String icon = args[i + 3];
            apps.add(new App(name, desc, url, icon));
        }
        return apps;
    }

    static Collection<App> buildSearchApps(String config) {
        String[] args = config.split(",");
        TreeSet<App> apps = new TreeSet<App>(new AppComparator());
        for (int i = 0; i < args.length - 1; i += 2) {
            String name = args[i];
            String url = args[i + 1];
            apps.add(new App(name, null, url, null));
        }
        return apps;
    }

    static void saveApps(RouterContext ctx, String prop, Collection<App> apps, boolean full) {
        StringBuilder buf = new StringBuilder(1024);
        for (App app : apps) {
            buf.append(app.name).append(',');
            if (full) {
                buf.append(app.desc).append(',');
            }
            buf.append(app.url).append(',');
            if (!full) continue;
            buf.append(app.icon).append(',');
        }
        ctx.router().saveConfig(prop, buf.toString());
    }

    private static String renderApps(Collection<App> apps) {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<div class=\"appgroup\">");
        for (App app : apps) {
            buf.append("<div class=\"app\"><div class=\"appimg\"><a href=\"").append(app.url).append("\"><img class=\"");
            if (app.icon.endsWith("/itoopie_sm.png")) {
                buf.append("app2p");
            } else {
                buf.append("app");
            }
            buf.append("\" alt=\"\" title=\"").append(app.desc).append("\" src=\"").append(app.icon).append("\"></a>\n</div><table class=\"app\"><tr class=\"app\"><td class=\"app\"><div class=\"applabel\"><a href=\"").append(app.url).append("\" title=\"").append(app.desc).append("\">").append(app.name).append("</a></div></td></tr></table></div>\n");
        }
        buf.append("</div>\n");
        return buf.toString();
    }

    private String renderConfig(Collection<App> apps) {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<table><tr><th>").append(this._("Remove")).append("</th><th colspan=\"2\">").append(this._("Name")).append("</th><th>").append(this._("URL")).append("</th></tr>\n");
        for (App app : apps) {
            buf.append("<tr><td align=\"center\"><input type=\"checkbox\" class=\"optbox\" name=\"delete_").append(app.name).append("\"></td><td align=\"center\">");
            if (app.icon != null) {
                buf.append("<img height=\"16\" alt=\"\" src=\"").append(app.icon).append("\">");
            }
            buf.append("</td><td align=\"left\">").append(app.name).append("</td><td align=\"left\"><a href=\"").append(app.url.replace("&", "&amp;")).append("\">").append(app.url.replace("&", "&amp;")).append("</a></td></tr>\n");
        }
        buf.append("<tr><td colspan=\"2\" align=\"center\"><b>").append(this._("Add")).append(":</b></td><td align=\"left\"><input type=\"text\" name=\"name\"></td><td align=\"left\"><input type=\"text\" size=\"40\" name=\"url\"></td></tr>");
        buf.append("</table>\n");
        return buf.toString();
    }

    static class App {
        public final String name;
        public final String desc;
        public final String url;
        public final String icon;

        public App(String name, String desc, String url, String icon) {
            this.name = name;
            this.desc = desc;
            this.url = url;
            this.icon = icon;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AppComparator
    implements Comparator<App> {
        private AppComparator() {
        }

        @Override
        public int compare(App l, App r) {
            return l.name.toLowerCase().compareTo(r.name.toLowerCase());
        }
    }
}

