/*
 * Decompiled with CFR 0.152.
 */
package net.metanotion.util.skiplist;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import net.metanotion.util.skiplist.SkipSpan;

public class SkipIterator
implements ListIterator {
    protected SkipSpan ss;
    protected int index;

    protected SkipIterator() {
    }

    public SkipIterator(SkipSpan ss, int index) {
        if (ss == null) {
            throw new NullPointerException();
        }
        this.ss = ss;
        this.index = index;
    }

    public boolean hasNext() {
        return this.index < this.ss.nKeys;
    }

    public Object next() {
        if (this.index >= this.ss.nKeys) {
            throw new NoSuchElementException();
        }
        Object o = this.ss.vals[this.index];
        if (this.index < this.ss.nKeys - 1) {
            ++this.index;
        } else if (this.ss.next != null) {
            this.ss = this.ss.next;
            this.index = 0;
        } else {
            this.index = this.ss.nKeys;
        }
        return o;
    }

    public Comparable nextKey() {
        if (this.index < this.ss.nKeys) {
            return this.ss.keys[this.index];
        }
        throw new NoSuchElementException();
    }

    public boolean hasPrevious() {
        if (this.index > 0) {
            return true;
        }
        return this.ss.prev != null && this.ss.prev.nKeys > 0;
    }

    public Object previous() {
        if (this.index > 0) {
            --this.index;
        } else if (this.ss.prev != null) {
            this.ss = this.ss.prev;
            if (this.ss.nKeys <= 0) {
                throw new NoSuchElementException();
            }
            this.index = this.ss.nKeys - 1;
        }
        return this.ss.vals[this.index];
    }

    public void add(Object o) {
        throw new UnsupportedOperationException();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void set(Object o) {
        throw new UnsupportedOperationException();
    }

    public int nextIndex() {
        throw new UnsupportedOperationException();
    }

    public int previousIndex() {
        throw new UnsupportedOperationException();
    }
}

