/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import net.i2p.util.InternalServerSocket;

public class InternalSocket
extends Socket {
    private InputStream _is;
    private OutputStream _os;

    InternalSocket(InputStream is, OutputStream os) {
        this._is = is;
        this._os = os;
    }

    public InternalSocket(int port) throws IOException {
        if (port <= 0) {
            throw new IOException("bad port number");
        }
        InternalServerSocket.internalConnect(port, this);
    }

    public static Socket getSocket(String host, int port) throws IOException {
        if (System.getProperty("router.version") != null && (host.equals("127.0.0.1") || host.equals("localhost"))) {
            try {
                return new InternalSocket(port);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new Socket(host, port);
    }

    public InputStream getInputStream() {
        return this._is;
    }

    public OutputStream getOutputStream() {
        return this._os;
    }

    void setInputStream(InputStream is) {
        this._is = is;
    }

    void setOutputStream(OutputStream os) {
        this._os = os;
    }

    public void close() {
        try {
            if (this._is != null) {
                this._is.close();
                this._is = null;
            }
        }
        catch (IOException ie) {
            // empty catch block
        }
        try {
            if (this._os != null) {
                this._os.close();
                this._os = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isClosed() {
        return this._is == null || this._os == null;
    }

    public String toString() {
        return "Internal socket";
    }

    public void setSoTimeout(int timeout) {
    }

    public int getSoTimeout() {
        return 0;
    }

    public void bind(SocketAddress endpoint) {
        throw new IllegalArgumentException("unsupported");
    }

    public void connect(SocketAddress endpoint) {
        throw new IllegalArgumentException("unsupported");
    }

    public void connect(SocketAddress endpoint, int timeout) {
        throw new IllegalArgumentException("unsupported");
    }

    public SocketChannel getChannel() {
        throw new IllegalArgumentException("unsupported");
    }

    public InetAddress getInetAddress() {
        throw new IllegalArgumentException("unsupported");
    }

    public boolean getKeepAlive() {
        throw new IllegalArgumentException("unsupported");
    }

    public InetAddress getLocalAddress() {
        throw new IllegalArgumentException("unsupported");
    }

    public int getLocalPort() {
        throw new IllegalArgumentException("unsupported");
    }

    public SocketAddress getLocalSocketAddress() {
        throw new IllegalArgumentException("unsupported");
    }

    public boolean getOOBInline() {
        throw new IllegalArgumentException("unsupported");
    }

    public int getPort() {
        throw new IllegalArgumentException("unsupported");
    }

    public int getReceiveBufferSize() {
        throw new IllegalArgumentException("unsupported");
    }

    public SocketAddress getRemoteSocketAddress() {
        throw new IllegalArgumentException("unsupported");
    }

    public boolean getReuseAddress() {
        throw new IllegalArgumentException("unsupported");
    }

    public int getSendBufferSize() {
        throw new IllegalArgumentException("unsupported");
    }

    public int getSoLinger() {
        throw new IllegalArgumentException("unsupported");
    }

    public boolean getTcpNoDelay() {
        throw new IllegalArgumentException("unsupported");
    }

    public int getTrafficClass() {
        throw new IllegalArgumentException("unsupported");
    }

    public boolean isBound() {
        throw new IllegalArgumentException("unsupported");
    }

    public boolean isConnected() {
        throw new IllegalArgumentException("unsupported");
    }

    public boolean isInputShutdown() {
        throw new IllegalArgumentException("unsupported");
    }

    public boolean isOutputShutdown() {
        throw new IllegalArgumentException("unsupported");
    }

    public void sendUrgentData(int data) {
        throw new IllegalArgumentException("unsupported");
    }

    public void setKeepAlive(boolean on) {
        throw new IllegalArgumentException("unsupported");
    }

    public void setOOBInline(boolean on) {
        throw new IllegalArgumentException("unsupported");
    }

    public void setReceiveBufferSize(int size) {
        throw new IllegalArgumentException("unsupported");
    }

    public void setReuseAddress(boolean on) {
        throw new IllegalArgumentException("unsupported");
    }

    public void setSendBufferSize(int size) {
        throw new IllegalArgumentException("unsupported");
    }

    public void setSoLinger(boolean on, int linger) {
        throw new IllegalArgumentException("unsupported");
    }

    public void setTcpNoDelay(boolean on) {
        throw new IllegalArgumentException("unsupported");
    }

    public void setTrafficClass(int cize) {
        throw new IllegalArgumentException("unsupported");
    }

    public void shutdownInput() {
        throw new IllegalArgumentException("unsupported");
    }

    public void shutdownOutput() {
        throw new IllegalArgumentException("unsupported");
    }
}

