/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.stat;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Properties;
import net.i2p.data.DataHelper;
import net.i2p.stat.Rate;
import net.i2p.stat.StatLog;

public class RateStat {
    private final String _statName;
    private final String _groupName;
    private final String _description;
    protected final Rate[] _rates;
    private StatLog _statLog;
    private static final String NL = System.getProperty("line.separator");

    public RateStat(String name, String description, String group, long[] periods) {
        this._statName = name;
        this._description = description;
        this._groupName = group;
        if (periods.length == 0) {
            throw new IllegalArgumentException();
        }
        long[] periodsCopy = new long[periods.length];
        System.arraycopy(periods, 0, periodsCopy, 0, periods.length);
        Arrays.sort(periodsCopy);
        this._rates = new Rate[periodsCopy.length];
        for (int i = 0; i < periodsCopy.length; ++i) {
            Rate rate = new Rate(periodsCopy[i]);
            rate.setRateStat(this);
            this._rates[i] = rate;
        }
    }

    public void setStatLog(StatLog sl) {
        this._statLog = sl;
    }

    public void addData(long value, long eventDuration) {
        if (this._statLog != null) {
            this._statLog.addData(this._groupName, this._statName, value, eventDuration);
        }
        for (Rate r : this._rates) {
            r.addData(value, eventDuration);
        }
    }

    public void addData(long value) {
        if (this._statLog != null) {
            this._statLog.addData(this._groupName, this._statName, value, 0L);
        }
        for (Rate r : this._rates) {
            r.addData(value);
        }
    }

    public void coalesceStats() {
        for (Rate r : this._rates) {
            r.coalesce();
        }
    }

    public String getName() {
        return this._statName;
    }

    public String getGroupName() {
        return this._groupName;
    }

    public String getDescription() {
        return this._description;
    }

    public long[] getPeriods() {
        long[] rv = new long[this._rates.length];
        for (int i = 0; i < this._rates.length; ++i) {
            rv[i] = this._rates[i].getPeriod();
        }
        return rv;
    }

    public double getLifetimeAverageValue() {
        return this._rates[0].getLifetimeAverageValue();
    }

    public long getLifetimeEventCount() {
        return this._rates[0].getLifetimeEventCount();
    }

    public Rate getRate(long period) {
        for (Rate r : this._rates) {
            if (r.getPeriod() != period) continue;
            return r;
        }
        return null;
    }

    @Deprecated
    public void addRate(long period) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void removeRate(long period) {
        throw new UnsupportedOperationException();
    }

    public boolean containsRate(long period) {
        return this.getRate(period) != null;
    }

    public int hashCode() {
        return this._statName.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(4096);
        buf.append(this.getGroupName()).append('.').append(this.getName()).append(": ").append(this.getDescription()).append('\n');
        long[] periods = this.getPeriods();
        Arrays.sort(periods);
        for (int i = 0; i < periods.length; ++i) {
            buf.append('\t').append(periods[i]).append(':');
            Rate curRate = this.getRate(periods[i]);
            buf.append(curRate.toString());
            buf.append(NL);
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RateStat)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        RateStat rs = (RateStat)obj;
        if (DataHelper.eq(this.getGroupName(), rs.getGroupName()) && DataHelper.eq(this.getDescription(), rs.getDescription()) && DataHelper.eq(this.getName(), rs.getName())) {
            return Arrays.deepEquals(this._rates, rs._rates);
        }
        return false;
    }

    public void store(OutputStream out, String prefix) throws IOException {
        StringBuilder buf = new StringBuilder(1024);
        buf.append(NL);
        buf.append("################################################################################").append(NL);
        buf.append("# Rate: ").append(this._groupName).append(": ").append(this._statName).append(NL);
        buf.append("# ").append(this._description).append(NL);
        buf.append("# ").append(NL).append(NL);
        out.write(buf.toString().getBytes());
        buf.setLength(0);
        for (Rate r : this._rates) {
            buf.append("#######").append(NL);
            buf.append("# Period : ").append(DataHelper.formatDuration(r.getPeriod())).append(" for rate ").append(this._groupName).append(" - ").append(this._statName).append(NL);
            buf.append(NL);
            String curPrefix = prefix + "." + DataHelper.formatDuration(r.getPeriod());
            r.store(curPrefix, buf);
            out.write(buf.toString().getBytes());
            buf.setLength(0);
        }
    }

    public void load(Properties props, String prefix, boolean treatAsCurrent) throws IllegalArgumentException {
        for (Rate r : this._rates) {
            long period = r.getPeriod();
            String curPrefix = prefix + "." + DataHelper.formatDuration(period);
            r.load(props, curPrefix, treatAsCurrent);
        }
    }
}

