/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelClientBase;
import net.i2p.i2ptunnel.Logging;
import net.i2p.util.EventDispatcher;
import net.i2p.util.InternalSocket;
import net.i2p.util.PasswordManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class I2PTunnelHTTPClientBase
extends I2PTunnelClientBase
implements Runnable {
    private static final int PROXYNONCE_BYTES = 8;
    private static final int MD5_BYTES = 16;
    private static final int NONCE_BYTES = 24;
    private static final long MAX_NONCE_AGE = 2592000000L;
    private static final String ERR_AUTH1 = "HTTP/1.1 407 Proxy Authentication Required\r\nContent-Type: text/html; charset=UTF-8\r\nCache-control: no-cache\r\nAccept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.5\r\nProxy-Authenticate: ";
    private static final String ERR_AUTH2 = "\r\n\r\n<html><body><H1>I2P ERROR: PROXY AUTHENTICATION REQUIRED</H1>This proxy is configured to require authentication.";
    protected final List<String> _proxyList = new ArrayList<String>(4);
    protected static final byte[] ERR_NO_OUTPROXY = "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\n\r\n<html><body><H1>I2P ERROR: No outproxy found</H1>Your request was for a site outside of I2P, but you have no HTTP outproxy configured.  Please configure an outproxy in I2PTunnel".getBytes();
    protected static volatile long __clientId = 0L;
    private final byte[] _proxyNonce = new byte[8];
    protected static final int DEFAULT_READ_TIMEOUT = 300000;
    protected static long __requestId = 0L;
    public static final String PROP_AUTH = "proxyAuth";
    public static final String PROP_USER = "proxyUsername";
    public static final String PROP_PW = "proxyPassword";
    public static final String PROP_PW_PREFIX = "proxyPassword.";
    public static final String PROP_OUTPROXY_AUTH = "outproxyAuth";
    public static final String PROP_OUTPROXY_USER = "outproxyUsername";
    public static final String PROP_OUTPROXY_PW = "outproxyPassword";
    public static final String PROP_OUTPROXY_USER_PREFIX = "outproxyUsername.";
    public static final String PROP_OUTPROXY_PW_PREFIX = "outproxyPassword.";
    public static final String PROP_PROXY_DIGEST_PREFIX = "proxy.auth.";
    public static final String PROP_PROXY_DIGEST_SUFFIX = ".md5";
    public static final String BASIC_AUTH = "basic";
    public static final String DIGEST_AUTH = "digest";

    protected String getPrefix(long requestId) {
        return "Client[" + this._clientId + "/" + requestId + "]: ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String selectProxy() {
        List<String> list = this._proxyList;
        synchronized (list) {
            int size = this._proxyList.size();
            if (size <= 0) {
                return null;
            }
            int index = this._context.random().nextInt(size);
            return this._proxyList.get(index);
        }
    }

    public I2PTunnelHTTPClientBase(int localPort, boolean ownDest, Logging l, EventDispatcher notifyThis, String handlerName, I2PTunnel tunnel) throws IllegalArgumentException {
        super(localPort, ownDest, l, notifyThis, handlerName, tunnel);
        this._context.random().nextBytes(this._proxyNonce);
    }

    public I2PTunnelHTTPClientBase(int localPort, Logging l, I2PSocketManager sktMgr, I2PTunnel tunnel, EventDispatcher notifyThis, long clientId) throws IllegalArgumentException {
        super(localPort, l, sktMgr, tunnel, notifyThis, clientId);
        this._context.random().nextBytes(this._proxyNonce);
    }

    protected abstract String getRealm();

    protected boolean isDigestAuthRequired() {
        String authRequired = this.getTunnel().getClientOptions().getProperty(PROP_AUTH);
        if (authRequired == null) {
            return false;
        }
        return authRequired.toLowerCase(Locale.US).equals(DIGEST_AUTH);
    }

    protected AuthResult authorize(Socket s, long requestId, String method, String authorization) {
        String authRequired = this.getTunnel().getClientOptions().getProperty(PROP_AUTH);
        if (authRequired == null) {
            return AuthResult.AUTH_GOOD;
        }
        if ((authRequired = authRequired.toLowerCase(Locale.US)).equals("false")) {
            return AuthResult.AUTH_GOOD;
        }
        if (s instanceof InternalSocket) {
            if (this._log.shouldLog(20)) {
                this._log.info(this.getPrefix(requestId) + "Internal access, no auth required");
            }
            return AuthResult.AUTH_GOOD;
        }
        if (authorization == null) {
            return AuthResult.AUTH_BAD;
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this.getPrefix(requestId) + "Auth: " + authorization);
        }
        String authLC = authorization.toLowerCase(Locale.US);
        if (authRequired.equals("true") || authRequired.equals(BASIC_AUTH)) {
            if (!authLC.startsWith("basic ")) {
                return AuthResult.AUTH_BAD;
            }
            byte[] decoded = Base64.decode((authorization = authorization.substring(6)).replace("/", "~").replace("+", "="));
            if (decoded != null) {
                try {
                    String configUser;
                    String dec = new String(decoded, "UTF-8");
                    String[] parts = dec.split(":");
                    String user = parts[0];
                    String pw = parts[1];
                    String configPW = this.getTunnel().getClientOptions().getProperty(PROP_PW_PREFIX + user);
                    if (configPW == null && user.equals(configUser = this.getTunnel().getClientOptions().getProperty(PROP_USER))) {
                        configPW = this.getTunnel().getClientOptions().getProperty(PROP_PW);
                    }
                    if (configPW != null && pw.equals(configPW)) {
                        if (this._log.shouldLog(20)) {
                            this._log.info(this.getPrefix(requestId) + "Good auth - user: " + user + " pw: " + pw);
                        }
                        return AuthResult.AUTH_GOOD;
                    }
                    this._log.logAlways(30, "PROXY AUTH FAILURE: user " + user);
                }
                catch (UnsupportedEncodingException uee) {
                    this._log.error(this.getPrefix(requestId) + "No UTF-8 support? B64: " + authorization, uee);
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn(this.getPrefix(requestId) + "Bad auth B64: " + authorization, aioobe);
                    }
                    return AuthResult.AUTH_BAD_REQ;
                }
                return AuthResult.AUTH_BAD;
            }
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getPrefix(requestId) + "Bad auth B64: " + authorization);
            }
            return AuthResult.AUTH_BAD_REQ;
        }
        if (authRequired.equals(DIGEST_AUTH)) {
            if (!authLC.startsWith("digest ")) {
                return AuthResult.AUTH_BAD;
            }
            authorization = authorization.substring(7);
            Map<String, String> args = I2PTunnelHTTPClientBase.parseArgs(authorization);
            AuthResult rv = this.validateDigest(method, args);
            return rv;
        }
        this._log.error("Unknown proxy authorization type configured: " + authRequired);
        return AuthResult.AUTH_BAD_REQ;
    }

    private AuthResult validateDigest(String method, Map<String, String> args) {
        String user = args.get("username");
        String realm = args.get("realm");
        String nonce = args.get("nonce");
        String qop = args.get("qop");
        String uri = args.get("uri");
        String cnonce = args.get("cnonce");
        String nc = args.get("nc");
        String response = args.get("response");
        if (user == null || realm == null || nonce == null || qop == null || uri == null || cnonce == null || nc == null || response == null) {
            if (this._log.shouldLog(20)) {
                this._log.info("Bad digest request: " + DataHelper.toString(args));
            }
            return AuthResult.AUTH_BAD_REQ;
        }
        AuthResult check = this.verifyNonce(nonce);
        if (check != AuthResult.AUTH_GOOD) {
            if (this._log.shouldLog(20)) {
                this._log.info("Bad digest nonce: " + (Object)((Object)check) + ' ' + DataHelper.toString(args));
            }
            return check;
        }
        String ha1 = this.getTunnel().getClientOptions().getProperty(PROP_PROXY_DIGEST_PREFIX + user + PROP_PROXY_DIGEST_SUFFIX);
        if (ha1 == null) {
            this._log.logAlways(30, "PROXY AUTH FAILURE: user " + user);
            return AuthResult.AUTH_BAD;
        }
        String a2 = method + ':' + uri;
        String ha2 = PasswordManager.md5Hex(a2);
        String kd = ha1 + ':' + nonce + ':' + nc + ':' + cnonce + ':' + qop + ':' + ha2;
        String hkd = PasswordManager.md5Hex(kd);
        if (!response.equals(hkd)) {
            this._log.logAlways(30, "PROXY AUTH FAILURE: user " + user);
            if (this._log.shouldLog(20)) {
                this._log.info("Bad digest auth: " + DataHelper.toString(args));
            }
            return AuthResult.AUTH_BAD;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Good digest auth - user: " + user);
        }
        return AuthResult.AUTH_GOOD;
    }

    private String getNonce() {
        byte[] b = new byte[16];
        byte[] n = new byte[24];
        long now = this._context.clock().now();
        DataHelper.toLong(b, 0, 8, now);
        System.arraycopy(this._proxyNonce, 0, b, 8, 8);
        System.arraycopy(b, 0, n, 0, 8);
        byte[] md5 = PasswordManager.md5Sum(b);
        System.arraycopy(md5, 0, n, 8, 16);
        return Base64.encode(n);
    }

    private AuthResult verifyNonce(String b64) {
        long stamp;
        byte[] n = Base64.decode(b64);
        if (n == null || n.length != 24) {
            return AuthResult.AUTH_BAD;
        }
        long now = this._context.clock().now();
        if (now - (stamp = DataHelper.fromLong(n, 0, 8)) > 2592000000L) {
            return AuthResult.AUTH_STALE;
        }
        byte[] b = new byte[16];
        System.arraycopy(n, 0, b, 0, 8);
        System.arraycopy(this._proxyNonce, 0, b, 8, 8);
        byte[] md5 = PasswordManager.md5Sum(b);
        if (!DataHelper.eq(md5, 0, n, 8, 16)) {
            return AuthResult.AUTH_BAD;
        }
        return AuthResult.AUTH_GOOD;
    }

    protected String getAuthError(boolean isStale) {
        boolean isDigest = this.isDigestAuthRequired();
        return ERR_AUTH1 + (isDigest ? "Digest" : "Basic") + " realm=\"" + this.getRealm() + '\"' + (isDigest ? ", nonce=\"" + this.getNonce() + "\"," + " algorithm=MD5," + " qop=\"auth\"" + (isStale ? ", stale=true" : "") : "") + ERR_AUTH2;
    }

    private static Map<String, String> parseArgs(String args) {
        HashMap<String, String> rv = new HashMap<String, String>(8);
        char[] data = args.toCharArray();
        StringBuilder buf = new StringBuilder(32);
        boolean isQuoted = false;
        String key = null;
        block5: for (int i = 0; i < data.length; ++i) {
            switch (data[i]) {
                case '\"': {
                    if (isQuoted) {
                        if (key != null) {
                            rv.put(key, buf.toString().trim());
                            key = null;
                        }
                        buf.setLength(0);
                    }
                    isQuoted = !isQuoted;
                    continue block5;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': {
                    if (isQuoted) {
                        buf.append(data[i]);
                        continue block5;
                    }
                    if (key != null) {
                        rv.put(key, buf.toString().trim());
                        key = null;
                    }
                    buf.setLength(0);
                    continue block5;
                }
                case '=': {
                    if (isQuoted) {
                        buf.append(data[i]);
                        continue block5;
                    }
                    key = buf.toString().trim().toLowerCase(Locale.US);
                    buf.setLength(0);
                    continue block5;
                }
                default: {
                    buf.append(data[i]);
                }
            }
        }
        if (key != null) {
            rv.put(key, buf.toString().trim());
        }
        return rv;
    }

    protected byte[] getErrorPage(String base, byte[] backup) {
        return I2PTunnelHTTPClientBase.getErrorPage(this._context, base, backup);
    }

    protected static byte[] getErrorPage(I2PAppContext ctx, String base, byte[] backup) {
        File file;
        File errorDir = new File(ctx.getBaseDir(), "docs");
        String lang = ctx.getProperty("routerconsole.lang", Locale.getDefault().getLanguage());
        if (lang != null && lang.length() > 0 && !lang.equals("en")) {
            file = new File(errorDir, base + "-header_" + lang + ".ht");
            try {
                return I2PTunnelHTTPClientBase.readFile(file);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        file = new File(errorDir, base + "-header.ht");
        try {
            return I2PTunnelHTTPClientBase.readFile(file);
        }
        catch (IOException ioe) {
            return backup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFile(File file) throws IOException {
        byte[] byArray;
        FileInputStream fis = null;
        byte[] buf = new byte[2048];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        try {
            int len = 0;
            fis = new FileInputStream(file);
            while ((len = fis.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
            byArray = baos.toByteArray();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException foo) {}
            throw throwable;
        }
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (IOException foo) {
            // empty catch block
        }
        return byArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum AuthResult {
        AUTH_BAD_REQ,
        AUTH_BAD,
        AUTH_STALE,
        AUTH_GOOD;

    }
}

