/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PSession;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketManagerFactory;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelIRCClient;
import net.i2p.i2ptunnel.I2PTunnelTask;
import net.i2p.i2ptunnel.Logging;
import net.i2p.util.EventDispatcher;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;

public abstract class I2PTunnelClientBase
extends I2PTunnelTask
implements Runnable {
    protected final Log _log;
    protected final I2PAppContext _context;
    protected final Logging l;
    static final long DEFAULT_CONNECT_TIMEOUT = 60000L;
    private static volatile long __clientId = 0L;
    protected long _clientId;
    protected final Object sockLock = new Object();
    protected I2PSocketManager sockMgr;
    protected final List<I2PSocket> mySockets = new ArrayList<I2PSocket>();
    protected boolean _ownDest;
    protected Destination dest = null;
    private int localPort;
    private boolean listenerReady = false;
    protected ServerSocket ss;
    private final Object startLock = new Object();
    private boolean startRunning = false;
    private String privKeyFile;
    private boolean chained = false;
    private static final long HANDLER_KEEPALIVE_MS = 120000L;
    private static volatile ThreadPoolExecutor _executor;
    private static int _executorThreadCount;
    private static final Object _executorLock;
    private static I2PSocketManager socketManager;
    private static final int RETRY_DELAY = 20000;
    private static final int MAX_RETRIES = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I2PTunnelClientBase(int localPort, Logging l, I2PSocketManager sktMgr, I2PTunnel tunnel, EventDispatcher notifyThis, long clientId) throws IllegalArgumentException {
        super(localPort + " (uninitialized)", notifyThis, tunnel);
        this.chained = true;
        this.sockMgr = sktMgr;
        this._clientId = clientId;
        this.localPort = localPort;
        this.l = l;
        this._ownDest = true;
        this._context = tunnel.getContext();
        this._context.statManager().createRateStat("i2ptunnel.client.closeBacklog", "How many pending sockets remain when we close one due to backlog?", "I2PTunnel", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("i2ptunnel.client.closeNoBacklog", "How many pending sockets remain when it was removed prior to backlog timeout?", "I2PTunnel", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("i2ptunnel.client.manageTime", "How long it takes to accept a socket and fire it into an i2ptunnel runner (or queue it for the pool)?", "I2PTunnel", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("i2ptunnel.client.buildRunTime", "How long it takes to run a queued socket into an i2ptunnel runner?", "I2PTunnel", new long[]{60000L, 600000L, 3600000L});
        this._log = this._context.logManager().getLog(this.getClass());
        Object object = _executorLock;
        synchronized (object) {
            if (_executor == null) {
                _executor = new CustomThreadPoolExecutor();
            }
        }
        I2PAppThread t = new I2PAppThread(this, "Client " + tunnel.listenHost + ':' + localPort);
        t.start();
        this.open = true;
        I2PTunnelClientBase i2PTunnelClientBase = this;
        synchronized (i2PTunnelClientBase) {
            while (!this.listenerReady && this.open) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        if (this.open && this.listenerReady) {
            l.log("Client ready, listening on " + tunnel.listenHost + ':' + localPort);
            this.notifyEvent("openBaseClientResult", "ok");
        } else {
            l.log("Client error for " + tunnel.listenHost + ':' + localPort + ", check logs");
            this.notifyEvent("openBaseClientResult", "error");
        }
    }

    public I2PTunnelClientBase(int localPort, boolean ownDest, Logging l, EventDispatcher notifyThis, String handlerName, I2PTunnel tunnel) throws IllegalArgumentException {
        this(localPort, ownDest, l, notifyThis, handlerName, tunnel, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I2PTunnelClientBase(int localPort, boolean ownDest, Logging l, EventDispatcher notifyThis, String handlerName, I2PTunnel tunnel, String pkf) throws IllegalArgumentException {
        super(localPort + " (uninitialized)", notifyThis, tunnel);
        boolean openNow;
        boolean dccEnabled;
        this._clientId = ++__clientId;
        this.localPort = localPort;
        this.l = l;
        this._ownDest = ownDest;
        this._context = tunnel.getContext();
        this._context.statManager().createRateStat("i2ptunnel.client.closeBacklog", "How many pending sockets remain when we close one due to backlog?", "I2PTunnel", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("i2ptunnel.client.closeNoBacklog", "How many pending sockets remain when it was removed prior to backlog timeout?", "I2PTunnel", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("i2ptunnel.client.manageTime", "How long it takes to accept a socket and fire it into an i2ptunnel runner (or queue it for the pool)?", "I2PTunnel", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("i2ptunnel.client.buildRunTime", "How long it takes to run a queued socket into an i2ptunnel runner?", "I2PTunnel", new long[]{60000L, 600000L, 3600000L});
        this._log = this._context.logManager().getLog(this.getClass());
        Object object = _executorLock;
        synchronized (object) {
            if (_executor == null) {
                _executor = new CustomThreadPoolExecutor();
            }
        }
        if (pkf != null) {
            File keyFile = new File(pkf);
            if (!keyFile.isAbsolute()) {
                keyFile = new File(this._context.getConfigDir(), pkf);
            }
            this.privKeyFile = keyFile.getAbsolutePath();
        }
        boolean bl = dccEnabled = this instanceof I2PTunnelIRCClient && Boolean.parseBoolean(tunnel.getClientOptions().getProperty("i2ptunnel.ircclient.enableDCC"));
        if (!dccEnabled) {
            tunnel.getClientOptions().setProperty("i2cp.dontPublishLeaseSet", "true");
        }
        boolean bl2 = openNow = !Boolean.parseBoolean(tunnel.getClientOptions().getProperty("i2cp.delayOpen"));
        if (openNow) {
            while (this.sockMgr == null) {
                this.verifySocketManager();
                if (this.sockMgr != null) continue;
                this._log.error("Unable to connect to router and build tunnels for " + handlerName);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {}
            }
            l.log("Tunnels ready for client: " + handlerName);
        }
        I2PAppThread t = new I2PAppThread(this);
        t.setName("Client " + this._clientId);
        t.start();
        this.open = true;
        I2PTunnelClientBase i2PTunnelClientBase = this;
        synchronized (i2PTunnelClientBase) {
            while (!this.listenerReady && this.open) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        if (this.open && this.listenerReady) {
            if (openNow) {
                l.log("Client ready, listening on " + tunnel.listenHost + ':' + localPort);
            } else {
                l.log("Client ready, listening on " + tunnel.listenHost + ':' + localPort + ", delaying tunnel open until required");
            }
            this.notifyEvent("openBaseClientResult", "ok");
        } else {
            l.log("Client error for " + tunnel.listenHost + ':' + localPort + ", check logs");
            this.notifyEvent("openBaseClientResult", "error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifySocketManager() {
        Object object = this.sockLock;
        synchronized (object) {
            boolean newManager = false;
            if (this.sockMgr == null) {
                newManager = true;
            } else {
                I2PSession sess = this.sockMgr.getSession();
                if (sess == null) {
                    newManager = true;
                } else if (sess.isClosed() && Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty("i2cp.closeOnIdle")) && Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty("i2cp.newDestOnResume"))) {
                    this.getTunnel().removeSession(sess);
                    if (this._log.shouldLog(30)) {
                        this._log.warn(this.getTunnel().getClientOptions().getProperty("inbound.nickname") + ": Built a new destination on resume");
                    }
                    newManager = true;
                }
            }
            if (newManager) {
                this.sockMgr = this._ownDest ? this.buildSocketManager() : this.getSocketManager();
            }
        }
    }

    protected I2PSocketManager getSocketManager() {
        return I2PTunnelClientBase.getSocketManager(this.getTunnel(), this.privKeyFile);
    }

    protected static I2PSocketManager getSocketManager(I2PTunnel tunnel) {
        return I2PTunnelClientBase.getSocketManager(tunnel, null);
    }

    protected static synchronized I2PSocketManager getSocketManager(I2PTunnel tunnel, String pkf) {
        Log _log = tunnel.getContext().logManager().getLog(I2PTunnelClientBase.class);
        if (socketManager != null) {
            I2PSession s = socketManager.getSession();
            if (s == null || s.isClosed()) {
                if (_log.shouldLog(20)) {
                    _log.info(tunnel.getClientOptions().getProperty("inbound.nickname") + ": Building a new socket manager since the old one closed [s=" + s + "]");
                }
                if (s != null) {
                    tunnel.removeSession(s);
                }
                socketManager = I2PTunnelClientBase.buildSocketManager(tunnel, pkf);
            } else if (_log.shouldLog(20)) {
                _log.info(tunnel.getClientOptions().getProperty("inbound.nickname") + ": Not building a new socket manager since the old one is open [s=" + s + "]");
            }
        } else {
            if (_log.shouldLog(20)) {
                _log.info(tunnel.getClientOptions().getProperty("inbound.nickname") + ": Building a new socket manager since there is no other one");
            }
            socketManager = I2PTunnelClientBase.buildSocketManager(tunnel, pkf);
        }
        return socketManager;
    }

    protected I2PSocketManager buildSocketManager() {
        return I2PTunnelClientBase.buildSocketManager(this.getTunnel(), this.privKeyFile, this.l);
    }

    protected static I2PSocketManager buildSocketManager(I2PTunnel tunnel) {
        return I2PTunnelClientBase.buildSocketManager(tunnel, null);
    }

    protected static I2PSocketManager buildSocketManager(I2PTunnel tunnel, String pkf) {
        return I2PTunnelClientBase.buildSocketManager(tunnel, pkf, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static I2PSocketManager buildSocketManager(I2PTunnel tunnel, String pkf, Logging log) {
        Log _log = tunnel.getContext().logManager().getLog(I2PTunnelClientBase.class);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)tunnel.getClientOptions());
        int portNum = 7654;
        if (tunnel.port != null) {
            try {
                portNum = Integer.parseInt(tunnel.port);
            }
            catch (NumberFormatException nfe) {
                _log.log(50, "Invalid port specified [" + tunnel.port + "], reverting to " + portNum);
            }
        }
        I2PSocketManager sockManager = null;
        int retries = 0;
        while (sockManager == null) {
            block20: {
                if (pkf != null) {
                    IOException ioe3;
                    Object var11_12;
                    FileInputStream fis = null;
                    try {
                        try {
                            fis = new FileInputStream(pkf);
                            sockManager = I2PSocketManagerFactory.createManager(fis, tunnel.host, portNum, props);
                        }
                        catch (IOException ioe2) {
                            if (log != null) {
                                log.log("Error opening key file " + ioe2);
                            }
                            _log.error("Error opening key file", ioe2);
                            throw new IllegalArgumentException("Error opening key file " + ioe2);
                        }
                        var11_12 = null;
                        if (fis == null) break block20;
                    }
                    catch (Throwable throwable) {
                        var11_12 = null;
                        if (fis == null) throw throwable;
                        try {
                            fis.close();
                            throw throwable;
                        }
                        catch (IOException ioe3) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (IOException ioe3) {}
                    fis.close();
                } else {
                    sockManager = I2PSocketManagerFactory.createManager(tunnel.host, portNum, props);
                }
            }
            if (sockManager != null) continue;
            String msg = "Unable to connect to the router at " + tunnel.host + ':' + portNum + " and build tunnels for the client";
            if (++retries < 4) {
                if (log != null) {
                    log.log(msg + ", retrying in " + 20 + " seconds");
                }
                _log.error(msg + ", retrying in " + 20 + " seconds");
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException ie) {}
                continue;
            }
            if (log != null) {
                log.log(msg + ", giving up");
            }
            _log.log(50, msg + ", giving up");
            throw new IllegalArgumentException(msg);
        }
        sockManager.setName("Client");
        if (_log.shouldLog(20)) {
            _log.info(tunnel.getClientOptions().getProperty("inbound.nickname") + ": Built a new socket manager [s=" + sockManager.getSession() + "]");
        }
        tunnel.addSession(sockManager.getSession());
        return sockManager;
    }

    public final int getLocalPort() {
        return this.localPort;
    }

    protected final InetAddress getListenHost(Logging l) {
        try {
            return InetAddress.getByName(this.getTunnel().listenHost);
        }
        catch (UnknownHostException uhe) {
            l.log("Could not find listen host to bind to [" + this.getTunnel().host + "]");
            this._log.error("Error finding host to bind", uhe);
            this.notifyEvent("openBaseClientResult", "error");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRunning() {
        Object object = this.startLock;
        synchronized (object) {
            this.startRunning = true;
            this.startLock.notify();
        }
    }

    protected I2PSocketOptions getDefaultOptions() {
        Properties defaultOpts = this.getTunnel().getClientOptions();
        I2PSocketOptions opts = this.sockMgr.buildOptions(defaultOpts);
        if (!defaultOpts.containsKey("i2p.streaming.connectTimeout")) {
            opts.setConnectTimeout(60000L);
        }
        return opts;
    }

    protected I2PSocketOptions getDefaultOptions(Properties overrides) {
        Properties defaultOpts = this.getTunnel().getClientOptions();
        defaultOpts.putAll((Map<?, ?>)overrides);
        I2PSocketOptions opts = this.sockMgr.buildOptions(defaultOpts);
        if (!defaultOpts.containsKey("i2p.streaming.connectTimeout")) {
            opts.setConnectTimeout(60000L);
        }
        return opts;
    }

    public void optionsUpdated(I2PTunnel tunnel) {
        I2PSocketManager sm;
        if (this.getTunnel() != tunnel) {
            return;
        }
        I2PSocketManager i2PSocketManager = sm = this._ownDest ? this.sockMgr : socketManager;
        if (sm == null) {
            return;
        }
        Properties props = tunnel.getClientOptions();
        sm.setDefaultOptions(sm.buildOptions(props));
    }

    public I2PSocket createI2PSocket(Destination dest) throws I2PException, ConnectException, NoRouteToHostException, InterruptedIOException {
        this.verifySocketManager();
        return this.createI2PSocket(dest, this.getDefaultOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I2PSocket createI2PSocket(Destination dest, I2PSocketOptions opt) throws I2PException, ConnectException, NoRouteToHostException, InterruptedIOException {
        this.verifySocketManager();
        I2PSocket i2ps = this.sockMgr.connect(dest, opt);
        Object object = this.sockLock;
        synchronized (object) {
            this.mySockets.add(i2ps);
        }
        return i2ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        try {
            InetAddress addr = this.getListenHost(this.l);
            if (addr == null) {
                this.open = false;
                I2PTunnelClientBase i2PTunnelClientBase = this;
                synchronized (i2PTunnelClientBase) {
                    this.notifyAll();
                }
                return;
            }
            this.ss = new ServerSocket(this.localPort, 0, addr);
            if (this.localPort == 0) {
                this.localPort = this.ss.getLocalPort();
            }
            this.notifyEvent("clientLocalPort", this.ss.getLocalPort());
            Object object = this;
            synchronized (object) {
                this.listenerReady = true;
                this.notify();
            }
            object = this.startLock;
            synchronized (object) {
                while (!this.startRunning) {
                    try {
                        this.startLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            while (this.open) {
                Socket s = this.ss.accept();
                this.manageConnection(s);
            }
        }
        catch (IOException ex) {
            if (this.open) {
                this._log.error("Error listening for connections on " + this.localPort, ex);
                this.notifyEvent("openBaseClientResult", "error");
            }
            Object object = this.sockLock;
            synchronized (object) {
                this.mySockets.clear();
            }
            this.open = false;
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
        }
    }

    static ThreadPoolExecutor getClientExecutor() {
        return _executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void killClientExecutor() {
        Object object = _executorLock;
        synchronized (object) {
            if (_executor != null) {
                _executor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
                _executor.shutdownNow();
                _executor = null;
            }
            socketManager = null;
        }
    }

    protected void manageConnection(Socket s) {
        if (s == null) {
            return;
        }
        ThreadPoolExecutor tpe = _executor;
        if (tpe == null) {
            this._log.error("No executor for socket!");
            try {
                s.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return;
        }
        try {
            tpe.execute(new BlockingRunner(s));
        }
        catch (RejectedExecutionException ree) {
            try {
                s.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(boolean forced) {
        if (this._log.shouldLog(20)) {
            this._log.info("close() called: forced = " + forced + " open = " + this.open + " sockMgr = " + this.sockMgr);
        }
        if (!this.open) {
            return true;
        }
        Object object = this.sockLock;
        synchronized (object) {
            if (this.sockMgr != null) {
                I2PSession session;
                this.mySockets.retainAll(this.sockMgr.listSockets());
                if (!forced && !this.mySockets.isEmpty()) {
                    this.l.log("Not closing, there are still active connections!");
                    this._log.debug("can't close: there are still active connections!");
                    for (I2PSocket s : this.mySockets) {
                        this.l.log("  -> " + s.toString());
                    }
                    return false;
                }
                if (!this.chained && (session = this.sockMgr.getSession()) != null) {
                    this.getTunnel().removeSession(session);
                }
            }
            this.l.log("Stopping client " + this.toString());
            this.open = false;
            try {
                if (this.ss != null) {
                    this.ss.close();
                }
            }
            catch (IOException ex) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("error closing", ex);
                }
                return false;
            }
        }
        return true;
    }

    public static void closeSocket(Socket s) {
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected abstract void clientConnectionRun(Socket var1);

    static {
        _executorLock = new Object();
    }

    private class BlockingRunner
    implements Runnable {
        private Socket _s;

        public BlockingRunner(Socket s) {
            this._s = s;
        }

        public void run() {
            I2PTunnelClientBase.this.clientConnectionRun(this._s);
        }
    }

    private static class CustomThreadFactory
    implements ThreadFactory {
        private CustomThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread rv = Executors.defaultThreadFactory().newThread(r);
            rv.setName("I2PTunnel Client Runner " + ++_executorThreadCount);
            rv.setDaemon(true);
            return rv;
        }
    }

    private static class CustomThreadPoolExecutor
    extends ThreadPoolExecutor {
        public CustomThreadPoolExecutor() {
            super(0, Integer.MAX_VALUE, 120000L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new CustomThreadFactory());
        }
    }
}

