/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.servlet.Holder;
import org.mortbay.log.Log;

public class ServletHolder
extends Holder
implements Comparable {
    private int _initOrder;
    private boolean _initOnStartup = false;
    private Map _roleMap;
    private String _forcedPath;
    private String _runAs;
    private UserRealm _realm;
    private transient Servlet _servlet;
    private transient Config _config;
    private transient long _unavailable;
    private transient UnavailableException _unavailableEx;

    public ServletHolder() {
    }

    public ServletHolder(Servlet servlet) {
        this.setServlet(servlet);
    }

    public ServletHolder(Class servlet) {
        super(servlet);
    }

    public UnavailableException getUnavailableException() {
        return this._unavailableEx;
    }

    public synchronized void setServlet(Servlet servlet) {
        if (servlet == null || servlet instanceof SingleThreadModel) {
            throw new IllegalArgumentException();
        }
        this._extInstance = true;
        this._servlet = servlet;
        this.setHeldClass(servlet.getClass());
        if (this.getName() == null) {
            this.setName(servlet.getClass().getName() + "-" + super.hashCode());
        }
    }

    public int getInitOrder() {
        return this._initOrder;
    }

    public void setInitOrder(int order) {
        this._initOnStartup = true;
        this._initOrder = order;
    }

    public int compareTo(Object o) {
        if (o instanceof ServletHolder) {
            int c;
            ServletHolder sh = (ServletHolder)o;
            if (sh == this) {
                return 0;
            }
            if (sh._initOrder < this._initOrder) {
                return 1;
            }
            if (sh._initOrder > this._initOrder) {
                return -1;
            }
            int n = c = this._className != null && sh._className != null ? this._className.compareTo(sh._className) : 0;
            if (c == 0) {
                c = this._name.compareTo(sh._name);
            }
            if (c == 0) {
                c = this.hashCode() > o.hashCode() ? 1 : -1;
            }
            return c;
        }
        return 1;
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public int hashCode() {
        return this._name == null ? System.identityHashCode(this) : this._name.hashCode();
    }

    public synchronized void setUserRoleLink(String name, String link) {
        if (this._roleMap == null) {
            this._roleMap = new HashMap();
        }
        this._roleMap.put(name, link);
    }

    public String getUserRoleLink(String name) {
        if (this._roleMap == null) {
            return name;
        }
        String link = (String)this._roleMap.get(name);
        return link == null ? name : link;
    }

    public Map getRoleMap() {
        return this._roleMap;
    }

    public void setRunAs(String role) {
        this._runAs = role;
    }

    public String getRunAs() {
        return this._runAs;
    }

    public String getForcedPath() {
        return this._forcedPath;
    }

    public void setForcedPath(String forcedPath) {
        this._forcedPath = forcedPath;
    }

    public void doStart() throws Exception {
        this._unavailable = 0L;
        try {
            super.doStart();
            this.checkServletType();
        }
        catch (UnavailableException ue) {
            this.makeUnavailable(ue);
        }
        this._config = new Config();
        if (this._runAs != null) {
            this._realm = ((SecurityHandler)ContextHandler.getCurrentContext().getContextHandler().getChildHandlerByClass(SecurityHandler.class)).getUserRealm();
        }
        if (SingleThreadModel.class.isAssignableFrom(this._class)) {
            this._servlet = new SingleThreadedWrapper();
        }
        if (this._extInstance || this._initOnStartup) {
            try {
                this.initServlet();
            }
            catch (Exception e) {
                if (this._servletHandler.isStartWithUnavailable()) {
                    Log.ignore((Throwable)e);
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() {
        Principal user = null;
        try {
            if (this._runAs != null && this._realm != null) {
                user = this._realm.pushRole(null, this._runAs);
            }
            if (this._servlet != null) {
                try {
                    this.destroyInstance(this._servlet);
                }
                catch (Exception e) {
                    Log.warn((Throwable)e);
                }
            }
            if (!this._extInstance) {
                this._servlet = null;
            }
            this._config = null;
        }
        finally {
            super.doStop();
            if (this._runAs != null && this._realm != null && user != null) {
                this._realm.popRole(user);
            }
        }
    }

    public void destroyInstance(Object o) throws Exception {
        if (o == null) {
            return;
        }
        Servlet servlet = (Servlet)o;
        servlet.destroy();
        this.getServletHandler().customizeServletDestroy(servlet);
    }

    public synchronized Servlet getServlet() throws ServletException {
        if (this._unavailable != 0L) {
            if (this._unavailable < 0L || this._unavailable > 0L && System.currentTimeMillis() < this._unavailable) {
                throw this._unavailableEx;
            }
            this._unavailable = 0L;
            this._unavailableEx = null;
        }
        if (this._servlet == null) {
            this.initServlet();
        }
        return this._servlet;
    }

    public Servlet getServletInstance() {
        return this._servlet;
    }

    public void checkServletType() throws UnavailableException {
        if (!Servlet.class.isAssignableFrom(this._class)) {
            throw new UnavailableException("Servlet " + this._class + " is not a javax.servlet.Servlet");
        }
    }

    public boolean isAvailable() {
        if (this.isStarted() && this._unavailable == 0L) {
            return true;
        }
        try {
            this.getServlet();
        }
        catch (Exception e) {
            Log.ignore((Throwable)e);
        }
        return this.isStarted() && this._unavailable == 0L;
    }

    private void makeUnavailable(UnavailableException e) {
        if (this._unavailableEx == e && this._unavailable != 0L) {
            return;
        }
        this._servletHandler.getServletContext().log("Unavailable " + (Object)((Object)e));
        this._unavailableEx = e;
        this._unavailable = -1L;
        this._unavailable = e.isPermanent() ? -1L : (this._unavailableEx.getUnavailableSeconds() > 0 ? System.currentTimeMillis() + (long)(1000 * this._unavailableEx.getUnavailableSeconds()) : System.currentTimeMillis() + 5000L);
    }

    private void makeUnavailable(Throwable e) {
        if (e instanceof UnavailableException) {
            this.makeUnavailable((UnavailableException)e);
        } else {
            this._servletHandler.getServletContext().log("unavailable", e);
            this._unavailableEx = new UnavailableException(e.toString(), -1);
            this._unavailable = -1L;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initServlet() throws ServletException {
        Principal user = null;
        try {
            if (this._servlet == null) {
                this._servlet = (Servlet)this.newInstance();
            }
            if (this._config == null) {
                this._config = new Config();
            }
            if (!(this._servlet instanceof SingleThreadedWrapper)) {
                this._servlet = this.getServletHandler().customizeServlet(this._servlet);
            }
            if (this._runAs != null && this._realm != null) {
                user = this._realm.pushRole(null, this._runAs);
            }
            this._servlet.init((ServletConfig)this._config);
            if (this._runAs == null) return;
            if (this._realm == null) return;
            if (user == null) return;
            this._realm.popRole(user);
            return;
        }
        catch (UnavailableException e) {
            try {
                this.makeUnavailable(e);
                this._servlet = null;
                this._config = null;
                throw e;
                catch (ServletException e2) {
                    this.makeUnavailable(e2.getCause() == null ? e2 : e2.getCause());
                    this._servlet = null;
                    this._config = null;
                    throw e2;
                }
                catch (Exception e3) {
                    this.makeUnavailable(e3);
                    this._servlet = null;
                    this._config = null;
                    throw new ServletException((Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                if (this._runAs == null) throw throwable;
                if (this._realm == null) throw throwable;
                if (user == null) throw throwable;
                this._realm.popRole(user);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handle(ServletRequest request, ServletResponse response) throws ServletException, UnavailableException, IOException {
        if (this._class == null) {
            throw new UnavailableException("Servlet Not Initialized");
        }
        Servlet servlet = this._servlet;
        ServletHolder servletHolder = this;
        synchronized (servletHolder) {
            if (this._unavailable != 0L || !this._initOnStartup) {
                servlet = this.getServlet();
            }
            if (servlet == null) {
                throw new UnavailableException("Could not instantiate " + this._class);
            }
        }
        boolean servlet_error = true;
        Principal user = null;
        Request base_request = null;
        try {
            if (this._forcedPath != null) {
                request.setAttribute("org.apache.catalina.jsp_file", (Object)this._forcedPath);
            }
            if (this._runAs != null && this._realm != null) {
                base_request = HttpConnection.getCurrentConnection().getRequest();
                user = this._realm.pushRole(base_request.getUserPrincipal(), this._runAs);
                base_request.setUserPrincipal(user);
            }
            servlet.service(request, response);
            servlet_error = false;
            if (this._runAs != null && this._realm != null && user != null && base_request != null) {
                user = this._realm.popRole(user);
                base_request.setUserPrincipal(user);
            }
            if (!servlet_error) return;
        }
        catch (UnavailableException e) {
            try {
                this.makeUnavailable(e);
                throw this._unavailableEx;
            }
            catch (Throwable throwable) {
                if (this._runAs != null && this._realm != null && user != null && base_request != null) {
                    user = this._realm.popRole(user);
                    base_request.setUserPrincipal(user);
                }
                if (!servlet_error) throw throwable;
                request.setAttribute("javax.servlet.error.servlet_name", (Object)this.getName());
                throw throwable;
            }
        }
        request.setAttribute("javax.servlet.error.servlet_name", (Object)this.getName());
        return;
    }

    class Config
    implements ServletConfig {
        Config() {
        }

        public String getServletName() {
            return ServletHolder.this.getName();
        }

        public ServletContext getServletContext() {
            return ServletHolder.this._servletHandler.getServletContext();
        }

        public String getInitParameter(String param) {
            return ServletHolder.this.getInitParameter(param);
        }

        public Enumeration getInitParameterNames() {
            return ServletHolder.this.getInitParameterNames();
        }
    }

    private class SingleThreadedWrapper
    implements Servlet {
        Stack _stack = new Stack();

        private SingleThreadedWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            SingleThreadedWrapper singleThreadedWrapper = this;
            synchronized (singleThreadedWrapper) {
                while (this._stack.size() > 0) {
                    try {
                        ((Servlet)this._stack.pop()).destroy();
                    }
                    catch (Exception e) {
                        Log.warn((Throwable)e);
                    }
                }
            }
        }

        public ServletConfig getServletConfig() {
            return ServletHolder.this._config;
        }

        public String getServletInfo() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init(ServletConfig config) throws ServletException {
            SingleThreadedWrapper singleThreadedWrapper = this;
            synchronized (singleThreadedWrapper) {
                if (this._stack.size() == 0) {
                    try {
                        Servlet s = (Servlet)ServletHolder.this.newInstance();
                        s = ServletHolder.this.getServletHandler().customizeServlet(s);
                        s.init(config);
                        this._stack.push(s);
                    }
                    catch (ServletException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new ServletException((Throwable)e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            Servlet s;
            SingleThreadedWrapper singleThreadedWrapper = this;
            synchronized (singleThreadedWrapper) {
                if (this._stack.size() > 0) {
                    s = (Servlet)this._stack.pop();
                } else {
                    try {
                        s = (Servlet)ServletHolder.this.newInstance();
                        s = ServletHolder.this.getServletHandler().customizeServlet(s);
                        s.init((ServletConfig)ServletHolder.this._config);
                    }
                    catch (ServletException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new ServletException((Throwable)e);
                    }
                }
            }
            try {
                s.service(req, res);
            }
            finally {
                singleThreadedWrapper = this;
                synchronized (singleThreadedWrapper) {
                    this._stack.push(s);
                }
            }
        }
    }
}

