/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.jetty;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManager;
import net.i2p.app.ClientAppState;
import org.mortbay.component.LifeCycle;
import org.mortbay.resource.Resource;
import org.mortbay.xml.XmlConfiguration;

public class JettyStart
implements ClientApp {
    private final I2PAppContext _context;
    private final ClientAppManager _mgr;
    private final String[] _args;
    private final List<LifeCycle> _jettys;
    private volatile ClientAppState _state = ClientAppState.UNINITIALIZED;

    public JettyStart(I2PAppContext context, ClientAppManager mgr, String[] args) throws Exception {
        this._context = context;
        this._mgr = mgr;
        this._args = args;
        this._jettys = new ArrayList<LifeCycle>(args.length);
        this.parseArgs(args);
        this._state = ClientAppState.INITIALIZED;
    }

    public void parseArgs(String[] args) throws Exception {
        Properties properties = new Properties();
        XmlConfiguration last = null;
        for (int i = 0; i < args.length; ++i) {
            Object o;
            if (args[i].toLowerCase().endsWith(".properties")) {
                properties.load(Resource.newResource((String)args[i]).getInputStream());
                continue;
            }
            XmlConfiguration configuration = new XmlConfiguration(Resource.newResource((String)args[i]).getURL());
            if (last != null) {
                configuration.getIdMap().putAll(last.getIdMap());
            }
            if (properties.size() > 0) {
                configuration.setProperties((Map)properties);
            }
            if ((o = configuration.configure()) instanceof LifeCycle) {
                this._jettys.add((LifeCycle)o);
            }
            last = configuration;
        }
    }

    public void startup() {
        if (this._state != ClientAppState.INITIALIZED) {
            return;
        }
        if (this._jettys.isEmpty()) {
            this.changeState(ClientAppState.START_FAILED);
        } else {
            new Starter().start();
        }
    }

    public void shutdown(String[] args) {
        if (this._state != ClientAppState.RUNNING) {
            return;
        }
        if (this._jettys.isEmpty()) {
            this.changeState(ClientAppState.STOPPED);
        } else {
            new Stopper().start();
        }
    }

    public ClientAppState getState() {
        return this._state;
    }

    public String getName() {
        return "Jetty";
    }

    public String getDisplayName() {
        return "Jetty " + Arrays.toString(this._args);
    }

    private void changeState(ClientAppState state) {
        this.changeState(state, null);
    }

    private synchronized void changeState(ClientAppState state, Exception e) {
        this._state = state;
        this._mgr.notify((ClientApp)this, state, null, e);
    }

    private class Starter
    extends Thread {
        public Starter() {
            super("JettyStarter");
        }

        public void run() {
            JettyStart.this.changeState(ClientAppState.STARTING);
            for (LifeCycle lc : JettyStart.this._jettys) {
                if (lc.isRunning()) continue;
                try {
                    lc.start();
                }
                catch (Exception e) {
                    JettyStart.this.changeState(ClientAppState.START_FAILED, e);
                    return;
                }
            }
            JettyStart.this.changeState(ClientAppState.RUNNING);
        }
    }

    private class Stopper
    extends Thread {
        public Stopper() {
            super("JettyStopper");
        }

        public void run() {
            JettyStart.this.changeState(ClientAppState.STOPPING);
            for (LifeCycle lc : JettyStart.this._jettys) {
                if (!lc.isRunning()) continue;
                try {
                    lc.stop();
                }
                catch (Exception e) {
                    JettyStart.this.changeState(ClientAppState.STOPPING, e);
                }
            }
            JettyStart.this.changeState(ClientAppState.STOPPED);
        }
    }
}

