/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.http;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.Vector;
import org.cybergarage.http.Date;
import org.cybergarage.http.HTTP;
import org.cybergarage.http.HTTPHeader;
import org.cybergarage.http.HTTPSocket;
import org.cybergarage.http.HTTPStatus;
import org.cybergarage.net.HostInterface;
import org.cybergarage.util.Debug;
import org.cybergarage.util.StringUtil;

public class HTTPPacket {
    private String version;
    private String firstLine = "";
    private Vector httpHeaderList = new Vector();
    private byte[] content = new byte[0];
    private InputStream contentInput = null;

    public HTTPPacket() {
        this.setVersion("1.1");
        this.setContentInputStream(null);
    }

    public HTTPPacket(HTTPPacket httpPacket) {
        this.setVersion("1.1");
        this.set(httpPacket);
        this.setContentInputStream(null);
    }

    public HTTPPacket(InputStream in) {
        this.setVersion("1.1");
        this.set(in);
        this.setContentInputStream(null);
    }

    public void init() {
        this.setFirstLine("");
        this.clearHeaders();
        this.setContent(new byte[0], false);
        this.setContentInputStream(null);
    }

    public void setVersion(String ver) {
        this.version = ver;
    }

    public String getVersion() {
        return this.version;
    }

    private String readLine(BufferedInputStream in) {
        ByteArrayOutputStream lineBuf = new ByteArrayOutputStream();
        byte[] readBuf = new byte[1];
        try {
            int readLen = in.read(readBuf);
            while (0 < readLen && readBuf[0] != 10) {
                if (readBuf[0] != 13) {
                    lineBuf.write(readBuf[0]);
                }
                readLen = in.read(readBuf);
            }
        }
        catch (InterruptedIOException e) {
        }
        catch (IOException e) {
            Debug.warning(e);
        }
        return lineBuf.toString();
    }

    protected boolean set(InputStream in, boolean onlyHeaders) {
        try {
            HTTPHeader header;
            String headerLine;
            BufferedInputStream reader = new BufferedInputStream(in);
            String firstLine = this.readLine(reader);
            if (firstLine == null || firstLine.length() <= 0) {
                return false;
            }
            this.setFirstLine(firstLine);
            HTTPStatus httpStatus = new HTTPStatus(firstLine);
            int statCode = httpStatus.getStatusCode();
            if (statCode == 100) {
                headerLine = this.readLine(reader);
                while (headerLine != null && 0 < headerLine.length()) {
                    header = new HTTPHeader(headerLine);
                    if (header.hasName()) {
                        this.setHeader(header);
                    }
                    headerLine = this.readLine(reader);
                }
                String actualFirstLine = this.readLine(reader);
                if (actualFirstLine != null && 0 < actualFirstLine.length()) {
                    this.setFirstLine(actualFirstLine);
                } else {
                    return true;
                }
            }
            headerLine = this.readLine(reader);
            while (headerLine != null && 0 < headerLine.length()) {
                header = new HTTPHeader(headerLine);
                if (header.hasName()) {
                    this.setHeader(header);
                }
                headerLine = this.readLine(reader);
            }
            if (onlyHeaders) {
                this.setContent("", false);
                return true;
            }
            boolean isChunkedRequest = this.isChunked();
            long contentLen = 0L;
            if (isChunkedRequest) {
                try {
                    String chunkSizeLine = this.readLine(reader);
                    contentLen = chunkSizeLine != null ? Long.parseLong(chunkSizeLine.trim(), 16) : 0L;
                }
                catch (Exception e) {}
            } else {
                contentLen = this.getContentLength();
            }
            ByteArrayOutputStream contentBuf = new ByteArrayOutputStream();
            while (0L < contentLen) {
                int readLen;
                int chunkSize = HTTP.getChunkSize();
                byte[] readBuf = new byte[(int)(contentLen > (long)chunkSize ? (long)chunkSize : contentLen)];
                for (long readCnt = 0L; readCnt < contentLen; readCnt += (long)readLen) {
                    try {
                        long bufReadLen = contentLen - readCnt;
                        if ((long)chunkSize < bufReadLen) {
                            bufReadLen = chunkSize;
                        }
                        if ((readLen = reader.read(readBuf, 0, (int)bufReadLen)) < 0) break;
                        contentBuf.write(readBuf, 0, readLen);
                        continue;
                    }
                    catch (Exception e) {
                        Debug.warning(e);
                        break;
                    }
                }
                if (isChunkedRequest) {
                    long skipCnt;
                    long skipLen = 0L;
                    while ((skipCnt = reader.skip((long)"\r\n".length() - skipLen)) >= 0L && (skipLen += skipCnt) < (long)"\r\n".length()) {
                    }
                    try {
                        String chunkSizeLine = this.readLine(reader);
                        contentLen = Long.parseLong(new String(chunkSizeLine.getBytes(), 0, chunkSizeLine.length() - 2), 16);
                    }
                    catch (Exception e) {
                        contentLen = 0L;
                    }
                    continue;
                }
                contentLen = 0L;
            }
            this.setContent(contentBuf.toByteArray(), false);
        }
        catch (Exception e) {
            Debug.warning(e);
            return false;
        }
        return true;
    }

    protected boolean set(InputStream in) {
        return this.set(in, false);
    }

    protected boolean set(HTTPSocket httpSock) {
        return this.set(httpSock.getInputStream());
    }

    protected void set(HTTPPacket httpPacket) {
        this.setFirstLine(httpPacket.getFirstLine());
        this.clearHeaders();
        int nHeaders = httpPacket.getNHeaders();
        for (int n = 0; n < nHeaders; ++n) {
            HTTPHeader header = httpPacket.getHeader(n);
            this.addHeader(header);
        }
        this.setContent(httpPacket.getContent());
    }

    public boolean read(HTTPSocket httpSock) {
        this.init();
        return this.set(httpSock);
    }

    private void setFirstLine(String value) {
        this.firstLine = value;
    }

    protected String getFirstLine() {
        return this.firstLine;
    }

    protected String getFirstLineToken(int num) {
        StringTokenizer st = new StringTokenizer(this.firstLine, " ");
        String lastToken = "";
        for (int n = 0; n <= num; ++n) {
            if (!st.hasMoreTokens()) {
                return "";
            }
            lastToken = st.nextToken();
        }
        return lastToken;
    }

    public boolean hasFirstLine() {
        return 0 < this.firstLine.length();
    }

    public int getNHeaders() {
        return this.httpHeaderList.size();
    }

    public void addHeader(HTTPHeader header) {
        this.httpHeaderList.add(header);
    }

    public void addHeader(String name, String value) {
        HTTPHeader header = new HTTPHeader(name, value);
        this.httpHeaderList.add(header);
    }

    public HTTPHeader getHeader(int n) {
        return (HTTPHeader)this.httpHeaderList.get(n);
    }

    public HTTPHeader getHeader(String name) {
        int nHeaders = this.getNHeaders();
        for (int n = 0; n < nHeaders; ++n) {
            HTTPHeader header = this.getHeader(n);
            String headerName = header.getName();
            if (!headerName.equalsIgnoreCase(name)) continue;
            return header;
        }
        return null;
    }

    public void clearHeaders() {
        this.httpHeaderList.clear();
        this.httpHeaderList = new Vector();
    }

    public boolean hasHeader(String name) {
        return this.getHeader(name) != null;
    }

    public void setHeader(String name, String value) {
        HTTPHeader header = this.getHeader(name);
        if (header != null) {
            header.setValue(value);
            return;
        }
        this.addHeader(name, value);
    }

    public void setHeader(String name, int value) {
        this.setHeader(name, Integer.toString(value));
    }

    public void setHeader(String name, long value) {
        this.setHeader(name, Long.toString(value));
    }

    public void setHeader(HTTPHeader header) {
        this.setHeader(header.getName(), header.getValue());
    }

    public String getHeaderValue(String name) {
        HTTPHeader header = this.getHeader(name);
        if (header == null) {
            return "";
        }
        return header.getValue();
    }

    public void setStringHeader(String name, String value, String startWidth, String endWidth) {
        String headerValue = value;
        if (!headerValue.startsWith(startWidth)) {
            headerValue = startWidth + headerValue;
        }
        if (!headerValue.endsWith(endWidth)) {
            headerValue = headerValue + endWidth;
        }
        this.setHeader(name, headerValue);
    }

    public void setStringHeader(String name, String value) {
        this.setStringHeader(name, value, "\"", "\"");
    }

    public String getStringHeaderValue(String name, String startWidth, String endWidth) {
        String headerValue = this.getHeaderValue(name);
        if (headerValue.startsWith(startWidth)) {
            headerValue = headerValue.substring(1, headerValue.length());
        }
        if (headerValue.endsWith(endWidth)) {
            headerValue = headerValue.substring(0, headerValue.length() - 1);
        }
        return headerValue;
    }

    public String getStringHeaderValue(String name) {
        return this.getStringHeaderValue(name, "\"", "\"");
    }

    public void setIntegerHeader(String name, int value) {
        this.setHeader(name, Integer.toString(value));
    }

    public void setLongHeader(String name, long value) {
        this.setHeader(name, Long.toString(value));
    }

    public int getIntegerHeaderValue(String name) {
        HTTPHeader header = this.getHeader(name);
        if (header == null) {
            return 0;
        }
        return StringUtil.toInteger(header.getValue());
    }

    public long getLongHeaderValue(String name) {
        HTTPHeader header = this.getHeader(name);
        if (header == null) {
            return 0L;
        }
        return StringUtil.toLong(header.getValue());
    }

    public String getHeaderString() {
        StringBuffer str = new StringBuffer();
        int nHeaders = this.getNHeaders();
        for (int n = 0; n < nHeaders; ++n) {
            HTTPHeader header = this.getHeader(n);
            str.append(header.getName() + ": " + header.getValue() + "\r\n");
        }
        return str.toString();
    }

    public void setContent(byte[] data, boolean updateWithContentLength) {
        this.content = data;
        if (updateWithContentLength) {
            this.setContentLength(data.length);
        }
    }

    public void setContent(byte[] data) {
        this.setContent(data, true);
    }

    public void setContent(String data, boolean updateWithContentLength) {
        this.setContent(data.getBytes(), updateWithContentLength);
    }

    public void setContent(String data) {
        this.setContent(data, true);
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getContentString() {
        String charSet = this.getCharSet();
        if (charSet == null || charSet.length() <= 0) {
            return new String(this.content);
        }
        try {
            return new String(this.content, charSet);
        }
        catch (Exception e) {
            Debug.warning(e);
            return new String(this.content);
        }
    }

    public boolean hasContent() {
        return this.content.length > 0;
    }

    public void setContentInputStream(InputStream in) {
        this.contentInput = in;
    }

    public InputStream getContentInputStream() {
        return this.contentInput;
    }

    public boolean hasContentInputStream() {
        return this.contentInput != null;
    }

    public void setContentType(String type) {
        this.setHeader("Content-Type", type);
    }

    public String getContentType() {
        return this.getHeaderValue("Content-Type");
    }

    public String getCharSet() {
        String contentType = this.getContentType();
        if (contentType == null) {
            return "";
        }
        int charSetIdx = (contentType = contentType.toLowerCase()).indexOf("charset");
        if (charSetIdx < 0) {
            return "";
        }
        int charSetEndIdx = charSetIdx + "charset".length() + 1;
        String charSet = new String(contentType.getBytes(), charSetEndIdx, contentType.length() - charSetEndIdx);
        if (charSet.length() < 0) {
            return "";
        }
        if (charSet.charAt(0) == '\"') {
            charSet = charSet.substring(1, charSet.length() - 1);
        }
        if (charSet.length() < 0) {
            return "";
        }
        if (charSet.charAt(charSet.length() - 1) == '\"') {
            charSet = charSet.substring(0, charSet.length() - 1);
        }
        return charSet;
    }

    public void setContentLength(long len) {
        this.setLongHeader("Content-Length", len);
    }

    public long getContentLength() {
        return this.getLongHeaderValue("Content-Length");
    }

    public boolean hasConnection() {
        return this.hasHeader("Connection");
    }

    public void setConnection(String value) {
        this.setHeader("Connection", value);
    }

    public String getConnection() {
        return this.getHeaderValue("Connection");
    }

    public boolean isCloseConnection() {
        if (!this.hasConnection()) {
            return false;
        }
        String connection = this.getConnection();
        if (connection == null) {
            return false;
        }
        return connection.equalsIgnoreCase("close");
    }

    public boolean isKeepAliveConnection() {
        if (!this.hasConnection()) {
            return false;
        }
        String connection = this.getConnection();
        if (connection == null) {
            return false;
        }
        return connection.equalsIgnoreCase("Keep-Alive");
    }

    public boolean hasContentRange() {
        return this.hasHeader("Content-Range") || this.hasHeader("Range");
    }

    public void setContentRange(long firstPos, long lastPos, long length) {
        String rangeStr = "";
        rangeStr = rangeStr + "bytes ";
        rangeStr = rangeStr + Long.toString(firstPos) + "-";
        rangeStr = rangeStr + Long.toString(lastPos) + "/";
        rangeStr = rangeStr + (0L < length ? Long.toString(length) : "*");
        this.setHeader("Content-Range", rangeStr);
    }

    public long[] getContentRange() {
        long[] range = new long[3];
        range[2] = 0L;
        range[1] = 0L;
        range[0] = 0L;
        if (!this.hasContentRange()) {
            return range;
        }
        String rangeLine = this.getHeaderValue("Content-Range");
        if (rangeLine.length() <= 0) {
            rangeLine = this.getHeaderValue("Range");
        }
        if (rangeLine.length() <= 0) {
            return range;
        }
        StringTokenizer strToken = new StringTokenizer(rangeLine, " =");
        if (!strToken.hasMoreTokens()) {
            return range;
        }
        String bytesStr = strToken.nextToken(" ");
        if (!strToken.hasMoreTokens()) {
            return range;
        }
        String firstPosStr = strToken.nextToken(" -");
        try {
            range[0] = Long.parseLong(firstPosStr);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (!strToken.hasMoreTokens()) {
            return range;
        }
        String lastPosStr = strToken.nextToken("-/");
        try {
            range[1] = Long.parseLong(lastPosStr);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (!strToken.hasMoreTokens()) {
            return range;
        }
        String lengthStr = strToken.nextToken("/");
        try {
            range[2] = Long.parseLong(lengthStr);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return range;
    }

    public long getContentRangeFirstPosition() {
        long[] range = this.getContentRange();
        return range[0];
    }

    public long getContentRangeLastPosition() {
        long[] range = this.getContentRange();
        return range[1];
    }

    public long getContentRangeInstanceLength() {
        long[] range = this.getContentRange();
        return range[2];
    }

    public void setCacheControl(String directive) {
        this.setHeader("Cache-Control", directive);
    }

    public void setCacheControl(String directive, int value) {
        String strVal = directive + "=" + Integer.toString(value);
        this.setHeader("Cache-Control", strVal);
    }

    public void setCacheControl(int value) {
        this.setCacheControl("max-age", value);
    }

    public String getCacheControl() {
        return this.getHeaderValue("Cache-Control");
    }

    public void setServer(String name) {
        this.setHeader("Server", name);
    }

    public String getServer() {
        return this.getHeaderValue("Server");
    }

    public void setHost(String host, int port) {
        String hostAddr = host;
        if (HostInterface.isIPv6Address(host)) {
            hostAddr = "[" + host + "]";
        }
        this.setHeader("HOST", hostAddr + ":" + Integer.toString(port));
    }

    public void setHost(String host) {
        String hostAddr = host;
        if (HostInterface.isIPv6Address(host)) {
            hostAddr = "[" + host + "]";
        }
        this.setHeader("HOST", hostAddr);
    }

    public String getHost() {
        return this.getHeaderValue("HOST");
    }

    public void setDate(Calendar cal) {
        Date date = new Date(cal);
        this.setHeader("Date", date.getDateString());
    }

    public String getDate() {
        return this.getHeaderValue("Date");
    }

    public boolean hasTransferEncoding() {
        return this.hasHeader("Transfer-Encoding");
    }

    public void setTransferEncoding(String value) {
        this.setHeader("Transfer-Encoding", value);
    }

    public String getTransferEncoding() {
        return this.getHeaderValue("Transfer-Encoding");
    }

    public boolean isChunked() {
        if (!this.hasTransferEncoding()) {
            return false;
        }
        String transEnc = this.getTransferEncoding();
        if (transEnc == null) {
            return false;
        }
        return transEnc.equalsIgnoreCase("Chunked");
    }
}

