/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.DataHelper;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterIdentity;
import net.i2p.data.RouterInfo;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.crypto.DHSessionKeyBuilder;
import net.i2p.router.transport.udp.InboundEstablishState;
import net.i2p.router.transport.udp.MTU;
import net.i2p.router.transport.udp.OutboundEstablishState;
import net.i2p.router.transport.udp.PacketBuilder;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPPacketReader;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Addresses;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

class EstablishmentManager {
    private final RouterContext _context;
    private final Log _log;
    private final UDPTransport _transport;
    private final PacketBuilder _builder;
    private final ConcurrentHashMap<RemoteHostId, InboundEstablishState> _inboundStates;
    private final ConcurrentHashMap<RemoteHostId, OutboundEstablishState> _outboundStates;
    private final ConcurrentHashMap<RemoteHostId, List<OutNetMessage>> _queuedOutbound;
    private final ConcurrentHashMap<Long, OutboundEstablishState> _liveIntroductions;
    private final ConcurrentHashMap<RemoteHostId, OutboundEstablishState> _outboundByClaimedAddress;
    private final ConcurrentHashMap<Hash, OutboundEstablishState> _outboundByHash;
    private volatile boolean _alive;
    private final Object _activityLock;
    private int _activity;
    private final int DEFAULT_MAX_CONCURRENT_ESTABLISH;
    private static final int DEFAULT_LOW_MAX_CONCURRENT_ESTABLISH = 20;
    private static final int DEFAULT_HIGH_MAX_CONCURRENT_ESTABLISH = 150;
    private static final String PROP_MAX_CONCURRENT_ESTABLISH = "i2np.udp.maxConcurrentEstablish";
    private static final int MAX_QUEUED_OUTBOUND = 50;
    private static final int MAX_QUEUED_PER_PEER = 16;
    private static final long MAX_NONCE = 0xFFFFFFFFL;
    private static final int MAX_OB_ESTABLISH_TIME = 35000;
    private static final int MAX_IB_ESTABLISH_TIME = 20000;
    public static final int OB_MESSAGE_TIMEOUT = 15000;
    private static final int DATA_MESSAGE_TIMEOUT = 10000;
    public static final long MAX_TAG_VALUE = 0xFFFFFFFFL;

    public EstablishmentManager(RouterContext ctx, UDPTransport transport) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(EstablishmentManager.class);
        this._transport = transport;
        this._builder = new PacketBuilder(ctx, transport);
        this._inboundStates = new ConcurrentHashMap();
        this._outboundStates = new ConcurrentHashMap();
        this._queuedOutbound = new ConcurrentHashMap();
        this._liveIntroductions = new ConcurrentHashMap();
        this._outboundByClaimedAddress = new ConcurrentHashMap();
        this._outboundByHash = new ConcurrentHashMap();
        this._activityLock = new Object();
        this.DEFAULT_MAX_CONCURRENT_ESTABLISH = Math.max(20, Math.min(150, ctx.bandwidthLimiter().getOutboundKBytesPerSecond() / 2));
        this._context.statManager().createRateStat("udp.inboundEstablishTime", "How long it takes for a new inbound session to be established", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.outboundEstablishTime", "How long it takes for a new outbound session to be established", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendIntroRelayRequest", "How often we send a relay request to reach a peer", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendIntroRelayTimeout", "How often a relay request times out before getting a response (due to the target or intro peer being offline)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receiveIntroRelayResponse", "How long it took to receive a relay response", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.establishDropped", "Dropped an inbound establish message", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.establishRejected", "How many pending outbound connections are there when we refuse to add any more?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.establishOverflow", "How many messages were queued up on a pending connection when it was too much?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.establishBadIP", "Received IP or port was bad", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.congestionOccurred", "How large the cwin was when congestion occurred (duration == sendBps)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.congestedRTO", "retransmission timeout after congestion (duration == rtt dev)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendACKPartial", "Number of partial ACKs sent (duration == number of full ACKs in that ack packet)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendBps", "How fast we are transmitting when a packet is acked", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receiveBps", "How fast we are receiving when a packet is fully received (at most one per second)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.mtuIncrease", "How many retransmissions have there been to the peer when the MTU was increased", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.mtuDecrease", "How many retransmissions have there been to the peer when the MTU was decreased", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.rejectConcurrentActive", "How many messages are currently being sent to the peer when we reject it (period is how many concurrent packets we allow)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.allowConcurrentActive", "How many messages are currently being sent to the peer when we accept it (period is how many concurrent packets we allow)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.rejectConcurrentSequence", "How many consecutive concurrency rejections have we had when we stop rejecting (period is how many concurrent packets we are on)", "udp", UDPTransport.RATES);
    }

    public synchronized void startup() {
        this._alive = true;
        I2PThread t = new I2PThread((Runnable)new Establisher(), "UDP Establisher", true);
        t.start();
    }

    public synchronized void shutdown() {
        this._alive = false;
        this.notifyActivity();
    }

    InboundEstablishState getInboundState(RemoteHostId from) {
        InboundEstablishState state = this._inboundStates.get(from);
        return state;
    }

    OutboundEstablishState getOutboundState(RemoteHostId from) {
        OutboundEstablishState state = this._outboundStates.get(from);
        if (state == null && (state = this._outboundByClaimedAddress.get(from)) != null && this._log.shouldLog(20)) {
            this._log.info("Found by claimed address: " + state);
        }
        return state;
    }

    private int getMaxConcurrentEstablish() {
        return this._context.getProperty(PROP_MAX_CONCURRENT_ESTABLISH, this.DEFAULT_MAX_CONCURRENT_ESTABLISH);
    }

    public void establish(OutNetMessage msg) {
        this.establish(msg, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establish(OutNetMessage msg, boolean queueIfMaxExceeded) {
        RouterInfo toRouterInfo = msg.getTarget();
        RouterAddress ra = toRouterInfo.getTargetAddress(this._transport.getStyle());
        if (ra == null) {
            this._transport.failed(msg, "Remote peer has no address, cannot establish");
            return;
        }
        RouterIdentity toIdentity = toRouterInfo.getIdentity();
        Hash toHash = toIdentity.calculateHash();
        if (toRouterInfo.getNetworkId() != 2) {
            this._context.banlist().banlistRouter(toHash);
            this._transport.markUnreachable(toHash);
            this._transport.failed(msg, "Remote peer is on the wrong network, cannot establish");
            return;
        }
        UDPAddress addr = new UDPAddress(ra);
        RemoteHostId maybeTo = null;
        InetAddress remAddr = addr.getHostAddress();
        int port = addr.getPort();
        if (remAddr != null && port > 0 && port <= 65535) {
            maybeTo = new RemoteHostId(remAddr.getAddress(), port);
            if (!this._transport.isValid(maybeTo.getIP()) || Arrays.equals(maybeTo.getIP(), this._transport.getExternalIP())) {
                this._transport.failed(msg, "Remote peer's IP isn't valid");
                this._transport.markUnreachable(toHash);
                this._context.statManager().addRateData("udp.establishBadIP", 1L);
                return;
            }
            InboundEstablishState inState = this._inboundStates.get(maybeTo);
            if (inState != null) {
                InboundEstablishState inboundEstablishState = inState;
                synchronized (inboundEstablishState) {
                    switch (inState.getState()) {
                        case IB_STATE_UNKNOWN: 
                        case IB_STATE_REQUEST_RECEIVED: 
                        case IB_STATE_CREATED_SENT: 
                        case IB_STATE_CONFIRMED_PARTIALLY: 
                        case IB_STATE_CONFIRMED_COMPLETELY: {
                            inState.addMessage(msg);
                            if (!this._log.shouldLog(30)) break;
                            this._log.debug("OB msg queued to IES");
                            break;
                        }
                        case IB_STATE_COMPLETE: {
                            this._transport.sendIfEstablished(msg);
                            break;
                        }
                        case IB_STATE_FAILED: {
                            this._transport.failed(msg, "OB msg failed during IB establish");
                        }
                    }
                }
                return;
            }
        }
        boolean isIndirect = addr.getIntroducerCount() > 0 || maybeTo == null;
        RemoteHostId to = isIndirect ? new RemoteHostId(toHash) : maybeTo;
        OutboundEstablishState state = null;
        int deferred = 0;
        boolean rejected = false;
        int queueCount = 0;
        state = this._outboundStates.get(to);
        if (state == null && (state = this._outboundByHash.get(toHash)) != null && this._log.shouldLog(20)) {
            this._log.info("Found by hash: " + state);
        }
        if (state == null) {
            if (queueIfMaxExceeded && this._outboundStates.size() >= this.getMaxConcurrentEstablish()) {
                if (this._queuedOutbound.size() >= 50 && !this._queuedOutbound.containsKey(to)) {
                    rejected = true;
                } else {
                    ArrayList<OutNetMessage> newQueued = new ArrayList<OutNetMessage>(16);
                    ArrayList<OutNetMessage> queued = this._queuedOutbound.putIfAbsent(to, newQueued);
                    if (queued == null) {
                        queued = newQueued;
                        if (this._log.shouldLog(30)) {
                            this._log.warn("Queueing outbound establish to " + to + ", increase " + PROP_MAX_CONCURRENT_ESTABLISH);
                        }
                    }
                    ArrayList<OutNetMessage> arrayList = queued;
                    synchronized (arrayList) {
                        queueCount = queued.size();
                        if (queueCount < 16) {
                            queued.add(msg);
                            ++queueCount;
                        } else {
                            rejected = true;
                        }
                        deferred = this._queuedOutbound.size();
                    }
                }
            } else {
                boolean isNew;
                SessionKey sessionKey;
                byte[] keyBytes = addr.getIntroKey();
                if (keyBytes == null) {
                    this._transport.markUnreachable(toHash);
                    this._transport.failed(msg, "Peer has no key, cannot establish");
                    return;
                }
                try {
                    sessionKey = new SessionKey(keyBytes);
                }
                catch (IllegalArgumentException iae) {
                    this._transport.markUnreachable(toHash);
                    this._transport.failed(msg, "Peer has bad key, cannot establish");
                    return;
                }
                state = new OutboundEstablishState(this._context, maybeTo, to, toIdentity, sessionKey, addr, this._transport.getDHFactory());
                OutboundEstablishState oldState = this._outboundStates.putIfAbsent(to, state);
                boolean bl = isNew = oldState == null;
                if (isNew) {
                    if (isIndirect && maybeTo != null) {
                        this._outboundByClaimedAddress.put(maybeTo, state);
                    }
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Adding new " + state);
                    }
                } else {
                    state = oldState;
                }
            }
        }
        if (state != null) {
            state.addMessage(msg);
            List<OutNetMessage> queued = this._queuedOutbound.remove(to);
            if (queued != null) {
                List<OutNetMessage> list = queued;
                synchronized (list) {
                    for (OutNetMessage m : queued) {
                        state.addMessage(m);
                    }
                }
            }
        }
        if (rejected) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Too many pending, rejecting outbound establish to " + to);
            }
            this._transport.failed(msg, "Too many pending outbound connections");
            this._context.statManager().addRateData("udp.establishRejected", (long)deferred, 0L);
            return;
        }
        if (queueCount >= 16) {
            this._transport.failed(msg, "Too many pending messages for the given peer");
            this._context.statManager().addRateData("udp.establishOverflow", (long)queueCount, (long)deferred);
            return;
        }
        if (deferred > 0) {
            msg.timestamp("too many deferred establishers");
        } else if (state != null) {
            msg.timestamp("establish state already waiting");
        }
        this.notifyActivity();
    }

    private int getMaxInboundEstablishers() {
        return this.getMaxConcurrentEstablish() / 2;
    }

    public boolean shouldAllowInboundEstablishment() {
        return this._inboundStates.size() < this.getMaxInboundEstablishers();
    }

    void receiveSessionRequest(RemoteHostId from, UDPPacketReader reader) {
        if (from.getPort() < 1024 || !this._transport.isValid(from.getIP())) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Receive session request from invalid: " + from);
            }
            return;
        }
        boolean isNew = false;
        InboundEstablishState state = this._inboundStates.get(from);
        if (state == null) {
            if (!this.shouldAllowInboundEstablishment()) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Dropping inbound establish, increase i2np.udp.maxConcurrentEstablish");
                }
                this._context.statManager().addRateData("udp.establishDropped", 1L);
                return;
            }
            if (this._context.blocklist().isBlocklisted(from.getIP())) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Receive session request from blocklisted IP: " + from);
                }
                this._context.statManager().addRateData("udp.establishBadIP", 1L);
                return;
            }
            if (!this._transport.allowConnection()) {
                return;
            }
            state = new InboundEstablishState(this._context, from.getIP(), from.getPort(), this._transport.getExternalPort(), this._transport.getDHBuilder());
            state.receiveSessionRequest(reader.getSessionRequestReader());
            InboundEstablishState oldState = this._inboundStates.putIfAbsent(from, state);
            boolean bl = isNew = oldState == null;
            if (!isNew) {
                state = oldState;
            }
        }
        if (isNew) {
            if (this._transport.canIntroduce() && state.getSentPort() >= 1024) {
                long tag = 1L + this._context.random().nextLong(0xFFFFFFFFL);
                state.setSentRelayTag(tag);
            }
            if (this._log.shouldLog(20)) {
                this._log.info("Received NEW session request " + state);
            }
        } else if (this._log.shouldLog(10)) {
            this._log.debug("Receive DUP session request from: " + state);
        }
        this.notifyActivity();
    }

    void receiveSessionConfirmed(RemoteHostId from, UDPPacketReader reader) {
        InboundEstablishState state = this._inboundStates.get(from);
        if (state != null) {
            state.receiveSessionConfirmed(reader.getSessionConfirmedReader());
            this.notifyActivity();
            if (this._log.shouldLog(10)) {
                this._log.debug("Receive session confirmed from: " + state);
            }
        } else if (this._log.shouldLog(30)) {
            this._log.warn("Receive (DUP?) session confirmed from: " + from);
        }
    }

    void receiveSessionCreated(RemoteHostId from, UDPPacketReader reader) {
        OutboundEstablishState state = this._outboundStates.get(from);
        if (state != null) {
            state.receiveSessionCreated(reader.getSessionCreatedReader());
            this.notifyActivity();
            if (this._log.shouldLog(10)) {
                this._log.debug("Receive session created from: " + state);
            }
        } else if (this._log.shouldLog(30)) {
            this._log.warn("Receive (DUP?) session created from: " + from);
        }
    }

    void receiveSessionDestroy(RemoteHostId from, PeerState state) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Receive session destroy (EST) from: " + from);
        }
        this._transport.dropPeer(state, false, "received destroy message");
    }

    void receiveSessionDestroy(RemoteHostId from, OutboundEstablishState state) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Receive session destroy (OB) from: " + from);
        }
        this._outboundStates.remove(from);
        Hash peer = state.getRemoteIdentity().calculateHash();
        this._transport.dropPeer(peer, false, "received destroy message during OB establish");
    }

    void receiveSessionDestroy(RemoteHostId from) {
        if (this._log.shouldLog(30)) {
            this._log.warn("Receive session destroy (none) from: " + from);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PeerState receiveData(OutboundEstablishState state) {
        Object object;
        state.dataReceived();
        this._outboundStates.remove(state.getRemoteHostId());
        List<OutNetMessage> queued = this._queuedOutbound.remove(state.getRemoteHostId());
        if (queued != null) {
            object = queued;
            synchronized (object) {
                for (OutNetMessage m : queued) {
                    state.addMessage(m);
                }
            }
        }
        if (this._outboundStates.size() < this.getMaxConcurrentEstablish() && !this._queuedOutbound.isEmpty()) {
            object = this._queuedOutbound;
            synchronized (object) {
                this.locked_admitQueued();
            }
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Outbound established completely!  yay: " + state);
        }
        PeerState peer = this.handleCompletelyEstablished(state);
        this.notifyActivity();
        return peer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int locked_admitQueued() {
        if (this._queuedOutbound.isEmpty()) {
            return 0;
        }
        int admitted = 0;
        int max = this.getMaxConcurrentEstablish();
        Iterator<Map.Entry<RemoteHostId, List<OutNetMessage>>> iter = this._queuedOutbound.entrySet().iterator();
        while (iter.hasNext() && this._outboundStates.size() < max) {
            Map.Entry<RemoteHostId, List<OutNetMessage>> entry = iter.next();
            iter.remove();
            RemoteHostId to = entry.getKey();
            List<OutNetMessage> allQueued = entry.getValue();
            ArrayList<OutNetMessage> queued = new ArrayList<OutNetMessage>();
            long now = this._context.clock().now();
            List<OutNetMessage> list = allQueued;
            synchronized (list) {
                for (OutNetMessage msg : allQueued) {
                    if (now - 60000L > msg.getExpiration()) {
                        this._transport.failed(msg, "Took too long in est. mgr OB queue");
                        continue;
                    }
                    queued.add(msg);
                }
            }
            if (queued.isEmpty()) continue;
            for (OutNetMessage m : queued) {
                m.timestamp("no longer deferred... establishing");
                this.establish(m, false);
            }
            ++admitted;
        }
        return admitted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyActivity() {
        Object object = this._activityLock;
        synchronized (object) {
            ++this._activity;
            this._activityLock.notifyAll();
        }
    }

    private void handleCompletelyEstablished(InboundEstablishState state) {
        OutNetMessage msg;
        String smtu;
        RouterAddress addr;
        if (state.isComplete()) {
            return;
        }
        RouterIdentity remote = state.getConfirmedIdentity();
        PeerState peer = new PeerState(this._context, this._transport, state.getSentIP(), state.getSentPort(), remote.calculateHash(), true);
        peer.setCurrentCipherKey(state.getCipherKey());
        peer.setCurrentMACKey(state.getMACKey());
        peer.setWeRelayToThemAs(state.getSentRelayTag());
        RouterInfo info = this._context.netDb().lookupRouterInfoLocally(remote.calculateHash());
        if (info != null && (addr = info.getTargetAddress("SSU")) != null && (smtu = addr.getOption("mtu")) != null) {
            try {
                int mtu = MTU.rectify(Integer.parseInt(smtu));
                peer.setHisMTU(mtu);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Handle completely established (inbound): " + state + " - " + peer.getRemotePeer());
        }
        this._transport.addRemotePeerState(peer);
        this._transport.inboundConnectionReceived();
        this._transport.setIP(remote.calculateHash(), state.getSentIP());
        this._context.statManager().addRateData("udp.inboundEstablishTime", state.getLifetime(), 0L);
        this.sendInboundComplete(peer);
        while ((msg = state.getNextQueuedMessage()) != null) {
            if (this._context.clock().now() - 60000L > msg.getExpiration()) {
                msg.timestamp("took too long but established...");
                this._transport.failed(msg, "Took too long to establish, but it was established");
                continue;
            }
            msg.timestamp("session fully established and sent");
            this._transport.send(msg);
        }
        state.complete();
    }

    private void sendInboundComplete(PeerState peer) {
        if (this._log.shouldLog(20)) {
            this._log.info("Completing to the peer after IB confirm: " + peer);
        }
        DeliveryStatusMessage dsm = new DeliveryStatusMessage(this._context);
        dsm.setArrival(2L);
        dsm.setMessageExpiration(this._context.clock().now() + 10000L);
        dsm.setMessageId(this._context.random().nextLong(0xFFFFFFFFL));
        this._transport.send(dsm, peer);
        Hash hash = peer.getRemotePeer();
        if (hash != null && !this._context.banlist().isBanlisted(hash) && !this._transport.isUnreachable(hash)) {
            this.sendOurInfo(peer, true);
        } else if (this._log.shouldLog(30)) {
            this._log.warn("NOT publishing to the peer after confirm plus delay (WITH banlist): " + (hash != null ? hash.toString() : "unknown"));
        }
    }

    private PeerState handleCompletelyEstablished(OutboundEstablishState state) {
        OutNetMessage msg;
        RouterIdentity rem;
        if (state.complete() && (rem = state.getRemoteIdentity()) != null) {
            return this._transport.getPeerState(rem.getHash());
        }
        long now = this._context.clock().now();
        RouterIdentity remote = state.getRemoteIdentity();
        RemoteHostId claimed = state.getClaimedAddress();
        if (claimed != null) {
            this._outboundByClaimedAddress.remove(claimed, state);
        }
        this._outboundByHash.remove(remote.calculateHash(), state);
        PeerState peer = new PeerState(this._context, this._transport, state.getSentIP(), state.getSentPort(), remote.calculateHash(), false);
        peer.setCurrentCipherKey(state.getCipherKey());
        peer.setCurrentMACKey(state.getMACKey());
        peer.setTheyRelayToUsAs(state.getReceivedRelayTag());
        int mtu = state.getRemoteAddress().getMTU();
        if (mtu > 0) {
            peer.setHisMTU(mtu);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Handle completely established (outbound): " + state + " - " + peer.getRemotePeer());
        }
        this._transport.addRemotePeerState(peer);
        this._transport.setIP(remote.calculateHash(), state.getSentIP());
        this._context.statManager().addRateData("udp.outboundEstablishTime", state.getLifetime(), 0L);
        this.sendOurInfo(peer, false);
        while ((msg = state.getNextQueuedMessage()) != null) {
            if (now - 60000L > msg.getExpiration()) {
                msg.timestamp("took too long but established...");
                this._transport.failed(msg, "Took too long to establish, but it was established");
                continue;
            }
            msg.timestamp("session fully established and sent");
            this._transport.send(msg);
        }
        return peer;
    }

    private void sendOurInfo(PeerState peer, boolean isInbound) {
        if (this._log.shouldLog(20)) {
            this._log.info("Publishing to the peer after confirm: " + (isInbound ? " inbound con from " + peer : "outbound con to " + peer));
        }
        DatabaseStoreMessage m = new DatabaseStoreMessage(this._context);
        m.setEntry((DatabaseEntry)this._context.router().getRouterInfo());
        m.setMessageExpiration(this._context.clock().now() + 10000L);
        this._transport.send(m, peer);
    }

    private void sendCreated(InboundEstablishState state) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Send created to: " + state);
        }
        try {
            state.generateSessionKey();
        }
        catch (DHSessionKeyBuilder.InvalidPublicParameterException ippe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Peer " + state + " sent us an invalid DH parameter", (Throwable)((Object)ippe));
            }
            this._inboundStates.remove(state.getRemoteHostId());
            return;
        }
        this._transport.send(this._builder.buildSessionCreatedPacket(state, this._transport.getExternalPort(), this._transport.getIntroKey()));
        state.createdPacketSent();
    }

    private void sendRequest(OutboundEstablishState state) {
        UDPPacket packet;
        if (this._log.shouldLog(10)) {
            this._log.debug("Send SessionRequest to: " + state);
        }
        if ((packet = this._builder.buildSessionRequestPacket(state)) != null) {
            this._transport.send(packet);
        } else if (this._log.shouldLog(30)) {
            this._log.warn("Unable to build a session request packet for " + state);
        }
        state.requestSent();
    }

    private void handlePendingIntro(OutboundEstablishState state) {
        long nonce = state.getIntroNonce();
        if (nonce < 0L) {
            OutboundEstablishState old;
            while ((old = this._liveIntroductions.putIfAbsent(nonce = this._context.random().nextLong(0xFFFFFFFFL), state)) != null) {
            }
            state.setIntroNonce(nonce);
        }
        this._context.statManager().addRateData("udp.sendIntroRelayRequest", 1L, 0L);
        List<UDPPacket> requests = this._builder.buildRelayRequest(this._transport, state, this._transport.getIntroKey());
        if (requests.isEmpty() && this._log.shouldLog(30)) {
            this._log.warn("No valid introducers! " + state);
        }
        for (UDPPacket req : requests) {
            this._transport.send(req);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Send intro for " + state + " with our intro key as " + this._transport.getIntroKey());
        }
        state.introSent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveRelayResponse(RemoteHostId bob, UDPPacketReader reader) {
        long nonce = reader.getRelayResponseReader().readNonce();
        OutboundEstablishState state = this._liveIntroductions.remove(nonce);
        if (state == null) {
            if (this._log.shouldLog(20)) {
                this._log.info("Dup or unknown RelayResponse: " + nonce);
            }
            return;
        }
        int sz = reader.getRelayResponseReader().readCharlieIPSize();
        byte[] ip = new byte[sz];
        reader.getRelayResponseReader().readCharlieIP(ip, 0);
        int port = reader.getRelayResponseReader().readCharliePort();
        if (!this.isValid(ip, port) || !this.isValid(bob.getIP(), bob.getPort())) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Bad relay resp from " + bob + " for " + Addresses.toString((byte[])ip, (int)port));
            }
            this._context.statManager().addRateData("udp.relayBadIP", 1L);
            return;
        }
        InetAddress addr = null;
        try {
            addr = InetAddress.getByAddress(ip);
        }
        catch (UnknownHostException uhe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Introducer for " + state + " (" + bob + ") sent us an invalid address for our target: " + Addresses.toString((byte[])ip, (int)port), (Throwable)uhe);
            }
            return;
        }
        this._context.statManager().addRateData("udp.receiveIntroRelayResponse", state.getLifetime(), 0L);
        if (this._log.shouldLog(20)) {
            this._log.info("Received RelayResponse for " + state.getRemoteIdentity().calculateHash() + " - they are on " + addr.toString() + ":" + port + " (according to " + bob + ") nonce=" + nonce);
        }
        OutboundEstablishState outboundEstablishState = state;
        synchronized (outboundEstablishState) {
            RemoteHostId oldId = state.getRemoteHostId();
            state.introduced(ip, port);
            RemoteHostId newId = state.getRemoteHostId();
            this._outboundByHash.put(state.getRemoteIdentity().calculateHash(), state);
            RemoteHostId claimed = state.getClaimedAddress();
            if (!oldId.equals(newId)) {
                this._outboundStates.remove(oldId);
                this._outboundStates.put(newId, state);
                if (this._log.shouldLog(30)) {
                    this._log.warn("RR replaced " + oldId + " with " + newId + ", claimed address was " + claimed);
                }
            }
            if (claimed != null) {
                this._outboundByClaimedAddress.remove(oldId, state);
            }
        }
        this.notifyActivity();
    }

    private boolean isValid(byte[] ip, int port) {
        return port >= 1024 && port <= 65535 && this._transport.isValid(ip) && !DataHelper.eq((byte[])ip, (int)0, (byte[])this._transport.getExternalIP(), (int)0, (int)2) && !this._context.blocklist().isBlocklisted(ip);
    }

    private void sendConfirmation(OutboundEstablishState state) {
        boolean valid = state.validateSessionCreated();
        if (!valid) {
            if (this._log.shouldLog(30)) {
                this._log.warn("SessionCreated validate failed: " + state);
            }
            return;
        }
        if (!this._transport.isValid(state.getReceivedIP()) || !this._transport.isValid(state.getRemoteHostId().getIP())) {
            state.fail();
            return;
        }
        this._transport.externalAddressReceived(state.getRemoteIdentity().calculateHash(), state.getReceivedIP(), state.getReceivedPort());
        state.prepareSessionConfirmed();
        UDPPacket[] packets = this._builder.buildSessionConfirmedPackets(state, this._context.router().getRouterInfo().getIdentity());
        if (this._log.shouldLog(10)) {
            this._log.debug("Send confirm to: " + state);
        }
        for (int i = 0; i < packets.length; ++i) {
            this._transport.send(packets[i]);
        }
        state.confirmedPacketsSent();
    }

    private void sendDestroy(OutboundEstablishState state) {
        UDPPacket packet = this._builder.buildSessionDestroyPacket(state);
        if (packet != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Send destroy to: " + state);
            }
            this._transport.send(packet);
        }
    }

    private void sendDestroy(InboundEstablishState state) {
        UDPPacket packet = this._builder.buildSessionDestroyPacket(state);
        if (packet != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Send destroy to: " + state);
            }
            this._transport.send(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long handleInbound() {
        long now = this._context.clock().now();
        long nextSendTime = -1L;
        InboundEstablishState inboundState = null;
        boolean expired = false;
        Iterator<InboundEstablishState> iter = this._inboundStates.values().iterator();
        while (iter.hasNext()) {
            InboundEstablishState cur = iter.next();
            if (cur.getState() == InboundEstablishState.InboundState.IB_STATE_CONFIRMED_COMPLETELY) {
                iter.remove();
                inboundState = cur;
                break;
            }
            if (cur.getLifetime() > 20000L) {
                iter.remove();
                inboundState = cur;
                expired = true;
                break;
            }
            if (cur.getState() == InboundEstablishState.InboundState.IB_STATE_FAILED) {
                iter.remove();
                continue;
            }
            if (cur.getNextSendTime() <= now) {
                inboundState = cur;
                break;
            }
            long when = -1L;
            when = cur.getNextSendTime() <= 0L ? cur.getEstablishBeginTime() + 20000L : cur.getNextSendTime();
            if (when >= nextSendTime) continue;
            nextSendTime = when;
        }
        if (inboundState != null) {
            InboundEstablishState inboundEstablishState = inboundState;
            synchronized (inboundEstablishState) {
                switch (inboundState.getState()) {
                    case IB_STATE_REQUEST_RECEIVED: {
                        if (expired) {
                            this.processExpired(inboundState);
                            break;
                        }
                        this.sendCreated(inboundState);
                        break;
                    }
                    case IB_STATE_CREATED_SENT: 
                    case IB_STATE_CONFIRMED_PARTIALLY: {
                        if (expired) {
                            this.sendDestroy(inboundState);
                            this.processExpired(inboundState);
                            break;
                        }
                        if (inboundState.getNextSendTime() > now) break;
                        this.sendCreated(inboundState);
                        break;
                    }
                    case IB_STATE_CONFIRMED_COMPLETELY: {
                        RouterIdentity remote = inboundState.getConfirmedIdentity();
                        if (remote != null) {
                            if (this._context.banlist().isBanlistedForever(remote.calculateHash())) {
                                if (this._log.shouldLog(30)) {
                                    this._log.warn("Dropping inbound connection from permanently banlisted peer: " + remote.calculateHash());
                                }
                                this._context.blocklist().add(inboundState.getSentIP());
                                inboundState.fail();
                                this.processExpired(inboundState);
                                break;
                            }
                            this.handleCompletelyEstablished(inboundState);
                            break;
                        }
                        if (this._log.shouldLog(30)) {
                            this._log.warn("confirmed with invalid? " + inboundState);
                        }
                        inboundState.fail();
                        this.processExpired(inboundState);
                        break;
                    }
                    case IB_STATE_COMPLETE: 
                    case IB_STATE_FAILED: {
                        break;
                    }
                    case IB_STATE_UNKNOWN: {
                        if (!this._log.shouldLog(40)) break;
                        this._log.error("hrm, state is unknown for " + inboundState);
                    }
                }
            }
            nextSendTime = now;
        }
        return nextSendTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long handleOutbound() {
        long now = this._context.clock().now();
        long nextSendTime = -1L;
        OutboundEstablishState outboundState = null;
        Iterator<OutboundEstablishState> iter = this._outboundStates.values().iterator();
        while (iter.hasNext()) {
            OutboundEstablishState cur = iter.next();
            OutboundEstablishState.OutboundState state = cur.getState();
            if (state == OutboundEstablishState.OutboundState.OB_STATE_CONFIRMED_COMPLETELY || state == OutboundEstablishState.OutboundState.OB_STATE_VALIDATION_FAILED) {
                iter.remove();
                outboundState = cur;
                break;
            }
            if (cur.getLifetime() >= 35000L) {
                iter.remove();
                outboundState = cur;
                break;
            }
            if (cur.getNextSendTime() <= now) {
                outboundState = cur;
                break;
            }
            long when = -1L;
            when = cur.getNextSendTime() <= 0L ? cur.getEstablishBeginTime() + 35000L : cur.getNextSendTime();
            if (nextSendTime > 0L && when >= nextSendTime) continue;
            nextSendTime = when;
        }
        if (outboundState != null) {
            OutboundEstablishState outboundEstablishState = outboundState;
            synchronized (outboundEstablishState) {
                boolean expired = outboundState.getLifetime() >= 35000L;
                switch (outboundState.getState()) {
                    case OB_STATE_UNKNOWN: 
                    case OB_STATE_INTRODUCED: {
                        if (expired) {
                            this.processExpired(outboundState);
                            break;
                        }
                        this.sendRequest(outboundState);
                        break;
                    }
                    case OB_STATE_REQUEST_SENT: {
                        long rtime = outboundState.getRequestSentTime();
                        if (expired || rtime > 0L && rtime + 15000L <= now) {
                            this.processExpired(outboundState);
                            break;
                        }
                        if (outboundState.getNextSendTime() > now) break;
                        this.sendRequest(outboundState);
                        break;
                    }
                    case OB_STATE_CREATED_RECEIVED: {
                        if (expired) {
                            this.processExpired(outboundState);
                            break;
                        }
                        if (outboundState.getNextSendTime() > now) break;
                        this.sendConfirmation(outboundState);
                        break;
                    }
                    case OB_STATE_CONFIRMED_PARTIALLY: {
                        long ctime = outboundState.getConfirmedSentTime();
                        if (expired || ctime > 0L && ctime + 15000L <= now) {
                            this.sendDestroy(outboundState);
                            this.processExpired(outboundState);
                            break;
                        }
                        if (outboundState.getNextSendTime() > now) break;
                        this.sendConfirmation(outboundState);
                        break;
                    }
                    case OB_STATE_CONFIRMED_COMPLETELY: {
                        if (expired) {
                            this.processExpired(outboundState);
                            break;
                        }
                        this.handleCompletelyEstablished(outboundState);
                        break;
                    }
                    case OB_STATE_PENDING_INTRO: {
                        long itime = outboundState.getIntroSentTime();
                        if (expired || itime > 0L && itime + 15000L <= now) {
                            this.processExpired(outboundState);
                            break;
                        }
                        if (outboundState.getNextSendTime() > now) break;
                        this.handlePendingIntro(outboundState);
                        break;
                    }
                    case OB_STATE_VALIDATION_FAILED: {
                        this.processExpired(outboundState);
                    }
                }
            }
            nextSendTime = now;
        }
        return nextSendTime;
    }

    private void processExpired(OutboundEstablishState outboundState) {
        RemoteHostId claimed;
        boolean removed;
        long nonce = outboundState.getIntroNonce();
        if (nonce >= 0L && (removed = this._liveIntroductions.remove(nonce, outboundState))) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Send intro for " + outboundState + " timed out");
            }
            this._context.statManager().addRateData("udp.sendIntroRelayTimeout", 1L, 0L);
        }
        if ((claimed = outboundState.getClaimedAddress()) != null) {
            this._outboundByClaimedAddress.remove(claimed, outboundState);
        }
        this._outboundByHash.remove(outboundState.getRemoteIdentity().calculateHash(), outboundState);
        boolean removed2 = this._outboundStates.remove(outboundState.getRemoteHostId(), outboundState);
        if (outboundState.getState() != OutboundEstablishState.OutboundState.OB_STATE_CONFIRMED_COMPLETELY) {
            OutNetMessage msg;
            if (this._log.shouldLog(20)) {
                this._log.info("Expired: " + outboundState + " Lifetime: " + outboundState.getLifetime());
            }
            while ((msg = outboundState.getNextQueuedMessage()) != null) {
                this._transport.failed(msg, "Expired during failed establish");
            }
            String err = "Took too long to establish OB connection, state = " + (Object)((Object)outboundState.getState());
            Hash peer = outboundState.getRemoteIdentity().calculateHash();
            this._transport.markUnreachable(peer);
            this._transport.dropPeer(peer, false, err);
        } else {
            OutNetMessage msg;
            while ((msg = outboundState.getNextQueuedMessage()) != null) {
                this._transport.send(msg);
            }
        }
    }

    private void processExpired(InboundEstablishState inboundState) {
        OutNetMessage msg;
        while ((msg = inboundState.getNextQueuedMessage()) != null) {
            this._transport.failed(msg, "Expired during failed establish");
        }
    }

    private class Establisher
    implements Runnable {
        private long _lastFailsafe;
        private static final long FAILSAFE_INTERVAL = 180000L;
        private long _lastPrinted;
        private static final long PRINT_INTERVAL = 5000L;

        private Establisher() {
        }

        public void run() {
            while (EstablishmentManager.this._alive) {
                try {
                    this.doPass();
                }
                catch (RuntimeException re) {
                    EstablishmentManager.this._log.log(50, "Error in the establisher", (Throwable)re);
                }
            }
            EstablishmentManager.this._inboundStates.clear();
            EstablishmentManager.this._outboundStates.clear();
            EstablishmentManager.this._queuedOutbound.clear();
            EstablishmentManager.this._outboundByClaimedAddress.clear();
            EstablishmentManager.this._outboundByHash.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doPass() {
            if (EstablishmentManager.this._log.shouldLog(10) && this._lastPrinted + 5000L < EstablishmentManager.this._context.clock().now()) {
                this._lastPrinted = EstablishmentManager.this._context.clock().now();
                int iactive = EstablishmentManager.this._inboundStates.size();
                int oactive = EstablishmentManager.this._outboundStates.size();
                if (iactive > 0 || oactive > 0) {
                    int queued = EstablishmentManager.this._queuedOutbound.size();
                    int live = EstablishmentManager.this._liveIntroductions.size();
                    int claimed = EstablishmentManager.this._outboundByClaimedAddress.size();
                    int hash = EstablishmentManager.this._outboundByHash.size();
                    EstablishmentManager.this._log.debug("OB states: " + oactive + " IB states: " + iactive + " OB queued: " + queued + " intros: " + live + " OB claimed: " + claimed + " hash: " + hash);
                }
            }
            EstablishmentManager.this._activity = 0;
            long now = EstablishmentManager.this._context.clock().now();
            if (this._lastFailsafe + 180000L < EstablishmentManager.this._context.clock().now()) {
                this._lastFailsafe = EstablishmentManager.this._context.clock().now();
                this.doFailsafe();
            }
            long nextSendTime = -1L;
            long nextSendInbound = EstablishmentManager.this.handleInbound();
            long nextSendOutbound = EstablishmentManager.this.handleOutbound();
            if (nextSendInbound > 0L) {
                nextSendTime = nextSendInbound;
            }
            if (nextSendTime < 0L || nextSendOutbound < nextSendTime) {
                nextSendTime = nextSendOutbound;
            }
            long delay = nextSendTime - now;
            if (nextSendTime == -1L || delay > 0L) {
                if (delay > 1000L) {
                    delay = 1000L;
                }
                try {
                    Object object = EstablishmentManager.this._activityLock;
                    synchronized (object) {
                        if (EstablishmentManager.this._activity > 0) {
                            return;
                        }
                        if (nextSendTime == -1L) {
                            EstablishmentManager.this._activityLock.wait(1000L);
                        } else {
                            EstablishmentManager.this._activityLock.wait(delay);
                        }
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }

        private void doFailsafe() {
            OutboundEstablishState state;
            Iterator iter = EstablishmentManager.this._liveIntroductions.values().iterator();
            while (iter.hasNext()) {
                state = (OutboundEstablishState)iter.next();
                if (state.getLifetime() <= 105000L) continue;
                iter.remove();
                if (!EstablishmentManager.this._log.shouldLog(30)) continue;
                EstablishmentManager.this._log.warn("Failsafe remove LI " + state);
            }
            iter = EstablishmentManager.this._outboundByClaimedAddress.values().iterator();
            while (iter.hasNext()) {
                state = (OutboundEstablishState)iter.next();
                if (state.getLifetime() <= 105000L) continue;
                iter.remove();
                if (!EstablishmentManager.this._log.shouldLog(30)) continue;
                EstablishmentManager.this._log.warn("Failsafe remove OBBCA " + state);
            }
            iter = EstablishmentManager.this._outboundByHash.values().iterator();
            while (iter.hasNext()) {
                state = (OutboundEstablishState)iter.next();
                if (state.getLifetime() <= 105000L) continue;
                iter.remove();
                if (!EstablishmentManager.this._log.shouldLog(30)) continue;
                EstablishmentManager.this._log.warn("Failsafe remove OBBH " + state);
            }
        }
    }
}

